/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.ejb;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayType;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import com.sap.tc.jtools.jlint.jom.util.NameTool;
import java.lang.reflect.Modifier;
import java.util.Properties;

public class ImplementationTest
extends JomTestVisitor {
    private static final String NAME = "EJB programming restrictions";
    private static final String MSG_KEY_1 = "ejbimpl.1";
    private static final String MSG_KEY_2 = "ejbimpl.2";
    private static final String MSG_KEY_3 = "ejbimpl.3";
    private static final String MSG_KEY_4 = "ejbimpl.4";
    private static final String MSG_KEY_5 = "ejbimpl.5";
    private static final String MSG_KEY_6 = "ejbimpl.6";
    private static final String MSG_KEY_7 = "ejbimpl.7";
    private static final String MSG_KEY_8 = "ejbimpl.8";
    private static final String MSG_KEY_9 = "ejbimpl.9";
    private static final String PKG_PARAM = "PACKAGE";
    private static final String METHOD_PARAM = "METHOD";
    private static final String FIELD_PARAM = "FIELD";
    private static final String CLASS_PARAM = "CLASS";
    private static final String EJB_CLASS_NAME = "javax.ejb.EnterpriseBean";
    private static final String FINALIZE_METH = "finalize";
    private static final String[] FORBIDDEN_PKGS = new String[]{"java.awt", "javax.swing", "java.lang.reflect", "java.lang.ref"};
    private static final String[] FORBIDDEN_CLASSES = new String[]{"java.lang.ClassLoader", "java.io.File", "java.io.FileDescriptor", "java.lang.SecurityManager", "java.lang.RuntimePermission", "java.lang.Thread", "java.lang.ThreadGroup", "java.lang.ThreadLocal", "java.lang.Runtime", "java.lang.Process", "java.lang.Compiler"};
    private static final String[] FORBIDDEN_STATIC_METHODS = new String[]{"java.lang.System.exit", "java.lang.System.setErr", "java.lang.System.setIn", "java.lang.System.setOut", "java.lang.System.load", "java.lang.System.loadLibrary", "java.lang.System.gc"};
    private static final String[] FORBIDDEN_STATIC_FIELDS = new String[]{"java.lang.System.out", "java.lang.System.err", "java.lang.System.in"};
    private boolean isEJB = false;
    private boolean hasConstructor = false;
    private boolean hasNoArgsConstructor = false;

    public String getTestName() {
        return NAME;
    }

    public boolean visit(ITypeDeclaration node) {
        IReferenceTypeBinding bnd = node.resolveBinding();
        if (bnd == null || !bnd.isClass()) {
            return false;
        }
        if (InheritanceTool.bndImplements((IReferenceTypeBinding)bnd, (String)EJB_CLASS_NAME)) {
            this.isEJB = true;
            this.checkModifiers(node);
            return true;
        }
        return false;
    }

    private void checkModifiers(ITypeDeclaration node) {
        int mod = node.getModifiers();
        if (!Modifier.isPublic(mod)) {
            this.addError(MSG_KEY_1, null, (Position)node);
        }
        if (Modifier.isFinal(mod)) {
            this.addError(MSG_KEY_2, null, (Position)node);
        }
    }

    public boolean visit(IFieldDeclaration node) {
        if (!Modifier.isStatic(node.getModifiers())) {
            return true;
        }
        if (!Modifier.isFinal(node.getModifiers())) {
            this.addError(MSG_KEY_3, null, (Position)node);
        }
        return true;
    }

    private void checkForbiddenComponents(ITypeBinding bnd, Position pos) {
        if (bnd == null) {
            return;
        }
        this.checkForbiddenPackages(bnd, pos);
        this.checkForbiddenClasses(bnd, pos);
    }

    private void checkForbiddenPackages(ITypeBinding bnd, Position pos) {
        ITypeBinding elementBinding = bnd;
        if (bnd.isArray()) {
            elementBinding = ((IArrayTypeBinding)bnd).getElementType();
        }
        if (elementBinding.isPrimitive()) {
            return;
        }
        int i = 0;
        while (i < FORBIDDEN_PKGS.length) {
            if (NameTool.getFullPackageName((IReferenceTypeBinding)((IReferenceTypeBinding)elementBinding)).startsWith(FORBIDDEN_PKGS[i])) {
                Properties p = new Properties();
                p.setProperty(PKG_PARAM, FORBIDDEN_PKGS[i]);
                this.addError(MSG_KEY_4, p, pos);
            }
            ++i;
        }
    }

    private void checkForbiddenClasses(ITypeBinding bnd, Position pos) {
        ITypeBinding elementBinding = bnd;
        if (bnd.isArray()) {
            elementBinding = ((IArrayTypeBinding)bnd).getElementType();
        }
        if (elementBinding.isPrimitive()) {
            return;
        }
        int i = 0;
        while (i < FORBIDDEN_CLASSES.length) {
            this.checkClassRecursive(FORBIDDEN_CLASSES[i], (IReferenceTypeBinding)elementBinding, pos);
            ++i;
        }
    }

    private void checkClassRecursive(String forbiddenName, IReferenceTypeBinding bnd, Position pos) {
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)bnd, (String)forbiddenName) || InheritanceTool.bndImplements((IReferenceTypeBinding)bnd, (String)forbiddenName)) {
            Properties p = new Properties();
            p.setProperty(CLASS_PARAM, forbiddenName);
            this.addError(MSG_KEY_5, p, pos);
        }
    }

    public boolean visit(IMethodInvocation node) {
        String fullyQalifiedMethod = NameTool.getFullClassName((ITypeBinding)node.resolveMethodBinding().getDeclaringClass()) + "." + node.resolveMethodBinding().getName();
        int i = 0;
        while (i < FORBIDDEN_STATIC_METHODS.length) {
            if (fullyQalifiedMethod.equals(FORBIDDEN_STATIC_METHODS[i])) {
                Properties p = new Properties();
                p.setProperty(METHOD_PARAM, FORBIDDEN_STATIC_METHODS[i]);
                this.addError(MSG_KEY_6, p, (Position)node);
            }
            ++i;
        }
        return true;
    }

    public boolean visit(IArrayType node) {
        this.checkForbiddenComponents(node.resolveBinding(), (Position)node);
        return true;
    }

    public boolean visit(IQualifiedName node) {
        this.checkForbiddenComponents(node.resolveTypeBinding(), (Position)node);
        return true;
    }

    public boolean visit(ISimpleName node) {
        this.checkForbiddenComponents(node.resolveTypeBinding(), (Position)node);
        return true;
    }

    public boolean visit(ISimpleType node) {
        this.checkForbiddenComponents(node.resolveBinding(), (Position)node);
        return true;
    }

    public boolean visit(IFieldAccess node) {
        IVariableBinding bnd = node.resolveBinding();
        if (!Modifier.isStatic(node.resolveBinding().getModifiers())) {
            return true;
        }
        String fullName = NameTool.getFullClassName((ITypeBinding)bnd.getDeclaringClass()) + "." + node.getName();
        int i = 0;
        while (i < FORBIDDEN_STATIC_FIELDS.length) {
            if (FORBIDDEN_STATIC_FIELDS[i].equals(fullName)) {
                Properties p = new Properties();
                p.setProperty(FIELD_PARAM, FORBIDDEN_STATIC_FIELDS[i]);
                this.addError(MSG_KEY_7, p, (Position)node);
            }
            ++i;
        }
        return true;
    }

    public boolean visit(IMethodDeclaration node) {
        this.checkFinalize(node);
        if (node.isConstructor()) {
            this.hasConstructor = true;
        }
        if (node.isConstructor() && node.parameters().size() == 0 && Modifier.isPublic(node.getModifiers())) {
            this.hasNoArgsConstructor = true;
        }
        return true;
    }

    private void checkFinalize(IMethodDeclaration node) {
        if (FINALIZE_METH.equals(node.getName()) && Modifier.isPublic(node.getModifiers()) && node.getReturnType().isSimpleType() && "void".equals(((ISimpleType)node.getReturnType()).getName()[0]) && node.parameters().size() == 0) {
            this.addError(MSG_KEY_8, null, (Position)node);
        }
    }

    public void endVisit(ITypeDeclaration node) {
        if (this.isEJB && this.hasConstructor && !this.hasNoArgsConstructor) {
            this.addError(MSG_KEY_9, null, (Position)node);
        }
        this.hasConstructor = false;
        this.hasNoArgsConstructor = false;
        this.isEJB = false;
    }
}

