/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.eclipse.api;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.PrimitiveTypeBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayType;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;

public class EclipseAPITest
extends JomTestVisitor {
    private static final String NAME = "eclipse API";
    private static final String MSG_KEY_1 = "eclipseapi.1";

    public String getTestName() {
        return NAME;
    }

    public boolean visit(IQualifiedName node) {
        this.checkPackageBinding(node.resolveTypeBinding(), (Position)node);
        return true;
    }

    public boolean visit(IArrayType node) {
        this.checkPackageBinding(node.resolveBinding(), (Position)node);
        return true;
    }

    public boolean visit(ISimpleName node) {
        this.checkPackageBinding(node.resolveTypeBinding(), (Position)node);
        return true;
    }

    public boolean visit(ISimpleType node) {
        this.checkPackageBinding(node.resolveBinding(), (Position)node);
        return true;
    }

    private void checkPackageBinding(ITypeBinding bnd, Position position) {
        if (bnd == null) {
            return;
        }
        if (bnd instanceof PrimitiveTypeBinding) {
            return;
        }
        if (bnd instanceof ArrayTypeBinding) {
            this.checkPackageBinding(((ArrayTypeBinding)bnd).getElementType(), position);
            return;
        }
        if (!(bnd instanceof ReferenceTypeBinding)) {
            throw new IllegalArgumentException("unsupported binding type class: " + bnd.getClass().getName());
        }
        IPackageBinding pckBnd = ((ReferenceTypeBinding)bnd).getPackage();
        if (pckBnd == null) {
            return;
        }
        String[] packageComp = pckBnd.getNameComponents();
        if (packageComp == null || packageComp.length < 2) {
            return;
        }
        if (!packageComp[0].equals("org")) {
            return;
        }
        if (!packageComp[1].equals("eclipse")) {
            return;
        }
        int i = 2;
        while (i < packageComp.length) {
            if (packageComp[i].equals("internal")) {
                this.addError(MSG_KEY_1, null, position);
                break;
            }
            ++i;
        }
    }
}

