/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IAnonymousClassDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayType;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssertStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IBooleanLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IBreakStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ICastExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.ICharacterLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IConditionalExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IEmptyStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IImportDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IInfixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IInstanceofExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ILabeledStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.INullLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.INumberLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IPrefixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.IStringLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISynchronizedStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThisExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public class XmlRepresentationTest
extends JomTestVisitor {
    public static final String TEST_NAME = "XML representation";
    public static final String JAVA_EXTENSION_JAVA = ".java";
    public static final String JDT_SUFFIX = "_jdt.xml";
    public static final String PARAMETER_OUTPUT_DIRECTORY = "outputDirectory";
    private StructureTree outputTree;
    private Stack currentTree = new Stack();

    public String getTestName() {
        return TEST_NAME;
    }

    public void endVisit(IArrayType node) {
        this.currentTree.pop();
    }

    public void endVisit(ICatchClause node) {
        this.currentTree.pop();
    }

    public void endVisit(IConstructorInvocation node) {
        this.currentTree.pop();
    }

    public void endVisit(IExpressionStatement node) {
        this.currentTree.pop();
    }

    public void endVisit(IPackageDeclaration node) {
        this.currentTree.pop();
    }

    public void endVisit(ISuperConstructorInvocation node) {
        this.currentTree.pop();
    }

    public void endVisit(ISuperExpression node) {
        this.currentTree.pop();
    }

    public void endVisit(ISuperMethodInvocation node) {
        this.currentTree.pop();
    }

    public void endVisit(IThisExpression node) {
        this.currentTree.pop();
    }

    public void endVisit(ITypeDeclarationStatement node) {
        this.currentTree.pop();
    }

    public void endVisit(ITypeLiteral node) {
        this.currentTree.pop();
    }

    public void endVisit(IVariableDeclaration node) {
        this.currentTree.pop();
    }

    public void endVisit(IVariableDeclarationStatement node) {
        this.currentTree.pop();
    }

    public void endVisit(IClassInstanceCreation allocationExpression) {
        this.currentTree.pop();
    }

    public void endVisit(IAnonymousClassDeclaration anonymousTypeDeclaration) {
        this.currentTree.pop();
    }

    public void endVisit(IArrayCreation arrayAllocationExpression) {
        this.currentTree.pop();
    }

    public void endVisit(IArrayInitializer arrayInitializer) {
        this.currentTree.pop();
    }

    public void endVisit(IArrayAccess arrayAccess) {
        this.currentTree.pop();
    }

    public void endVisit(IAssertStatement assertStatement) {
        this.currentTree.pop();
    }

    public void endVisit(IAssignment assignment) {
        this.currentTree.pop();
    }

    public void endVisit(IInfixExpression binaryExpression) {
        this.currentTree.pop();
    }

    public void endVisit(IBlock block) {
        this.currentTree.pop();
    }

    public void endVisit(IBreakStatement breakStatement) {
        this.currentTree.pop();
    }

    public void endVisit(ISwitchCase caseStatement) {
        this.currentTree.pop();
    }

    public void endVisit(ICastExpression castExpression) {
        this.currentTree.pop();
    }

    public void endVisit(ICharacterLiteral charLiteral) {
        this.currentTree.pop();
    }

    public void endVisit(ICompilationUnit compilationUnitDeclaration) {
        String baseDir = this.testObject.getBaseDir();
        String fileName = new File(compilationUnitDeclaration.getFileName()).getName();
        File dir = new File((String)((Object)this.getParameter(PARAMETER_OUTPUT_DIRECTORY).getValue()) + File.separator + compilationUnitDeclaration.getFileName().substring(baseDir.length() + 1, compilationUnitDeclaration.getFileName().length() - fileName.length()));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String outputFile = (String)((Object)this.getParameter(PARAMETER_OUTPUT_DIRECTORY).getValue()) + File.separator + compilationUnitDeclaration.getFileName().substring(baseDir.length() + 1, compilationUnitDeclaration.getFileName().length() - JAVA_EXTENSION_JAVA.length()) + JDT_SUFFIX;
        try {
            File f = new File(outputFile);
            XMLTool.writeDocument((StructureTree)this.outputTree, (Writer)new FileWriter(f));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void endVisit(IConditionalExpression conditionalExpression) {
        this.currentTree.pop();
    }

    public void endVisit(IContinueStatement continueStatement) {
        this.currentTree.pop();
    }

    public void endVisit(IDoStatement doStatement) {
        this.currentTree.pop();
    }

    public void endVisit(IEmptyStatement statement) {
        this.currentTree.pop();
    }

    public void endVisit(IFieldDeclaration fieldDeclaration) {
        this.currentTree.pop();
    }

    public void endVisit(IFieldAccess fieldAccess) {
        this.currentTree.pop();
    }

    public void endVisit(IForStatement forStatement) {
        this.currentTree.pop();
    }

    public void endVisit(IIfStatement ifStatement) {
        this.currentTree.pop();
    }

    public void endVisit(IImportDeclaration importRef) {
        this.currentTree.pop();
    }

    public void endVisit(IInitializer initializer) {
        this.currentTree.pop();
    }

    public void endVisit(IInstanceofExpression instanceOfExpression) {
        this.currentTree.pop();
    }

    public void endVisit(ILabeledStatement labeledStatement) {
        this.currentTree.pop();
    }

    public void endVisit(INumberLiteral literal) {
        this.currentTree.pop();
    }

    public void endVisit(IMethodInvocation methodCall) {
        this.currentTree.pop();
    }

    public void endVisit(IMethodDeclaration methodDeclaration) {
        this.currentTree.pop();
    }

    public void endVisit(INullLiteral nullLiteral) {
        this.currentTree.pop();
    }

    public void endVisit(IPostfixExpression postfixExpression) {
        this.currentTree.pop();
    }

    public void endVisit(IPrefixExpression prefixExpression) {
        this.currentTree.pop();
    }

    public void endVisit(IQualifiedName qualifiedName) {
        this.currentTree.pop();
    }

    public void endVisit(IReturnStatement returnStatement) {
        this.currentTree.pop();
    }

    public void endVisit(ISimpleName name) {
        this.currentTree.pop();
    }

    public void endVisit(ISimpleType type) {
        this.currentTree.pop();
    }

    public void endVisit(IStringLiteral stringLiteral) {
        this.currentTree.pop();
    }

    public void endVisit(ISwitchStatement switchStatement) {
        this.currentTree.pop();
    }

    public void endVisit(ISynchronizedStatement synchronizedStatement) {
        this.currentTree.pop();
    }

    public void endVisit(IThrowStatement throwStatement) {
        this.currentTree.pop();
    }

    public void endVisit(IBooleanLiteral trueLiteral) {
        this.currentTree.pop();
    }

    public void endVisit(ITryStatement tryStatement) {
        this.currentTree.pop();
    }

    public void endVisit(ITypeDeclaration typeDeclaration) {
        this.currentTree.pop();
    }

    public void endVisit(IWhileStatement whileStatement) {
        this.currentTree.pop();
    }

    public boolean visit(IArrayType node) {
        boolean status = true;
        Header header = new Header("ARRAY_TYPE");
        this.addLineAndCol(header, (Position)node);
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = node.resolveBinding();
            header.setParameter("TYPE", this.getFullName(tb));
            ITypeBinding ct = node.getComponentType();
            header.setParameter("COMPONENT_TYPE", this.getFullName(ct));
            ITypeBinding et = node.getElementType();
            header.setParameter("ELEMENT_TYPE", this.getFullName(et));
            header.setParameter("DIMENSIONS", Integer.toString(node.getDimensions()));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(ICatchClause node) {
        boolean status = true;
        Header header = new Header("CATCH_CLAUSE");
        this.addLineAndCol(header, (Position)node);
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IConstructorInvocation node) {
        boolean status = true;
        Header header = new Header("CONSTRUCTOR_INVOCATION");
        this.addLineAndCol(header, (Position)node);
        IReferenceTypeBinding tb = node.resolveConstructorBinding().getDeclaringClass();
        header.setParameter("TYPE", this.getFullName((ITypeBinding)tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IExpressionStatement node) {
        boolean status = true;
        Header header = new Header("EXPRESSION_STATEMENT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IPackageDeclaration node) {
        boolean status = true;
        Header header = new Header("PACKAGE_DECLARATION");
        header.setParameter("BINDING_NAME", node.resolveBinding().getName());
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(ISuperConstructorInvocation node) {
        boolean status = true;
        Header header = new Header("SUPER_CONSTRUCTOR_INVOCATION");
        header.setParameter("POSITION", Integer.toString(node.getStartPosition()));
        IReferenceTypeBinding tb = node.resolveConstructorBinding().getDeclaringClass();
        header.setParameter("TYPE", this.getFullName((ITypeBinding)tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(ISuperExpression node) {
        boolean status = true;
        Header header = new Header("SUPER_EXPRESSION");
        ITypeBinding tb = node.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(ISuperMethodInvocation node) {
        boolean status = true;
        Header header = new Header("SUPER_METHOD_INVOCATION");
        ITypeBinding tb = node.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        header.setParameter("NAME", node.getName());
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IThisExpression node) {
        boolean status = true;
        Header header = new Header("THIS_EXPRESSION");
        ITypeBinding tb = node.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(ITypeDeclarationStatement node) {
        boolean status = true;
        Header header = new Header("TYPE_DECLARATION_STATEMENT");
        ITypeBinding tb = node.resolveBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(ITypeLiteral node) {
        boolean status = true;
        Header header = new Header("TYPE_LITERAL");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IVariableDeclaration node) {
        boolean status = true;
        Header header = new Header("SINGLE_VARIABLE_DECLARATION");
        ITypeBinding tb = node.resolveBinding().getType();
        header.setParameter("TYPE", this.getFullName(tb));
        header.setParameter("MOdIFIERS", Integer.toString(node.getModifiers()));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IVariableDeclarationStatement node) {
        boolean status = true;
        Header header = new Header("VARIABLE_DECLARATION_STATEMENT");
        header.setParameter("MODIFIERS", Integer.toString(node.getModifiers()));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IClassInstanceCreation allocationExpression) {
        boolean status = true;
        Header header = new Header("CLASS_INSTANCE_CREATION");
        this.addLineAndCol(header, (Position)allocationExpression);
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = allocationExpression.resolveTypeBinding();
            header.setParameter("TYPE", this.getFullName(tb));
            IMethodBinding mb = allocationExpression.resolveConstructorBinding();
            IReferenceTypeBinding tbc = null;
            if (mb != null) {
                tbc = mb.getDeclaringClass();
            }
            header.setParameter("CONSTRUCTOR_TYPE", this.getFullName((ITypeBinding)tbc));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IAnonymousClassDeclaration node) {
        boolean status = true;
        Header header = new Header("ANONYMOUS_CLASS_DECLARATION");
        this.addLineAndCol(header, (Position)node);
        StructureTree tree = new StructureTree(header);
        try {
            IReferenceTypeBinding tb = node.resolveBinding();
            if (tb != null) {
                header.setParameter("TYPE", this.getFullName((ITypeBinding)tb));
                IReferenceTypeBinding tbsuper = tb.getSuperclass();
                if (tbsuper.isClass()) {
                    header.setParameter("SUPERCLASS", this.getFullName((ITypeBinding)tbsuper));
                } else {
                    header.setParameter("SUPERINTERFACE", this.getFullName((ITypeBinding)tbsuper));
                }
            } else {
                header.setParameter("SUPERTYPE", this.getFullName(null));
            }
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IArrayCreation arrayAllocationExpression) {
        boolean status = true;
        Header header = new Header("ARRAY_CREATION");
        this.addLineAndCol(header, (Position)arrayAllocationExpression);
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = arrayAllocationExpression.resolveTypeBinding();
            header.setParameter("TYPE", this.getFullName(tb));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IArrayInitializer arrayInitializer) {
        boolean status = true;
        Header header = new Header("ARRAY_INITIALIZER");
        this.addLineAndCol(header, (Position)arrayInitializer);
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = arrayInitializer.resolveTypeBinding();
            header.setParameter("TYPE", this.getFullName(tb));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IArrayAccess arrayAccess) {
        boolean status = true;
        Header header = new Header("ARRAY_ACCESS");
        this.addLineAndCol(header, (Position)arrayAccess);
        ITypeBinding tb = arrayAccess.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IAssertStatement assertStatement) {
        boolean status = true;
        Header header = new Header("ASSERT");
        this.addLineAndCol(header, (Position)assertStatement);
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IAssignment assignment) {
        Header header = new Header("ASSIGNMENT");
        this.addLineAndCol(header, (Position)assignment);
        header.setParameter("OPERATOR", assignment.getOperator());
        ITypeBinding tb = assignment.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IInfixExpression binaryExpression) {
        boolean status = true;
        Header header = new Header("INFIX_EXPRESSION");
        header.setParameter("OPERATOR", binaryExpression.getOperator());
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = binaryExpression.resolveTypeBinding();
            header.setParameter("TYPE", this.getFullName(tb));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IBlock block) {
        Header header = new Header("BLOCK");
        this.addLineAndCol(header, (Position)block);
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IBreakStatement breakStatement) {
        Header header = new Header("BREAK");
        this.addLineAndCol(header, (Position)breakStatement);
        if (breakStatement.getLabel() != null) {
            header.setParameter("LABEL", breakStatement.getLabel());
        }
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(ISwitchCase caseStatement) {
        Header header = new Header("SWITCH_CASE");
        if (caseStatement.isDefault()) {
            header.setParameter("DEFAULT", "true");
        }
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(ICastExpression castExpression) {
        boolean status = true;
        Header header = new Header("CAST_EXPRESSION");
        this.addLineAndCol(header, (Position)castExpression);
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = castExpression.resolveTypeBinding();
            header.setParameter("TYPE", this.getFullName(tb));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(ICharacterLiteral charLiteral) {
        Header header = new Header("CHARACTER_LITERAL");
        this.addLineAndCol(header, (Position)charLiteral);
        StructureTree tree = new StructureTree(header);
        ITypeBinding tb = charLiteral.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        header.setParameter("CHAR_VALUE", new String(new char[]{charLiteral.charValue()}));
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(ICompilationUnit compilationUnitDeclaration) {
        this.currentCompilationUnit = compilationUnitDeclaration;
        Header header = new Header("COMPILATION_UNIT");
        this.addLineAndCol(header, (Position)compilationUnitDeclaration);
        header.setParameter("FILE", compilationUnitDeclaration.getFileName());
        this.outputTree = new StructureTree(header);
        this.currentTree.push(this.outputTree);
        return true;
    }

    public boolean visit(IConditionalExpression conditionalExpression) {
        Header header = new Header("CONDITIONAL_EXPRESSION");
        this.addLineAndCol(header, (Position)conditionalExpression);
        ITypeBinding tb = conditionalExpression.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IContinueStatement continueStatement) {
        Header header = new Header("CONTINUE");
        if (continueStatement.getLabel() != null) {
            header.setParameter("LABEL", continueStatement.getLabel());
        }
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IDoStatement doStatement) {
        Header header = new Header("DO_STMT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IEmptyStatement statement) {
        Header header = new Header("EMPTY_STMT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IFieldDeclaration fieldDeclaration) {
        boolean status = true;
        Header header = new Header("FIELD_DECLARATION");
        StructureTree tree = new StructureTree(header);
        try {
            header.setParameter("MODIFIERS", Integer.toString(fieldDeclaration.getModifiers()));
            ITypeBinding tb = fieldDeclaration.getType().resolveBinding();
            header.setParameter("TYPE", this.getFullName(tb));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IFieldAccess fieldAccess) {
        boolean status = true;
        Header header = new Header("FIELD_ACCESS");
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = fieldAccess.resolveTypeBinding();
            header.setParameter("TYPE", this.getFullName(tb));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IForStatement forStatement) {
        Header header = new Header("FOR_STATEMENT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IIfStatement ifStatement) {
        Header header = new Header("IF_STATEMENT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IImportDeclaration importRef) {
        Header header = new Header("IMPORT_DECLARATION");
        IBinding binding = importRef.resolveBinding();
        if (binding == null) {
            header.setParameter("BINDING", "_unknown_type_");
        } else {
            if (binding instanceof IPackageBinding) {
                header.setParameter("BINDING", binding.getName());
            }
            if (binding instanceof ITypeBinding) {
                header.setParameter("BINDING", this.getFullName((ITypeBinding)binding));
            }
        }
        if (importRef.isOnDemand()) {
            header.setParameter("ON_DEMAND", "true");
        }
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IInitializer initializer) {
        Header header = new Header("INITIALIZER");
        header.setParameter("MODIFIERS", Integer.toString(initializer.getModifiers()));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IInstanceofExpression instanceOfExpression) {
        Header header = new Header("INSTANCE_OF");
        ITypeBinding tb = instanceOfExpression.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(INumberLiteral literal) {
        Header header = new Header("NUMBER__LITERAL");
        header.setParameter("VALUE", literal.getToken());
        ITypeBinding tb = literal.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(ILabeledStatement labeledStatement) {
        Header header = new Header("LABELED_STMT");
        header.setParameter("LABEL", labeledStatement.getLabel());
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IMethodInvocation methodCall) {
        boolean status = true;
        Header header = new Header("METHOD_INVOCATION");
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = methodCall.resolveTypeBinding();
            header.setParameter("TYPE", this.getFullName(tb));
            header.setParameter("METHOD_NAME", methodCall.getName());
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IMethodDeclaration methodDeclaration) {
        boolean status = true;
        String methodOrConstructor = methodDeclaration.isConstructor() ? "CONSTRUCTOR_DECLARATION" : "METHOD_DECLARATION";
        Header header = new Header(methodOrConstructor);
        header.setParameter("MODIFIERS", Integer.toString(methodDeclaration.getModifiers()));
        StructureTree tree = new StructureTree(header);
        try {
            header.setParameter("NAME", methodDeclaration.getName());
            if (!methodDeclaration.isConstructor()) {
                ITypeBinding tb = methodDeclaration.getReturnType().resolveBinding();
                header.setParameter("RETURN_TYPE", this.getFullName(tb));
            }
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(INullLiteral nullLiteral) {
        Header header = new Header("NULL_LITERAL");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IPostfixExpression postfixExpression) {
        Header header = new Header("POSTFIX_EXPRESSION");
        header.setParameter("OPERATOR", postfixExpression.getOperator());
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IPrefixExpression prefixExpression) {
        Header header = new Header("PREFIX_EXPRESSION");
        header.setParameter("OPERATOR", prefixExpression.getOperator());
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IQualifiedName qualifiedName) {
        boolean status = true;
        Header header = new Header("QUALIFIED_NAME");
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = qualifiedName.resolveTypeBinding();
            header.setParameter("TYPE", this.getFullName(tb));
            StructureTree cTree = tree;
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IReturnStatement returnStatement) {
        Header header = new Header("RETURN_STATEMENT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(ISimpleName name) {
        boolean status = true;
        Header header = new Header("SIMPLE_NAME");
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = name.resolveTypeBinding();
            header.setParameter("IDENTIFIER", name.getIdentifier());
            header.setParameter("TYPE", this.getFullName(tb));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(ISimpleType type) {
        boolean status = true;
        Header header = new Header("SIMPLE_TYPE");
        StructureTree tree = new StructureTree(header);
        try {
            ITypeBinding tb = type.resolveBinding();
            header.setParameter("TYPE", this.getFullName(tb));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IStringLiteral stringLiteral) {
        boolean status = true;
        Header header = new Header("STRING_LITERAL");
        StructureTree tree = new StructureTree(header);
        header.setParameter("LITERAL_VALUE", stringLiteral.getLiteralValue());
        ITypeBinding tb = stringLiteral.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(ISwitchStatement switchStatement) {
        Header header = new Header("SWITCH_STATEMENT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(ISynchronizedStatement synchronizedStatement) {
        Header header = new Header("SYNCHRONIZED_STATEMENT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IThrowStatement throwStatement) {
        Header header = new Header("THROW_STMT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(IBooleanLiteral literal) {
        Header header = new Header("BOOLEAN_LITERAL");
        this.addLineAndCol(header, (Position)literal);
        header.setParameter("VALUE", String.valueOf(literal.booleanValue()));
        ITypeBinding tb = literal.resolveTypeBinding();
        header.setParameter("TYPE", this.getFullName(tb));
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(ITryStatement tryStatement) {
        Header header = new Header("TRY_STMT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public boolean visit(ITypeDeclaration typeDeclaration) {
        boolean status = true;
        Header header = new Header("TYPE_DECLARATION");
        if (typeDeclaration.isInterface()) {
            header.setParameter("IS_INTERFACE", "true");
        }
        if (typeDeclaration.isPackageMemberTypeDeclaration()) {
            header.setParameter("IS_PACKAGE_MEMBER_TYPE_DECL", "true");
        }
        if (typeDeclaration.isMemberTypeDeclaration()) {
            header.setParameter("IS_MEMBER_TYPE_DECL", "true");
        }
        if (typeDeclaration.isLocalTypeDeclaration()) {
            header.setParameter("IS_LOCAL_TYPE_DECL", "true");
        }
        header.setParameter("MODIFIERS", Integer.toString(typeDeclaration.getModifiers()));
        StructureTree tree = new StructureTree(header);
        try {
            IReferenceTypeBinding tb = typeDeclaration.resolveBinding();
            header.setParameter("TYPE", this.getFullName((ITypeBinding)tb));
        }
        catch (Exception e) {
            this.writeError(e, tree);
            status = false;
        }
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return status;
    }

    public boolean visit(IWhileStatement whileStatement) {
        Header header = new Header("WHILE_STATEMENT");
        StructureTree tree = new StructureTree(header);
        ((StructureTree)this.currentTree.peek()).addNewChild(tree);
        this.currentTree.push(tree);
        return true;
    }

    public void writeError(Exception e, StructureTree tree) {
        this.logException(e);
    }

    private String getFullName(ITypeBinding tb) {
        if (tb == null) {
            return "_unknown type_";
        }
        return tb.getName();
    }

    private void addLineAndCol(Header header, Position pos) {
        header.setParameter("LINE", String.valueOf(this.currentCompilationUnit.lineNumber(pos.getStartPosition())));
    }
}

