/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import com.sap.tc.jtools.jlint.javadiff.comparator.ListenerInterface;
import com.sap.tc.jtools.jlint.javadiff.tests.APIDiff;
import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.javaelements.FieldInterface;
import com.sap.tc.jtools.jlint.javaelements.MethodInterface;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.NameTool;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

class Listener
implements ListenerInterface {
    private ITypeDeclaration currentClass;
    private String packageName;
    APIDiff visitor;

    public Listener(String packageName, APIDiff visitor) {
        this.packageName = packageName;
        this.visitor = visitor;
    }

    public void setClass(ITypeDeclaration cls) {
        this.currentClass = cls;
    }

    public void extraFieldIn1(FieldInterface f1) {
        String fieldName = f1.getName();
        IFieldDeclaration fd = this.findField(f1);
        Properties properties = new Properties();
        properties.setProperty("FIELD_NAME", fieldName);
        this.visitor.addError("apidiff.4", properties, (Position)fd);
    }

    public void extraFieldIn2(FieldInterface f2) {
        String fieldName = f2.getName();
        Properties properties = new Properties();
        properties.setProperty("FIELD_NAME", fieldName);
        this.visitor.addError("apidiff.5", properties, (Position)this.findClass(this.getFullClassName(f2.getDefiningClass())));
    }

    public void extraMethodIn1(MethodInterface method1) {
        StringBuffer signature = new StringBuffer();
        String[] parTypes = method1.getParameterTypes();
        int i = 0;
        while (i < parTypes.length) {
            if (i > 0) {
                signature.append(", ");
            }
            signature.append(parTypes[i]);
            ++i;
        }
        String methodName = method1.getMethodName();
        IMethodDeclaration md = this.findMethod(method1);
        Properties properties = new Properties();
        properties.setProperty("METHOD_NAME", (methodName == null ? "<constructor>" : methodName) + "(" + signature.toString() + ")");
        this.visitor.addError("apidiff.6", properties, (Position)md);
    }

    public void extraMethodIn2(MethodInterface method2) {
        String methodName = method2.getMethodName();
        StringBuffer signature = new StringBuffer();
        String[] parTypes = method2.getParameterTypes();
        int i = 0;
        while (i < parTypes.length) {
            if (i > 0) {
                signature.append(", ");
            }
            signature.append(parTypes[i]);
            ++i;
        }
        Properties properties = new Properties();
        properties.setProperty("METHOD_NAME", (methodName == null ? "<constructor>" : methodName) + "(" + signature.toString() + ")");
        this.visitor.addError("apidiff.7", properties, (Position)this.findClass(this.getFullClassName(method2.getDefiningClass())));
    }

    public void differentMethodSignatures(MethodInterface method1, MethodInterface method2) {
        String methodName = method1.getMethodName();
        StringBuffer signature = new StringBuffer();
        String[] parTypes = method1.getParameterTypes();
        int i = 0;
        while (i < parTypes.length) {
            if (i > 0) {
                signature.append(", ");
            }
            signature.append(parTypes[i]);
            ++i;
        }
        String refMethodName = method2.getMethodName();
        StringBuffer refSignature = new StringBuffer();
        String[] parTypes2 = method2.getParameterTypes();
        int i2 = 0;
        while (i2 < parTypes2.length) {
            if (i2 > 0) {
                refSignature.append(", ");
            }
            refSignature.append(parTypes2[i2]);
            ++i2;
        }
        IMethodDeclaration md = this.findMethod(method1);
        Properties properties = new Properties();
        properties.setProperty("METHOD_NAME", (methodName == null ? "<constructor>" : methodName) + "(" + signature.toString() + ")");
        properties.setProperty("REF_METHOD_NAME", (refMethodName == null ? "<constructor>" : refMethodName) + "(" + refSignature.toString() + ")");
        this.visitor.addError("apidiff.8", properties, (Position)md);
    }

    public void differentClassModifiers(ClassInterface c1, ClassInterface c2) {
        Properties properties = new Properties();
        properties.setProperty("MOD_1", NameTool.getHumanReadableModifiers((int)c1.getModifiers()));
        properties.setProperty("MOD_2", NameTool.getHumanReadableModifiers((int)c2.getModifiers()));
        this.visitor.addError("apidiff.9", properties, (Position)this.findClass(c1));
    }

    public void differentMethodModifiers(MethodInterface m1, MethodInterface m2) {
        IMethodDeclaration md = this.findMethod(m1);
        Properties properties = new Properties();
        properties.setProperty("MOD_1", NameTool.getHumanReadableModifiers((int)m1.getModifiers()));
        properties.setProperty("MOD_2", NameTool.getHumanReadableModifiers((int)m2.getModifiers()));
        this.visitor.addError("apidiff.9", properties, (Position)md);
    }

    public void differentFieldModifiers(FieldInterface f1, FieldInterface f2) {
        IFieldDeclaration fd = this.findField(f1);
        Properties properties = new Properties();
        properties.setProperty("MOD_1", NameTool.getHumanReadableModifiers((int)f1.getModifiers()));
        properties.setProperty("MOD_2", NameTool.getHumanReadableModifiers((int)f2.getModifiers()));
        this.visitor.addError("apidiff.9", properties, (Position)fd);
    }

    public void differentSuperclass(ClassInterface c1, ClassInterface c2) {
        Properties properties = new Properties();
        String tmp = c1.getSuperclass();
        if (tmp == null) {
            tmp = "null";
        }
        properties.setProperty("SC_1", tmp);
        tmp = c2.getSuperclass();
        if (tmp == null) {
            tmp = "null";
        }
        properties.setProperty("SC_2", tmp);
        this.visitor.addError("apidiff.10", properties, (Position)this.findClass(c1));
    }

    public void extraSuperInterfaceIn1(ClassInterface c1, String si) {
        Properties properties = new Properties();
        properties.setProperty("INTERFACE", si);
        this.visitor.addError("apidiff.11", properties, (Position)this.findClass(c1));
    }

    public void extraSuperInterfaceIn2(ClassInterface c1, String si) {
        Properties properties = new Properties();
        properties.setProperty("INTERFACE", si);
        this.visitor.addError("apidiff.12", properties, (Position)this.findClass(c1));
    }

    public void extraClassIn1(ClassInterface cl, ClassInterface cls) {
        Properties properties = new Properties();
        this.visitor.addError("apidiff.13", properties, (Position)this.findClass(cls));
    }

    public void extraClassIn2(ClassInterface cl, ClassInterface cls) {
        Properties properties = new Properties();
        properties.setProperty("CLASS", cls.getClassName());
        this.visitor.addError("apidiff.14", properties, (Position)this.findClass(cl));
    }

    public void differentReturnTypes(MethodInterface m1, MethodInterface m2) {
        String signature = "";
        String[] parTypes = m1.getParameterTypes();
        int i = 0;
        while (i < parTypes.length) {
            signature = signature + parTypes[i] + ";";
            ++i;
        }
        IMethodDeclaration md = this.findMethod(m1);
        Properties properties = new Properties();
        properties.setProperty("RT_1", m1.getReturnType());
        properties.setProperty("RT_2", m2.getReturnType());
        this.visitor.addError("apidiff.15", properties, (Position)md);
    }

    public void differentExceptions(MethodInterface m1, MethodInterface m2) {
        Properties properties = new Properties();
        String exc1 = "";
        String[] et1 = m1.getExceptionTypes();
        int i = 0;
        while (i < et1.length) {
            exc1 = exc1 + et1[i] + ", ";
            ++i;
        }
        String exc2 = "";
        String[] et2 = m2.getExceptionTypes();
        int i2 = 0;
        while (i2 < et2.length) {
            exc2 = exc2 + et2[i2] + ", ";
            ++i2;
        }
        properties.setProperty("EXC_1", exc1);
        properties.setProperty("EXC_2", exc2);
        this.visitor.addError("apidiff.16", properties, (Position)this.findMethod(m1));
    }

    public void differentFieldTypes(FieldInterface f1, FieldInterface f2) {
        Properties properties = new Properties();
        properties.setProperty("TYPE_1", f1.getType());
        properties.setProperty("TYPE_2", f2.getType());
        this.visitor.addError("apidiff.17", properties, (Position)this.findField(f1));
    }

    public void differentFieldValues(FieldInterface f1, FieldInterface f2) {
        Properties properties = new Properties();
        String value1 = f1.getValue();
        String value2 = f2.getValue();
        properties.setProperty("VALUE_1", value1 == null ? "<null>" : value1);
        properties.setProperty("VALUE_2", value2 == null ? "<null>" : value2);
        this.visitor.addError("apidiff.18", properties, (Position)this.findField(f1));
    }

    private String getFullClassName(ClassInterface ci) {
        return ci.getPckName() == null ? ci.getClassName() : ci.getPckName() + "." + ci.getClassName();
    }

    private ITypeDeclaration findClass(ClassInterface c) {
        return this.findClass(this.getFullClassName(c));
    }

    private ITypeDeclaration findClass(String className) {
        String topLevelClassName = this.currentClass.getName().getIdentifier();
        if (this.packageName != null) {
            topLevelClassName = this.packageName + "." + topLevelClassName;
        }
        if (!className.startsWith(topLevelClassName)) {
            return null;
        }
        ITypeDeclaration cls = this.currentClass;
        StringTokenizer tokenizer = new StringTokenizer(className.substring(this.packageName.length() + 1), ".");
        tokenizer.nextToken();
        block0: while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            ITypeDeclaration[] innerTypes = cls.getTypes();
            int i = 0;
            while (i < innerTypes.length) {
                if (innerTypes[i].getName().getIdentifier().equals(element)) {
                    cls = innerTypes[i];
                    continue block0;
                }
                ++i;
            }
            return null;
        }
        return cls;
    }

    private IMethodDeclaration findMethod(MethodInterface m) {
        ITypeDeclaration type = this.findClass(this.getFullClassName(m.getDefiningClass()));
        if (type == null) {
            return null;
        }
        String methodName = m.getMethodName();
        String[] signature = m.getParameterTypes();
        IMethodDeclaration[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            block5: {
                List params;
                if ((methods[i].isConstructor() && methodName == null || !methods[i].isConstructor() && methods[i].getName().equals(methodName)) && (params = methods[i].parameters()).size() == signature.length) {
                    int j = 0;
                    while (j < params.size()) {
                        if (((IVariableDeclaration)params.get(j)).getType().resolveBinding().getName().equals(signature[j])) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    return methods[i];
                }
            }
            ++i;
        }
        return null;
    }

    private IFieldDeclaration findField(FieldInterface f) {
        ITypeDeclaration type = this.findClass(this.getFullClassName(f.getDefiningClass()));
        if (type == null) {
            return null;
        }
        IFieldDeclaration[] fields = type.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(f.getName())) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }
}

