/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import com.sap.tc.jtools.jlint.javadiff.tests.APIDiff;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class InstanceMetaInfo
implements Serializable {
    private boolean isTest = false;
    private boolean isNOTTest = false;
    private boolean isAPI = false;
    private boolean isRequiredAsAPI = false;
    private boolean isNOTAPI = false;
    private Set descendants = null;
    private String projectName = "API";
    private static final long serialVersionUID = 1L;

    public void addDescendant(String packageAndClass) {
        if (this.descendants == null) {
            this.descendants = new HashSet();
        }
        this.descendants.add(packageAndClass);
        this.isRequiredAsAPI = true;
    }

    public Set getDescendants() {
        return this.descendants;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean isAPI() {
        return this.isAPI;
    }

    public boolean isNOTApi() {
        return this.isNOTAPI;
    }

    public boolean isTest() {
        return this.isTest;
    }

    public boolean isNOTTest() {
        return this.isNOTTest;
    }

    public void setIsAPI(boolean value) {
        if (value) {
            this.isAPI = true;
        } else {
            this.isNOTAPI = true;
        }
    }

    public void setIsTest(boolean value) {
        if (value) {
            this.isTest = true;
        } else {
            this.isNOTTest = true;
        }
    }

    public void setIsRequiredAsAPI(boolean value) {
        if (value) {
            this.isRequiredAsAPI = true;
        }
    }

    void processAPIFlags(String packageAndClass, APIDiff messageHelper) {
        Properties properties;
        if (this.isAPI && this.isNOTAPI) {
            properties = new Properties();
            properties.setProperty("packageAndClass", packageAndClass);
            messageHelper.addError("apidiff.21", properties);
            this.isNOTAPI = false;
        }
        if (this.isTest && this.isNOTTest) {
            properties = new Properties();
            properties.setProperty("packageAndClass", packageAndClass);
            messageHelper.addError("apidiff.25", properties);
            this.isNOTTest = false;
        }
        if (this.isTest && this.isAPI) {
            properties = new Properties();
            properties.setProperty("packageAndClass", packageAndClass);
            messageHelper.addError("apidiff.26", properties);
            this.isTest = false;
        }
        if (this.isRequiredAsAPI && !this.isAPI) {
            Iterator theDescendants = this.descendants.iterator();
            while (theDescendants.hasNext()) {
                String descendant = (String)theDescendants.next();
                Properties properties2 = new Properties();
                properties2.setProperty("CLASS", descendant);
                properties2.setProperty("ANCESTOR", packageAndClass);
                messageHelper.addError("apidiff.20", properties2);
            }
            this.isAPI = true;
            this.isNOTAPI = false;
        }
    }
}

