/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import com.sap.tc.jtools.jlint.java.JavaFileArrayTestObject;
import com.sap.tc.jtools.jlint.javadiff.tests.APIDiffUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class CodeClassification {
    public static final int JAVADOC_DEFINED = 1;
    public static final int AP_DEFINED = 2;
    public static final int USAGE_DEFINE = 4;
    private static Map loadedFileListsAP = new HashMap();
    private static Map loadedFileListsJD = new HashMap();
    private static Map loadedFileListsUS = new HashMap();

    public CodeClassification(String[] referenceDirs) {
        int length = referenceDirs.length;
        HashMap tmp1 = new HashMap();
        HashMap tmp2 = new HashMap();
        HashMap tmp3 = new HashMap();
        int i = 0;
        while (i < length) {
            Properties apiFiles;
            String file1 = referenceDirs[i] + "\\" + "APIclassesAP.properties";
            String file2 = referenceDirs[i] + "\\APIClassesJavaDoc.properties";
            String file3 = referenceDirs[i] + "\\missingClasses.properties";
            if (loadedFileListsAP.containsKey(file1)) {
                tmp1.put(file1, loadedFileListsAP.get(file1));
            } else {
                apiFiles = APIDiffUtil.loadProcessedClasses(file1);
                tmp1.put(file1, apiFiles);
            }
            if (loadedFileListsJD.containsKey(file2)) {
                tmp2.put(file2, loadedFileListsJD.get(file2));
            } else {
                apiFiles = APIDiffUtil.loadProcessedClasses(file2);
                tmp2.put(file2, apiFiles);
            }
            if (loadedFileListsUS.containsKey(file3)) {
                tmp3.put(file3, loadedFileListsUS.get(file3));
            } else {
                apiFiles = APIDiffUtil.loadProcessedClasses(file3);
                tmp3.put(file3, apiFiles);
            }
            ++i;
        }
        loadedFileListsAP = tmp1;
        loadedFileListsJD = tmp2;
        loadedFileListsUS = tmp3;
    }

    private boolean isApi(Map fileList, String packageAndClass) {
        boolean result = false;
        Collection values = fileList.values();
        if (values != null) {
            Iterator it = values.iterator();
            String test = null;
            while (it.hasNext() && test == null) {
                Properties prop = (Properties)it.next();
                test = (String)((Hashtable)prop).get(packageAndClass);
            }
            if (test != null) {
                return true;
            }
        }
        return result;
    }

    public boolean isApi(JavaFileArrayTestObject testObject, String packageAndClass) {
        boolean tmp = this.isApi(loadedFileListsAP, packageAndClass);
        if (tmp) {
            return true;
        }
        tmp = this.isApi(loadedFileListsJD, packageAndClass);
        if (tmp) {
            return true;
        }
        tmp = this.isApi(loadedFileListsUS, packageAndClass);
        if (tmp) {
            return true;
        }
        String[] codeClasses = testObject.getCodeClassification();
        int i = 0;
        while (i < codeClasses.length) {
            if ("api".equals(codeClasses[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getReasonForAPI(String packageAndClass) {
        Properties prop;
        String test = null;
        Collection values = loadedFileListsJD.values();
        Iterator it = values.iterator();
        while (it.hasNext() && test == null) {
            prop = (Properties)it.next();
            test = (String)((Hashtable)prop).get(packageAndClass);
        }
        if (test != null) {
            return 1;
        }
        values = loadedFileListsAP.values();
        it = values.iterator();
        test = null;
        while (it.hasNext() && test == null) {
            prop = (Properties)it.next();
            test = (String)((Hashtable)prop).get(packageAndClass);
        }
        if (test != null) {
            return 2;
        }
        values = loadedFileListsUS.values();
        it = values.iterator();
        test = null;
        while (it.hasNext() && test == null) {
            prop = (Properties)it.next();
            test = (String)((Hashtable)prop).get(packageAndClass);
        }
        if (test != null) {
            return 4;
        }
        return 0;
    }

    public boolean isTest(JavaFileArrayTestObject testObject, String packageAndClass) {
        String[] codeClasses = testObject.getCodeClassification();
        int i = 0;
        while (i < codeClasses.length) {
            if ("test".equals(codeClasses[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

