/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import com.sap.tc.jtools.jlint.javadiff.tests.APIDiff;
import com.sap.tc.jtools.jlint.javadiff.tests.APIDiffUtil;
import com.sap.tc.jtools.jlint.javadiff.tests.InstanceMetaInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class APIMetaInfo {
    private APIDiff messageHelper = null;
    private static HashMap processedClasses = null;

    public APIMetaInfo(APIDiff tmp, String filename) {
        this.messageHelper = tmp;
        if (processedClasses == null) {
            File file = new File(filename);
            try {
                FileInputStream str = new FileInputStream(file);
                ObjectInputStream ostr = new ObjectInputStream(str);
                processedClasses = (HashMap)ostr.readObject();
            }
            catch (FileNotFoundException ex) {
                processedClasses = new HashMap();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    public void addAncestor(String Class2, String ancestor) {
        InstanceMetaInfo tmp = (InstanceMetaInfo)processedClasses.get(ancestor);
        if (tmp == null) {
            tmp = new InstanceMetaInfo();
            processedClasses.put(ancestor, tmp);
        }
        tmp.addDescendant(Class2);
    }

    public void setAPIFlag(String packageAndClass, boolean isAPI) {
        InstanceMetaInfo old = (InstanceMetaInfo)processedClasses.get(packageAndClass);
        if (old == null) {
            old = new InstanceMetaInfo();
            processedClasses.put(packageAndClass, old);
        }
        old.setIsAPI(isAPI);
    }

    public void setTestFlag(String packageAndClass, boolean isTest) {
        InstanceMetaInfo old = (InstanceMetaInfo)processedClasses.get(packageAndClass);
        if (old == null) {
            old = new InstanceMetaInfo();
            processedClasses.put(packageAndClass, old);
        }
        old.setIsTest(isTest);
    }

    private void checkDescendants(String packageAndClass, InstanceMetaInfo value) {
        if (value.isAPI()) {
            return;
        }
        Set descendants = value.getDescendants();
        if (descendants != null) {
            Iterator it = descendants.iterator();
            while (it.hasNext()) {
                String childName = (String)it.next();
                InstanceMetaInfo child = (InstanceMetaInfo)processedClasses.get(childName);
                if (child.isAPI() && value.isNOTApi()) {
                    value.setIsRequiredAsAPI(true);
                }
                if (!child.isAPI() || !value.isTest()) continue;
                Properties prop = new Properties();
                ((Hashtable)prop).put("packageAndClass", childName);
                ((Hashtable)prop).put("testClass", packageAndClass);
                this.messageHelper.addError("apidiff.27", prop);
            }
        }
    }

    public void processAPIFlags() {
        InstanceMetaInfo value;
        String packageAndClass;
        Set keys = processedClasses.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            packageAndClass = (String)it.next();
            value = (InstanceMetaInfo)processedClasses.get(packageAndClass);
            this.checkDescendants(packageAndClass, value);
        }
        it = keys.iterator();
        while (it.hasNext()) {
            packageAndClass = (String)it.next();
            value = (InstanceMetaInfo)processedClasses.get(packageAndClass);
            value.processAPIFlags(packageAndClass, this.messageHelper);
        }
    }

    public void saveProcessedClasses(String outputDir) {
        try {
            FileOutputStream out = new FileOutputStream(outputDir + "/ClassesInNewApi.ser");
            ObjectOutputStream out2 = new ObjectOutputStream(out);
            out2.writeObject(processedClasses);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        Properties prop = new Properties();
        Iterator it = processedClasses.keySet().iterator();
        while (it.hasNext()) {
            String packageAndClass = (String)it.next();
            InstanceMetaInfo info = (InstanceMetaInfo)processedClasses.get(packageAndClass);
            String project = info.getProjectName();
            ((Hashtable)prop).put(packageAndClass, project);
        }
        APIDiffUtil.saveProcessedClasses(outputDir + "/ClassesInNewApi.properties", prop);
    }
}

