/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff.tests;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.javadiff.comparator.Comparator;
import com.sap.tc.jtools.jlint.javadiff.comparator.FilterInterface;
import com.sap.tc.jtools.jlint.javadiff.comparator.ListenerInterface;
import com.sap.tc.jtools.jlint.javadiff.tests.APIMetaInfo;
import com.sap.tc.jtools.jlint.javadiff.tests.CodeClassification;
import com.sap.tc.jtools.jlint.javadiff.tests.Listener;
import com.sap.tc.jtools.jlint.javadiff.util.APIFilter;
import com.sap.tc.jtools.jlint.javadiff.wrapper.Wrapper;
import com.sap.tc.jtools.jlint.javaelements.Class;
import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class APIDiff
extends JomTestVisitor {
    public static final String TEST_NAME = "API Diff";
    public static final String API_SUFFIX = "_api.xml";
    public static final String MSG_KEY_WRAPPING_ERROR = "apidiff.1";
    public static final String MSG_KEY_REF_CLASS_PARSING_ERROR = "apidiff.3";
    public static final String MSG_KEY_EXTRA_FIELD = "apidiff.4";
    public static final String MSG_KEY_MISSING_FIELD = "apidiff.5";
    public static final String MSG_KEY_EXTRA_METHOD = "apidiff.6";
    public static final String MSG_KEY_MISSING_METHOD = "apidiff.7";
    public static final String MSG_KEY_CHANGED_SIGNATURE = "apidiff.8";
    public static final String MSG_KEY_CHANGED_MODIFIERS = "apidiff.9";
    public static final String MSG_KEY_CHANGED_SUPERCLASS = "apidiff.10";
    public static final String MSG_KEY_EXTRA_SI = "apidiff.11";
    public static final String MSG_KEY_MISSING_SI = "apidiff.12";
    public static final String MSG_KEY_EXTRA_CLASS = "apidiff.13";
    public static final String MSG_KEY_MISSING_CLASS = "apidiff.14";
    public static final String MSG_KEY_CHANGED_RETURN_TYPE = "apidiff.15";
    public static final String MSG_KEY_CHANGED_EXCEPTIONS = "apidiff.16";
    public static final String MSG_KEY_CHANGED_FIELD_TYPE = "apidiff.17";
    public static final String MSG_KEY_CHANGED_FIELD_VALUE = "apidiff.18";
    public static final String PARAMETER_REFERENCE_DIRECTORY = "REFERENCE_DIRS";
    public static final String PARAMETER_EXCEPTIONS_LISTS = "EXCEPTION_LISTS";
    private String packageName;
    private String[] referenceDirs;
    private static String outputDir;
    private boolean inProcessErrors = false;
    private List messages;
    private Comparator comparator;
    private Listener listener;
    private static boolean messageIsGenerated;
    private static APIMetaInfo data;

    public String getTestName() {
        return TEST_NAME;
    }

    public boolean visit(ITypeDeclaration node) {
        Class currentClass;
        boolean isAPI = false;
        CodeClassification classif = new CodeClassification(this.referenceDirs);
        String className = node.getName().getIdentifier();
        String packageAndClass = this.packageName + "." + className;
        boolean isTest = classif.isTest(this.testObject, packageAndClass);
        data.setTestFlag(packageAndClass, isTest);
        isAPI = classif.isApi(this.testObject, packageAndClass);
        data.setAPIFlag(packageAndClass, isAPI);
        if (!isAPI) {
            return false;
        }
        if (!messageIsGenerated) {
            super.addError("apidiff.19", null);
            messageIsGenerated = true;
        }
        this.listener.setClass(node);
        try {
            currentClass = Wrapper.wrap((ITypeDeclaration)node);
        }
        catch (Exception e) {
            this.logException(e);
            Properties properties = new Properties();
            properties.setProperty("PACKAGE", this.packageName);
            properties.setProperty("CLASS", className);
            this.addError(MSG_KEY_WRAPPING_ERROR, properties, (Position)node);
            return false;
        }
        String superName = currentClass.getSuperclass();
        if (superName != null) {
            data.addAncestor(packageAndClass, superName);
        }
        String[] interfaces = currentClass.getSuperinterfaces();
        int i = 0;
        while (i < interfaces.length) {
            data.addAncestor(packageAndClass, interfaces[i]);
            ++i;
        }
        try {
            Class referenceClass = this.getClass(this.packageName, className, this.referenceDirs);
            if (referenceClass == null) {
                System.out.println("found no reference data for class, is it new? " + packageAndClass);
                return false;
            }
            this.comparator.compareClasses((ClassInterface)currentClass, (ClassInterface)referenceClass);
        }
        catch (Exception e) {
            this.logException(e);
            Properties properties = new Properties();
            properties.setProperty("PACKAGE", this.packageName);
            properties.setProperty("CLASS", className);
            this.addError(MSG_KEY_REF_CLASS_PARSING_ERROR, properties, (Position)node);
        }
        return false;
    }

    public boolean visit(IPackageDeclaration node) {
        String[] nameComponents = node.getName();
        this.packageName = nameComponents[0];
        int i = 1;
        while (i < nameComponents.length) {
            this.packageName = this.packageName + "." + nameComponents[i];
            ++i;
        }
        return true;
    }

    public boolean visit(ICompilationUnit node) {
        this.comparator = new Comparator();
        this.listener = new Listener(this.packageName, this);
        this.comparator.attachListener((ListenerInterface)this.listener);
        this.comparator.attachFilter((FilterInterface)new APIFilter());
        return true;
    }

    private Class getClass(String packageName, String className, String[] referenceDirs) throws IOException, XMLParseException, BadTreeException {
        Class result = null;
        if (referenceDirs == null) {
            return null;
        }
        int i = 0;
        while (i < referenceDirs.length) {
            String oneDir = referenceDirs[i];
            result = this.getClass(packageName, className, oneDir);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class getClass(String packageName, String className, String referenceDir) throws IOException, XMLParseException, BadTreeException {
        String fullClassName = packageName != null ? packageName.replace('.', File.separatorChar) + File.separator + className : className;
        String absolutePath = referenceDir + File.separator + fullClassName + API_SUFFIX;
        File f = new File(absolutePath);
        if (!f.isFile()) {
            return null;
        }
        Reader fr = null;
        StructureTree st = null;
        try {
            fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF8"));
            st = XMLTool.parseReader((Reader)fr);
            Object var10_9 = null;
            if (fr == null) return new Class(st);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (fr == null) throw throwable;
            fr.close();
            throw throwable;
        }
        fr.close();
        return new Class(st);
    }

    public void setParameters(ParameterInterface[] parameters, TestObject testObject) {
        super.setParameters(parameters, testObject);
        System.out.println("setParameters is called");
        ParameterInterface tmp = this.getParameter("OUTPUT_DIR");
        outputDir = (String)((Object)tmp.getValue());
        this.referenceDirs = (String[])this.getParameter(PARAMETER_REFERENCE_DIRECTORY).getValue();
        data = new APIMetaInfo(this, outputDir + "/ClassesInNewApi.ser");
        messageIsGenerated = false;
    }

    public void addError(String key, Properties params, Position pos) {
        if (this.inProcessErrors) {
            Result tmp = new Result(this.getName(), "Java file list", "", null, 1, "", params);
            this.messages.add(tmp);
        } else {
            super.addError(key, params, pos);
        }
    }

    public void addError(String key, Properties params) {
        if (this.inProcessErrors) {
            Result tmp = new Result(this.getName(), "Java file list", "", null, 1, "", params);
            this.messages.add(tmp);
        } else {
            super.addError(key, params);
        }
    }

    public ResultInterface[] processErrors(ResultInterface[] params) {
        super.processErrors(params);
        System.out.println("processErrors is called");
        ResultInterface[] result = null;
        this.inProcessErrors = true;
        try {
            if (data != null) {
                ResultInterface[] tmp;
                this.messages = new ArrayList();
                int i = 0;
                while (i < params.length) {
                    this.messages.add(params[i]);
                    ++i;
                }
                if (outputDir != null) {
                    data.saveProcessedClasses(outputDir);
                    outputDir = null;
                }
                data.processAPIFlags();
                result = tmp = this.messages.toArray(new ResultInterface[this.messages.size()]);
            } else {
                System.out.println("Ignoring call to processErrors before setParameters");
            }
            Object var6_5 = null;
            this.inProcessErrors = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.inProcessErrors = false;
            throw throwable;
        }
        return result;
    }

    static {
        messageIsGenerated = false;
        data = null;
    }
}

