/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff;

import com.sap.tc.jtools.jlint.javadiff.tests.APIDiffUtil;
import com.sap.tc.jtools.jlint.javaelements.Class;
import com.sap.tc.jtools.jlint.javaelements.Method;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class BinaryConverter {
    public static final String API_SUFFIX = "_api.xml";
    public static final String OUTFILENAME = "APIclassesAP.properties";
    private static final String CLASS_SUFFIX = ".class";
    private static Properties _classnames = null;
    private static Properties _missingClasses = new Properties();
    private URL[] apiJars;
    private String _outputDir;

    public BinaryConverter(File[] rootDirsOrJarFiles, File[] additionalJarFiles, String outputDir) {
        int i;
        this._outputDir = outputDir;
        _classnames = APIDiffUtil.loadProcessedClasses(outputDir + File.separator + OUTFILENAME);
        int numberOfDirs = rootDirsOrJarFiles.length;
        int numberOfDirs2 = additionalJarFiles.length;
        this.apiJars = new URL[numberOfDirs + numberOfDirs2];
        try {
            int i2 = 0;
            while (i2 < numberOfDirs) {
                this.apiJars[i2] = rootDirsOrJarFiles[i2].toURL();
                ++i2;
            }
            i = 0;
            while (i < numberOfDirs2) {
                this.apiJars[numberOfDirs + i] = additionalJarFiles[i].toURL();
                ++i;
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
        i = 0;
        while (i < numberOfDirs) {
            File oneDir = rootDirsOrJarFiles[i];
            System.out.print("About to process " + (i + 1) + " of " + numberOfDirs + " folders/jars ");
            System.out.println(oneDir.getName());
            if (oneDir.isDirectory()) {
                this.convertDirectory("", oneDir);
            } else {
                this.processJar(oneDir);
            }
            ++i;
        }
    }

    public void saveStatistics() {
        APIDiffUtil.saveProcessedClasses(this._outputDir + File.separator + OUTFILENAME, _classnames);
        APIDiffUtil.saveProcessedClasses(this._outputDir + File.separator + "missingClasses.properties", _missingClasses);
    }

    private void processJar(File jarfile) {
        URLClassLoader loader = new URLClassLoader(this.apiJars);
        try {
            JarFile file = new JarFile(jarfile);
            Enumeration<JarEntry> allFiles = file.entries();
            while (allFiles.hasMoreElements()) {
                String fileName;
                JarEntry tmp = allFiles.nextElement();
                JarEntry oneEntry = tmp;
                if (oneEntry.isDirectory() || !this.isValidClassFileName(fileName = oneEntry.getName())) continue;
                this.handleOneClass(fileName, loader);
            }
        }
        catch (IOException ex) {
            System.err.println(jarfile.getAbsolutePath());
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    private static String getTypeName(java.lang.Class param) {
        String result = null;
        if (param.isArray()) {
            java.lang.Class<?> tmp = param.getComponentType();
            String tmp2 = BinaryConverter.getTypeName(tmp);
            result = tmp2 + "[]";
        } else {
            result = param.getName();
        }
        return result;
    }

    private String extractClassNameFromRelativeFilename(String relativeFilename) {
        String result = null;
        int pos = relativeFilename.indexOf(CLASS_SUFFIX);
        String tmp = relativeFilename.substring(0, pos);
        String tmp2 = tmp.replace(File.separatorChar, '.');
        result = tmp2.replace('/', '.');
        return result;
    }

    private void checkOrCreateFolders(String fileName) {
        int pos = fileName.lastIndexOf(File.separatorChar);
        String outdir = pos > 0 ? fileName.substring(0, pos) : fileName;
        File outputSubdirectory = new File(outdir);
        if (!outputSubdirectory.exists()) {
            outputSubdirectory.mkdirs();
        }
    }

    private Method constructorToMethod(Constructor theMethod) {
        Method result = null;
        String name = theMethod.getName();
        boolean isConstructor = true;
        int modifiers = theMethod.getModifiers();
        String returnType = null;
        java.lang.Class<?>[] tmp = theMethod.getParameterTypes();
        String[] parameterTypes = new String[tmp.length];
        int i = 0;
        while (i < tmp.length) {
            java.lang.Class<?> tmp2 = tmp[i];
            parameterTypes[i] = BinaryConverter.getTypeName(tmp2);
            ++i;
        }
        tmp = theMethod.getExceptionTypes();
        String[] exceptions = new String[tmp.length];
        int i2 = 0;
        while (i2 < tmp.length) {
            java.lang.Class<?> tmp2 = tmp[i2];
            exceptions[i2] = BinaryConverter.getTypeName(tmp2);
            ++i2;
        }
        result = new Method(name, isConstructor, modifiers, returnType, parameterTypes, exceptions);
        return result;
    }

    private Method methodToMethod(java.lang.reflect.Method theMethod) {
        Method result = null;
        String name = theMethod.getName();
        boolean isConstructor = false;
        int modifiers = theMethod.getModifiers();
        java.lang.Class<?> returnType = theMethod.getReturnType();
        String returnTypeName = BinaryConverter.getTypeName(returnType);
        java.lang.Class<?>[] tmp = theMethod.getParameterTypes();
        String[] parameterTypes = new String[tmp.length];
        int i = 0;
        while (i < tmp.length) {
            java.lang.Class<?> tmp2 = tmp[i];
            parameterTypes[i] = BinaryConverter.getTypeName(tmp2);
            ++i;
        }
        tmp = theMethod.getExceptionTypes();
        String[] exceptions = new String[tmp.length];
        int i2 = 0;
        while (i2 < tmp.length) {
            java.lang.Class<?> tmp2 = tmp[i2];
            exceptions[i2] = BinaryConverter.getTypeName(tmp2);
            ++i2;
        }
        result = new Method(name, isConstructor, modifiers, returnTypeName, parameterTypes, exceptions);
        return result;
    }

    private com.sap.tc.jtools.jlint.javaelements.Field fieldToField(Field theField) {
        com.sap.tc.jtools.jlint.javaelements.Field result = null;
        String name = theField.getName();
        int modifier = theField.getModifiers();
        java.lang.Class<?> type = theField.getType();
        String typeName = BinaryConverter.getTypeName(type);
        result = new com.sap.tc.jtools.jlint.javaelements.Field(name, modifier, typeName);
        return result;
    }

    private Class classToClass(java.lang.Class theClass) {
        Class result = null;
        String superClassName = null;
        String packageName = theClass.getPackage().getName();
        String tmp1 = theClass.getName();
        tmp1 = tmp1.substring(packageName.length() + 1);
        String className = tmp1.replace('$', '.');
        java.lang.Class superClass = theClass.getSuperclass();
        if (superClass != null) {
            superClassName = superClass.getName().replace('$', '.');
        }
        boolean isInterface = theClass.isInterface();
        int modifiers = theClass.getModifiers();
        java.lang.Class<?>[] tmp = theClass.getInterfaces();
        String[] superInterfaces = new String[tmp.length];
        int i = 0;
        while (i < tmp.length) {
            java.lang.Class<?> tmp2 = tmp[i];
            superInterfaces[i] = tmp2.getName().replace('$', '.');
            ++i;
        }
        Constructor<?>[] tmp5 = theClass.getDeclaredConstructors();
        java.lang.reflect.Method[] tmp4 = theClass.getDeclaredMethods();
        Method[] methods = new Method[tmp5.length + tmp4.length];
        int i2 = 0;
        while (i2 < tmp5.length) {
            Constructor<?> tmp2 = tmp5[i2];
            methods[i2] = this.constructorToMethod(tmp2);
            ++i2;
        }
        int i3 = 0;
        while (i3 < tmp4.length) {
            java.lang.reflect.Method tmp2 = tmp4[i3];
            methods[tmp5.length + i3] = this.methodToMethod(tmp2);
            ++i3;
        }
        Field[] tmp3 = theClass.getDeclaredFields();
        com.sap.tc.jtools.jlint.javaelements.Field[] fields = new com.sap.tc.jtools.jlint.javaelements.Field[tmp3.length];
        int i4 = 0;
        while (i4 < tmp3.length) {
            Field tmp2 = tmp3[i4];
            fields[i4] = this.fieldToField(tmp2);
            ++i4;
        }
        tmp = theClass.getDeclaredClasses();
        Class[] innerClasses = new Class[tmp.length];
        int i5 = 0;
        while (i5 < tmp.length) {
            java.lang.Class<?> tmp2 = tmp[i5];
            innerClasses[i5] = this.classToClass(tmp2);
            ++i5;
        }
        result = new Class(packageName, className, superClassName, superInterfaces, isInterface, modifiers, methods, fields, innerClasses);
        return result;
    }

    private void handleOneClass(String fileName, ClassLoader loader) {
        String classnameWithDollar = this.extractClassNameFromRelativeFilename(fileName);
        String packageAndClassName1 = classnameWithDollar.replace('$', '.');
        if (!((Hashtable)_classnames).contains(classnameWithDollar)) {
            String packageAndClassName;
            String status = null;
            Class theSAPClass = null;
            java.lang.Class<?> theJavaClass = null;
            try {
                theJavaClass = java.lang.Class.forName(classnameWithDollar, false, loader);
                status = "success";
            }
            catch (ClassNotFoundException ex) {
                status = "NotFound";
                ex.printStackTrace();
                throw new RuntimeException(ex.getMessage());
            }
            catch (NoClassDefFoundError ex) {
                String msg = ex.getMessage();
                status = "NotLoaded";
                System.err.println(msg);
                ((Hashtable)_missingClasses).put(msg, "missing");
                ((Hashtable)_missingClasses).put(classnameWithDollar.replace('$', '.'), status);
                System.err.println("required class is not in Classpath. Ignoring " + classnameWithDollar);
            }
            catch (SecurityException ex) {
                String msg = ex.getMessage();
                status = "SecurityException";
                System.err.println(msg);
                System.err.println("Security exception when loading " + classnameWithDollar);
            }
            catch (IllegalAccessError err) {
                String msg = err.getMessage();
                status = "AccessError";
                System.err.println(msg);
                System.err.println("Class is already loaded in an other version? " + classnameWithDollar);
            }
            catch (VerifyError err) {
                String msg = err.getMessage();
                status = "VerifyError";
                System.err.println(msg);
                System.err.println("Class seems to be inconsistent? " + classnameWithDollar);
            }
            catch (Exception ex) {
                String msg;
                status = msg = ex.getMessage();
                System.err.println(msg);
                System.err.println("What other exceptions do I miss? " + classnameWithDollar);
            }
            if (theJavaClass != null) {
                try {
                    theSAPClass = this.classToClass(theJavaClass);
                }
                catch (NoClassDefFoundError ex) {
                    String msg = ex.getMessage();
                    status = "NotLoaded2";
                    System.err.println(msg);
                    ((Hashtable)_missingClasses).put(msg, "missing2");
                    ((Hashtable)_missingClasses).put(classnameWithDollar.replace('$', '.'), status);
                    System.err.println("required class is not in Classpath2. Ignoring " + classnameWithDollar);
                }
            }
            if (theSAPClass != null) {
                String packageName = theSAPClass.getPckName();
                String className = theSAPClass.getClassName();
                packageAndClassName = packageName != null ? packageName + "." + className : className;
                this.writeClass(this._outputDir, theSAPClass);
                if (!packageAndClassName.equals(packageAndClassName1)) {
                    System.err.println("packageAndClassname is inconsistent: " + packageAndClassName + " " + packageAndClassName1);
                }
            } else {
                packageAndClassName = packageAndClassName1;
            }
            ((Hashtable)_classnames).put(packageAndClassName, status);
        }
    }

    private void convertDirectory(String relativePath, File dir) {
        File[] children = dir.listFiles();
        URLClassLoader loader = new URLClassLoader(this.apiJars);
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                String newRelativePath = relativePath + children[i].getName() + File.separatorChar;
                this.convertDirectory(newRelativePath, children[i]);
            } else {
                String name = children[i].getName();
                if (this.isValidClassFileName(name)) {
                    this.handleOneClass(relativePath + name, loader);
                }
            }
            ++i;
        }
    }

    private void writeClass(String dir, Class theClass) {
        String currentClass = theClass.getClassName();
        int lastDotSign = currentClass.lastIndexOf(46);
        if (lastDotSign == -1) {
            String packageName = theClass.getPckName();
            currentClass = packageName + "." + currentClass;
            String fileName = dir + File.separator + currentClass.replace('.', File.separatorChar) + API_SUFFIX;
            this.checkOrCreateFolders(fileName);
            File outputFile = new File(fileName);
            StructureTree tmp2 = theClass.toStructureTree();
            FileWriter tmp = null;
            try {
                tmp = new FileWriter(outputFile);
                XMLTool.writeDocument((StructureTree)tmp2, (Writer)tmp);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    private boolean isValidClassFileName(String filename) {
        if (!filename.endsWith(CLASS_SUFFIX)) {
            return false;
        }
        String fileNameWithoutExtension = filename.substring(0, filename.length() - CLASS_SUFFIX.length());
        StringTokenizer st = new StringTokenizer(fileNameWithoutExtension, "$");
        if (st.hasMoreTokens()) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    Integer.parseInt(token);
                    return false;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    public static void main(String[] args) {
        String rootFolder = args[0];
        String outputDir = args[1];
        File folder = new File(rootFolder);
        File[] folders = new File[]{folder};
        File[] others = new File[]{};
        BinaryConverter test = new BinaryConverter(folders, others, outputDir);
        test.saveStatistics();
    }
}

