/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdt.s2x.transform;

import com.sap.ide.eclipse.s2x.editor.model.TextPool;
import com.sap.ide.eclipse.s2x.editor.model.TranslatableText;
import com.sap.jdt.s2x.transform.IDocReader;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.etc.TranslationUnit;
import com.sap.s2x.validation.ValidationException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class S2XReader
implements IDocReader {
    static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$control$custom$tableview$ToolbarTableView == null ? (class$com$sap$control$custom$tableview$ToolbarTableView = S2XReader.class$("com.sap.control.custom.tableview.ToolbarTableView")) : class$com$sap$control$custom$tableview$ToolbarTableView));
    private File mSSXFile;
    private S2XDocument mSSXDocument;
    static /* synthetic */ Class class$com$sap$control$custom$tableview$ToolbarTableView;

    public void init() {
        if (this.mSSXFile != null && this.mSSXFile.exists()) {
            try {
                if (null == this.mSSXDocument) {
                    this.mSSXDocument = new S2XDocument(this.mSSXFile);
                }
            }
            catch (IOException e) {
                if (tracer.error()) {
                    tracer.error(e.getMessage());
                } else {
                    tracer.warning(e.getMessage());
                }
            }
            catch (ParserConfigurationException e) {
                if (tracer.error()) {
                    tracer.error(e.getMessage());
                } else {
                    tracer.warning(e.getMessage());
                }
            }
            catch (SAXException e) {
                if (tracer.error()) {
                    tracer.error(e.getMessage());
                } else {
                    tracer.warning(e.getMessage());
                }
            }
            catch (ValidationException e) {
                if (tracer.error()) {
                    tracer.error(e.getMessage());
                }
                tracer.warning(e.getMessage());
            }
        }
    }

    public Iterator getTextElements() {
        Vector v = this.mSSXDocument.getTexts();
        TextPool pool = new TextPool();
        Iterator iter = ((AbstractList)v).iterator();
        while (iter.hasNext()) {
            TranslationUnit element = (TranslationUnit)iter.next();
            TranslatableText text = new TranslatableText(element.getID(), element.getResname(), element.getRestype(), element.getSource(), element.getMaxwidth());
            pool.add(text);
        }
        return pool.iterator();
    }

    public void setInput(File inFile) {
        if (null == inFile || !inFile.exists()) {
            throw new InvalidParameterException("Input file cannot be null and it should exist");
        }
        this.mSSXFile = inFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

