/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdt.s2x.transform;

import com.sap.ide.eclipse.s2x.editor.model.TranslatableText;
import com.sap.ide.eclipse.s2x.editor.model.property.PropertyFile;
import com.sap.ide.eclipse.s2x.editor.model.property.ResourceItem;
import com.sap.ide.eclipse.s2x.editor.model.property.Resources;
import com.sap.jdt.s2x.transform.IDocWriter;
import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;

public class PropertyWriter
implements IDocWriter {
    private File mPropFile;
    private PropertyFile mPropertyFile;
    private Resources mResources;

    public void init() {
        this.mPropertyFile = new PropertyFile(null);
        this.mResources = new Resources();
        this.mPropertyFile.setResources(this.mResources);
        this.mPropertyFile.open(this.mPropFile.getAbsolutePath());
    }

    public void setOutput(File outFile) {
        if (null == outFile) {
            throw new InvalidParameterException("Provide a valid property file");
        }
        if (null == this.mPropFile) {
            this.mPropFile = outFile;
            if (!this.mPropFile.exists()) {
                try {
                    this.mPropFile.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void putTextElement(Object element) {
        TranslatableText text = (TranslatableText)((Object)element);
        ResourceItem item = new ResourceItem();
        item.setComment(text.getID());
        item.setKey(text.getResname());
        item.setText(text.getSource());
        this.mResources.add(item);
    }

    public void commit() {
        this.mPropertyFile.store(true);
    }
}

