/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.wizard;

import com.sap.ide.metamodel.core.services.MMCCheckServices;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PropertiesDetailPage
extends WizardPage {
    private IFile m_xlfFile;
    private Text m_PropertiesFileNameText;
    private Button mFileDialogButton;

    public PropertiesDetailPage(String pageName, IFile m_xlfFile) {
        super(pageName);
        this.m_xlfFile = m_xlfFile;
        this.setTitle("Properties File Details");
        this.setDescription("Please enter the name of the properties File. This file will be created only in this project. An Existing file will be overwritten");
    }

    public PropertiesDetailPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite top) {
        Composite parent = new Composite(top, 0);
        GridLayout gLayout = new GridLayout(3, false);
        parent.setLayout((Layout)gLayout);
        Label name = new Label(parent, 0);
        name.setText("Properties File Name");
        this.m_PropertiesFileNameText = new Text(parent, 2048);
        GridData gdata = new GridData(768);
        this.m_PropertiesFileNameText.setLayoutData((Object)gdata);
        this.m_PropertiesFileNameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
                if (!PropertiesDetailPage.this.m_PropertiesFileNameText.getText().toLowerCase().endsWith(".properties")) {
                    PropertiesDetailPage.this.m_PropertiesFileNameText.setText(PropertiesDetailPage.this.m_PropertiesFileNameText.getText() + ".properties");
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.m_PropertiesFileNameText.addModifyListener((ModifyListener)new QueryNameModListener());
        this.fillTextBox();
        this.mFileDialogButton = new Button(parent, 524288);
        this.mFileDialogButton.setText("Browse...");
        this.mFileDialogButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                FileDialog dialog = new FileDialog(shell, 4096);
                dialog.setFilterPath(PropertiesDetailPage.this.m_xlfFile.getParent().getLocation().toString());
                dialog.setFilterExtensions(new String[]{"*.properties"});
                String fileName = dialog.open();
                if (fileName != null) {
                    if (!fileName.trim().toLowerCase().endsWith(".properties")) {
                        fileName = fileName + ".properties";
                    }
                    PropertiesDetailPage.this.m_PropertiesFileNameText.setText(fileName.trim());
                    PropertiesDetailPage.this.m_PropertiesFileNameText.setToolTipText(fileName);
                    PropertiesDetailPage.this.setPageComplete(true);
                    PropertiesDetailPage.this.setErrorMessage(null);
                } else {
                    PropertiesDetailPage.this.setPageComplete(false);
                }
            }
        });
        this.setControl((Control)top);
    }

    public String getPropertiesFileName() {
        return this.m_PropertiesFileNameText.getText();
    }

    public static void main(String[] args) {
    }

    public void fillTextBox() {
        IFolder folder = (IFolder)this.m_xlfFile.getParent();
        String text = this.m_xlfFile.getName().substring(0, this.m_xlfFile.getName().indexOf(this.m_xlfFile.getFileExtension()) - 1);
        this.m_PropertiesFileNameText.setText(text + ".properties");
    }

    public boolean canFinish() {
        this.setErrorMessage(null);
        boolean isValid = this.validateName();
        return isValid;
    }

    private boolean validateName() {
        if (0 == this.m_PropertiesFileNameText.getText().length()) {
            return false;
        }
        String fileName = this.m_PropertiesFileNameText.getText();
        if (fileName.indexOf(92) != -1) {
            File drive = new File(fileName.substring(0, fileName.indexOf(92) + 1));
            File file = new File(fileName);
            if (!drive.exists()) {
                this.setErrorMessage("Please enter a valid File Name");
                return false;
            }
            if (!new File(file.getParent()).exists()) {
                this.setErrorMessage("Please enter a valid File path");
                return false;
            }
        }
        fileName = this.m_PropertiesFileNameText.getText();
        fileName = fileName.substring(fileName.lastIndexOf(92) + 1, fileName.length());
        MMCCheckServices.CheckResult c = MMCCheckServices.isValidFileName((String)(fileName = this.removeFromString(fileName, ".")));
        if (!c.isOk()) {
            this.setErrorMessage(c.getMessage());
            return false;
        }
        return true;
    }

    String removeFromString(String filename, String removeStr) {
        int index = filename.indexOf(removeStr);
        while (index != -1) {
            filename = filename.substring(0, index) + filename.substring(index + removeStr.length(), filename.length());
            index = filename.indexOf(removeStr);
        }
        return filename;
    }

    class QueryNameModListener
    implements ModifyListener {
        QueryNameModListener() {
        }

        public void modifyText(ModifyEvent e) {
            PropertiesDetailPage.super.getContainer().updateButtons();
        }
    }
}

