/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.tab;

import com.sap.control.custom.tableview.ToolbarTableView;
import com.sap.ide.eclipse.s2x.editor.dialog.ResourceTextDialog;
import com.sap.ide.eclipse.s2x.editor.editors.S2XMultiPageEditor;
import com.sap.ide.eclipse.s2x.editor.filter.CustomFilterDialog;
import com.sap.ide.eclipse.s2x.editor.filter.CustomTabViewerFilter;
import com.sap.ide.eclipse.s2x.editor.helper.SSXEditorHelper;
import com.sap.ide.eclipse.s2x.editor.model.ResourceTextLabelProvider;
import com.sap.ide.eclipse.s2x.editor.model.ResourceTextModel;
import com.sap.ide.eclipse.s2x.editor.model.TranslatableText;
import com.sap.ide.eclipse.s2x.editor.sort.S2XTableSorter;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.S2XTypes;
import com.sap.s2x.TextNotFoundException;
import com.sap.s2x.core.types.S2XTypeInterface;
import com.sap.s2x.etc.TranslationUnit;
import com.sap.s2x.validation.ValidationException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;

public class SSXResourceEditor {
    static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$s2x$editor$tab$SSXResourceEditor == null ? (class$com$sap$ide$eclipse$s2x$editor$tab$SSXResourceEditor = SSXResourceEditor.class$("com.sap.ide.eclipse.s2x.editor.tab.SSXResourceEditor")) : class$com$sap$ide$eclipse$s2x$editor$tab$SSXResourceEditor));
    public static final String TC_HDE_RESNAME = "Resource Name";
    public static final String TC_HDR_RESTYPE = "Resource Type";
    public static final String TC_HDR_TEXT = "Text";
    public static final String TC_HDR_LEN = "Max Length";
    private static int SE_COLUMN_COUNT = 4;
    private ICellEditorValidator[] m_validators;
    private Button m_ActivateFilterButton;
    private CustomTabViewerFilter m_customFilter;
    private TranslatableText m_currentTextItem;
    private S2XDocument m_SSXDocument;
    private ToolbarTableView m_CustomTableView;
    private ResourceTextModel m_ResourceTextModel;
    private IBaseLabelProvider m_ResourceTextLabelProvider;
    private Composite mParent;
    private SSXResourceEditor me = this;
    private String[] strList;
    private S2XMultiPageEditor m_ParentEditor;
    private boolean m_IsDirty;
    static /* synthetic */ Class class$com$sap$ide$eclipse$s2x$editor$tab$SSXResourceEditor;

    public SSXResourceEditor(Composite parent, S2XMultiPageEditor parentEditor, S2XDocument document) {
        this.mParent = parent;
        this.m_ParentEditor = parentEditor;
        this.m_SSXDocument = document;
        this.m_customFilter = new CustomTabViewerFilter();
        this.createPartControl(parent);
    }

    private void contentChanged() {
        this.m_IsDirty = true;
        this.m_ParentEditor.contentModified();
    }

    private void fillForm(Composite parent) {
        block2: {
            try {
                int[] editors = new int[SE_COLUMN_COUNT];
                this.m_CustomTableView = new ToolbarTableView(parent, 0);
                this.m_CustomTableView.setColumnCount(SE_COLUMN_COUNT);
                String[] p = new String[]{TC_HDE_RESNAME, TC_HDR_RESTYPE, TC_HDR_TEXT, TC_HDR_LEN};
                this.m_CustomTableView.setColumnHeaders(p);
                editors[0] = 5;
                editors[1] = 5;
                editors[2] = 1;
                editors[3] = 1;
                this.m_CustomTableView.setColumnEditors(editors);
                this.m_ResourceTextModel = new ResourceTextModel(this.m_SSXDocument);
                this.m_CustomTableView.setTableMode((IContentProvider)this.m_ResourceTextModel);
                this.m_ResourceTextLabelProvider = new ResourceTextLabelProvider(this.m_ResourceTextModel);
                this.m_CustomTableView.setLabeProvider(this.m_ResourceTextLabelProvider);
                AddAction action = new AddAction();
                this.m_CustomTableView.addActionListener(1, (IAction)action);
                this.m_CustomTableView.addActionListener(2, (IAction)new EditAction());
                this.m_CustomTableView.addActionListener(3, (IAction)new DeleteAction());
                this.m_CustomTableView.setCellModifier(this.getCellModifier());
                this.m_validators = new ICellEditorValidator[4];
                this.m_validators[0] = new NameCellValidator();
                this.m_validators[2] = new TextCellValidator();
                this.m_CustomTableView.setCellValidator(this.m_validators);
                ICellEditorListener[] celleditorListener = new ICellEditorListener[4];
                celleditorListener[2] = new TextCellEditorListener();
                this.m_CustomTableView.setCellEditorListener(celleditorListener);
                this.m_CustomTableView.setInput(this.m_SSXDocument);
                this.m_CustomTableView.addToolAction((IAction)new FilterAction(), null, "Set Filter", "Set filter parameters", 8);
                this.m_ActivateFilterButton = (Button)this.m_CustomTableView.addToolAction((IAction)new FilterActivateAction(), null, "Activate Filter", "Activate Filter", 2);
            }
            catch (Throwable e) {
                if (!tracer.error()) break block2;
                tracer.error(e.getMessage());
            }
        }
    }

    public void initControlStates() {
        if (!this.m_ParentEditor.checkWritability()) {
            this.m_CustomTableView.setActionState(1, -1);
            this.m_CustomTableView.setActionState(2, -1);
            this.m_CustomTableView.setActionState(3, -1);
            this.m_CustomTableView.setTableEdit(false);
        }
    }

    private ICellModifier getCellModifier() {
        return new ICellModifier(){

            public boolean canModify(Object element, String property) {
                boolean modify = true;
                if (SSXResourceEditor.this.m_ParentEditor.checkWritability()) {
                    SSXResourceEditor.this.m_currentTextItem = (TranslatableText)((Object)element);
                    if (property.compareTo(SSXResourceEditor.TC_HDR_LEN) == 0) {
                        modify = false;
                    }
                } else {
                    modify = false;
                }
                return modify;
            }

            public Object getValue(Object element, String property) {
                String value = "";
                TranslatableText text = (TranslatableText)((Object)element);
                if (property.compareTo(SSXResourceEditor.TC_HDE_RESNAME) == 0) {
                    value = text.getResname();
                }
                if (property.compareTo(SSXResourceEditor.TC_HDR_RESTYPE) == 0) {
                    value = text.getRestype();
                }
                if (property.compareTo(SSXResourceEditor.TC_HDR_TEXT) == 0) {
                    value = text.getSource();
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                if (null != value) {
                    TranslatableText text = (TranslatableText)((Object)((TableItem)element).getData());
                    if (property.compareTo(SSXResourceEditor.TC_HDE_RESNAME) == 0) {
                        text.setResname((String)value);
                    }
                    if (property.compareTo(SSXResourceEditor.TC_HDR_RESTYPE) == 0 && value instanceof String) {
                        text.setRestype((String)value);
                    }
                    if (property.compareTo(SSXResourceEditor.TC_HDR_TEXT) == 0) {
                        text.setSource((String)value);
                    }
                    SSXResourceEditor.this.contentChanged();
                    SSXResourceEditor.this.refresh();
                }
            }
        };
    }

    public void doSave(IProgressMonitor monitor) {
        this.m_IsDirty = false;
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
    }

    public boolean isDirty() {
        return this.m_IsDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.fillForm(parent);
        this.m_CustomTableView.setSorterListener(new S2XTableSorter(this.m_CustomTableView));
    }

    public void setFocus() {
    }

    public void setRowText(TranslatableText text) throws ValidationException, TextNotFoundException {
        this.contentChanged();
        this.m_CustomTableView.refreshTable();
    }

    public Object[] getSelectedText() {
        return this.m_CustomTableView.getTableSelection();
    }

    public Control getControl() {
        return null;
    }

    public S2XDocument getSSXDocument() {
        return this.m_SSXDocument;
    }

    public Composite getParent() {
        return this.mParent;
    }

    public TranslationUnit[] getTextArray() {
        return this.m_ResourceTextModel.getTextArray();
    }

    public ResourceTextModel getTextModel() {
        return this.m_ResourceTextModel;
    }

    public void refresh() {
        this.m_CustomTableView.refreshTable();
    }

    public ToolbarTableView getM_CustomTableView() {
        return this.m_CustomTableView;
    }

    public ResourceTextModel getM_ResourceTextModel() {
        return this.m_ResourceTextModel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TextCellEditorListener
    implements ICellEditorListener {
        private boolean m_valid;

        private TextCellEditorListener() {
        }

        public void applyEditorValue() {
        }

        public void cancelEditor() {
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            this.m_valid = newValidState;
            StatusLineManager statusLineManager = SSXResourceEditor.this.m_ParentEditor.getStatusLine();
            statusLineManager.setMessage("");
            if (!newValidState) {
                statusLineManager.setMessage("You have entered an error");
            }
        }
    }

    private class NameCellValidator
    implements ICellEditorValidator {
        private NameCellValidator() {
        }

        public String isValid(Object value) {
            String text = (String)value;
            if (null != SSXResourceEditor.this.m_currentTextItem) {
                if (text.length() > 32) {
                    return "Name is longer than the maximum length";
                }
                char[] chars = text.toCharArray();
                int i = 0;
                while (i < chars.length) {
                    boolean isValid;
                    char ch = chars[i];
                    boolean conditionLetter = Character.isLetter(ch);
                    boolean conditionUnderscore = ch == '_';
                    boolean conditionSlash = ch == '\\';
                    boolean conditionDot = ch == '.';
                    boolean conditionDigit = Character.isDigit(ch);
                    boolean conditionMisc = ch == '@' || ch == ':';
                    boolean bl = isValid = conditionLetter || conditionUnderscore || conditionSlash || conditionDot || conditionMisc || conditionDigit;
                    if (!isValid) {
                        return "The character " + ch + " is not allowed.";
                    }
                    ++i;
                }
            }
            return null;
        }
    }

    private class TextCellValidator
    implements ICellEditorValidator {
        private TextCellValidator() {
        }

        public String isValid(Object value) {
            String text = (String)value;
            if (null != SSXResourceEditor.this.m_currentTextItem && text.length() > Integer.parseInt(SSXResourceEditor.this.m_currentTextItem.getMaxwidth())) {
                return "Text is longer than the maximum length";
            }
            return null;
        }
    }

    private class FilterActivateAction
    extends Action {
        private FilterActivateAction() {
        }

        public void run() {
            if (SSXResourceEditor.this.m_ActivateFilterButton.getSelection()) {
                SSXResourceEditor.this.m_CustomTableView.setFilter(SSXResourceEditor.this.m_customFilter);
            } else {
                SSXResourceEditor.this.m_CustomTableView.setFilter(null);
            }
        }
    }

    private class FilterAction
    extends Action {
        private FilterAction() {
        }

        public void run() {
            CustomFilterDialog dialog = new CustomFilterDialog(SSXResourceEditor.this.getParent().getShell(), SSXResourceEditor.this.m_customFilter);
            ArrayList<String> items = new ArrayList<String>();
            ArrayList mResTypeList = S2XTypes.getInstance().getRestypes();
            int i = 0;
            while (i < mResTypeList.size()) {
                S2XTypeInterface type = (S2XTypeInterface)mResTypeList.get(i);
                items.add(type.getXLIFFValue());
                ++i;
            }
            dialog.addListItems(items);
            dialog.open();
        }
    }

    private class DeleteAction
    extends Action {
        private DeleteAction() {
        }

        public void run() {
            block10: {
                try {
                    if (!SSXResourceEditor.this.m_ParentEditor.checkWritability()) break block10;
                    Object[] texts = null;
                    texts = SSXResourceEditor.this.getSelectedText();
                    int i = 0;
                    while (i < texts.length) {
                        block11: {
                            TranslatableText translatableText = (TranslatableText)((Object)texts[i]);
                            try {
                                SSXResourceEditor.this.m_SSXDocument.removeText(translatableText.getID(), translatableText.getResType());
                                SSXResourceEditor.this.m_ResourceTextModel.getTextPool().remove(translatableText);
                                if (null != SSXResourceEditor.this.m_ParentEditor.getPropertyFile()) {
                                    SSXResourceEditor.this.m_ParentEditor.getPropertyFile().removeItem(translatableText.getID());
                                }
                            }
                            catch (TextNotFoundException e) {
                                SSXResourceEditor.this.m_ResourceTextModel.getTextPool().remove(translatableText);
                                if (!tracer.error()) break block11;
                                tracer.error(e.getMessage());
                            }
                        }
                        try {
                            SSXResourceEditor.this.m_ResourceTextModel.refresh();
                            SSXResourceEditor.this.m_CustomTableView.refreshTable();
                            SSXResourceEditor.this.contentChanged();
                        }
                        catch (Exception e) {
                            if (tracer.error()) {
                                tracer.error(e.getMessage());
                            }
                            tracer.warning(e.getMessage());
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    if (tracer.error()) {
                        tracer.error(e.getMessage());
                    }
                    tracer.warning(e.getMessage());
                }
            }
        }
    }

    private class EditAction
    extends Action {
        private EditAction() {
        }

        public void run() {
            block3: {
                try {
                    if (SSXResourceEditor.this.m_ParentEditor.checkWritability()) {
                        ResourceTextDialog dlg = new ResourceTextDialog(SSXResourceEditor.this.me, false);
                        dlg.setResTypes(SSXEditorHelper.fillResTypes());
                        dlg.open();
                    }
                }
                catch (Exception e) {
                    if (!tracer.error()) break block3;
                    tracer.error(e.getMessage());
                }
            }
        }
    }

    private class AddAction
    extends Action {
        private AddAction() {
        }

        public void run() {
            block3: {
                try {
                    if (SSXResourceEditor.this.m_ParentEditor.checkWritability()) {
                        ResourceTextDialog dlg = new ResourceTextDialog(SSXResourceEditor.this.me, true);
                        dlg.setResTypes(SSXEditorHelper.fillResTypes());
                        dlg.open();
                    }
                }
                catch (Exception e) {
                    if (!tracer.error()) break block3;
                    tracer.error(e.getMessage());
                }
            }
        }
    }
}

