/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.tab;

import com.sap.control.custom.tableview.TableLabelProvider;
import com.sap.control.custom.tableview.TableModel;
import com.sap.control.custom.tableview.ToolbarTableView;
import com.sap.ide.eclipse.s2x.editor.editors.S2XMultiPageEditor;
import com.sap.ide.eclipse.s2x.editor.helper.SSXEditorHelper;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.S2XTypes;
import com.sap.s2x.core.types.LangType;
import com.sap.s2x.core.types.S2XTypeInterface;
import com.sap.s2x.validation.ValidationException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class SSXHeaderEditor {
    private Combo mDomainCombo;
    private Text mCollectionText;
    private Text mProductNameText;
    private Text mDomainText;
    static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$s2x$editor$tab$SSXHeaderEditor == null ? (class$com$sap$ide$eclipse$s2x$editor$tab$SSXHeaderEditor = SSXHeaderEditor.class$("com.sap.ide.eclipse.s2x.editor.tab.SSXHeaderEditor")) : class$com$sap$ide$eclipse$s2x$editor$tab$SSXHeaderEditor));
    private static final int SSE_JAVA_PROP_BUNDLE = 3;
    private S2XDocument mSSXDocument;
    private ArrayList mResTypeList;
    private ArrayList mDataTypeValueList;
    private int mTheID;
    private IEditorSite mSite;
    private IEditorInput mInput;
    private Composite mParent;
    private Combo mDataTypeCombo;
    private Combo mSourceLangCombo;
    private Text mSrcFileText;
    private Text mToolText;
    private Text mProcessNameText;
    private Text mPhaseNameText;
    private StatusLineManager mStatusLine;
    private Text mDevContactText;
    private Text mMaxLengthText;
    private HashMap mLangMap;
    private Text mDataTypeText;
    private boolean mIsDirty;
    private S2XMultiPageEditor mParentEditor;
    private String masterLanguage;
    static /* synthetic */ Class class$com$sap$ide$eclipse$s2x$editor$tab$SSXHeaderEditor;

    public SSXHeaderEditor(Composite parent, S2XMultiPageEditor parentEditor, S2XDocument docu, StatusLineManager status) {
        this.mStatusLine = status;
        this.mParentEditor = parentEditor;
        this.mSSXDocument = docu;
        this.createPartControl(parent);
    }

    public static Image getImage2(String imageName) {
        ImageDescriptor imageDesc = null;
        Image img = null;
        Object imageDes = null;
        URL imageUrl = null;
        try {
            imageUrl = new URL(imageName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        imageDesc = ImageDescriptor.createFromURL((URL)imageUrl);
        img = imageDesc.createImage();
        return img;
    }

    private void fillPhaseSection(Group parent) {
        block2: {
            parent.setLayoutData((Object)new GridData(1808));
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            parent.setLayout((Layout)gridLayout);
            Label label0 = new Label((Composite)parent, 0);
            label0.setText("Name ");
            this.mPhaseNameText = new Text((Composite)parent, 2048);
            this.mPhaseNameText.setText("");
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.mPhaseNameText.setLayoutData((Object)data);
            Label label2 = new Label((Composite)parent, 0);
            label2.setText("Process Name ");
            this.mProcessNameText = new Text((Composite)parent, 2048);
            this.mProcessNameText.setText("");
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.mProcessNameText.setLayoutData((Object)data);
            Group shell = new Group((Composite)parent, 0);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            data.horizontalSpan = 4;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            shell.setLayoutData((Object)data);
            shell.setLayout((Layout)new FillLayout());
            shell.setText("Notes");
            try {
                ToolbarTableView name = new ToolbarTableView((Composite)shell, 0);
                name.setColumnCount(3);
                TableModel tableModel = new TableModel();
                name.setTableMode((IContentProvider)tableModel);
                name.setLabeProvider((IBaseLabelProvider)new TableLabelProvider(tableModel));
                name.setInput(this.mSSXDocument);
            }
            catch (Throwable e) {
                if (!tracer.error()) break block2;
                tracer.error(e.getMessage());
            }
        }
    }

    private void fillFileSection(Composite parent) {
        ModifyListener listener = this.getModifyListener();
        GridData data = new GridData(272);
        data.grabExcessVerticalSpace = false;
        parent.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(0, false);
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)gridLayout);
        Label label0 = new Label(parent, 0);
        label0.setText("Tool ");
        this.mToolText = new Text(parent, 2048);
        this.mToolText.setText("SAP Java IDE S2X Editor");
        this.mToolText.setEditable(false);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.mToolText.setLayoutData((Object)data);
        Label label5 = new Label(parent, 0);
        label5.setText("Source Language ");
        this.masterLanguage = this.mSSXDocument.getSourceLanguage();
        if (null == this.masterLanguage || 0 == this.masterLanguage.compareTo("")) {
            this.masterLanguage = "en";
        }
        this.mSourceLangCombo = new Combo(parent, 2056);
        this.mSourceLangCombo.setItems(SSXEditorHelper.fillLanguages());
        this.mSourceLangCombo.select(0);
        data = new GridData(512);
        data.horizontalAlignment = 4;
        this.mSourceLangCombo.setLayoutData((Object)data);
        this.mSourceLangCombo.addModifyListener(listener);
        Label label7 = new Label(parent, 0);
        label7.setText("Data Type");
        this.mDataTypeText = new Text(parent, 2048);
        this.mDataTypeText.setText("Java Property Resource Bundle");
        this.mDataTypeText.setEditable(false);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.mDataTypeText.setLayoutData((Object)data);
        Label label8 = new Label(parent, 0);
        label8.setText("Developer Contact");
        this.mDevContactText = new Text(parent, 2048);
        this.mDevContactText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        this.mDevContactText.setLayoutData((Object)data);
        this.mDevContactText.addModifyListener(listener);
        Label label10 = new Label(parent, 0);
        label10.setText("Domain");
        this.mDomainCombo = new Combo(parent, 2056);
        this.mDomainCombo.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        this.mDomainCombo.setLayoutData((Object)data);
        this.mDomainCombo.addModifyListener(listener);
        Label label11 = new Label(parent, 0);
        label11.setText("Product Name");
        this.mProductNameText = new Text(parent, 2048);
        this.mProductNameText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        this.mProductNameText.setLayoutData((Object)data);
        this.mProductNameText.setEditable(false);
        this.mProductNameText.addModifyListener(listener);
        Label label9 = new Label(parent, 0);
        label9.setText("Maximum Length");
        this.mMaxLengthText = new Text(parent, 2048);
        this.mMaxLengthText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        this.mMaxLengthText.setLayoutData((Object)data);
        this.mMaxLengthText.addModifyListener((ModifyListener)new LengthModListener());
    }

    public void initControlStates() {
        if (!this.mParentEditor.checkWritability()) {
            this.mMaxLengthText.setEnabled(false);
            this.mDevContactText.setEnabled(false);
            this.mSourceLangCombo.setEnabled(false);
            this.mDomainCombo.setEnabled(false);
        }
    }

    private void fillLanguages(Combo sourceLang) {
        ArrayList list = null;
        list = S2XTypes.getInstance().getLangTypes();
        int j = 0;
        while (j < list.size()) {
            S2XTypeInterface type = null;
            type = (S2XTypeInterface)list.get(j);
            sourceLang.add(type.getDescription());
            ++j;
        }
        sourceLang.select(0);
    }

    private void fillDataType(Combo dataType) {
        ArrayList list = null;
        list = S2XTypes.getInstance().getDatatypeValueList();
        int j = 0;
        while (j < list.size()) {
            S2XTypeInterface type = null;
            type = (S2XTypeInterface)list.get(j);
            dataType.add(type.getDescription());
            ++j;
        }
        dataType.select(0);
    }

    private void fillForm(Composite parent) {
        Group fileSectionShell = new Group(parent, 0);
        this.fillFileSection((Composite)fileSectionShell);
        fileSectionShell.setText("File Section");
    }

    private void displayTypes() {
        S2XTypeInterface type;
        this.mResTypeList = S2XTypes.getInstance().getRestypes();
        int i = 0;
        while (i < this.mResTypeList.size()) {
            type = (S2XTypeInterface)this.mResTypeList.get(i);
            ++i;
        }
        this.mDataTypeValueList = S2XTypes.getInstance().getDatatypeValueList();
        int j = 0;
        while (j < this.mResTypeList.size()) {
            type = (S2XTypeInterface)this.mResTypeList.get(j);
            ++j;
        }
        this.mResTypeList = S2XTypes.getInstance().getDomainTypes();
        int j2 = 0;
        while (j2 < this.mResTypeList.size()) {
            type = (S2XTypeInterface)this.mResTypeList.get(j2);
            ++j2;
        }
    }

    private void loadForm() {
        block5: {
            try {
                this.mToolText.setText(this.mSSXDocument.getTool());
                this.mSourceLangCombo.setText(SSXEditorHelper.getLangTypeByID(this.masterLanguage).getDescription());
                this.mDevContactText.setText(this.mSSXDocument.getDevelContact());
                this.mMaxLengthText.setText(this.mSSXDocument.getMaxLength());
                this.mDomainCombo.setText(this.mSSXDocument.getDomain().getXLIFFValue());
                this.mProductNameText.setText(this.mSSXDocument.getProductname());
                this.mResTypeList = S2XTypes.getInstance().getDomainTypes();
                int j = 0;
                while (j < this.mResTypeList.size()) {
                    S2XTypeInterface type = (S2XTypeInterface)this.mResTypeList.get(j);
                    this.mDomainCombo.add(type.getDescription());
                    ++j;
                }
                int index = this.mDomainCombo.indexOf(this.mSSXDocument.getDomain().getXLIFFValue());
                if (-1 == index) {
                    this.mDomainCombo.select(0);
                } else {
                    this.mDomainCombo.select(index);
                }
            }
            catch (RuntimeException e) {
                if (!tracer.error()) break block5;
                tracer.error(e.getMessage());
            }
        }
    }

    private ModifyListener getModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SSXHeaderEditor.this.mIsDirty = true;
                SSXHeaderEditor.this.mParentEditor.contentModified();
            }
        };
    }

    private void updateDocument() {
        try {
            this.mSSXDocument.setTool(this.mToolText.getText());
            LangType langType = SSXEditorHelper.getLangType(this.mSourceLangCombo.getText());
            if (null != langType) {
                this.mSSXDocument.setSourceLanguage(langType.getXLIFFValue());
            }
            S2XTypeInterface dataType = SSXEditorHelper.getDataType(this.mDataTypeText.getText());
            this.mSSXDocument.setDatatype(dataType.getXLIFFValue());
            this.mSSXDocument.setDevelContact(this.mDevContactText.getText());
            if (this.mMaxLengthText.getText().length() > 0) {
                this.mSSXDocument.setMaxLength(this.mMaxLengthText.getText());
            }
            this.mSSXDocument.setDomain(this.mDomainCombo.getText());
        }
        catch (ValidationException e) {
            if (tracer.error()) {
                tracer.error(e.getMessage());
            }
            this.mStatusLine.setErrorMessage(e.getMessage());
        }
    }

    public int getTheID() {
        return this.mTheID;
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.subTask("Header Information");
        this.updateDocument();
        this.mIsDirty = false;
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.mSite = site;
        this.mInput = input;
    }

    public boolean isDirty() {
        return this.mIsDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.mParent = parent;
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        this.fillForm(parent);
        this.loadForm();
        this.mIsDirty = false;
    }

    public IWorkbenchPartSite getSite() {
        return this.mSite;
    }

    public IEditorInput getEditorInput() {
        return this.mInput;
    }

    public void setFocus() {
    }

    public void setControlStates(boolean b) {
        this.mMaxLengthText.setEnabled(true);
        this.mDevContactText.setEnabled(true);
        this.mSourceLangCombo.setEnabled(true);
        this.mDomainCombo.setEnabled(true);
    }

    public void updateFields() {
        this.mProductNameText.setText(this.mSSXDocument.getProductname());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class LengthModListener
    implements ModifyListener {
        public void modifyText(ModifyEvent me) {
            try {
                SSXHeaderEditor.this.mStatusLine.setErrorMessage(null);
                SSXHeaderEditor.this.mStatusLine.update(true);
                SSXHeaderEditor.this.mSSXDocument.setMaxLength(SSXHeaderEditor.this.mMaxLengthText.getText());
                SSXHeaderEditor.this.mIsDirty = true;
                SSXHeaderEditor.this.mParentEditor.contentModified();
            }
            catch (ValidationException e) {
                String str = e.getMessage().replace(System.getProperty("line.separator", "\n").charAt(0), ' ');
                SSXHeaderEditor.this.mStatusLine.setErrorMessage(str);
            }
        }
    }
}

