/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.sort;

import com.sap.control.custom.tableview.ToolbarTableView;
import com.sap.control.custom.tableview.sort.TableSorterListener;
import com.sap.ide.eclipse.s2x.editor.model.TranslatableText;
import java.text.Collator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class S2XTableSorter
extends ViewerSorter
implements TableSorterListener {
    public static final int STS_SORT_UP = 1;
    public static final int STS_SORT_DOWN = 2;
    public static final int STS_SORT_TYPE = 1;
    public static final int STS_SORT_TEXT = 2;
    public static final int STS_SORT_NAME = 3;
    public static final int STS_SORT_LEN = 4;
    private int m_sortColumn;
    private int m_sortDirection;
    private ToolbarTableView m_toolbarTableView;

    public S2XTableSorter(ToolbarTableView tableView) {
        this.m_toolbarTableView = tableView;
        this.m_sortDirection = 2;
    }

    public S2XTableSorter(Collator collator) {
        super(collator);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = 0;
        TranslatableText text1 = (TranslatableText)((Object)e1);
        TranslatableText text2 = (TranslatableText)((Object)e2);
        switch (this.m_sortColumn) {
            case 3: {
                result = this.sortByName(text1, text2);
                break;
            }
            case 2: {
                result = this.sortByText(text1, text2);
                break;
            }
            case 1: {
                result = this.sortByType(text1, text2);
                break;
            }
            case 4: {
                result = this.sortByLen(text1, text2);
                break;
            }
        }
        return result;
    }

    private int sortByLen(TranslatableText text1, TranslatableText text2) {
        int res = 0;
        switch (this.m_sortDirection) {
            case 2: {
                res = Integer.valueOf(text1.getMaxLength()).compareTo(Integer.valueOf(text2.getMaxLength()));
            }
            case 1: {
                res = Integer.valueOf(text2.getMaxLength()).compareTo(Integer.valueOf(text1.getMaxLength()));
            }
        }
        return res;
    }

    private int sortByType(TranslatableText text1, TranslatableText text2) {
        int res = 0;
        switch (this.m_sortDirection) {
            case 2: {
                res = text1.getResType().compareTo(text2.getResType());
                break;
            }
            case 1: {
                res = text2.getResType().compareTo(text1.getResType());
            }
        }
        return res;
    }

    private int sortByText(TranslatableText text1, TranslatableText text2) {
        int res = 0;
        switch (this.m_sortDirection) {
            case 2: {
                res = text1.getResText().compareTo(text2.getResText());
                break;
            }
            case 1: {
                res = text2.getResText().compareTo(text1.getResText());
            }
        }
        return res;
    }

    private int sortByName(TranslatableText text1, TranslatableText text2) {
        int res = 0;
        switch (this.m_sortDirection) {
            case 2: {
                res = text1.getResName().compareTo(text2.getResName());
                break;
            }
            case 1: {
                res = text2.getResName().compareTo(text1.getResName());
            }
        }
        return res;
    }

    public boolean isSorterProperty(Object element, String property) {
        return super.isSorterProperty(element, property);
    }

    public void setSortDirection(int dir) {
        this.m_sortDirection = 2 == this.m_sortDirection ? 1 : 2;
    }

    public void setSortColumn(int column) {
        this.m_sortColumn = column;
    }

    public void setSortColumn(String string) {
        if ("Resource Name".equals(string)) {
            this.m_sortColumn = 3;
        }
        if ("Max Length".equals(string)) {
            this.m_sortColumn = 4;
        }
        if ("Resource Type".equals(string)) {
            this.m_sortColumn = 1;
        }
        if ("Text".equals(string)) {
            this.m_sortColumn = 2;
        }
    }

    public void sort() {
        this.m_toolbarTableView.setSorter(null);
        this.m_toolbarTableView.setSorter(this);
    }
}

