/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.model.property;

import com.sap.ide.eclipse.s2x.editor.model.property.ResourceItem;
import com.sap.ide.eclipse.s2x.editor.model.property.ResourceIterator;
import com.sap.s2x.TextNotFoundException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;

public class Resources {
    ArrayList mResourceList = new ArrayList(20);
    private boolean mMapHaschanged;
    private Object[] mResourceArray;

    public ResourceItem getItem(int index) {
        Object item = null;
        if (this.mMapHaschanged) {
            this.mResourceArray = this.mResourceList.toArray();
            this.mMapHaschanged = false;
        }
        return (ResourceItem)this.mResourceArray[index];
    }

    public ResourceItem getItemByKey(String key) throws TextNotFoundException {
        int count = this.mResourceList.size();
        int i = 0;
        while (i < count) {
            ResourceItem resourceItem = (ResourceItem)this.mResourceList.get(i);
            if (resourceItem.getKey().equals(key)) {
                return resourceItem;
            }
            ++i;
        }
        throw new TextNotFoundException();
    }

    public ResourceItem getItemById(String id) throws TextNotFoundException {
        ResourceItem element = null;
        if (null == this.mResourceArray) {
            this.mResourceArray = this.mResourceList.toArray();
        }
        int i = 0;
        while (i < this.mResourceArray.length) {
            element = (ResourceItem)this.mResourceArray[i];
            if (element.getComment() != null && element.getComment().compareTo(id) == 0) break;
            element = null;
            ++i;
        }
        if (null == element) {
            throw new TextNotFoundException();
        }
        return element;
    }

    public void add(ResourceItem item) {
        this.mResourceList.add(item);
        this.mMapHaschanged = true;
    }

    public void delete(ResourceItem item) {
        ((AbstractCollection)this.mResourceList).remove(item.getKey());
        this.mMapHaschanged = true;
    }

    public int getCount() {
        return this.mResourceList.size();
    }

    public Iterator iterator() {
        ResourceIterator iterator = new ResourceIterator(this);
        return iterator;
    }
}

