/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.model.property;

import com.sap.ide.eclipse.s2x.editor.model.property.Messages;
import com.sap.ide.eclipse.s2x.editor.model.property.ResourceItem;
import com.sap.ide.eclipse.s2x.editor.model.property.ResourceIterator;
import com.sap.ide.eclipse.s2x.editor.model.property.Resources;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.TextNotFoundException;
import com.sap.s2x.validation.ValidationException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.text.BreakIterator;
import java.util.Iterator;

public class PropertyFile {
    static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$s2x$editor$model$property$PropertyFile == null ? (class$com$sap$ide$eclipse$s2x$editor$model$property$PropertyFile = PropertyFile.class$("com.sap.ide.eclipse.s2x.editor.model.property.PropertyFile")) : class$com$sap$ide$eclipse$s2x$editor$model$property$PropertyFile));
    private File mPropertyFile;
    private Resources mResources;
    private S2XDocument mSSXDocument;
    private InputStream mPropertyStream;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    static /* synthetic */ Class class$com$sap$ide$eclipse$s2x$editor$model$property$PropertyFile;

    public PropertyFile(S2XDocument document) {
        this.mSSXDocument = document;
    }

    public void open(String fileName) {
        block6: {
            if (null != fileName && fileName.compareTo(Messages.getString("_2")) != 0) {
                if (null == this.mPropertyFile) {
                    this.mPropertyFile = new File(fileName);
                }
                try {
                    if (null != this.mSSXDocument) {
                        this.mSSXDocument.setProductname(fileName);
                    }
                    break block6;
                }
                catch (ValidationException e) {
                    if (tracer.error()) {
                        tracer.error(e.getMessage());
                    }
                    break block6;
                }
            }
            throw new InvalidParameterException(Messages.getString("Filename_is_invalid_3"));
        }
    }

    public void open(InputStream fileStream) {
        if (null != fileStream) {
            if (null == this.mPropertyStream) {
                this.mPropertyStream = fileStream;
            }
        } else {
            throw new InvalidParameterException("Filename is invalid");
        }
    }

    public Resources read() {
        try {
            if (null == this.mResources) {
                LineNumberReader reader;
                this.mResources = new Resources();
                if (null != this.mPropertyFile) {
                    if (!this.mPropertyFile.exists()) {
                        this.mPropertyFile.createNewFile();
                    } else {
                        FileReader filereader = new FileReader(this.mPropertyFile);
                        reader = new LineNumberReader(filereader);
                        this.fillResources(reader);
                    }
                }
                if (null != this.mPropertyStream) {
                    InputStreamReader streamReader = new InputStreamReader(this.mPropertyStream, "UTF8");
                    reader = new LineNumberReader(streamReader);
                    this.fillResources(reader);
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.mResources;
    }

    public void write(ResourceItem item) {
    }

    public void store(OutputStream outStream) {
        block3: {
            CharArrayWriter out = new CharArrayWriter(10);
            OutputStreamWriter writer = null;
            this.internalStore(out, true);
            try {
                if (null != outStream) {
                    writer = new OutputStreamWriter(outStream);
                }
                out.writeTo(writer);
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                if (!tracer.error()) break block3;
                tracer.error(e.getMessage());
            }
        }
    }

    public void store(boolean overWrite) {
        FileWriter writer = null;
        CharArrayWriter out = new CharArrayWriter(10);
        this.internalStore(out, overWrite);
        if (null != this.mPropertyFile) {
            try {
                writer = new FileWriter(this.mPropertyFile);
                out.writeTo(writer);
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public ResourceItem getItem(String key) throws TextNotFoundException {
        return this.mResources.getItemByKey(key);
    }

    public Iterator iterator() {
        ResourceIterator iterator = new ResourceIterator(this);
        return iterator;
    }

    public void setResources(Resources resources) {
        this.mResources = resources;
    }

    ResourceItem getResourceItem(int index) {
        return this.mResources.getItem(index);
    }

    int getResourceCount() {
        return this.mResources.getCount();
    }

    private void internalStore(Writer out, boolean overwrite) {
        block22: {
            String line = null;
            ResourceItem item = null;
            String string = null;
            try {
                InputStreamReader inputreader = null;
                if (null != this.mPropertyFile) {
                    inputreader = new FileReader(this.mPropertyFile);
                } else if (null != this.mPropertyStream) {
                    inputreader = new InputStreamReader(this.mPropertyStream);
                }
                try {
                    boolean isEmpty = true;
                    if (!overwrite) {
                        if (null != this.mPropertyStream && this.mPropertyStream.read() != -1) {
                            isEmpty = false;
                        } else if (null != this.mPropertyFile && this.mPropertyFile.length() != 0L) {
                            isEmpty = false;
                        }
                    }
                    if (isEmpty) {
                        Iterator iter = this.mResources.iterator();
                        while (iter.hasNext()) {
                            ResourceItem element = (ResourceItem)iter.next();
                            if (element.getComment() != null) {
                                out.write("#" + element.getComment());
                                out.write("\n");
                            }
                            out.write(element.getKey());
                            out.write("=");
                            out.write(this.saveConvert(element.getText(), false));
                            out.write("\n");
                            out.write("\n");
                        }
                        break block22;
                    }
                    LineNumberReader reader = new LineNumberReader(inputreader);
                    block7: do {
                        if (null == (line = reader.readLine()) || line.length() <= 0) continue;
                        boolean hasComment = false;
                        BreakIterator boundary = BreakIterator.getWordInstance();
                        boundary.setText(line);
                        int start = boundary.first();
                        int end = boundary.next();
                        while (end != -1) {
                            String token = line.substring(start, end);
                            if (token.startsWith("#")) {
                                start = end;
                                end = boundary.next();
                                token = line.substring(start);
                                hasComment = true;
                                continue block7;
                            }
                            if (token.length() > 0) {
                                try {
                                    item = this.mResources.getItemByKey(token);
                                    string = token + "=";
                                    string = string + this.saveConvert(item.getText(), false);
                                    if (!hasComment) {
                                        out.write("#");
                                        out.write(item.getComment() + "\n");
                                    }
                                    hasComment = false;
                                }
                                catch (TextNotFoundException e) {
                                    // empty catch block
                                }
                                out.write(string + "\n");
                                continue block7;
                            }
                            out.write("\n");
                            start = end;
                            end = boundary.next();
                        }
                    } while (null != line);
                }
                catch (IOException e) {
                    if (tracer.error()) {
                        tracer.error(e.getMessage());
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (!tracer.error()) break block22;
                tracer.error(e.getMessage());
            }
        }
    }

    private String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    break;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    break;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    break;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    break;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    break;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    break;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertyFile.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertyFile.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertyFile.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertyFile.toHex(aChar & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private void fillResources(LineNumberReader reader) {
        String line = null;
        ResourceItem item = null;
        block2: do {
            try {
                line = reader.readLine();
                if (null == line || line.length() <= 0) continue;
                if (null == item) {
                    item = new ResourceItem();
                }
                BreakIterator boundary = BreakIterator.getWordInstance();
                boundary.setText(line);
                int start = boundary.first();
                int end = boundary.next();
                while (end != -1) {
                    String token = line.substring(start, end);
                    if (token.startsWith("#")) {
                        token = line.substring(++start);
                        item.setComment(token);
                        continue block2;
                    }
                    if (line.length() > 0) {
                        start = line.indexOf(61);
                        if (start > 0) {
                            String converted = null;
                            token = line.substring(0, start);
                            item.setKey(token);
                            token = line.substring(start + 1);
                            converted = this.loadConvert(token);
                            item.setText(converted);
                        }
                        this.mResources.add(item);
                        item = null;
                        continue block2;
                    }
                    start = end;
                    end = boundary.next();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (null != line);
    }

    private String getLine(InputStreamReader reader) {
        StringBuffer line = new StringBuffer();
        while (true) {
            try {
                int c = reader.read();
                if (10 == c || 13 == c || 65535 == c || -1 == c) break;
                line.append((char)c);
            }
            catch (IOException iOException) {}
        }
        return line.toString();
    }

    private String convertToken(String token) {
        try {
            byte[] utf8Bytes = token.getBytes("UTF8");
            byte[] defaultBytes = token.getBytes();
            String converted = new String(utf8Bytes);
            return converted;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static void printBytes(byte[] array, String name) {
    }

    public void removeItem(String id) {
        block2: {
            try {
                this.mResources.delete(this.mResources.getItemById(id));
            }
            catch (TextNotFoundException e) {
                if (!tracer.error()) break block2;
                tracer.error(e.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

