/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.model;

import com.sap.s2x.DuplicateResnameException;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.TextNotFoundException;
import com.sap.s2x.etc.TranslationUnit;
import com.sap.s2x.tools.GUIDVersionException;
import com.sap.s2x.tools.S2XGUID;
import com.sap.s2x.validation.ValidationException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;

public class TranslatableText
extends TranslationUnit {
    static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$s2x$editor$model$TranslatableText == null ? (class$com$sap$ide$eclipse$s2x$editor$model$TranslatableText = TranslatableText.class$("com.sap.ide.eclipse.s2x.editor.model.TranslatableText")) : class$com$sap$ide$eclipse$s2x$editor$model$TranslatableText));
    public static final int TT_RES_NAME = 1;
    public static final int TT_RES_TYPE = 2;
    public static final int TT_RES_TEXT = 4;
    private String mID;
    private String mResName;
    private String mResType;
    private String mResText;
    private int mChangedFields;
    private String mOldResType;
    private String mMaxLength;
    private String mOldResName;
    private boolean isNew;
    private boolean isDeleted;
    static /* synthetic */ Class class$com$sap$ide$eclipse$s2x$editor$model$TranslatableText;

    public TranslatableText(String id, String resName, String resType, String resText) {
        if (null == id) {
            try {
                this.mID = S2XGUID.getGUID();
            }
            catch (GUIDVersionException e) {
                if (tracer.error()) {
                    tracer.error(e.getMessage());
                } else {
                    tracer.warning(e.getMessage());
                }
                this.mID = "00000_ERR";
            }
        } else {
            this.mID = id;
        }
        this.mResName = resName;
        this.mResType = resType;
        this.mResText = resText;
        this.mOldResType = resType;
        this.mOldResName = resName;
        this.mChangedFields = 0;
        this.isNew = false;
        this.isDeleted = false;
    }

    public TranslatableText(String id, String resName, String resType, String resText, String maxLength) {
        if (null == id) {
            try {
                this.mID = S2XGUID.getGUID();
            }
            catch (GUIDVersionException e) {
                if (tracer.error()) {
                    tracer.error(e.getMessage());
                } else {
                    tracer.warning(e.getMessage());
                }
                this.mID = "00000_ERR";
            }
        } else {
            this.mID = id;
        }
        this.mResName = resName;
        this.mResType = resType;
        this.mResText = resText;
        this.mMaxLength = maxLength;
        this.setResname(resName);
        this.setRestype(resType);
        this.setMaxwidth(maxLength);
        this.setSource(resText);
        this.mChangedFields = 0;
    }

    public String getID() {
        if (null == this.mID) {
            return super.getID();
        }
        return this.mID;
    }

    public String getResName() {
        return super.getResname();
    }

    public String getResText() {
        return this.mResText;
    }

    public String getResType() {
        return this.mResType;
    }

    public int getChangedFields() {
        return this.mChangedFields;
    }

    public void setResName(String resName) {
        this.setResname(resName);
    }

    public void setResText(String resText) {
        if (this.mResText.compareTo(resText) != 0) {
            this.mResText = resText;
            this.mChangedFields |= 4;
        }
    }

    public void setResType(String resType) {
        if (0 == (this.mChangedFields & 2)) {
            this.mOldResType = this.mResType;
        }
        if (this.mResType.compareTo(resType) != 0) {
            this.mResType = resType;
            this.mChangedFields |= 2;
        }
    }

    public String getOldResType() {
        return this.mOldResType;
    }

    public String getMaxLength() {
        return this.mMaxLength;
    }

    public void setMaxLength(String maxWidth) {
        this.mMaxLength = maxWidth;
    }

    public void setResname(String resName) {
        if (0 == (this.mChangedFields & 1)) {
            this.mOldResName = this.getResname();
        }
        if (super.getResname().compareTo(resName) != 0) {
            this.mResName = resName;
            this.mChangedFields |= 1;
            super.setResname(resName);
        }
    }

    public void setRestype(String resType) {
        if (0 == (this.mChangedFields & 2)) {
            this.mOldResType = this.mResType;
        }
        if (super.getRestype().compareTo(resType) != 0) {
            this.mResType = resType;
            this.mChangedFields |= 2;
            super.setRestype(resType);
        }
    }

    public void setSource(String resText) {
        if (super.getSource().compareTo(resText) != 0) {
            this.mResText = resText;
            this.mChangedFields |= 4;
            super.setSource(resText);
        }
    }

    public String getOldResName() {
        return this.mOldResName;
    }

    public void setNew(boolean b) {
        this.isNew = b;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void commit(S2XDocument doc) throws ValidationException {
        block13: {
            try {
                TranslationUnit unit = doc.getText(this.getID());
                if ((this.getChangedFields() & 2) == 2) {
                    doc.changeRestype(this.getID(), this.getOldResType(), this.getResType());
                }
                if ((this.getChangedFields() & 1) == 1) {
                    doc.setResname(unit.getID(), this.getRestype(), this.getResname());
                }
                if ((this.getChangedFields() & 4) == 4) {
                    String str = this.getSource();
                    doc.modifyText(str, this.getID(), this.getRestype());
                }
                doc.modifyMaxwidth(this.getID(), this.mResType, this.mMaxLength);
            }
            catch (TextNotFoundException e) {
                String key = null;
                try {
                    try {
                        key = doc.addText(this.getSource(), this.getResname(), this.getRestype(), this.getMaxwidth());
                        this.setID(key);
                        this.isNew = false;
                    }
                    catch (DuplicateResnameException err) {
                        if (tracer.error()) {
                            tracer.error(err.getMessage());
                        }
                        Object var7_8 = null;
                        break block13;
                    }
                    catch (ValidationException err) {
                        if (tracer.error()) {
                            tracer.error(err.getMessage());
                        }
                        Object var7_9 = null;
                        break block13;
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    throw throwable;
                }
            }
            catch (ValidationException err) {
                if (!tracer.error()) break block13;
                tracer.error(err.getMessage());
            }
        }
    }

    public void delete() {
        this.isDeleted = true;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

