/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.model;

import com.sap.ide.eclipse.s2x.editor.model.TranslatableText;
import com.sap.s2x.DuplicateResnameException;
import com.sap.s2x.TextNotFoundException;
import com.sap.s2x.etc.TranslationUnit;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class TextPool {
    ArrayList mTextArray = new ArrayList(20);

    public void add(TranslatableText text) {
        Iterator iter = ((AbstractList)this.mTextArray).iterator();
        while (iter.hasNext()) {
            TranslatableText element = (TranslatableText)((Object)iter.next());
            if (null == element.getID() || 0 != text.getID().compareTo(element.getID())) continue;
            return;
        }
        this.mTextArray.add(text);
    }

    public TranslatableText[] getTextArray() {
        return this.mTextArray.toArray(new TranslatableText[this.mTextArray.size()]);
    }

    public String addText(String resName, String resText, String resType, String maxWidth) throws DuplicateResnameException {
        Iterator iter = ((AbstractList)this.mTextArray).iterator();
        while (iter.hasNext()) {
            TranslatableText element = (TranslatableText)((Object)iter.next());
            if (0 != resName.compareTo(element.getResname())) continue;
            throw new DuplicateResnameException("This resource already exists");
        }
        TranslatableText text = new TranslatableText(null, resName, resType, resText, maxWidth);
        text.setNew(true);
        this.add(text);
        return text.getID();
    }

    public TranslationUnit getText(String id) throws TextNotFoundException {
        TranslationUnit unit = null;
        int i = 0;
        while (i < this.mTextArray.size()) {
            unit = (TranslationUnit)this.mTextArray.get(i);
            if (unit.getID().compareTo(id) == 0) break;
            unit = null;
            ++i;
        }
        if (null == unit) {
            throw new TextNotFoundException();
        }
        return unit;
    }

    public Iterator iterator() {
        TextIterator iterator = new TextIterator();
        return iterator;
    }

    public void remove(TranslatableText element) {
        ((AbstractCollection)this.mTextArray).remove((Object)element);
    }

    protected class TextIterator
    implements Iterator {
        private int mCount = 0;

        public boolean hasNext() {
            boolean hasNext = false;
            if (this.mCount < TextPool.this.mTextArray.size()) {
                hasNext = true;
            }
            return hasNext;
        }

        public Object next() {
            Object text = TextPool.this.mTextArray.get(this.mCount);
            ++this.mCount;
            return text;
        }

        public void remove() {
        }
    }
}

