/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.model;

import com.sap.ide.eclipse.s2x.editor.model.TextPool;
import com.sap.ide.eclipse.s2x.editor.model.TranslatableText;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.etc.TranslationUnit;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceTextModel
implements IStructuredContentProvider {
    private S2XDocument mSSXDocument;
    private TextPool mTextPool;
    private ArrayList tempTextPool;

    public ResourceTextModel(S2XDocument document) {
        this.mSSXDocument = document;
    }

    public Object[] getElements(Object inputElement) {
        if (null == this.mTextPool) {
            this.createTextPool();
        }
        return this.mTextPool.getTextArray();
    }

    protected void createTextPool() {
        this.mTextPool = new TextPool();
        if (null != this.tempTextPool) {
            Iterator iter = ((AbstractList)this.tempTextPool).iterator();
            while (iter.hasNext()) {
                TranslatableText element = (TranslatableText)((Object)iter.next());
                this.mTextPool.add(element);
            }
            this.tempTextPool = null;
        }
        Vector v = this.mSSXDocument.getTexts();
        int i = 0;
        while (i < v.size()) {
            TranslationUnit element = (TranslationUnit)v.get(i);
            TranslatableText text = new TranslatableText(element.getID(), element.getResname(), element.getRestype(), element.getSource(), element.getMaxwidth());
            this.mTextPool.add(text);
            ++i;
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public TranslationUnit[] getTextArray() {
        return this.mTextPool.getTextArray();
    }

    public TextPool getTextPool() {
        if (null == this.mTextPool) {
            this.createTextPool();
        }
        return this.mTextPool;
    }

    public void refresh() {
        this.tempTextPool = new ArrayList(10);
        Iterator iter = this.mTextPool.iterator();
        while (iter.hasNext()) {
            TranslatableText element = (TranslatableText)((Object)iter.next());
            if (!element.isNew() && 0 == element.getChangedFields()) continue;
            this.tempTextPool.add(element);
        }
        this.mTextPool = null;
    }

    public void refreshTextPool() {
        this.mTextPool = null;
    }
}

