/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.editors;

import com.sap.control.custom.tableview.TableLabelProvider;
import com.sap.control.custom.tableview.TableModel;
import com.sap.control.custom.tableview.ToolbarTableView;
import com.sap.ide.eclipse.s2x.editor.model.TextPool;
import com.sap.ide.eclipse.s2x.editor.model.TranslatableText;
import com.sap.ide.eclipse.s2x.editor.model.property.PropertyFile;
import com.sap.ide.eclipse.s2x.editor.model.property.ResourceItem;
import com.sap.ide.eclipse.s2x.editor.model.property.Resources;
import com.sap.ide.eclipse.s2x.editor.model.property.UnicodeFormatter;
import com.sap.ide.eclipse.s2x.editor.tab.SSXHeaderEditor;
import com.sap.ide.eclipse.s2x.editor.tab.SSXResourceEditor;
import com.sap.jdt.s2x.transform.ResourceExtractor;
import com.sap.s2x.DuplicatePhaseException;
import com.sap.s2x.DuplicateResnameException;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.S2XTypes;
import com.sap.s2x.TextNotFoundException;
import com.sap.s2x.core.MarshalException;
import com.sap.s2x.core.types.RestypeValue;
import com.sap.s2x.core.types.S2XTypeInterface;
import com.sap.s2x.etc.TranslationUnit;
import com.sap.s2x.validation.ValidationException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.xml.sax.SAXException;

public class S2XMultiPageEditor
extends MultiPageEditorPart {
    private String mPropFilePackageName;
    static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$control$custom$tableview$ToolbarTableView == null ? (class$com$sap$control$custom$tableview$ToolbarTableView = S2XMultiPageEditor.class$("com.sap.control.custom.tableview.ToolbarTableView")) : class$com$sap$control$custom$tableview$ToolbarTableView));
    private boolean m_isWritable;
    public static final int S2X_MAX_KEY_LEN = 32;
    public static final String STR_TOOL_NAME = "SAP Java IDE S2X Editor";
    private static ArrayList mDataTypeValueList;
    private static ArrayList mResTypeList;
    private S2XDocument mSSXDocument;
    private int mTheID;
    private SSXHeaderEditor mHeaderEditor;
    private SSXResourceEditor mResourceEditor;
    private StatusLineManager m_statusLine;
    private String mPropFileName;
    private PropertyFile mPropertyFile;
    private InputStream mPropertyStream;
    private String mSSXFileName;
    private IFile m_ifileXLF;
    private IFile m_ifileProperties;
    private IPath mSSXFilePath;
    private boolean mIsNewSSX;
    private boolean mIsStartedFromXLF;
    static /* synthetic */ Class class$com$sap$control$custom$tableview$ToolbarTableView;

    private void store() {
        byte[] bytes = new byte[4];
        bytes = System.getProperty("line.separator").getBytes();
        int i = 0;
        while (i < bytes.length) {
            String s = Integer.toHexString(bytes[i]);
            ++i;
        }
        this.persist();
        File file = this.m_ifileXLF.getLocation().toFile();
        try {
            this.mSSXDocument.store(file);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        catch (MarshalException e) {
            // empty catch block
        }
        IFileEditorInput fileInput = (IFileEditorInput)this.getEditorInput();
        File propFile = new File(fileInput.getFile().getLocation().toOSString());
        try {
            if (!this.mIsStartedFromXLF) {
                FileOutputStream oStream = new FileOutputStream(propFile);
                this.mPropertyFile.store(oStream);
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    private void displayAllText() {
        Vector texts = this.mSSXDocument.getTexts();
        Iterator iter = ((AbstractList)texts).iterator();
        while (iter.hasNext()) {
            TranslationUnit element = (TranslationUnit)iter.next();
            System.out.println("Printing:" + element.getResname());
            System.out.println("Text:" + element.getSource());
            UnicodeFormatter.printBytes(element.getSource().getBytes(), element.getSource());
        }
    }

    private void persist() {
        Resources resources = null;
        boolean isValid = true;
        ArrayList<String> errList = new ArrayList<String>();
        if (!this.mIsStartedFromXLF) {
            resources = this.mPropertyFile.read();
        }
        TranslatableText[] textArray = (TranslatableText[])this.mResourceEditor.getTextModel().getTextArray();
        int i = 0;
        while (i < textArray.length) {
            block25: {
                TranslatableText translatableText = textArray[i];
                ResourceItem resourceItem = null;
                String key = null;
                try {
                    TranslationUnit unit = this.mSSXDocument.getText(translatableText.getID());
                    translatableText.commit(this.mSSXDocument);
                    if (!this.mIsStartedFromXLF) {
                        resourceItem = resources.getItemById(translatableText.getID());
                        resourceItem.setComment(unit.getID());
                        resourceItem.setKey(translatableText.getResName());
                        resourceItem.setText(translatableText.getSource());
                    }
                }
                catch (TextNotFoundException e) {
                    if (tracer.error()) {
                        tracer.error(e.getMessage());
                    } else {
                        tracer.warning(e.getMessage());
                    }
                    try {
                        key = this.mSSXDocument.addText(translatableText.getSource(), translatableText.getResname(), translatableText.getRestype(), translatableText.getMaxwidth());
                        translatableText.setID(key);
                        try {
                            if (!this.mIsStartedFromXLF) {
                                resources.getItemById(translatableText.getID());
                            }
                        }
                        catch (TextNotFoundException err) {
                            Object var13_20;
                            if (tracer.error()) {
                                tracer.error(e.getMessage());
                            } else {
                                tracer.warning(e.getMessage());
                            }
                            try {
                                try {
                                    resourceItem = resources.getItemByKey(translatableText.getResname());
                                }
                                catch (TextNotFoundException error) {
                                    resourceItem = new ResourceItem();
                                    resources.add(resourceItem);
                                    var13_20 = null;
                                    resourceItem.setComment(translatableText.getID());
                                    resourceItem.setKey(translatableText.getResname());
                                    resourceItem.setText(translatableText.getSource());
                                    break block25;
                                }
                                var13_20 = null;
                                resourceItem.setComment(translatableText.getID());
                                resourceItem.setKey(translatableText.getResname());
                                resourceItem.setText(translatableText.getSource());
                            }
                            catch (Throwable throwable) {
                                var13_20 = null;
                                resourceItem.setComment(translatableText.getID());
                                resourceItem.setKey(translatableText.getResname());
                                resourceItem.setText(translatableText.getSource());
                                throw throwable;
                            }
                        }
                    }
                    catch (DuplicateResnameException err) {
                        errList.add(err.getMessage());
                    }
                    catch (ValidationException error) {
                        if (tracer.error()) {
                            tracer.error(e.getMessage());
                        } else {
                            tracer.warning(e.getMessage());
                        }
                        isValid = false;
                        errList.add(error.getMessage());
                    }
                    catch (Exception er) {}
                }
                catch (Exception e) {
                    if (tracer.error()) {
                        tracer.error(e.getMessage());
                    }
                    tracer.warning(e.getMessage());
                }
            }
            ++i;
        }
        if (!isValid) {
            MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Validation Error", (String)((String)errList.get(errList.size() - 1)));
        }
    }

    private void loadFromPropFile() {
        this.mPropertyFile = new PropertyFile(this.mSSXDocument);
        this.mPropertyFile.open(this.mPropertyStream);
        this.mPropertyFile.read();
        Iterator it = this.mPropertyFile.iterator();
        TextPool textPool = this.mResourceEditor.getTextModel().getTextPool();
        this.mHeaderEditor.updateFields();
        boolean newPropertyItem = false;
        while (it.hasNext()) {
            ResourceItem element = (ResourceItem)it.next();
            TranslationUnit unit = null;
            String propertiesKey = element.getKey();
            if (32 < propertiesKey.length()) {
                propertiesKey = propertiesKey.substring(0, 32);
            }
            try {
                if (null != element.getComment()) {
                    unit = textPool.getText(element.getComment());
                    unit.setSource(element.getText());
                    unit.setResname(propertiesKey);
                    continue;
                }
                String key = null;
                try {
                    key = textPool.addText(propertiesKey, element.getText(), "label", this.mSSXDocument.getMaxLength());
                }
                catch (DuplicateResnameException e) {
                    if (tracer.error()) {
                        tracer.error(e.getMessage());
                        break;
                    }
                    tracer.warning(e.getMessage());
                    break;
                }
                newPropertyItem = true;
                element.setComment(key);
            }
            catch (TextNotFoundException e) {
                if (tracer.error()) {
                    tracer.error(e.getMessage());
                } else {
                    tracer.warning(e.getMessage());
                }
                String key = null;
                try {
                    key = textPool.addText(propertiesKey, element.getText(), "label", this.mSSXDocument.getMaxLength());
                }
                catch (DuplicateResnameException err) {
                    break;
                }
                element.setComment(key);
            }
        }
        if (newPropertyItem) {
            this.store();
        }
        if (this.mIsNewSSX) {
            this.store();
            this.mIsNewSSX = false;
        }
    }

    private void init(Composite parent) {
        S2XMultiPageEditor.displayTypes();
        this.initStatusBar(parent);
        this.initDocument();
    }

    private void initStatusBar(Composite parent) {
        this.m_statusLine = new StatusLineManager();
        this.m_statusLine.createControl(parent);
        this.m_statusLine.setMessage("");
        GridData gdata = new GridData(1808);
        gdata.grabExcessVerticalSpace = false;
        this.m_statusLine.getControl().setLayoutData((Object)gdata);
        this.m_statusLine.getControl().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
                S2XMultiPageEditor.this.m_statusLine.setMessage("Ready");
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
    }

    private boolean initDocument() {
        try {
            File file;
            IPath filePath = null;
            Object aList = null;
            Object layout = null;
            IProject project = null;
            IFileEditorInput fileInput = (IFileEditorInput)this.getEditorInput();
            if (null != fileInput.getFile()) {
                fileInput.getFile().refreshLocal(0, null);
                filePath = fileInput.getFile().getFullPath();
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (0 == filePath.getFileExtension().compareToIgnoreCase("xlf")) {
                this.mIsStartedFromXLF = true;
                file = filePath.toFile();
                this.m_ifileXLF = workspace.getRoot().getFile(filePath);
            } else {
                this.mIsStartedFromXLF = false;
                this.mPropFileName = filePath.makeRelative().toOSString();
                this.m_ifileProperties = fileInput.getFile();
                this.mPropertyStream = fileInput.getFile().getContents();
                this.mSSXFilePath = filePath.removeFileExtension().addFileExtension("xlf");
                this.mSSXFileName = this.mSSXFilePath.toOSString();
                file = this.mSSXFilePath.toFile();
                this.m_ifileXLF = workspace.getRoot().getFile(this.mSSXFilePath);
            }
            String propFilePath = this.m_ifileXLF.getProjectRelativePath().toOSString();
            this.mPropFilePackageName = "";
            if (-1 != propFilePath.lastIndexOf(92)) {
                this.mPropFilePackageName = propFilePath.substring(0, propFilePath.lastIndexOf(92) + 1).replace('\\', '.');
                if (this.mPropFilePackageName.length() > 1) {
                    this.mPropFilePackageName = this.mPropFilePackageName.substring(0, this.mPropFilePackageName.length() - 1);
                }
            }
            this.mIsNewSSX = false;
            if (!this.m_ifileXLF.exists()) {
                this.mIsNewSSX = true;
                ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
                try {
                    this.m_ifileXLF.create((InputStream)contents, true, null);
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() == 374) {
                        this.m_ifileXLF.refreshLocal(0, null);
                    }
                    throw e;
                }
                this.mSSXDocument = new S2XDocument();
                this.initHeaderInfo();
                this.mSSXDocument.store(file);
            } else {
                IFile[] files = new IFile[1];
                this.m_ifileXLF.refreshLocal(0, null);
                IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                project = this.m_ifileXLF.getProject();
                if (null == project) {
                    return false;
                }
                project.refreshLocal(2, null);
                files[0] = this.m_ifileXLF;
                IStatus status = project.getWorkspace().validateEdit(files, null);
                InputStream stream = this.m_ifileXLF.getContents();
                if (0 == stream.available()) {
                    this.mSSXDocument = new S2XDocument();
                    this.initHeaderInfo();
                } else {
                    this.mSSXDocument = new S2XDocument(stream, 2);
                }
                this.m_isWritable = true;
            }
            ArrayList aList1 = this.mSSXDocument.getErrorMessagesLoadRSX();
            if (aList1.size() > 0) {
                Iterator iter = ((AbstractList)aList1).iterator();
                while (iter.hasNext()) {
                    String element = (String)iter.next();
                }
            }
        }
        catch (MarshalException e) {
        }
        catch (FileNotFoundException e) {
        }
        catch (SAXException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (IOException e) {
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    private void initHeaderInfo() {
        try {
            this.mSSXDocument.setTool(STR_TOOL_NAME);
            this.mSSXDocument.setOriginalLocale("en");
            this.mSSXDocument.setDatatype("javaPropertyResourceBundle");
            this.mSSXDocument.setMaxLength("255");
            this.mSSXDocument.setOriginal("None");
            this.mSSXDocument.setDevelContact("sapuser@sap.com");
            String ext = this.m_ifileXLF.getFileExtension();
            int idx = this.m_ifileXLF.getName().indexOf(ext);
            String onlyName = this.m_ifileXLF.getName();
            if (idx > 1) {
                onlyName = this.m_ifileXLF.getName().substring(0, idx - 1);
            }
            this.mSSXDocument.setProductname(onlyName + " [" + this.mPropFilePackageName + "]");
        }
        catch (ValidationException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fillForm(Composite parent) {
        try {
            Composite firstTab = new Composite(parent, 0);
            firstTab.setLayout((Layout)new FillLayout());
            this.init(firstTab);
            this.mHeaderEditor = new SSXHeaderEditor(firstTab, this, this.mSSXDocument, this.m_statusLine);
            this.addPage((Control)firstTab);
            this.setPageText(0, "Header ");
            Composite secondTab = new Composite(parent, 0);
            secondTab.setLayout((Layout)new FillLayout());
            this.mResourceEditor = new SSXResourceEditor(secondTab, this, this.mSSXDocument);
            this.addPage((Control)secondTab);
            this.setPageText(1, "Resource Text");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void fillPhaseSection(Group parent) {
        parent.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        parent.setLayout((Layout)gridLayout);
        Label label0 = new Label((Composite)parent, 0);
        label0.setText("Name ");
        Text text1 = new Text((Composite)parent, 2048);
        text1.setText("");
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text1.setLayoutData((Object)data);
        Label label2 = new Label((Composite)parent, 0);
        label2.setText("Process Name ");
        Text text3 = new Text((Composite)parent, 2048);
        text3.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text3.setLayoutData((Object)data);
        Group shell = new Group((Composite)parent, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        shell.setLayoutData((Object)data);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Notes");
        ToolbarTableView name = new ToolbarTableView((Composite)shell, 0);
        name.setColumnCount(3);
        TableModel tableModel = new TableModel();
        name.setTableMode((IContentProvider)tableModel);
        name.setLabeProvider((IBaseLabelProvider)new TableLabelProvider(tableModel));
        name.setInput(this.mSSXDocument);
    }

    private void fillFileSection(Composite parent) {
        GridData data = new GridData(272);
        data.grabExcessVerticalSpace = false;
        parent.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        parent.setLayout((Layout)gridLayout);
        Label label0 = new Label(parent, 0);
        label0.setText("Tool ");
        Text text1 = new Text(parent, 2048);
        text1.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text1.setLayoutData((Object)data);
        Label label2 = new Label(parent, 0);
        label2.setText("Source File");
        Text text3 = new Text(parent, 2048);
        text3.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text3.setLayoutData((Object)data);
        Button button4 = new Button(parent, 0x800000);
        Image image = S2XMultiPageEditor.getImage("file://C:/Program Files/SAP/JDT/eclipse/Workspace/TestApp/resources/icons/NewMessage.gif");
        button4.addSelectionListener((SelectionListener)new MySelectionListener());
        button4.setImage(image);
        Label label5 = new Label(parent, 0);
        label5.setText("Source Language ");
        Combo sourceLang = new Combo(parent, 2056);
        sourceLang.setText("text6");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        sourceLang.setLayoutData((Object)data);
        Label label7 = new Label(parent, 0);
        label7.setText("Data Type");
        Combo dataType = new Combo(parent, 2056);
        dataType.setText("text8");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        dataType.setLayoutData((Object)data);
        this.fillDataType(dataType);
    }

    private void fillDataType(Combo dataType) {
        ArrayList list = null;
        list = S2XTypes.getInstance().getDatatypeValueList();
        int j = 0;
        while (j < list.size()) {
            S2XTypeInterface type = null;
            type = (S2XTypeInterface)list.get(j);
            dataType.add(type.getDescription());
            ++j;
        }
        dataType.select(0);
    }

    private void addSomeText() {
        try {
            S2XTypes types = S2XTypes.getInstance();
            RestypeValue restypeValue = (RestypeValue)types.getRestypes().get(0);
            S2XTypeInterface type = (S2XTypeInterface)types.getRestypes().get(0);
            this.mSSXDocument.addText("Simple", type.getXLIFFValue(), "32");
            this.mSSXDocument.addText("Another", type.getXLIFFValue(), "32");
            type = (S2XTypeInterface)types.getRestypes().get(2);
            this.mSSXDocument.addText("I Dunno", type.getXLIFFValue(), "32");
            this.mSSXDocument.addText("Hmmm", type.getXLIFFValue(), "32");
            type = (S2XTypeInterface)types.getRestypes().get(5);
            this.mSSXDocument.addText("What this", type.getXLIFFValue(), "32");
            this.mSSXDocument.addText("Hmmm ...", type.getXLIFFValue(), "32");
            String[] notes = new String[]{"Note1", "Note 2"};
            this.mSSXDocument.addPhase("modelling", "viewDesign", "webDynproViewDesigner", notes);
        }
        catch (DuplicatePhaseException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void displayTypes() {
        S2XTypeInterface type;
        mResTypeList = S2XTypes.getInstance().getRestypes();
        int i = 0;
        while (i < mResTypeList.size()) {
            type = (S2XTypeInterface)mResTypeList.get(i);
            ++i;
        }
        mDataTypeValueList = S2XTypes.getInstance().getDatatypeValueList();
        int j = 0;
        while (j < mResTypeList.size()) {
            type = (S2XTypeInterface)mResTypeList.get(j);
            ++j;
        }
        mResTypeList = S2XTypes.getInstance().getDomainTypes();
        int j2 = 0;
        while (j2 < mResTypeList.size()) {
            type = (S2XTypeInterface)mResTypeList.get(j2);
            ++j2;
        }
    }

    public boolean isWritable() {
        boolean retVal = false;
        try {
            block6: {
                try {
                    if (this.mIsStartedFromXLF) {
                        if (null != this.m_ifileXLF) {
                            retVal = !this.m_ifileXLF.isReadOnly();
                        }
                        break block6;
                    }
                    if (null == this.m_ifileProperties || null == this.m_ifileXLF) break block6;
                    retVal = !this.m_ifileXLF.isReadOnly() && !this.m_ifileProperties.isReadOnly();
                }
                catch (Exception e) {
                    Object var4_3 = null;
                    return retVal;
                }
            }
            Object var4_2 = null;
            return retVal;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            return retVal;
        }
    }

    protected void finalize() throws Throwable {
        File file = new File(this.mSSXFileName);
        this.mSSXDocument.store(file);
        super.finalize();
    }

    protected void createPages() {
        Composite parent;
        block5: {
            parent = this.getContainer();
            this.setTitle(this.getEditorInput().getName());
            if (!this.mIsStartedFromXLF) {
                try {
                    if (null != this.mSSXDocument) {
                        this.mSSXDocument.setProductname(this.m_ifileProperties.getName());
                    }
                }
                catch (ValidationException e) {
                    if (!tracer.error()) break block5;
                    tracer.error(e.getMessage());
                }
            }
        }
        this.fillForm(parent);
        if (!this.mIsStartedFromXLF) {
            this.loadFromPropFile();
        }
        this.mResourceEditor.refresh();
        this.mHeaderEditor.initControlStates();
        this.mResourceEditor.initControlStates();
    }

    public static Image getImage(String imageName) {
        ImageDescriptor imageDesc = null;
        Image img = null;
        Object imageDes = null;
        URL imageUrl = null;
        try {
            imageUrl = new URL(imageName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        imageDesc = ImageDescriptor.createFromURL(imageUrl);
        img = imageDesc.createImage();
        return img;
    }

    public void openFile() {
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask("Saving... ", 100);
        this.mHeaderEditor.doSave(monitor);
        this.mResourceEditor.doSave(monitor);
        this.store();
        monitor.done();
        try {
            if (null != this.m_ifileXLF) {
                this.m_ifileXLF.refreshLocal(0, null);
            }
            if (null != this.m_ifileProperties) {
                this.m_ifileProperties.refreshLocal(0, null);
            }
        }
        catch (CoreException e) {
            if (tracer.error()) {
                tracer.error(e.getMessage());
            }
            tracer.warning(e.getMessage());
        }
        this.firePropertyChange(257);
        if (this.m_ifileXLF.getLocation().toOSString().length() > 0) {
            String newPropFileLocation = this.m_ifileXLF.getLocation().toOSString();
            newPropFileLocation = newPropFileLocation.substring(0, newPropFileLocation.lastIndexOf(".xlf")) + ".properties";
            ResourceExtractor.runTransform(this.m_ifileXLF.getLocation().toOSString(), newPropFileLocation);
        }
        this.mResourceEditor.getM_ResourceTextModel().refreshTextPool();
        this.mResourceEditor.getM_CustomTableView().refreshTable();
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public int getTheID() {
        return this.mTheID;
    }

    public boolean isDirty() {
        if (null == this.mHeaderEditor || null == this.mResourceEditor) {
            return false;
        }
        return this.mHeaderEditor.isDirty() || this.mResourceEditor.isDirty();
    }

    public boolean checkWritability() {
        IFile[] files = new IFile[1];
        try {
            this.m_ifileXLF.refreshLocal(0, null);
        }
        catch (CoreException e1) {
            // empty catch block
        }
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = this.m_ifileXLF.getProject();
        if (null == project) {
            return false;
        }
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            // empty catch block
        }
        if (!this.mIsStartedFromXLF) {
            files = new IFile[]{this.m_ifileXLF, this.m_ifileProperties};
        } else {
            files[0] = this.m_ifileXLF;
        }
        IStatus status = project.getWorkspace().validateEdit(files, null);
        if (status.isOK()) {
            this.mHeaderEditor.setControlStates(true);
            this.m_isWritable = !this.m_ifileXLF.isReadOnly();
        } else {
            this.m_isWritable = false;
        }
        return this.m_isWritable;
    }

    public void contentModified() {
        this.firePropertyChange(257);
    }

    public PropertyFile getPropertyFile() {
        return this.mPropertyFile;
    }

    public StatusLineManager getStatusLine() {
        return this.m_statusLine;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Editor input type. Excpecting IFileEditorInput.");
        }
        super.init(site, input);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MySelectionListener
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
        }
    }
}

