/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.s2x.editor.dialog;

import com.sap.ide.eclipse.s2x.editor.helper.SSXEditorHelper;
import com.sap.ide.eclipse.s2x.editor.model.TextPool;
import com.sap.ide.eclipse.s2x.editor.model.TranslatableText;
import com.sap.ide.eclipse.s2x.editor.tab.SSXResourceEditor;
import com.sap.s2x.DuplicateResnameException;
import com.sap.s2x.TextNotFoundException;
import com.sap.s2x.core.types.RestypeValue;
import com.sap.s2x.etc.TranslationUnit;
import com.sap.s2x.validation.ValidationException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Iterator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResourceTextDialog
extends TitleAreaDialog {
    static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$s2x$editor$dialog$ResourceTextDialog == null ? (class$com$sap$ide$eclipse$s2x$editor$dialog$ResourceTextDialog = ResourceTextDialog.class$("com.sap.ide.eclipse.s2x.editor.dialog.ResourceTextDialog")) : class$com$sap$ide$eclipse$s2x$editor$dialog$ResourceTextDialog));
    private StatusLineManager m_StatusLine;
    private static final int SE_NAME_MAXLENGTH = 32;
    private SSXResourceEditor m_ResEditor;
    private Text m_KeyText;
    private Combo m_ResTypeCombo;
    private Text m_ResNameText;
    private Text m_ResText;
    private String[] m_ResTypes;
    private boolean m_IsNew;
    private Object m_ResId;
    private Text m_MaxLengthText;
    private Button m_DefaultLengthButton;
    private String m_PrevText;
    static /* synthetic */ Class class$com$sap$ide$eclipse$s2x$editor$dialog$ResourceTextDialog;

    public ResourceTextDialog(SSXResourceEditor resEdit, boolean isNew) {
        super(resEdit.getParent().getShell());
        this.m_IsNew = isNew;
        this.m_ResEditor = resEdit;
        this.setShellStyle(67616);
    }

    private void fillDialog() {
        Object[] items = this.m_ResEditor.getSelectedText();
        if (null != items && items.length > 0) {
            TranslatableText element = (TranslatableText)((Object)items[0]);
            this.m_ResId = element.getID();
            this.m_ResNameText.setText(element.getResname());
            this.m_ResTypeCombo.setText(element.getRestype());
            this.m_ResText.setText(element.getSource());
            this.m_MaxLengthText.setText(element.getMaxwidth());
            this.m_PrevText = element.getResname();
        }
    }

    protected void okPressed() {
        try {
            TranslatableText text = null;
            String uid = "";
            if (this.validate()) {
                if (this.m_IsNew) {
                    TextPool pool = this.m_ResEditor.getTextModel().getTextPool();
                    try {
                        uid = pool.addText(this.m_ResNameText.getText(), this.m_ResText.getText(), this.m_ResTypeCombo.getText(), this.m_MaxLengthText.getText());
                        TranslationUnit tunit = pool.getText(uid);
                    }
                    catch (DuplicateResnameException e) {
                        if (tracer.error()) {
                            tracer.error(e.getMessage());
                        } else {
                            tracer.warning(e.getMessage());
                        }
                        this.m_StatusLine.setErrorMessage(e.getMessage());
                        return;
                    }
                } else {
                    Iterator iter = this.m_ResEditor.getTextModel().getTextPool().iterator();
                    while (iter.hasNext()) {
                        TranslatableText element = (TranslatableText)((Object)iter.next());
                        if (this.m_PrevText.compareTo(element.getResname()) == 0 || 0 != this.m_ResNameText.getText().compareTo(element.getResname())) continue;
                        try {
                            throw new DuplicateResnameException("This resource already exists");
                        }
                        catch (DuplicateResnameException e1) {
                            if (tracer.error()) {
                                tracer.error(e1.getMessage());
                            } else {
                                tracer.warning(e1.getMessage());
                            }
                            this.m_StatusLine.setErrorMessage(e1.getMessage());
                            return;
                        }
                    }
                    text = (TranslatableText)((Object)this.m_ResEditor.getSelectedText()[0]);
                    text.setResname(this.m_ResNameText.getText());
                    text.setRestype(this.m_ResTypeCombo.getText());
                    text.setSource(this.m_ResText.getText());
                    text.setMaxwidth(this.m_MaxLengthText.getText());
                }
                this.m_ResEditor.setRowText(text);
                super.okPressed();
            }
        }
        catch (ValidationException e) {
            if (tracer.error()) {
                tracer.error(e.getMessage());
            }
            this.m_StatusLine.setErrorMessage(e.getMessage());
        }
        catch (TextNotFoundException e) {
            if (tracer.error()) {
                tracer.error(e.getMessage());
            }
            this.m_StatusLine.setErrorMessage(e.getMessage());
        }
    }

    private boolean validate() {
        boolean retVal = true;
        this.m_StatusLine.setErrorMessage("");
        if (null == this.m_ResNameText.getText() || 0 == this.m_ResNameText.getText().length()) {
            this.m_StatusLine.setErrorMessage("Resource name and text cannot be blank");
            retVal = false;
        }
        if (null == this.m_ResText.getText() || 0 == this.m_ResText.getText().length()) {
            this.m_StatusLine.setErrorMessage("Resource name and text cannot be blank");
            retVal = false;
        }
        if (Integer.valueOf(this.m_MaxLengthText.getText()) < this.m_ResText.getText().length()) {
            this.m_StatusLine.setErrorMessage("The resource text length is more than the max length you specified");
            retVal = false;
        }
        return retVal;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite dialogParent = new Composite(parentComposite, 0);
        this.setTitle("Resource Text");
        this.setMessage("Enter the Resource Text. The name can contain a-z A-Z 0-9 _ and .");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        dialogParent.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        dialogParent.setLayoutData((Object)data);
        Label label2 = new Label(dialogParent, 0);
        label2.setText("Resource Type");
        this.m_ResTypeCombo = new Combo(dialogParent, 8);
        this.m_ResTypeCombo.setItems(this.m_ResTypes);
        this.m_ResTypeCombo.setText("");
        this.m_ResTypeCombo.select(0);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.m_ResTypeCombo.setLayoutData((Object)data);
        this.m_ResTypeCombo.addModifyListener((ModifyListener)new ResTypeModifyListener());
        Label label4 = new Label(dialogParent, 0);
        label4.setText("Resource Name");
        this.m_ResNameText = new Text(dialogParent, 2048);
        this.m_ResNameText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.m_ResNameText.setLayoutData((Object)data);
        this.m_ResNameText.addModifyListener((ModifyListener)new TextModifyListener(this.m_ResNameText));
        this.m_ResNameText.addFocusListener((FocusListener)new ResNameFocusListener());
        Label label5 = new Label(dialogParent, 0);
        label5.setText("Text");
        this.m_ResText = new Text(dialogParent, 2818);
        this.m_ResText.setText("");
        data = new GridData();
        data.heightHint = 45;
        data.horizontalAlignment = 4;
        this.m_ResText.setLayoutData((Object)data);
        this.m_ResText.addModifyListener((ModifyListener)new TextModifyListener(this.m_ResText));
        Composite composite = new Composite(dialogParent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Group group = new Group(composite, 0);
        group.setText("Maximum Length");
        group.setLayout((Layout)new GridLayout(2, false));
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        this.m_DefaultLengthButton = new Button((Composite)group, 32);
        this.m_DefaultLengthButton.setText("Use Default Length");
        this.m_DefaultLengthButton.addSelectionListener((SelectionListener)new DefaultLenSelectListener());
        this.m_MaxLengthText = new Text((Composite)group, 2048);
        this.m_MaxLengthText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.m_MaxLengthText.setLayoutData((Object)data);
        this.m_MaxLengthText.setEditable(true);
        this.m_MaxLengthText.addFocusListener((FocusListener)new MaxLenFocusListener());
        if (!this.m_IsNew) {
            this.fillDialog();
            this.m_DefaultLengthButton.setEnabled(true);
            this.setTitle("Edit Text Item");
        } else {
            this.m_MaxLengthText.setEditable(true);
            this.m_DefaultLengthButton.setSelection(true);
            this.m_MaxLengthText.setText(this.m_ResEditor.getSSXDocument().getMaxLength());
            this.m_MaxLengthText.setEditable(true);
            this.setTitle("New Text Item");
        }
        this.m_StatusLine = new StatusLineManager();
        this.m_StatusLine.createControl(parent);
        this.m_StatusLine.setMessage("");
        GridData gdata = new GridData(1808);
        gdata.grabExcessVerticalSpace = false;
        this.m_StatusLine.getControl().setLayoutData((Object)gdata);
        return dialogParent;
    }

    public void setResTypes(String[] strings) {
        this.m_ResTypes = strings;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ResNameFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent arg0) {
            ResourceTextDialog.this.setMessage("Enter the Resource Text. The name can contain a-z A-Z 0-9 _ and . and not more than 32 chars");
        }

        public void focusLost(FocusEvent arg0) {
        }
    }

    protected class DefaultLenSelectListener
    implements SelectionListener {
        private String mMaxLen;

        protected DefaultLenSelectListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ResourceTextDialog.this.m_DefaultLengthButton.getSelection()) {
                ResourceTextDialog.this.m_MaxLengthText.setEditable(false);
                this.mMaxLen = ResourceTextDialog.this.m_MaxLengthText.getText();
                ResourceTextDialog.this.m_MaxLengthText.setText(ResourceTextDialog.this.m_ResEditor.getSSXDocument().getMaxLength());
                ResourceTextDialog.this.m_ResText.setTextLimit(Integer.valueOf(ResourceTextDialog.this.m_ResEditor.getSSXDocument().getMaxLength()).intValue());
            } else {
                ResourceTextDialog.this.m_MaxLengthText.setEditable(true);
                ResourceTextDialog.this.m_MaxLengthText.setText(this.mMaxLen);
                ResourceTextDialog.this.m_ResText.setTextLimit(Text.LIMIT);
            }
        }
    }

    public class MaxLenFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent arg0) {
            try {
                RestypeValue restype = (RestypeValue)SSXEditorHelper.getResType(ResourceTextDialog.this.m_ResTypeCombo.getText());
                if (restype.getSAPInternalValue().charAt(0) == 'X') {
                    ResourceTextDialog.this.setMessage("This resource type can have a length of 16384 characters");
                } else {
                    Object str = null;
                    if (Integer.parseInt(ResourceTextDialog.this.m_MaxLengthText.getText()) > 0) {
                        ResourceTextDialog.this.setMessage("This resource type can have a length of " + ResourceTextDialog.this.m_ResEditor.getSSXDocument().getMaxLength());
                    } else {
                        ResourceTextDialog.this.setMessage("This resource type can have a length of " + ResourceTextDialog.this.m_MaxLengthText.getText());
                    }
                }
            }
            catch (RuntimeException e) {
                if (tracer.error()) {
                    tracer.error(e.getMessage());
                } else {
                    tracer.warning(e.getMessage());
                }
                ResourceTextDialog.this.setMessage("Enter the text");
            }
        }

        public void focusLost(FocusEvent arg0) {
            ResourceTextDialog.this.setMessage("Enter the text");
        }
    }

    public class ResTypeModifyListener
    implements ModifyListener {
        public void modifyText(ModifyEvent arg0) {
            try {
                RestypeValue restype = (RestypeValue)SSXEditorHelper.getResTypebyId(ResourceTextDialog.this.m_ResTypeCombo.getText());
                ResourceTextDialog.this.setMessage(restype.getDocumentation());
            }
            catch (RuntimeException e) {
                if (tracer.error()) {
                    tracer.error(e.getMessage());
                } else {
                    tracer.warning(e.getMessage());
                }
                ResourceTextDialog.this.setMessage("Enter the text");
            }
        }
    }

    public class TextModifyListener
    implements ModifyListener {
        Text mTextControl;

        public TextModifyListener(Text thisTextControl) {
            this.mTextControl = thisTextControl;
        }

        public void modifyText(ModifyEvent arg0) {
            if (null != this.mTextControl) {
                this.mTextControl.setToolTipText(Integer.toString(this.mTextControl.getCharCount()) + " characters");
            }
        }
    }
}

