/*
 * Decompiled with CFR 0.152.
 */
package com.sap.control.custom.tableview;

import com.sap.control.custom.tableview.sort.TableSorterListener;
import com.sap.ide.eclipse.s2x.editor.S2XEditorPlugin;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ToolbarTableView {
    static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$control$custom$tableview$ToolbarTableView == null ? (class$com$sap$control$custom$tableview$ToolbarTableView = ToolbarTableView.class$("com.sap.control.custom.tableview.ToolbarTableView")) : class$com$sap$control$custom$tableview$ToolbarTableView));
    private ViewerFilter m_filter;
    public static final int UI_TEXTCELLEDITOR = 1;
    public static final int UI_COMBOBOXCELLEDITOR = 2;
    public static final int UI_CHECKBOXCELLEDITOR = 3;
    public static final int UI_DIALOGCELLEDITOR = 4;
    public static final int UI_NOCELLEDITOR = 5;
    public static final int ACTION_ADD = 1;
    public static final int ACTION_EDIT = 2;
    public static final int ACTION_DELETE = 3;
    public static final int ACTIONSTATE_DISABLE = -1;
    public static final int ACTIONSTATE_HIDE = -2;
    private CellEditor[] m_ColEditors;
    private int[] m_ColEditorsInt;
    private int m_ColumnCount;
    private TableViewer m_TableViewer;
    private Table m_TableControl;
    private HashMap mComboData;
    private IContentProvider messageTableModel;
    private boolean mIsDirty;
    private ICellEditorListener[] m_cellEditorListener;
    private IBaseLabelProvider mLabelProvider;
    private IContentProvider mContentProvider;
    private Composite mParent;
    private IGridLayoutPane m_glp;
    private IAction mActionAddListener;
    private IAction mActionEditListener;
    private IAction mActionDeleteListener;
    private String[] mColumnHeaders;
    private ICellModifier mCellModifier;
    private ICellEditorValidator[] mCellValidators;
    private Button mDeleteButton;
    private Button mEditButton;
    private Button mAddButton;
    private TableSorterListener m_sorterListner;
    private HashMap m_additionalButtons;
    private MenuManager mMenuManager;
    private boolean tableEdit;
    static /* synthetic */ Class class$com$sap$control$custom$tableview$ToolbarTableView;

    public ToolbarTableView(Composite parent, int style) {
        this.mParent = parent;
        this.m_ColumnCount = 1;
        this.m_additionalButtons = new HashMap();
    }

    public ToolbarTableView(Composite parent, int style, int columns) {
        this.mParent = parent;
        this.m_ColumnCount = columns;
        this.m_additionalButtons = new HashMap();
    }

    private void addToolbarButtons(IGridLayoutPane glp, SelectionListener toolbarListener) {
        this.mAddButton = new Button(glp.getComposite(), 8);
        this.mAddButton.setData((Object)"AddMessage");
        this.mAddButton.setText("Add ");
        this.mAddButton.addSelectionListener(toolbarListener);
        GridData tabLayoutData = new GridData(34);
        tabLayoutData.horizontalAlignment = 4;
        tabLayoutData.verticalAlignment = 1;
        tabLayoutData.grabExcessHorizontalSpace = false;
        tabLayoutData.grabExcessVerticalSpace = false;
        this.mAddButton.setLayoutData((Object)tabLayoutData);
        this.mEditButton = new Button(glp.getComposite(), 8);
        this.mEditButton.setData((Object)"EditMessage");
        this.mEditButton.setText("Edit ");
        tabLayoutData = new GridData(34);
        tabLayoutData.horizontalAlignment = 4;
        tabLayoutData.verticalAlignment = 1;
        tabLayoutData.grabExcessHorizontalSpace = false;
        tabLayoutData.grabExcessVerticalSpace = false;
        this.mEditButton.setLayoutData((Object)tabLayoutData);
        this.mEditButton.addSelectionListener(toolbarListener);
        this.mDeleteButton = new Button(glp.getComposite(), 8);
        this.mDeleteButton.setData((Object)"DeleteMessage");
        this.mDeleteButton.setText("Delete ");
        this.mDeleteButton.setVisible(true);
        tabLayoutData = new GridData(34);
        tabLayoutData.horizontalAlignment = 4;
        tabLayoutData.verticalAlignment = 1;
        tabLayoutData.grabExcessHorizontalSpace = false;
        tabLayoutData.grabExcessVerticalSpace = false;
        this.mDeleteButton.setLayoutData((Object)tabLayoutData);
        this.mDeleteButton.addSelectionListener(toolbarListener);
    }

    private void setupCellEditors(TableViewer tableViewer) {
        this.m_TableViewer.setCellEditors(this.m_ColEditors);
        this.m_TableViewer.setCellModifier(this.mCellModifier);
    }

    private void createColumns(Table mMessageTableControl, SelectionListener toolbarListener) {
        SelectionListener headerListener = this.getTableSelectionListener();
        this.m_TableControl.setHeaderVisible(true);
        this.m_TableControl.removeAll();
        TableColumn tc = new TableColumn(this.m_TableControl, 0, 0);
        tc.setResizable(true);
        tc.setText("Message Key");
        tc.addSelectionListener(headerListener);
        tc = new TableColumn(this.m_TableControl, 0, 1);
        tc.setResizable(true);
        tc.setText("Message Type");
        tc.addSelectionListener(headerListener);
        tc = new TableColumn(this.m_TableControl, 0, 2);
        tc.setResizable(true);
        tc.setText("Message text");
        tc.addSelectionListener(headerListener);
        ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(75), new ColumnWeightData(75), new ColumnWeightData(175)};
        TableLayout l = new TableLayout();
        int i = 0;
        while (i < columnLayouts.length) {
            l.addColumnData(columnLayouts[i]);
            ++i;
        }
        this.m_TableControl.setLayout((Layout)l);
    }

    private void setCellEditors() {
        if (null != this.m_ColEditorsInt) {
            if (null == this.mCellModifier) {
                this.mCellModifier = new ICellModifier(){

                    public boolean canModify(Object arg0, String arg1) {
                        ServicesUI.logMessage((String)"inside canModify", (Plugin)S2XEditorPlugin.getDefault());
                        return true;
                    }

                    public Object getValue(Object arg0, String arg1) {
                        return " ";
                    }

                    public void modify(Object arg0, String arg1, Object arg2) {
                    }
                };
            }
            CellEditor[] editors = null;
            if (this.m_ColEditorsInt.length > 0) {
                editors = new CellEditor[this.m_ColEditorsInt.length];
                int i = 0;
                while (i < this.m_ColEditorsInt.length) {
                    switch (this.m_ColEditorsInt[i]) {
                        case 3: {
                            editors[i] = new CheckboxCellEditor((Composite)this.m_TableControl);
                            break;
                        }
                        case 1: {
                            editors[i] = new TextCellEditor((Composite)this.m_TableControl);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 2: {
                            String[] comboText = null;
                            if (null != this.mComboData) {
                                List stringList = (List)this.mComboData.get(new Integer(i));
                                if (null != stringList) {
                                    comboText = (String[])stringList.toArray();
                                }
                            } else {
                                comboText = new String[]{"Combo list is not set."};
                            }
                            editors[i] = new ComboBoxCellEditor((Composite)this.m_TableControl, comboText);
                            break;
                        }
                        case 5: {
                            editors[i] = null;
                            break;
                        }
                    }
                    if (this.mCellValidators != null && null != this.mCellValidators[i] && null != editors[i]) {
                        editors[i].setValidator(this.mCellValidators[i]);
                    }
                    if (null != this.m_cellEditorListener && null != this.m_cellEditorListener[i]) {
                        editors[i].addListener(this.m_cellEditorListener[i]);
                    }
                    ++i;
                }
                this.m_TableViewer.setCellModifier(this.mCellModifier);
            }
            if (null != this.mColumnHeaders) {
                this.m_TableViewer.setColumnProperties(this.mColumnHeaders);
            }
            this.m_TableViewer.setCellEditors(editors);
        }
    }

    protected void initControl(Object data) {
        SelectionListener toolbarListener = null;
        this.m_glp = PaneFactory.createGridLayoutPane((Composite)this.mParent, (int)0);
        GridLayout layout = new GridLayout(2, false);
        this.m_glp.getComposite().setLayout((Layout)layout);
        String[] ele = new String[]{"First", "Second", "Third"};
        this.m_TableViewer = this.m_glp.addTableViewer(true);
        this.m_TableControl = this.m_TableViewer.getTable();
        this.m_TableControl.addSelectionListener(this.getTableSelectionListener());
        GridData tabLayoutData = new GridData(1536);
        tabLayoutData.horizontalAlignment = 4;
        tabLayoutData.verticalAlignment = 4;
        tabLayoutData.verticalSpan = 5;
        this.m_TableControl.setLayoutData((Object)tabLayoutData);
        this.m_TableViewer.setContentProvider(this.mContentProvider);
        this.m_TableViewer.setLabelProvider(this.mLabelProvider);
        this.addColumns();
        toolbarListener = this.getToolbarListener();
        this.setCellEditors();
        this.addToolbarButtons(this.m_glp, toolbarListener);
        this.addContextMenu();
    }

    protected void addContextMenu() {
        this.mMenuManager = new MenuManager("#PopupMenu");
        this.mMenuManager.setRemoveAllWhenShown(false);
        Menu menu = this.mMenuManager.createContextMenu((Control)this.m_TableControl);
        this.mMenuManager.add((IAction)new AddAction());
        this.mMenuManager.add((IContributionItem)new Separator());
        this.mMenuManager.add((IAction)new EditAction());
        this.mMenuManager.add((IContributionItem)new Separator());
        this.mMenuManager.add((IAction)new DeleteAction());
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
            }
        });
        this.m_TableControl.setMenu(menu);
    }

    protected void addColumns() {
        this.m_TableControl.setHeaderVisible(true);
        this.m_TableControl.removeAll();
        ColumnLayoutData[] columnLayouts = new ColumnLayoutData[this.m_ColumnCount];
        boolean noHeaders = true;
        if (null != this.mColumnHeaders && this.mColumnHeaders.length >= this.m_ColumnCount) {
            noHeaders = false;
        }
        int i = 0;
        while (i < this.m_ColumnCount) {
            TableColumn tc = new TableColumn(this.m_TableControl, 0, 0);
            tc.setResizable(true);
            if (noHeaders) {
                tc.setText("Column " + Integer.toString(i));
            } else {
                tc.setText(this.mColumnHeaders[this.mColumnHeaders.length - i - 1]);
                tc.setData((Object)this.mColumnHeaders[this.mColumnHeaders.length - i - 1]);
            }
            columnLayouts[i] = new ColumnWeightData(100);
            tc.addSelectionListener((SelectionListener)new TableColumnSelectionListener());
            ++i;
        }
        TableLayout l = new TableLayout();
        int i2 = 0;
        while (i2 < columnLayouts.length) {
            l.addColumnData(columnLayouts[i2]);
            ++i2;
        }
        this.m_TableControl.setLayout((Layout)l);
        SelectionListener selectLisener = this.getTableSelectionListener();
        this.m_TableControl.addSelectionListener(selectLisener);
    }

    protected SelectionListener getToolbarListener() {
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("AddMessage" == e.widget.getData()) {
                    TableItem[] item = ToolbarTableView.this.m_TableControl.getSelection();
                    ToolbarTableView.this.onAddClick();
                }
                if ("EditMessage" == e.widget.getData()) {
                    ToolbarTableView.this.onEditClick();
                }
                if ("DeleteMessage" == e.widget.getData()) {
                    ToolbarTableView.this.onDeleteClick();
                }
            }
        };
        return headerListener;
    }

    private void onDeleteClick() {
        if (null != this.mActionDeleteListener) {
            this.mActionDeleteListener.run();
        }
    }

    private void onEditClick() {
        if (null != this.mActionEditListener) {
            this.mActionEditListener.run();
        }
    }

    private void onAddClick() {
        if (null != this.mActionAddListener) {
            this.mActionAddListener.run();
            this.m_TableViewer.refresh();
        }
    }

    protected SelectionListener getTableSelectionListener() {
        SelectionAdapter tabListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                ToolbarTableView.this.mAddButton.setEnabled(true);
                ISelection selection = null;
                selection = ToolbarTableView.this.m_TableViewer.getSelection();
                int[] name = new int[]{1, 2};
                if (selection.isEmpty()) {
                    ToolbarTableView.this.setCommandStates(2, name, false);
                    ToolbarTableView.this.setCommandStates(3, name, false);
                } else {
                    if (ToolbarTableView.this.m_TableControl.getSelectionCount() == 1) {
                        ToolbarTableView.this.setCommandStates(2, name, true);
                    } else {
                        ToolbarTableView.this.setCommandStates(2, name, false);
                    }
                    ToolbarTableView.this.setCommandStates(3, name, true);
                }
            }
        };
        return tabListener;
    }

    public void setCommandStates(int cmdID, int[] states, boolean b) {
        MenuItem item = null;
        Button btn = null;
        switch (cmdID) {
            case 1: {
                if (this.mMenuManager.getMenu().getItemCount() > 0) {
                    item = this.mMenuManager.getMenu().getItem(0);
                }
                btn = this.mAddButton;
                break;
            }
            case 2: {
                if (this.mMenuManager.getMenu().getItemCount() >= 2) {
                    item = this.mMenuManager.getMenu().getItem(2);
                }
                btn = this.mEditButton;
                break;
            }
            case 3: {
                if (this.mMenuManager.getMenu().getItemCount() >= 4) {
                    item = this.mMenuManager.getMenu().getItem(4);
                }
                btn = this.mDeleteButton;
                break;
            }
        }
        if (null != btn) {
            btn.setEnabled(b);
        }
        if (null != item) {
            item.setEnabled(b);
        }
    }

    public Control addToolAction(IAction action, Image toolImage, String toolText, String toolTip, int params) {
        GridData tabLayoutData = null;
        if (0 == params) {
            params = 8;
        }
        Button button = new Button(this.m_glp.getComposite(), params);
        button.setText(toolText);
        button.setToolTipText(toolTip);
        button.setImage(toolImage);
        tabLayoutData = new GridData(0);
        tabLayoutData.horizontalAlignment = 4;
        tabLayoutData.verticalAlignment = 1;
        tabLayoutData.grabExcessHorizontalSpace = false;
        tabLayoutData.grabExcessVerticalSpace = false;
        button.setLayoutData((Object)tabLayoutData);
        button.addSelectionListener((SelectionListener)new GenericButtonListener());
        this.m_additionalButtons.put(button, action);
        return button;
    }

    public void setDirty(boolean b) {
        this.mIsDirty = b;
    }

    public boolean isDirty() {
        return this.mIsDirty;
    }

    public void setTableMode(IContentProvider provider) {
        this.mContentProvider = provider;
    }

    public void setLabeProvider(IBaseLabelProvider labelProvider) {
        this.mLabelProvider = labelProvider;
    }

    public void setColumnCount(int columns) {
        this.m_ColumnCount = columns;
    }

    public void setColumnEditors(int[] editors) {
        this.m_ColEditorsInt = editors;
    }

    public void setInput(Object data) {
        try {
            this.initControl(data);
            this.m_TableViewer.setInput(data);
        }
        catch (RuntimeException e) {
            if (tracer.error()) {
                tracer.error(e.getMessage());
            }
            tracer.warning(e.getMessage());
        }
    }

    public void setActionState(int toolID, int state) {
        if (-1 == state) {
            this.setCommandStates(toolID, null, false);
        } else {
            this.setCommandStates(toolID, null, true);
        }
    }

    public void setStyle(int style) {
    }

    public void setComboData(int columnIndex, String[] comboData) {
        List<String> stringList = Arrays.asList(comboData);
        if (null == this.mComboData) {
            this.mComboData = new HashMap(5);
        }
        if (this.mComboData.containsKey(new Integer(columnIndex))) {
            this.mComboData.remove(new Integer(columnIndex));
        }
        this.mComboData.put(new Integer(columnIndex), stringList);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.mCellModifier = modifier;
        if (null != this.m_TableViewer) {
            this.m_TableViewer.setCellModifier(modifier);
        }
    }

    public void setCellEditorListener(ICellEditorListener[] cellEditorListener) {
        this.m_cellEditorListener = cellEditorListener;
    }

    public void addActionListener(int actionID, IAction action) {
        switch (actionID) {
            case 1: {
                this.mActionAddListener = action;
                break;
            }
            case 2: {
                this.mActionEditListener = action;
                break;
            }
            case 3: {
                this.mActionDeleteListener = action;
                break;
            }
        }
    }

    public void setColumnHeaders(String[] p) {
        this.mColumnHeaders = p;
    }

    public void setCellValidator(ICellEditorValidator[] validators) {
        this.mCellValidators = validators;
    }

    public Object[] getTableSelection() {
        TableItem[] items = this.m_TableControl.getSelection();
        Object[] texts = new Object[items.length];
        int i = 0;
        while (i < items.length) {
            Object text;
            texts[i] = text = items[i].getData();
            ++i;
        }
        return texts;
    }

    public void refreshTable() {
        this.m_TableViewer.refresh();
    }

    public void setTableEdit(boolean b) {
        this.tableEdit = b;
        if (!b) {
            this.setCellModifier(null);
        } else {
            this.setCellModifier(this.mCellModifier);
        }
    }

    public void setFilter(ViewerFilter filter) {
        if (null != filter) {
            this.m_TableViewer.removeFilter(filter);
            this.m_TableViewer.addFilter(filter);
            this.m_filter = filter;
        } else {
            this.m_TableViewer.removeFilter(this.m_filter);
        }
    }

    public void setSorterListener(TableSorterListener sorterListener) {
        this.m_sorterListner = sorterListener;
    }

    public void setSorter(ViewerSorter sorter) {
        this.m_TableViewer.setSorter(sorter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TableColumnSelectionListener
    implements SelectionListener {
        private String m_lastColumn;

        private TableColumnSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.getSource();
            if (null != this.m_lastColumn && this.m_lastColumn.equals((String)column.getData())) {
                ToolbarTableView.this.m_sorterListner.setSortDirection(0);
            }
            this.m_lastColumn = (String)column.getData();
            ToolbarTableView.this.m_sorterListner.setSortColumn((String)column.getData());
            ToolbarTableView.this.m_sorterListner.sort();
        }
    }

    private class GenericButtonListener
    implements SelectionListener {
        private GenericButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent event) {
            IAction action = (IAction)ToolbarTableView.this.m_additionalButtons.get(event.getSource());
            action.run();
        }
    }

    public class DeleteAction
    extends Action {
        public void run() {
            ToolbarTableView.this.onDeleteClick();
        }

        public String getText() {
            String text = "";
            if (null != ToolbarTableView.this.mActionDeleteListener) {
                text = ToolbarTableView.this.mActionDeleteListener.getText();
            }
            if (text == "" || text == null) {
                return "Delete";
            }
            return text;
        }

        public void runWithEvent(Event event) {
            if (null != ToolbarTableView.this.mActionDeleteListener) {
                ToolbarTableView.this.mActionDeleteListener.runWithEvent(event);
            }
        }
    }

    public class EditAction
    extends Action {
        public void run() {
            ToolbarTableView.this.onEditClick();
        }

        public String getText() {
            String text = "";
            if (null != ToolbarTableView.this.mActionEditListener) {
                text = ToolbarTableView.this.mActionEditListener.getText();
            }
            if (text == "" || text == null) {
                return "Edit";
            }
            return text;
        }

        public void runWithEvent(Event event) {
            if (null != ToolbarTableView.this.mActionEditListener) {
                ToolbarTableView.this.mActionEditListener.runWithEvent(event);
            }
        }
    }

    public class AddAction
    extends Action {
        public void run() {
            ToolbarTableView.this.onAddClick();
        }

        public String getText() {
            String text = "";
            if (null != ToolbarTableView.this.mActionAddListener) {
                text = ToolbarTableView.this.mActionAddListener.getText();
            }
            if (text == "" || text == null) {
                return "Add";
            }
            return text;
        }

        public void runWithEvent(Event event) {
            if (null != ToolbarTableView.this.mActionAddListener) {
                ToolbarTableView.this.mActionAddListener.runWithEvent(event);
            }
        }
    }

    public class CellEditorListener
    implements ICellEditorListener {
        public void applyEditorValue() {
            ServicesUI.logMessage((String)"applyEditorValue", (Plugin)S2XEditorPlugin.getDefault());
        }

        public void cancelEditor() {
            ServicesUI.logMessage((String)"cancelEditor", (Plugin)S2XEditorPlugin.getDefault());
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            ServicesUI.logMessage((String)"editorValueChanged", (Plugin)S2XEditorPlugin.getDefault());
        }
    }
}

