/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sql.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseConstantNode;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseElementNode;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseFeatureNode;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseNodeFactory;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBIParseOperation;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIDefaultDatabaseMetaData;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIParseConstantNode;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIParseElementNode;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIParseFeatureNode;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BIParseOperation;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Map;

public class BIDefaultParseNodeFactory
implements IBIParseNodeFactory {
    private final BIParseConstantNode constantNodeParser;
    private final BIParseElementNode elementNodeParser;
    private final BIParseFeatureNode featureNodeParser;
    private final BIParseOperation operationParser;
    private final DatabaseMetaData meta;
    private Map symbolTable = new HashMap();
    protected IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    public BIDefaultParseNodeFactory(IBIConnectionInfo connectionInfo) throws BIResourceException {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
        this.meta = new BIDefaultDatabaseMetaData(connectionInfo);
        this.constantNodeParser = new BIParseConstantNode(connectionInfo, this);
        this.elementNodeParser = new BIParseElementNode(connectionInfo, this);
        this.featureNodeParser = new BIParseFeatureNode(connectionInfo, this);
        this.operationParser = new BIParseOperation(connectionInfo, this);
    }

    public BIDefaultParseNodeFactory(IBIConnectionInfo connectionInfo, DatabaseMetaData meta) throws BIResourceException {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
        if (meta == null) {
            throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.connector.rel_3000");
        }
        this.meta = meta;
        this.constantNodeParser = new BIParseConstantNode(connectionInfo, this);
        this.elementNodeParser = new BIParseElementNode(connectionInfo, this);
        this.featureNodeParser = new BIParseFeatureNode(connectionInfo, this);
        this.operationParser = new BIParseOperation(connectionInfo, this);
    }

    public IBIParseConstantNode createParseConstantNode() throws BIResourceException {
        return this.constantNodeParser;
    }

    public IBIParseElementNode createParseElementNode() throws BIResourceException {
        return this.elementNodeParser;
    }

    public IBIParseFeatureNode createParseFeatureNode() throws BIResourceException {
        return this.featureNodeParser;
    }

    public IBIParseOperation createParseOperation() throws BIResourceException {
        return this.operationParser;
    }

    public Map getSymbolTable() {
        return this.symbolTable;
    }

    public void setSymbolTable(Map symbolTable) {
        this.symbolTable = symbolTable == null ? new HashMap() : symbolTable;
    }

    public DatabaseMetaData getMetaData() {
        return this.meta;
    }
}

