/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.sapq.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.relational.BIRelationalMetaDataConstants;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpression;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionOrderByRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionSelectColumnRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionTableRef;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.IBISapqQueryCall;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.IBISapqSelectOption;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.IBISapqSortField;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.impl.BISapqQueryCall;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.impl.BISapqSelectOption;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLComparisonOperator;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLKeyword;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BISQLComparisonOperator;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTree;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnValueNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeNotNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTree;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeAndNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeColumnValueNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeNotNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTreeOrNode;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.omg.cwm.foundation.expressions.ConstantNode;
import org.omg.cwm.foundation.expressions.ElementNode;
import org.omg.cwm.foundation.expressions.ExpressionNode;
import org.omg.cwm.foundation.expressions.FeatureNode;
import org.omg.cwm.objectmodel.core.CorePackage;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.objectmodel.core.TaggedElement;
import org.omg.cwm.objectmodel.core.TaggedValue;
import org.omg.cwm.resource.relational.Column;
import org.omg.cwm.resource.relational.Table;

public class BIParseQueryExpression {
    private IBIQuery query = null;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;
    private static final boolean INCLUDING = true;
    private static final boolean EXCLUDING = false;
    private static final boolean NEGATE = true;
    private static final boolean DONT_NEGATE = false;

    public BIParseQueryExpression(IBIQuery query, IBIConnectionInfo connectionInfo) throws BIResourceException {
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
        if (query == null || query.getExpression() == null) {
            throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.rel.query_1015");
        }
        this.query = query;
    }

    public IBIQuery getQuery() {
        return this.query;
    }

    public IBISapqQueryCall parse() throws BIResourceException {
        if (this.query == null) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1015");
        }
        if (this.query.getExpression() instanceof FeatureNode) {
            return this.parseQueryExpression((FeatureNode)this.query.getExpression());
        }
        if (this.query.getExpression() instanceof IBIQueryExpression) {
            return this.parseQueryExpression((IBIQueryExpression)this.query.getExpression());
        }
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1014");
    }

    private IBISapqQueryCall parseQueryExpression(IBIQueryExpression expr) throws BIResourceException {
        List fields = this.parseSelectClause(expr);
        String funcArea = this.parseFromClause(expr);
        List sortFields = this.parseOrderByClause(expr);
        IBISapqSelectOption[] selectTable = this.parseWhereClause(expr);
        BISapqQueryCall c = new BISapqQueryCall(funcArea);
        ArrayList selectFields = new ArrayList();
        c.setFields(fields);
        c.setSelectFields(selectFields);
        c.setSelectTable(selectTable);
        c.setSortFields(sortFields);
        return c;
    }

    private List parseSelectClause(IBIQueryExpression expr) throws BIResourceException {
        TaggedElement element = ((CorePackage)((IBIQueryExpressionTableRef)expr.getTableRef().get(0)).getTable().refOutermostPackage().refPackage("org.omg.cwm.objectmodel.Core")).getTaggedElement();
        List colRef = expr.getColumnRef();
        if (colRef != null) {
            ArrayList<String> selectFields = new ArrayList<String>();
            Iterator i = colRef.iterator();
            while (i.hasNext()) {
                IBIQueryExpressionSelectColumnRef c = (IBIQueryExpressionSelectColumnRef)i.next();
                if (c.getAggr() != null) {
                    throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1005", new Object[]{c.getAggr()});
                }
                boolean add = true;
                Iterator t = element.getTaggedValue((ModelElement)c.getColumn()).iterator();
                while (t.hasNext()) {
                    TaggedValue tv = (TaggedValue)t.next();
                    if (!BIRelationalMetaDataConstants.COLUMN_DISPLAY_TAG.toString().equals(tv.getTag()) || !BIRelationalMetaDataConstants.SELECT_ONLY.toString().equals(tv.getValue())) continue;
                    add = false;
                }
                if (!add) continue;
                selectFields.add(c.getColumn().getName());
            }
            return selectFields;
        }
        return Collections.EMPTY_LIST;
    }

    private String parseFromClause(IBIQueryExpression expr) throws BIResourceException {
        if (expr.getTableRef() != null && expr.getTableRef().size() == 1) {
            IBIQueryExpressionTableRef t = (IBIQueryExpressionTableRef)expr.getTableRef().get(0);
            return t.getTable().getName();
        }
        return null;
    }

    private List parseOrderByClause(IBIQueryExpression expr) throws BIResourceException {
        List orderRef = expr.getOrderByRef();
        if (orderRef != null) {
            ArrayList<SortField> orderByFields = new ArrayList<SortField>();
            Iterator i = orderRef.iterator();
            while (i.hasNext()) {
                IBIQueryExpressionOrderByRef o = (IBIQueryExpressionOrderByRef)i.next();
                SortField s = new SortField(o.getColumn().getName(), o.isAscending());
                orderByFields.add(s);
            }
            return orderByFields;
        }
        return Collections.EMPTY_LIST;
    }

    private IBISapqSelectOption[] parseWhereClause(IBIQueryExpression expr) throws BIResourceException {
        IBIWhereTree tree = expr.getWhereTree();
        if (tree != null && tree.getRoot() == null) {
            tree.popRoot();
        }
        if (tree != null && tree.getRoot() != null) {
            return this.parseWhereClause(tree);
        }
        IBIQueryExpressionSelectColumnRef cref = (IBIQueryExpressionSelectColumnRef)expr.getColumnRef().get(0);
        if (cref == null) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1004");
        }
        IBISapqSelectOption[] sel = new BISapqSelectOption[]{new BISapqSelectOption(this.connectionInfo, cref.getColumn(), IBISapqSelectOption.Kind.SELECT_OPTION, IBISapqSelectOption.Sign.INCLUDING, IBISapqSelectOption.Option.CONTAINS_PATTERN, "*", null)};
        return sel;
    }

    private IBISapqQueryCall parseQueryExpression(FeatureNode expr) throws BIResourceException {
        this.assertOperation(expr, IBISQLKeyword._ROOT);
        List args = expr.getArgument();
        this.assertArgumentListSize(expr, 2, -1);
        BISapqQueryCall s = new BISapqQueryCall();
        Iterator i = args.iterator();
        while (i.hasNext()) {
            FeatureNode arg = (FeatureNode)i.next();
            if (this.equalsFunction(arg, IBISQLKeyword.SELECT)) {
                List fields = this.parseSelectClause(arg.getArgument());
                s.setFields(fields);
                continue;
            }
            if (this.equalsFunction(arg, IBISQLKeyword.FROM)) {
                this.assertArgumentListSize(arg, 1, 1);
                Table tab = this.parseFromClause(arg.getArgument());
                s.setFuncArea(tab.getName());
                continue;
            }
            if (this.equalsFunction(arg, IBISQLKeyword.WHERE)) {
                this.assertArgumentListSize(arg, 1, 1);
                IBISapqSelectOption[] selectOption = this.parseWhereClause(arg.getArgument());
                s.setSelectTable(selectOption);
                continue;
            }
            if (this.equalsFunction(arg, IBISQLKeyword.GROUP_BY)) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
            }
            if (this.equalsFunction(arg, IBISQLKeyword.ORDER_BY)) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
            }
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
        }
        return s;
    }

    private List parseSelectClause(List argList) throws BIResourceException {
        ArrayList<String> cols = new ArrayList<String>();
        Iterator i = argList.iterator();
        while (i.hasNext()) {
            ExpressionNode node = (ExpressionNode)i.next();
            if (node instanceof ElementNode) {
                cols.add(((ElementNode)node).getModelElement().getName());
                continue;
            }
            if (node instanceof FeatureNode) {
                this.assertOperation((FeatureNode)node, IBISQLKeyword._REF);
                this.assertArgumentListSize((FeatureNode)node, 2, 2);
                cols.add(((ElementNode)((FeatureNode)node).getArgument().get(1)).getModelElement().getName());
                continue;
            }
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
        }
        return cols;
    }

    private Table parseFromClause(List argList) throws BIResourceException {
        Table table = null;
        Iterator i = argList.iterator();
        while (i.hasNext()) {
            ExpressionNode node = (ExpressionNode)i.next();
            if (node instanceof ElementNode) {
                table = (Table)((ElementNode)node).getModelElement();
                continue;
            }
            if (node instanceof FeatureNode) {
                this.assertOperation((FeatureNode)node, IBISQLKeyword._ALIAS);
                this.assertArgumentListSize((FeatureNode)node, 2, 2);
                table = (Table)((ElementNode)((FeatureNode)node).getArgument().get(0)).getModelElement();
                continue;
            }
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
        }
        return table;
    }

    private IBISapqSelectOption[] parseWhereClause(List argList) throws BIResourceException {
        FeatureNode where = (FeatureNode)argList.get(0);
        BIWhereTree tree = new BIWhereTree();
        this.assertArgumentListSize(where, 1, 1);
        tree.setRoot(this.parseWhereTreeNode(where));
        return this.parseWhereClause(tree);
    }

    private IBISapqSelectOption[] parseWhereClause(IBIWhereTree tree) throws BIResourceException {
        tree.normalize();
        if (!tree.isInSelectOptions()) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
        }
        List pred = tree.getPredicateList();
        ArrayList<IBISapqSelectOption> s = new ArrayList<IBISapqSelectOption>();
        Iterator i = pred.iterator();
        while (i.hasNext()) {
            Set p = (Set)i.next();
            if (p != null && p.size() > 0) {
                if (p.size() > 1) {
                    s.addAll(this.parseWhereSelectIncluding(p));
                    continue;
                }
                s.add(this.parseWhereSelectExcluding((IBIWhereTreeNode)p.toArray()[0]));
                continue;
            }
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
        }
        return s.toArray(new IBISapqSelectOption[0]);
    }

    private List parseWhereSelectIncluding(Set nodes) throws BIResourceException {
        ArrayList<IBISapqSelectOption> s = new ArrayList<IBISapqSelectOption>();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            s.add(this.parseWhereTreeValueNode((IBIWhereTreeColumnValueNode)i.next(), true));
        }
        return s;
    }

    private IBISapqSelectOption parseWhereSelectExcluding(IBIWhereTreeNode node) throws BIResourceException {
        return this.parseWhereTreeValueNode(node, false);
    }

    private IBISapqSelectOption parseWhereTreeValueNode(IBIWhereTreeNode node, boolean including) throws BIResourceException {
        if (node instanceof IBIWhereTreeNotNode) {
            return this.parseWhereTreeValueNode((IBIWhereTreeColumnValueNode)((IBIWhereTreeNotNode)node).getChild(), including, true);
        }
        if (node instanceof IBIWhereTreeColumnValueNode) {
            return this.parseWhereTreeValueNode((IBIWhereTreeColumnValueNode)node, including, false);
        }
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
    }

    private IBISapqSelectOption parseWhereTreeValueNode(IBIWhereTreeColumnValueNode node, boolean including) throws BIResourceException {
        return this.parseWhereTreeValueNode(node, including, false);
    }

    private IBISapqSelectOption parseWhereTreeValueNode(IBIWhereTreeColumnValueNode node, boolean including, boolean negated) throws BIResourceException {
        Column column = node.getColumn();
        IBISapqSelectOption.Option option = this.sqlComparisonToSelectOption(node.getOper(), !(including ^ negated));
        IBISapqSelectOption.Sign sign = null;
        sign = including ? IBISapqSelectOption.Sign.INCLUDING : IBISapqSelectOption.Sign.EXCLUDING;
        String low = null;
        String high = null;
        if (node.getValue() != null) {
            if (node.getValue().length == 1) {
                low = node.getValue()[0].toString();
            } else if (node.getValue().length == 2) {
                low = node.getValue()[0].toString();
                high = node.getValue()[1].toString();
            } else {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1012", new Object[]{"1/2", new Integer(node.getValue().length)});
            }
        }
        if (option == IBISapqSelectOption.Option.CONTAINS_PATTERN || option == IBISapqSelectOption.Option.NOT_CONTAINS_PATTERN) {
            low = BISapqSelectOption.replaceSQLSpecialChars(low);
        }
        BISapqSelectOption sel = new BISapqSelectOption(this.connectionInfo, column, IBISapqSelectOption.Kind.SELECT_OPTION, sign, option, low, high);
        return sel;
    }

    private IBIWhereTreeNode parseWhereTreeNode(FeatureNode where) throws BIResourceException {
        if (this.isOperation(where, IBISQLKeyword.AND)) {
            return this.parseWhereLogicalNode(where);
        }
        if (this.isOperation(where, IBISQLKeyword.OR)) {
            return this.parseWhereLogicalNode(where);
        }
        if (this.isOperation(where, IBISQLKeyword.NOT)) {
            return this.parseWhereLogicalNode(where);
        }
        if (this.isOperation(where, IBISQLKeyword.BETWEEN) || this.isOperation(where, IBISQLKeyword.EQUALS) || this.isOperation(where, IBISQLKeyword.GREATER_EQUALS) || this.isOperation(where, IBISQLKeyword.GREATER_THAN) || this.isOperation(where, IBISQLKeyword.LESS_EQUALS) || this.isOperation(where, IBISQLKeyword.LESS_THAN) || this.isOperation(where, IBISQLKeyword.LIKE) || this.isOperation(where, IBISQLKeyword.NOT_EQUALS)) {
            return this.parseWhereColumnValueNode(where);
        }
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
    }

    private IBIWhereTreeColumnValueNode parseWhereColumnValueNode(FeatureNode where) throws BIResourceException {
        Column column = null;
        this.assertArgumentListSize(where, 2, 3);
        ExpressionNode node = (ExpressionNode)where.getArgument().get(0);
        if (node == null) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
        }
        if (node instanceof FeatureNode) {
            this.assertOperation((FeatureNode)node, IBISQLKeyword._REF);
            this.assertArgumentListSize((FeatureNode)node, 2, 2);
            column = (Column)((ElementNode)((FeatureNode)node).getArgument().get(1)).getModelElement();
        } else if (node instanceof ElementNode) {
            column = (Column)((ElementNode)node).getModelElement();
        }
        if (this.isOperation(where, IBISQLKeyword.BETWEEN)) {
            this.assertArgumentListSize(where, 3, 3);
            ConstantNode low = (ConstantNode)where.getArgument().get(1);
            ConstantNode high = (ConstantNode)where.getArgument().get(2);
            if (low == null || high == null) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
            }
            return new BIWhereTreeColumnValueNode(column, IBISQLComparisonOperator.BETWEEN, low.getValue(), high.getValue());
        }
        this.assertArgumentListSize(where, 2, 2);
        ConstantNode value = (ConstantNode)where.getArgument().get(1);
        return new BIWhereTreeColumnValueNode(column, BISQLComparisonOperator.get(where.getFeature().getName()), value.getValue());
    }

    private IBIWhereTreeNode parseWhereLogicalNode(FeatureNode where) throws BIResourceException {
        if (this.isOperation(where, IBISQLKeyword.AND)) {
            this.assertArgumentListSize(where, 2, 2);
            IBIWhereTreeNode left = this.parseWhereTreeNode((FeatureNode)where.getArgument().get(0));
            IBIWhereTreeNode right = this.parseWhereTreeNode((FeatureNode)where.getArgument().get(0));
            return new BIWhereTreeAndNode(left, right);
        }
        if (this.isOperation(where, IBISQLKeyword.OR)) {
            this.assertArgumentListSize(where, 2, 2);
            IBIWhereTreeNode left = this.parseWhereTreeNode((FeatureNode)where.getArgument().get(0));
            IBIWhereTreeNode right = this.parseWhereTreeNode((FeatureNode)where.getArgument().get(0));
            return new BIWhereTreeOrNode(left, right);
        }
        this.assertArgumentListSize(where, 1, 1);
        IBIWhereTreeNode child = this.parseWhereTreeNode((FeatureNode)where.getArgument().get(0));
        return new BIWhereTreeNotNode(child);
    }

    private boolean equalsFunction(FeatureNode node, IBISQLKeyword oper) {
        return node != null && node.getFeature() != null && oper.toString().equals(node.getFeature().getName());
    }

    private void assertArgumentListSize(FeatureNode node, int min, int max) throws BIResourceException {
        if (node == null || node.getArgument() == null) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
        }
        if (min < 0 && max < 0 ? node.getArgument().size() >= -min && node.getArgument().size() <= -max : (min < 0 && max >= 0 ? node.getArgument().size() < 0 || node.getArgument().size() > max : (min >= 0 && max >= 0 ? node.getArgument().size() < min || node.getArgument().size() > max : min >= 0 && max < 0 && node.getArgument().size() < min))) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
        }
    }

    private void assertOperation(FeatureNode node, IBISQLKeyword oper) throws BIResourceException {
        if (!this.isOperation(node, oper)) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
        }
    }

    private boolean isOperation(FeatureNode node, IBISQLKeyword oper) throws BIResourceException {
        return oper != null && node != null && node.getFeature() != null && oper.toString().equals(node.getFeature().getName());
    }

    private IBISapqSelectOption.Option sqlComparisonToSelectOption(IBISQLComparisonOperator oper) throws BIResourceException {
        return this.sqlComparisonToSelectOption(oper, false);
    }

    private IBISapqSelectOption.Option sqlComparisonToSelectOption(IBISQLComparisonOperator oper, boolean negate) throws BIResourceException {
        IBISapqSelectOption.Option option = null;
        if (IBISQLComparisonOperator.BETWEEN.equals(oper)) {
            option = !negate ? IBISapqSelectOption.Option.BETWEEN : IBISapqSelectOption.Option.NOT_BETWEEN;
        } else if (IBISQLComparisonOperator.EQUALS.equals(oper)) {
            option = !negate ? IBISapqSelectOption.Option.EQUALS : IBISapqSelectOption.Option.NOT_EQUALS;
        } else if (IBISQLComparisonOperator.GREATER_EQUALS.equals(oper)) {
            option = !negate ? IBISapqSelectOption.Option.GREATER_EQUALS : IBISapqSelectOption.Option.LESS_THAN;
        } else if (IBISQLComparisonOperator.GREATER_THAN.equals(oper)) {
            option = !negate ? IBISapqSelectOption.Option.GREATER_THAN : IBISapqSelectOption.Option.LESS_EQUALS;
        } else {
            if (IBISQLComparisonOperator.IN.equals(oper)) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1028", new Object[]{oper});
            }
            if (IBISQLComparisonOperator.IS_NULL.equals(oper)) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1028", new Object[]{oper});
            }
            if (IBISQLComparisonOperator.LESS_EQUALS.equals(oper)) {
                option = !negate ? IBISapqSelectOption.Option.LESS_EQUALS : IBISapqSelectOption.Option.GREATER_THAN;
            } else if (IBISQLComparisonOperator.LESS_THAN.equals(oper)) {
                option = !negate ? IBISapqSelectOption.Option.LESS_THAN : IBISapqSelectOption.Option.GREATER_EQUALS;
            } else if (IBISQLComparisonOperator.LIKE.equals(oper)) {
                option = !negate ? IBISapqSelectOption.Option.CONTAINS_PATTERN : IBISapqSelectOption.Option.NOT_CONTAINS_PATTERN;
            } else if (IBISQLComparisonOperator.NOT_EQUALS.equals(oper)) {
                option = !negate ? IBISapqSelectOption.Option.NOT_EQUALS : IBISapqSelectOption.Option.EQUALS;
            } else {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1028", new Object[]{oper});
            }
        }
        return option;
    }

    private class SortField
    implements IBISapqSortField {
        private final String sortField;
        private final boolean isAscending;

        public SortField(String sortField) {
            this.sortField = sortField;
            this.isAscending = true;
        }

        public SortField(String sortField, boolean isAscending) {
            this.sortField = sortField;
            this.isAscending = isAscending;
        }

        public String getSortField() {
            return this.sortField;
        }

        public boolean isAscending() {
            return this.isAscending;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer().append('[').append(this.sortField).append('|').append(this.isAscending ? "ASC" : "DESC").append(']');
            return buf.toString();
        }
    }
}

