/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.impl;

import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpression;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionColumnRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionGroupByRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionOrderByRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionSelectColumnRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionTableRef;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLAggregateFunction;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLSortingOperator;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTree;
import java.util.ArrayList;
import java.util.List;
import org.omg.cwm.resource.relational.Column;
import org.omg.cwm.resource.relational.Table;

public class BIQueryExpression
implements IBIQueryExpression {
    private List columnRef = new ArrayList();
    private List tableRef = new ArrayList();
    private List groupByRef = new ArrayList();
    private List orderByRef = new ArrayList();
    private IBIWhereTree where = null;

    public void clear() {
        this.columnRef.clear();
        this.tableRef.clear();
        this.groupByRef.clear();
        this.orderByRef.clear();
        this.where = null;
    }

    public void addColumn(IBIQueryExpressionColumnRef columnRef) {
        this.columnRef.add(columnRef);
    }

    public void addColumn(String tableRef, Column column, IBISQLAggregateFunction aggr, String columnRef) {
        this.columnRef.add(new ColumnRef(tableRef, column, aggr, columnRef));
    }

    public void addColumn(String tableRef, Column column, IBISQLAggregateFunction aggr) {
        this.addColumn(tableRef, column, aggr, null);
    }

    public void addColumn(String tableRef, Column column, String columnRef) {
        this.addColumn(tableRef, column, null, columnRef);
    }

    public void addColumn(String tableRef, Column column) {
        this.addColumn(tableRef, column, null, null);
    }

    public void addColumn(Column column, IBISQLAggregateFunction aggr, String columnRef) {
        this.addColumn(null, column, aggr, columnRef);
    }

    public void addColumn(Column column, IBISQLAggregateFunction aggr) {
        this.addColumn(null, column, aggr, null);
    }

    public void addColumn(Column column, String columnRef) {
        this.addColumn(null, column, null, columnRef);
    }

    public void addColumn(Column column) {
        this.addColumn(null, column, null, null);
    }

    public void addTable(IBIQueryExpressionTableRef tableRef) {
        this.tableRef.add(tableRef);
    }

    public void addTable(String tableRef, Table table) {
        this.tableRef.add(new TableRef(table, tableRef));
    }

    public void addTable(Table table) {
        this.addTable(null, table);
    }

    public void addGroupBy(IBIQueryExpressionGroupByRef groupByRef) {
        this.groupByRef.add(groupByRef);
    }

    public void addGroupBy(String tableRef, Column column) {
        this.groupByRef.add(new GroupByRef(tableRef, column));
    }

    public void addGroupBy(Column column) {
        this.addGroupBy(null, column);
    }

    public void addOrderBy(IBIQueryExpressionOrderByRef orderByRef) {
        this.orderByRef.add(orderByRef);
    }

    public void addOrderBy(String tableRef, Column column, IBISQLSortingOperator direction) {
        this.orderByRef.add(new OrderByRef(tableRef, column, direction));
    }

    public void addOrderBy(String tableRef, Column column) {
        this.addOrderBy(tableRef, column, IBISQLSortingOperator.ASC);
    }

    public void addOrderBy(Column column, IBISQLSortingOperator direction) {
        this.addOrderBy(null, column, direction);
    }

    public void addOrderBy(Column column) {
        this.addOrderBy(null, column, IBISQLSortingOperator.ASC);
    }

    public IBIWhereTree getWhereTree() {
        return this.where;
    }

    public void setWhereTree(IBIWhereTree where) {
        this.where = where;
    }

    public List getColumnRef() {
        return this.columnRef;
    }

    public List getTableRef() {
        return this.tableRef;
    }

    public List getGroupByRef() {
        return this.groupByRef;
    }

    public List getOrderByRef() {
        return this.orderByRef;
    }

    private class OrderByRef
    implements IBIQueryExpressionOrderByRef {
        private String tableRef = null;
        private Column column = null;
        private IBISQLSortingOperator direction = IBISQLSortingOperator.ASC;

        public OrderByRef(String tableRef, Column column, IBISQLSortingOperator direction) {
            this.tableRef = tableRef;
            this.column = column;
            this.direction = direction;
        }

        public OrderByRef(String tableRef, Column column) {
            this.tableRef = tableRef;
            this.column = column;
        }

        public Column getColumn() {
            return this.column;
        }

        public String getTableRef() {
            return this.tableRef;
        }

        public boolean isAscending() {
            return this.direction != IBISQLSortingOperator.DESC;
        }
    }

    private class GroupByRef
    implements IBIQueryExpressionGroupByRef {
        private String tableRef = null;
        private Column column = null;

        public GroupByRef(String tableRef, Column column) {
            this.tableRef = tableRef;
            this.column = column;
        }

        public Column getColumn() {
            return this.column;
        }

        public String getTableRef() {
            return this.tableRef;
        }
    }

    private class TableRef
    implements IBIQueryExpressionTableRef {
        private Table table = null;
        private String tableRef = null;

        public TableRef(Table table, String tableRef) {
            this.table = table;
            this.tableRef = tableRef;
        }

        public Table getTable() {
            return this.table;
        }

        public String getTableRef() {
            return this.tableRef;
        }
    }

    private class ColumnRef
    implements IBIQueryExpressionSelectColumnRef {
        private Column column = null;
        private String tableRef = null;
        private IBISQLAggregateFunction aggr = null;
        private String columnRef = null;

        public ColumnRef(String tableRef, Column column, IBISQLAggregateFunction aggr, String columnRef) {
            this.column = column;
            this.tableRef = tableRef;
            this.aggr = aggr;
            this.columnRef = columnRef;
        }

        public IBISQLAggregateFunction getAggr() {
            return this.aggr;
        }

        public Column getColumn() {
            return this.column;
        }

        public String getColumnRef() {
            return this.columnRef;
        }

        public String getTableRef() {
            return this.tableRef;
        }
    }
}

