/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.impl;

import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.IBICommandProcessor;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExecute;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BICommandProcessor;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BIQueryExpression;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import java.sql.ResultSet;
import javax.jmi.reflect.RefPackage;
import org.omg.cwm.foundation.expressions.FeatureNode;

public class BIQuery
implements IBIQuery {
    private IBIQueryExecute connection = null;
    private Object expression = null;
    private IBICommandProcessor cmd = null;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;

    public BIQuery(IBIQueryExecute connection, IBIConnectionInfo connectionInfo) {
        this.connection = connection;
        if (connection == null) {
            throw new BIRuntimeException(connectionInfo.getLocale(), "sdk_4000", new Object[]{"connection"});
        }
        this.connectionInfo = connectionInfo;
        BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
    }

    public void setExpression(Object expression) throws BIResourceException {
        if (!(expression instanceof BIQueryExpression) && !(expression instanceof FeatureNode) && expression != null) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1014");
        }
        this.expression = expression;
    }

    public Object getExpression() throws BIResourceException {
        return this.expression;
    }

    public ResultSet execute() throws BIResourceException {
        this.synchronize();
        if (this.connection != null) {
            return this.connection.execute(this);
        }
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_4003");
    }

    public boolean supports(IBIRelational.Supports feature) {
        return this.connection.supports(feature);
    }

    public void synchronize() throws BIResourceException {
        if (this.cmd != null) {
            this.cmd.synchronize();
        }
    }

    public IBICommandProcessor getCommandProcessor() throws BIResourceException {
        if (this.cmd == null) {
            this.cmd = new BICommandProcessor(this, this.connectionInfo);
        }
        return this.cmd;
    }

    public RefPackage getRefPackage() throws BIResourceException {
        if (this.connection != null) {
            return this.connection.getRefPackage();
        }
        throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_4003");
    }
}

