/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.relational.query.impl;

import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.relational.query.IBICommandProcessor;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionColumnRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionGroupByRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionOrderByRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionSelectColumnRef;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExpressionTableRef;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BIQueryExpression;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BIRedoStack;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BISchemaLiteral;
import com.sap.ip.bi.sdk.dac.relational.query.impl.IBIRedoStack;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.IBISapqCommandProcessor;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.IBISapqSelectOption;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.impl.BISapqSelectOption;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLAggregateFunction;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLComparisonOperator;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLKeyword;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLLogicalOperator;
import com.sap.ip.bi.sdk.dac.relational.query.sql.IBISQLParserConstants;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BISQLKeyword;
import com.sap.ip.bi.sdk.dac.relational.query.sql.impl.BISQLParserConstants;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTree;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeAndNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeBinaryNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnJoinNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnSubQueryNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeColumnValueNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeNotNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeOrNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.IBIWhereTreeUnaryNode;
import com.sap.ip.bi.sdk.dac.relational.query.tree.impl.BIWhereTree;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.omg.cwm.foundation.expressions.ConstantNode;
import org.omg.cwm.foundation.expressions.ElementNode;
import org.omg.cwm.foundation.expressions.ExpressionNode;
import org.omg.cwm.foundation.expressions.ExpressionsPackage;
import org.omg.cwm.foundation.expressions.FeatureNode;
import org.omg.cwm.objectmodel.behavioral.BehavioralPackage;
import org.omg.cwm.objectmodel.behavioral.Operation;
import org.omg.cwm.objectmodel.behavioral.Parameter;
import org.omg.cwm.objectmodel.core.CorePackage;
import org.omg.cwm.objectmodel.core.Feature;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.omg.cwm.resource.relational.Column;
import org.omg.cwm.resource.relational.RelationalPackage;
import org.omg.cwm.resource.relational.SqlsimpleType;
import org.omg.cwm.resource.relational.Table;

public class BICommandProcessor
implements IBICommandProcessor,
IBISapqCommandProcessor {
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$relational$query$impl$BICommandProcessor == null ? (class$com$sap$ip$bi$sdk$dac$relational$query$impl$BICommandProcessor = BICommandProcessor.class$("com.sap.ip.bi.sdk.dac.relational.query.impl.BICommandProcessor")) : class$com$sap$ip$bi$sdk$dac$relational$query$impl$BICommandProcessor).getName());
    private static final Category loggingCat = BILoggingSetup.QUERY.getCategory();
    private IBIMonitor monitor = null;
    private static final boolean useCwmExpression = false;
    private IBIQuery query = null;
    private IBIRedoStack stack = new BIRedoStack();
    private int currentStackPosition = 0;
    private IBIRedoStack whereStack = new BIRedoStack();
    private BIQueryExpression expr = null;
    private IBIWhereTree whereTree = new BIWhereTree();
    private BehavioralPackage bP = null;
    private CorePackage cP = null;
    private ExpressionsPackage eP = null;
    private RelationalPackage rP = null;
    private Hashtable objectReference = new Hashtable();
    private Hashtable referenceObject = new Hashtable();
    private long referenceCounter = 0L;
    private HashSet columnReference = new HashSet();
    private char refPrefix = (char)116;
    private int tableCount = 1;
    private final boolean supportsJoin;
    private final boolean supportsSubSelect;
    private final boolean supportsOnlySelectOptions;
    private List selectOptions = new ArrayList();
    private WhereType whereType = WhereType.UNKNOWN;
    IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$relational$query$impl$BICommandProcessor;
    static /* synthetic */ Class class$org$omg$cwm$foundation$expressions$FeatureNode;

    public BICommandProcessor(IBIQuery query, IBIConnectionInfo connectionInfo) throws BIResourceException {
        String method = "BICommandProcessor(IBIQuery)";
        try {
            this.connectionInfo = connectionInfo;
            BIConnectionInfo.assertConnectionInfo((IBIConnectionInfo)connectionInfo);
            this.query = query;
            this.supportsJoin = query.supports(IBIRelational.Supports.JOIN);
            this.supportsOnlySelectOptions = query.supports(IBIRelational.Supports.ONLY_SELECT_OPTIONS_STYLE_WHERE);
            this.supportsSubSelect = query.supports(IBIRelational.Supports.SUBSELECT);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    public void clear() throws BIResourceException {
        String method = "clear()";
        loggingLoc.entering("clear()");
        try {
            this.stack.empty();
            this.whereStack.clear();
            this.whereTree.clear();
            this.objectReference.clear();
            this.columnReference.clear();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void synchronize() throws BIResourceException {
        String method = "synchronize()";
        loggingLoc.entering("synchronize()");
        try {
            this.processQueryStack();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public String addColumn(Column column) throws BIResourceException {
        String string;
        String method = "addColumn(Column)";
        loggingLoc.entering("addColumn(Column)", new Object[]{column});
        try {
            String ref;
            string = ref = this.addColumn(column, null, null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public String addColumn(Column column, String tableRef) throws BIResourceException {
        String string;
        String method = "addColumn(Column, String)";
        loggingLoc.entering("addColumn(Column, String)", new Object[]{column, tableRef});
        try {
            string = this.addColumn(column, tableRef, null, null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public String addColumn(Column column, String tableRef, String columnRef) throws BIResourceException {
        String string;
        String method = "addColumn(Column, String, String)";
        loggingLoc.entering("addColumn(Column, String, String)", new Object[]{column, tableRef, columnRef});
        try {
            string = this.addColumn(column, tableRef, null, columnRef);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public String addColumn(Column column, String tableRef, IBISQLAggregateFunction aggregateFunction, String columnRef) throws BIResourceException {
        String string;
        String method = "addColumn(Column, String, IBISQLAggregateFunction, String)";
        loggingLoc.entering("addColumn(Column, String, IBISQLAggregateFunction, String)", new Object[]{column, tableRef, aggregateFunction, columnRef});
        try {
            String ref;
            this.assertSelectParameters(column, tableRef, columnRef);
            if (tableRef == null) {
                tableRef = (String)this.referenceObject.get(column.getOwner());
            }
            this.stack.push(new AddColumn(tableRef, column, aggregateFunction, columnRef));
            string = ref = this.columnRefName(column, tableRef, aggregateFunction, columnRef);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    private void addColumn(AddColumn item) throws BIResourceException {
        String method = "addColumn(AddColumn)";
        try {
            this.assertQueryExpression();
            ArrayList<Object> pars = new ArrayList<Object>();
            ArrayList<Object> args = new ArrayList<Object>();
            FeatureNode select = this.findClause(IBISQLKeyword.SELECT);
            ExpressionNode _ref = this.createColumnReference(item.getTableRef(), item.getColumn());
            ExpressionNode _aggr = null;
            if (item.getAggr() != null) {
                pars.clear();
                pars.add(IBISQLParserConstants.REFERENCE);
                Operation soper = this.createOperation(item.getAggr().getKeyword(), pars);
                args.clear();
                args.add(_ref);
                _aggr = this.createFeatureNode(soper, args);
            } else {
                _aggr = _ref;
            }
            ExpressionNode _as = null;
            if (item.getColumnRef() != null) {
                pars.clear();
                pars.add(IBISQLParserConstants.COLUMN.toString());
                pars.add(IBISQLParserConstants.REFERENCE.toString());
                Operation aoper = this.createOperation(IBISQLKeyword.AS, pars);
                args.clear();
                args.add(_aggr);
                args.add(this.createConstantNode(new BISchemaLiteral(item.getColumnRef())));
                _as = this.createFeatureNode(aoper, args);
            } else {
                _as = _aggr;
            }
            pars.clear();
            pars.add(IBISQLParserConstants.REFERENCE.toString());
            args.clear();
            args.add(_as);
            this.addArgument(select, args, pars);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            throw throwable;
        }
    }

    public String addRowCount(String tableRef) throws BIResourceException {
        return this.addRowCount(tableRef, null);
    }

    public String addRowCount(String tableRef, String columnRef) throws BIResourceException {
        String string;
        String method = "addRowCount(String, String)";
        loggingLoc.entering("addRowCount(String, String)", new Object[]{tableRef, columnRef});
        try {
            this.assertTableReference(tableRef);
            this.stack.push(new AddRowCount(tableRef, columnRef));
            string = this.rowCountName(tableRef, columnRef);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public void addGroupBy(Column column, String tableRef) throws BIResourceException {
        String method = "addGroupBy(Column, String)";
        loggingLoc.entering("addGroupBy(Column, String)", new Object[]{column, tableRef});
        try {
            this.assertColumnReference(column, tableRef);
            this.stack.push(new AddGroupBy(column, tableRef));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    private void addGroupBy(AddGroupBy item) throws BIResourceException {
        String method = "addGroupBy(AddGroupBy)";
        try {
            this.assertQueryExpression();
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<ExpressionNode> args = new ArrayList<ExpressionNode>();
            FeatureNode groupby = null;
            try {
                groupby = this.findClause(IBISQLKeyword.GROUP_BY);
            }
            catch (BIResourceException ex) {
                this.setupEmptyClause(IBISQLKeyword.GROUP_BY);
                groupby = this.findClause(IBISQLKeyword.GROUP_BY);
            }
            ExpressionNode _ref = this.createColumnReference(item.getTableRef(), item.getColumn());
            pars.clear();
            pars.add(IBISQLParserConstants.REFERENCE);
            args.clear();
            args.add(_ref);
            this.addArgument(groupby, args, pars);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            throw throwable;
        }
    }

    public void addOrderBy(Column column, String tableRef) throws BIResourceException {
        String method = "addOrderBy(Column, String)";
        loggingLoc.entering("addOrderBy(Column, String)", new Object[]{column, tableRef});
        try {
            this.addOrderBy(column, tableRef, true);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void addOrderBy(Column column, String tableRef, boolean ascending) throws BIResourceException {
        String method = "addOrderBy(Column, String, boolean)";
        loggingLoc.entering("addOrderBy(Column, String, boolean)", new Object[]{column, tableRef, new Boolean(ascending)});
        try {
            this.assertColumnReference(column, tableRef);
            this.stack.push(new AddOrderBy(column, tableRef, ascending));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    private void addOrderBy(AddOrderBy item) throws BIResourceException {
        String method = "addOrderBy(AddOrderBy)";
        try {
            this.assertQueryExpression();
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<ExpressionNode> args = new ArrayList<ExpressionNode>();
            FeatureNode orderby = null;
            try {
                orderby = this.findClause(IBISQLKeyword.ORDER_BY);
            }
            catch (BIResourceException ex) {
                this.setupEmptyClause(IBISQLKeyword.ORDER_BY);
                orderby = this.findClause(IBISQLKeyword.ORDER_BY);
            }
            ExpressionNode _ref = this.createColumnReference(item.getTableRef(), item.getColumn());
            ExpressionNode _asc = null;
            if (item.isAscending()) {
                _asc = _ref;
            } else {
                pars.clear();
                pars.add(IBISQLParserConstants.REFERENCE);
                Operation _doper = this.createOperation(IBISQLKeyword.DESC, pars);
                args.clear();
                args.add(_ref);
                _asc = this.createFeatureNode(_doper, args);
            }
            pars.clear();
            pars.add(IBISQLParserConstants.REFERENCE);
            args.clear();
            args.add(_asc);
            this.addArgument(orderby, args, pars);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            throw throwable;
        }
    }

    public String addTable(Table table) throws BIResourceException {
        String string;
        String method = "addTable(Table)";
        loggingLoc.entering("addTable(Table)", new Object[]{table});
        try {
            string = this.addTable(table, this.addObjectReference((ModelElement)table), true);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    public String addTable(Table table, String tableRef) throws BIResourceException {
        String string;
        String method = "addTable(Table, String)";
        loggingLoc.entering("addTable(Table, String)", new Object[]{table, tableRef});
        try {
            string = this.addTable(table, tableRef, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return string;
    }

    private String addTable(Table table, String tableRef, boolean generatedReference) throws BIResourceException {
        String method = "addTable(Table, String, boolean)";
        try {
            if (!this.supportsJoin && this.tableCount > 1) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1002", new Object[]{IBIRelational.Supports.JOIN.toString()});
                loggingLoc.throwing("addTable(Table, String, boolean)", (Throwable)rex);
                throw rex;
            }
            if (!generatedReference) {
                this.assertUniqueReference(tableRef);
            }
            this.assertTableReference(table, tableRef);
            this.stack.push(new AddTable(table, tableRef));
            ++this.tableCount;
            String string = tableRef;
            Object var7_7 = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            throw throwable;
        }
    }

    private void addTable(AddTable item) throws BIResourceException {
        String method = "addTable(AddTable)";
        try {
            this.assertQueryExpression();
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<Object> args = new ArrayList<Object>();
            FeatureNode from = this.findClause(IBISQLKeyword.FROM);
            pars.clear();
            pars.add(IBISQLParserConstants.TABLE);
            pars.add(IBISQLParserConstants.REFERENCE);
            Operation aop = this.createOperation(IBISQLKeyword._ALIAS, pars);
            ElementNode tabNode = this.createElementNode((ModelElement)item.getTable());
            ConstantNode refNode = this.createConstantNode(new BISchemaLiteral(item.getTableRef()));
            args.clear();
            args.add(tabNode);
            args.add(refNode);
            FeatureNode as = this.createFeatureNode(aop, args);
            pars.clear();
            pars.add((BISQLParserConstants)this.createParameter(IBISQLKeyword._ALIAS));
            args.clear();
            args.add(as);
            this.addArgument(from, args, pars);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet execute() throws BIResourceException {
        ResultSet resultSet;
        String method = "execute()";
        loggingLoc.entering("execute()");
        try {
            if (this.query == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1001");
                loggingLoc.throwing("execute()", (Throwable)rex);
                throw rex;
            }
            resultSet = this.query.execute();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return resultSet;
    }

    public void initialize() throws BIResourceException {
        String method = "initialize()";
        loggingLoc.entering("initialize()");
        try {
            this.query.setExpression(null);
            this.stack = new BIRedoStack();
            this.currentStackPosition = 0;
            this.whereStack = new BIRedoStack();
            this.expr = null;
            this.whereTree = new BIWhereTree();
            this.objectReference = new Hashtable();
            this.referenceObject = new Hashtable();
            this.referenceCounter = 0L;
            this.columnReference = new HashSet();
            this.tableCount = 1;
            this.whereType = WhereType.UNKNOWN;
            this.selectOptions = new ArrayList();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void pushWhereComparison(String tableRef, Column column, IBISQLComparisonOperator oper, Object value) throws BIResourceException {
        String method = "pushWhereComparison(String, Column, IBISQLComparisonOperator, Object)";
        loggingLoc.entering("pushWhereComparison(String, Column, IBISQLComparisonOperator, Object)", new Object[]{tableRef, column, oper, value});
        try {
            this.assertWhereType(WhereType.WHERE);
            this.assertColumnReference(column, tableRef);
            this.stack.push(new WhereComparisonValue(tableRef, column, oper, new Object[]{value}));
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void pushWhereComparison(String tableRef, Column column, IBISQLComparisonOperator oper) throws BIResourceException {
        String method = "pushWhereComparison(String, Column, IBISQLComparisonOperator)";
        loggingLoc.entering("pushWhereComparison(String, Column, IBISQLComparisonOperator)", new Object[]{tableRef, column, oper});
        try {
            this.assertWhereType(WhereType.WHERE);
            this.assertColumnReference(column, tableRef);
            this.stack.push(new WhereComparisonValue(tableRef, column, oper, new Object[0]));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void pushWhereComparison(String tableRef, Column column, IBISQLComparisonOperator oper, Object[] values) throws BIResourceException {
        String method = "pushWhereComparison(String, Column, IBISQLComparisonOperator, Object[])";
        loggingLoc.entering("pushWhereComparison(String, Column, IBISQLComparisonOperator, Object[])", new Object[]{tableRef, column, oper, values});
        try {
            this.assertWhereType(WhereType.WHERE);
            this.assertColumnReference(column, tableRef);
            this.assertComparisonOperator(oper, values);
            this.stack.push(new WhereComparisonValue(tableRef, column, oper, values));
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    private void processWhereComparison(WhereComparisonValue expr) throws BIResourceException {
        String method = "processWhereComparison(WhereComparisonValue)";
        try {
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<Object> args = new ArrayList<Object>();
            Object _lhs = null;
            ExpressionNode _ref = this.createColumnReference(expr.getTableReference(), expr.getColumn());
            pars.clear();
            pars.add(expr.getTableReference() != null ? IBISQLParserConstants.REFERENCE : IBISQLParserConstants.COLUMN);
            int i = 0;
            while (i < expr.getValue().length) {
                pars.add(IBISQLParserConstants.CONSTANT);
                ++i;
            }
            Operation _coper = this.createOperation(expr.getOper().getKeyword(), pars);
            args.clear();
            args.add(_ref);
            int i2 = 0;
            while (i2 < expr.getValue().length) {
                args.add(this.createConstantNode(expr.getValue()[i2]));
                ++i2;
            }
            FeatureNode comparison = this.createFeatureNode(_coper, args);
            this.whereStack.push(comparison);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            throw throwable;
        }
    }

    public void pushWhereComparison(String tableRef, Column column, IBISQLComparisonOperator oper, List values) throws BIResourceException {
        String method = "pushWhereComparison(String, Column, IBISQLComparisonOperator, List)";
        loggingLoc.entering("pushWhereComparison(String, Column, IBISQLComparisonOperator, List)", new Object[]{tableRef, column, oper, values});
        try {
            this.assertWhereType(WhereType.WHERE);
            this.assertColumnReference(column, tableRef);
            Object[] valueArray = values.toArray();
            this.assertComparisonOperator(oper, valueArray);
            this.stack.push(new WhereComparisonValue(tableRef, column, oper, valueArray));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void pushWhereComparison(String tableRef, Column column, IBISQLComparisonOperator oper, IBIQuery subquery) throws BIResourceException {
        String method = "pushWhereComparison(String, Column, IBISQLComparisonOperator, IBIQuery)";
        loggingLoc.entering("pushWhereComparison(String, Column, IBISQLComparisonOperator, IBIQuery)", new Object[]{tableRef, column, oper, subquery});
        try {
            if (!this.supportsSubSelect) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1002", new Object[]{IBIRelational.Supports.SUBSELECT.toString()});
                loggingLoc.throwing("pushWhereComparison(String, Column, IBISQLComparisonOperator, IBIQuery)", (Throwable)rex);
                throw rex;
            }
            this.assertWhereType(WhereType.WHERE);
            this.assertComparisonOperator(oper, subquery);
            this.assertColumnReference(column, tableRef);
            this.stack.push(new WhereComparisonSubSelect(tableRef, column, oper, subquery));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    private void processWhereComparison(WhereComparisonSubSelect expr) throws BIResourceException {
        String method = "processWhereComparison(WhereComparisonSubSelect)";
        try {
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<Object> args = new ArrayList<Object>();
            Object _lhs = null;
            ExpressionNode _ref = this.createColumnReference(expr.getTableReference(), expr.getColumn());
            pars.clear();
            pars.add(expr.getTableReference() != null ? IBISQLParserConstants.REFERENCE : IBISQLParserConstants.COLUMN);
            pars.add(IBISQLParserConstants.SUBSELECT);
            Operation _coper = this.createOperation(expr.getOper().getKeyword(), pars);
            args.clear();
            args.add(_ref);
            args.add(expr.getQuery().getExpression());
            FeatureNode comparison = this.createFeatureNode(_coper, args);
            this.whereStack.push(comparison);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            throw throwable;
        }
    }

    public void pushWhereComparison(String tableRef, Column column, IBISQLComparisonOperator oper, String tableRef2, Column column2) throws BIResourceException {
        String method = "pushWhereComparison(String, Column, IBISQLComparisonOperator, String, Column)";
        loggingLoc.entering("pushWhereComparison(String, Column, IBISQLComparisonOperator, String, Column)", new Object[]{tableRef, column, oper, tableRef2, column2});
        try {
            if (!this.supportsJoin) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1002", new Object[]{IBIRelational.Supports.JOIN.toString()});
                loggingLoc.throwing("pushWhereComparison(String, Column, IBISQLComparisonOperator, String, Column)", (Throwable)rex);
                throw rex;
            }
            this.assertWhereType(WhereType.WHERE);
            this.assertColumnReference(column, tableRef);
            this.assertColumnReference(column2, tableRef2);
            this.stack.push(new WhereComparisonJoin(tableRef, column, oper, tableRef2, column2));
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    private void processWhereComparison(WhereComparisonJoin expr) throws BIResourceException {
        String method = "processWhereComparison(WhereComparisonJoin)";
        try {
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<ExpressionNode> args = new ArrayList<ExpressionNode>();
            Object _lhs = null;
            ExpressionNode _ref = this.createColumnReference(expr.getTableReference(), expr.getColumn());
            ExpressionNode _ref2 = this.createColumnReference(expr.getRightTableReference(), expr.getRightColumn());
            pars.clear();
            pars.add(expr.getTableReference() != null ? IBISQLParserConstants.REFERENCE : IBISQLParserConstants.COLUMN);
            pars.add(expr.getRightTableReference() != null ? IBISQLParserConstants.REFERENCE : IBISQLParserConstants.COLUMN);
            Operation _coper = this.createOperation(expr.getOper().getKeyword(), pars);
            args.clear();
            args.add(_ref);
            args.add(_ref2);
            FeatureNode comparison = this.createFeatureNode(_coper, args);
            this.whereStack.push(comparison);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            throw throwable;
        }
    }

    public void pushWhereLogicalOperator(IBISQLLogicalOperator oper) throws BIResourceException {
        String method = "pushWhereLogicalOperator(IBISQLLogicalOperator)";
        loggingLoc.entering("pushWhereLogicalOperator(IBISQLLogicalOperator)", new Object[]{oper});
        try {
            this.assertWhereType(WhereType.WHERE);
            this.assertNotNull(oper, "sdk.dac.rel.query_1013");
            this.stack.push(oper);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void pushWhereSelectOption(IBISapqSelectOption selOpt) throws BIResourceException {
        String method = "pushWhereSelectOption(IBISapqSelectOption)";
        loggingLoc.entering("pushWhereSelectOption(IBISapqSelectOption)", new Object[]{selOpt});
        try {
            this.assertWhereType(WhereType.SELOPT);
            this.assertNotNull(selOpt, "sdk.dac.rel.query_1013");
            this.selectOptions.add(selOpt);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void removeColumn(String columnRef) throws BIResourceException {
        String method = "removeColumn(String)";
        loggingLoc.entering("removeColumn(String)", new Object[]{columnRef});
        try {
            BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1002", new Object[]{"removeColumn"});
            loggingLoc.throwing("removeColumn(String)", (Throwable)rex);
            throw rex;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    public void removeTable(String tableRef) throws BIResourceException {
        String method = "removeTable(String)";
        loggingLoc.entering("removeTable(String)", new Object[]{tableRef});
        try {
            BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1002", new Object[]{"removeTable"});
            loggingLoc.throwing("removeTable(String)", (Throwable)rex);
            throw rex;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    public void removeWhereCondition() throws BIResourceException {
        String method = "removeWhereCondition()";
        loggingLoc.entering("removeWhereCondition()");
        try {
            BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1002", new Object[]{"removeWhereCondition"});
            loggingLoc.throwing("removeWhereCondition()", (Throwable)rex);
            throw rex;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    private String columnRefName(Column column, String tableRef, IBISQLAggregateFunction aggrFunc, String columnRef) throws BIResourceException {
        String method = "columnRefName(Column, String, IBISQLAggregateFunction, String)";
        try {
            String refName = null;
            if (columnRef != null) {
                refName = columnRef;
            } else {
                StringBuffer colRef = new StringBuffer();
                if (tableRef != null) {
                    colRef.append("\"").append(tableRef).append("\".");
                }
                colRef.append("\"").append(column.getName()).append("\"");
                refName = aggrFunc != null ? aggrFunc.toString() + '(' + colRef + ')' : colRef.toString();
            }
            this.assertUniqueColumnReference(refName);
            String string = refName;
            Object var9_8 = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            throw throwable;
        }
    }

    private String rowCountName(String tableRef, String columnRef) throws BIResourceException {
        String method = "rowCountName(String, String)";
        try {
            String refName = null;
            if (columnRef != null) {
                refName = columnRef;
            } else {
                StringBuffer colRef = new StringBuffer();
                colRef.append(IBISQLAggregateFunction.COUNT.toString()).append('(');
                if (tableRef != null) {
                    colRef.append("\"").append(tableRef).append("\".");
                }
                colRef.append("*").append(')');
                refName = colRef.toString();
            }
            this.assertUniqueColumnReference(refName);
            String string = refName;
            Object var7_6 = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    private ExpressionNode createColumnReference(String tableRef, Column column) throws BIResourceException {
        String method = "createColumnReference(String, Column)";
        try {
            this.assertColumnReference(column, tableRef);
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<Object> args = new ArrayList<Object>();
            ElementNode ref = null;
            if (tableRef != null) {
                pars.clear();
                pars.add(IBISQLParserConstants.REFERENCE);
                pars.add(IBISQLParserConstants.COLUMN);
                Operation _roper = this.createOperation(IBISQLKeyword._REF, pars);
                args.clear();
                args.add(this.createConstantNode(new BISchemaLiteral(tableRef)));
                args.add(this.createElementNode((ModelElement)column));
                ref = this.createFeatureNode(_roper, args);
            } else {
                ref = this.createElementNode((ModelElement)column);
            }
            ElementNode elementNode = ref;
            Object var9_8 = null;
            return elementNode;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            throw throwable;
        }
    }

    private void addArgument(FeatureNode node, List args, List params) throws BIResourceException {
        String method = "addArgument(FeatureNode, List, List)";
        try {
            if (node == null || args == null || params == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1003");
                loggingLoc.throwing("addArgument(FeatureNode, List, List)", (Throwable)rex);
                throw rex;
            }
            Operation oper = (Operation)node.getFeature();
            if (oper == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1004");
                loggingLoc.throwing("addArgument(FeatureNode, List, List)", (Throwable)rex);
                throw rex;
            }
            oper.getParameter().addAll(params);
            node.getArgument().addAll(args);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            throw throwable;
        }
    }

    private void addArgument(FeatureNode node, int index, FeatureNode arg, String param) throws BIResourceException {
        String method = "addArgument(FeatureNode, int, FeatureNode, String)";
        try {
            if (node == null || index < 0 || arg == null || param == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1003");
                loggingLoc.throwing("addArgument(FeatureNode, int, FeatureNode, String)", (Throwable)rex);
                throw rex;
            }
            Operation oper = (Operation)node.getFeature();
            if (oper == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1004");
                loggingLoc.throwing("addArgument(FeatureNode, int, FeatureNode, String)", (Throwable)rex);
                throw rex;
            }
            oper.getParameter().add(index, param);
            node.getArgument().add(index, arg);
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            throw throwable;
        }
    }

    private String addObjectReference(ModelElement object) {
        String method = "addObjectReference(ModelElement)";
        try {
            String ref = this.nextObjectReference();
            this.objectReference.put(ref, object);
            this.referenceObject.put(object, ref);
            String string = ref;
            Object var6_5 = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    private void assertWhereType(WhereType type) throws BIResourceException {
        if (this.whereType == WhereType.UNKNOWN) {
            this.whereType = type;
        } else if (this.whereType != type) {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_5000");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void assertAggregateFunction(String aggregateFunction) throws BIResourceException {
        String method = "assertAggregateFunction(String)";
        try {
            if (IBISQLKeyword.SUM.equals(aggregateFunction)) {
                return;
            }
            if (IBISQLKeyword.MIN.equals(aggregateFunction)) {
                return;
            }
            if (IBISQLKeyword.MAX.equals(aggregateFunction)) {
                return;
            }
            if (IBISQLKeyword.AVG.equals(aggregateFunction)) return;
            BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1005", new Object[]{aggregateFunction});
            loggingLoc.throwing("assertAggregateFunction(String)", (Throwable)rex);
            throw rex;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            throw throwable;
        }
    }

    private void assertUniqueColumnReference(String columnRef) throws BIResourceException {
        String method = "assertUniqueColumnReference(String)";
        try {
            if (this.columnReference.contains(columnRef)) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1027", new Object[]{columnRef});
                loggingLoc.throwing("assertUniqueColumnReference(String)", (Throwable)rex);
                throw rex;
            }
            this.columnReference.add(columnRef);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    private void assertColumnReference(Column column, String tableRef) throws BIResourceException {
        String method = "assertColumnReference(Column, String)";
        try {
            if (column == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1006");
                loggingLoc.throwing("assertColumnReference(Column, String)", (Throwable)rex);
                throw rex;
            }
            if (tableRef != null) {
                if (!this.objectReference.containsKey(tableRef)) {
                    BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1007", new Object[]{tableRef});
                    loggingLoc.throwing("assertColumnReference(Column, String)", (Throwable)rex);
                    throw rex;
                }
                Object table = this.objectReference.get(tableRef);
                if (!(table instanceof Table)) {
                    BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1008", new Object[]{tableRef, table.getClass()});
                    loggingLoc.throwing("assertColumnReference(Column, String)", (Throwable)rex);
                    throw rex;
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            throw throwable;
        }
    }

    private void assertComparisonOperator(IBISQLComparisonOperator oper, IBIQuery subquery) throws BIResourceException {
        String method = "assertComparisonOperator(IBISQLComparisonOperator, IBIQuery)";
        try {
            if (subquery == null) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1009", new Object[]{subquery});
            }
            if (IBISQLComparisonOperator.IN != oper) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1010", new Object[]{oper});
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    private void assertComparisonOperator(IBISQLComparisonOperator oper, Object[] values) throws BIResourceException {
        String method = "assertComparisonOperator(IBISQLComparisonOperator, Object[])";
        try {
            if (values == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1011");
                loggingLoc.throwing("assertComparisonOperator(IBISQLComparisonOperator, Object[])", (Throwable)rex);
                throw rex;
            }
            int operCount = values.length;
            if (oper.argCount() != operCount && oper.argCount() == IBISQLComparisonOperator.MANY && operCount < 1) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1012", new Object[]{new Integer(oper.argCount()), new Integer(operCount)});
                loggingLoc.throwing("assertComparisonOperator(IBISQLComparisonOperator, Object[])", (Throwable)rex);
                throw rex;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            throw throwable;
        }
    }

    private void assertNotNull(Object obj, String exception) throws BIResourceException {
        String method = "assertNotNull(Object, String)";
        try {
            if (obj == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), exception);
                loggingLoc.throwing("assertNotNull(Object, String)", (Throwable)rex);
                throw rex;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    private void assertLogicalOperator(IBISQLLogicalOperator oper) throws BIResourceException {
        String method = "assertLogicalOperator(IBISQLLogicalOperator)";
        try {
            if (oper == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1013");
                loggingLoc.throwing("assertLogicalOperator(IBISQLLogicalOperator)", (Throwable)rex);
                throw rex;
            }
            this.assertWhereStackSize(oper);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    private void assertQueryExpression() throws BIResourceException {
        String method = "assertQueryExpression()";
        try {
            if (!(this.query == null || this.query.getExpression() instanceof FeatureNode && ((FeatureNode)this.query.getExpression()).getFeature().getName().equals(IBISQLKeyword._ROOT.toString()))) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1014");
                loggingLoc.throwing("assertQueryExpression()", (Throwable)rex);
                throw rex;
            }
            if (this.query == null) {
                this.setupEmptyQuery();
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    private void assertQueryExpressionNotNull() throws BIResourceException {
        String method = "assertQueryExpressionNotNull()";
        try {
            if (this.query == null || this.query.getExpression() == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1015");
                loggingLoc.throwing("assertQueryExpressionNotNull()", (Throwable)rex);
                throw rex;
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    private void assertSelectParameters(Column column, String tableRef, String columnRef) throws BIResourceException {
        String method = "assertSelectParameters(Column, String, String)";
        try {
            this.assertColumnReference(column, tableRef);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    private void assertUniqueReference(String ref) throws BIResourceException {
        String method = "assertUniqueReference(String)";
        try {
            if (ref == null || this.objectReference.containsKey(ref)) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1027", new Object[]{ref});
                loggingLoc.throwing("assertUniqueReference(String)", (Throwable)rex);
                throw rex;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    private void assertTableReference(String tableRef) throws BIResourceException {
        String method = "assertTableReference(String)";
        try {
            if (tableRef != null && !this.objectReference.containsKey(tableRef)) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1007", new Object[]{tableRef});
                loggingLoc.throwing("assertTableReference(String)", (Throwable)rex);
                throw rex;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    private void assertTableReference(Table table, String tableRef) throws BIResourceException {
        String method = "assertTableReference(Table, String)";
        try {
            if (table == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1016");
                loggingLoc.throwing("assertTableReference(Table, String)", (Throwable)rex);
                throw rex;
            }
            if (tableRef != null) {
                if (!this.objectReference.containsKey(tableRef)) {
                    this.objectReference.put(tableRef, table);
                } else {
                    Object obj = this.objectReference.get(tableRef);
                    if (!(obj instanceof Table)) {
                        BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1008", new Object[]{tableRef, table.getClass()});
                        loggingLoc.throwing("assertTableReference(Table, String)", (Throwable)rex);
                        throw rex;
                    }
                    if (obj != table) {
                        BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1017", new Object[]{tableRef, table.getName()});
                        loggingLoc.throwing("assertTableReference(Table, String)", (Throwable)rex);
                        throw rex;
                    }
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            throw throwable;
        }
    }

    private void assertWhereStackSize(IBISQLLogicalOperator oper) throws BIResourceException {
        String method = "assertWhereStackSize(IBISQLLogicalOperator)";
        try {
            if (oper == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1013");
                loggingLoc.throwing("assertWhereStackSize(IBISQLLogicalOperator)", (Throwable)rex);
                throw rex;
            }
            this.assertWhereStackSize(oper.isBinary() ? 2 : 1);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    private void assertWhereStackSize(int min) throws BIResourceException {
        String method = "assertWhereStackSize(int)";
        try {
            int size = this.whereStack.size();
            if (size < min) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1012", new Object[]{new Integer(min), new Integer(size)});
                loggingLoc.throwing("assertWhereStackSize(int)", (Throwable)rex);
                throw rex;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    private void assertWhereStackTop(Class instance) throws BIResourceException {
        String method = "assertWhereStackTop(Class)";
        try {
            try {
                Object top = this.whereStack.peek();
                if (instance == null || !instance.isAssignableFrom(top.getClass())) {
                    BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1018", new Object[]{instance, top.getClass()});
                    loggingLoc.throwing("assertWhereStackTop(Class)", (Throwable)rex);
                    throw rex;
                }
            }
            catch (EmptyStackException ex) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
                loggingLoc.throwing("assertWhereStackTop(Class)", (Throwable)rex);
                throw rex;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            throw throwable;
        }
    }

    private ConstantNode createConstantNode(Object value) throws BIResourceException {
        String method = "createConstantNode(Object)";
        try {
            if (value == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1020");
                loggingLoc.throwing("createConstantNode(Object)", (Throwable)rex);
                throw rex;
            }
            ConstantNode cnode = this.eP.getConstantNode().createConstantNode();
            cnode.setValue(value);
            ConstantNode constantNode = cnode;
            Object var6_6 = null;
            return constantNode;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    private ElementNode createElementNode(ModelElement element) throws BIResourceException {
        String method = "createElementNode(ModelElement)";
        try {
            if (element == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1021");
                loggingLoc.throwing("createElementNode(ModelElement)", (Throwable)rex);
                throw rex;
            }
            ElementNode enode = this.eP.getElementNode().createElementNode();
            enode.setModelElement(element);
            ElementNode elementNode = enode;
            Object var6_6 = null;
            return elementNode;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    private FeatureNode createFeatureNode(Operation oper, List args) throws BIResourceException {
        String method = "createFeatureNode(Operation, List)";
        try {
            if (oper == null || args == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
                loggingLoc.throwing("createFeatureNode(Operation, List)", (Throwable)rex);
                throw rex;
            }
            FeatureNode f = this.eP.getFeatureNode().createFeatureNode();
            f.setFeature((Feature)oper);
            f.getArgument().addAll(args);
            FeatureNode featureNode = f;
            Object var7_7 = null;
            return featureNode;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            throw throwable;
        }
    }

    private Operation createOperation(IBISQLKeyword operName, List parNames) throws BIResourceException {
        String method = "createOperation(IBISQLKeyword, List)";
        try {
            if (operName == null || parNames == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1022");
                loggingLoc.throwing("createOperation(IBISQLKeyword, List)", (Throwable)rex);
                throw rex;
            }
            Operation oper = this.bP.getOperation().createOperation();
            oper.setName(operName.toString());
            Iterator iter = parNames.iterator();
            List opars = oper.getParameter();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (item instanceof String) {
                    opars.add(this.createParameter((String)item));
                    continue;
                }
                if (item instanceof IBISQLKeyword) {
                    opars.add(this.createParameter((IBISQLKeyword)item));
                    continue;
                }
                if (item instanceof IBISQLParserConstants) {
                    opars.add(this.createParameter((IBISQLParserConstants)item));
                    continue;
                }
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1023", new Object[]{item == null ? null : item.getClass(), item});
                loggingLoc.throwing("createOperation(IBISQLKeyword, List)", (Throwable)rex);
                throw rex;
            }
            Operation operation = oper;
            Object var10_10 = null;
            return operation;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            throw throwable;
        }
    }

    private Parameter createParameter(IBISQLParserConstants parName) throws BIResourceException {
        String method = "createParameter(IBISQLParserConstants)";
        try {
            if (parName == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1024");
                loggingLoc.throwing("createParameter(IBISQLParserConstants)", (Throwable)rex);
                throw rex;
            }
            Parameter parameter = this.createParameter(parName.toString());
            Object var5_5 = null;
            return parameter;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    private Parameter createParameter(IBISQLKeyword parName) throws BIResourceException {
        String method = "createParameter(IBISQLKeyword)";
        try {
            if (parName == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1024");
                loggingLoc.throwing("createParameter(IBISQLKeyword)", (Throwable)rex);
                throw rex;
            }
            Parameter parameter = this.createParameter(parName.toString());
            Object var5_5 = null;
            return parameter;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    private Parameter createParameter(String parName) throws BIResourceException {
        String method = "createParameter(String)";
        try {
            if (parName == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1024");
                loggingLoc.throwing("createParameter(String)", (Throwable)rex);
                throw rex;
            }
            Parameter p = this.bP.getParameter().createParameter();
            p.setName(parName);
            Parameter parameter = p;
            Object var6_6 = null;
            return parameter;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    private FeatureNode findClause(IBISQLKeyword operName) throws BIResourceException {
        String method = "findClause(IBISQLKeyword)";
        try {
            if (operName == null) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1004");
            }
            FeatureNode featureNode = this.findClause(operName.toString());
            Object var5_4 = null;
            return featureNode;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    private FeatureNode findClause(String operName) throws BIResourceException {
        String method = "findClause(String)";
        try {
            if (!(this.query.getExpression() instanceof FeatureNode)) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1014");
            }
            Iterator clauses = ((FeatureNode)this.query.getExpression()).getArgument().iterator();
            while (clauses.hasNext()) {
                FeatureNode clause = (FeatureNode)clauses.next();
                if (clause.getFeature() == null || clause.getFeature().getName() == null || !clause.getFeature().getName().equals(operName)) continue;
                FeatureNode featureNode = clause;
                Object var7_6 = null;
                return featureNode;
            }
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1004");
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int generatedTableReference(String refName) {
        String method = "generatedTableReference(String)";
        try {
            if (refName == null) {
                return -1;
            }
            char[] ref = refName.toCharArray();
            if (ref[0] != 'r') {
                return -1;
            }
            int power = 1;
            int value = 0;
            int i = ref.length - 1;
            while (i > 0) {
                if (ref[i] < '0') return -1;
                if (ref[i] > '9') {
                    return -1;
                }
                value += power * i;
                power *= 10;
                ++i;
            }
            return value;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            throw throwable;
        }
    }

    private String nextObjectReference() {
        String method = "nextObjectReference()";
        try {
            ++this.referenceCounter;
            String ref = null;
            while (this.objectReference.contains(ref = "" + this.refPrefix + this.referenceCounter)) {
                ++this.referenceCounter;
            }
            String string = ref;
            Object var5_4 = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    private void processQueryStack() throws BIResourceException {
        String method = "processStack()";
        try {
            Object[] s = this.stack.toArray();
            this.expr = this.query != null && this.query.getExpression() instanceof BIQueryExpression ? (BIQueryExpression)this.query.getExpression() : new BIQueryExpression();
            this.whereTree = new BIWhereTree();
            if (this.expr.getWhereTree() != null) {
                this.whereTree.setRoot(this.expr.getWhereTree().getRoot());
                this.whereTree.pushRoot();
            }
            int i = this.currentStackPosition;
            while (i < s.length) {
                Column col;
                String tref;
                IBISQLComparisonOperator oper;
                ++this.currentStackPosition;
                Object item = s[i];
                if (item instanceof IBISQLLogicalOperator) {
                    this.whereTree.push((IBISQLLogicalOperator)item);
                } else if (item instanceof WhereComparisonJoin) {
                    String tref1 = ((WhereComparisonJoin)item).getLeftTableReference();
                    Column col1 = ((WhereComparisonJoin)item).getLeftColumn();
                    oper = ((WhereComparisonJoin)item).getOper();
                    String tref2 = ((WhereComparisonJoin)item).getRightTableReference();
                    Column col2 = ((WhereComparisonJoin)item).getRightColumn();
                    this.whereTree.push(tref1, col1, oper, tref2, col2);
                } else if (item instanceof WhereComparisonSubSelect) {
                    tref = ((WhereComparisonSubSelect)item).getTableReference();
                    col = ((WhereComparisonSubSelect)item).getColumn();
                    oper = ((WhereComparisonSubSelect)item).getOper();
                    IBIQuery subSelect = ((WhereComparisonSubSelect)item).getQuery();
                    this.whereTree.push(tref, col, oper, subSelect);
                } else if (item instanceof WhereComparisonValue) {
                    tref = ((WhereComparisonValue)item).getTableReference();
                    col = ((WhereComparisonValue)item).getColumn();
                    oper = ((WhereComparisonValue)item).getOper();
                    Object[] value = ((WhereComparisonValue)item).getValue();
                    this.whereTree.push(tref, col, oper, value);
                } else if (item instanceof AddColumn) {
                    this.expr.addColumn((IBIQueryExpressionColumnRef)item);
                } else if (item instanceof AddTable) {
                    this.expr.addTable((IBIQueryExpressionTableRef)item);
                } else if (item instanceof AddOrderBy) {
                    this.expr.addOrderBy((IBIQueryExpressionOrderByRef)item);
                } else if (item instanceof AddGroupBy) {
                    this.expr.addGroupBy((IBIQueryExpressionGroupByRef)item);
                } else {
                    BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
                    loggingLoc.throwing("processStack()", (Throwable)rex);
                    throw rex;
                }
                ++i;
            }
            if (this.whereType == WhereType.SELOPT) {
                IBIWhereTreeNode selNode = BISapqSelectOption.toWhereTreeNode(this.selectOptions.toArray(new IBISapqSelectOption[0]));
                this.whereTree.clear();
                this.whereTree.setRoot(selNode);
            } else {
                this.whereTree.peekRoot();
            }
            this.expr.setWhereTree(this.whereTree);
            this.query.setExpression(this.expr);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            throw throwable;
        }
    }

    private void processCwmStack() throws BIResourceException {
        String method = "processExpressionStack()";
        try {
            Object[] s = this.stack.toArray();
            this.whereTree.clear();
            int i = this.currentStackPosition;
            while (i < s.length) {
                Column col;
                String tref;
                IBISQLComparisonOperator oper;
                ++this.currentStackPosition;
                Object item = s[i];
                if (item instanceof IBISQLLogicalOperator) {
                    this.whereTree.push((IBISQLLogicalOperator)item);
                } else if (item instanceof WhereComparisonJoin) {
                    String tref1 = ((WhereComparisonJoin)item).getLeftTableReference();
                    Column col1 = ((WhereComparisonJoin)item).getLeftColumn();
                    oper = ((WhereComparisonJoin)item).getOper();
                    String tref2 = ((WhereComparisonJoin)item).getRightTableReference();
                    Column col2 = ((WhereComparisonJoin)item).getRightColumn();
                    this.whereTree.push(tref1, col1, oper, tref2, col2);
                } else if (item instanceof WhereComparisonSubSelect) {
                    tref = ((WhereComparisonSubSelect)item).getTableReference();
                    col = ((WhereComparisonSubSelect)item).getColumn();
                    oper = ((WhereComparisonSubSelect)item).getOper();
                    IBIQuery subSelect = ((WhereComparisonSubSelect)item).getQuery();
                    this.whereTree.push(tref, col, oper, subSelect);
                } else if (item instanceof WhereComparisonValue) {
                    tref = ((WhereComparisonValue)item).getTableReference();
                    col = ((WhereComparisonValue)item).getColumn();
                    oper = ((WhereComparisonValue)item).getOper();
                    Object[] value = ((WhereComparisonValue)item).getValue();
                    this.whereTree.push(tref, col, oper, value);
                } else if (item instanceof AddColumn) {
                    this.addColumn((AddColumn)item);
                } else if (item instanceof AddTable) {
                    this.addTable((AddTable)item);
                } else if (item instanceof AddOrderBy) {
                    this.addOrderBy((AddOrderBy)item);
                } else if (item instanceof AddGroupBy) {
                    this.addGroupBy((AddGroupBy)item);
                } else {
                    BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
                    loggingLoc.throwing("processExpressionStack()", (Throwable)rex);
                    throw rex;
                }
                ++i;
            }
            if (this.whereType == WhereType.SELOPT) {
                IBIWhereTreeNode selNode = BISapqSelectOption.toWhereTreeNode(this.selectOptions.toArray(new IBISapqSelectOption[0]));
                this.whereTree.setRoot(selNode);
            }
            this.processWhereTree();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            throw throwable;
        }
    }

    private void processWhereExpression() throws BIResourceException {
        String method = "processWhereExpression()";
        try {
            try {
                Object top = this.whereStack.peek();
                if (top == null) {
                    BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
                    loggingLoc.throwing("processWhereExpression()", (Throwable)rex);
                    throw rex;
                }
                if (top instanceof FeatureNode) {
                    this.replaceWhereClause((FeatureNode)top);
                } else if (top instanceof IBISQLLogicalOperator) {
                    this.whereStack.pop();
                    if ((IBISQLLogicalOperator)top instanceof IBISQLLogicalOperator) {
                        this.assertWhereStackSize((IBISQLLogicalOperator)top);
                        this.processWhereExpressionLogOper((IBISQLLogicalOperator)top);
                        Object var5_6 = null;
                        return;
                    }
                    BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
                    loggingLoc.throwing("processWhereExpression()", (Throwable)rex);
                    throw rex;
                }
            }
            catch (EmptyStackException ex) {
                Object var5_7 = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            throw throwable;
        }
        Object var5_8 = null;
    }

    private void processWhereTree() throws BIResourceException {
        String method = "processWhereTree()";
        try {
            this.whereTree.peekRoot();
            IBIWhereTreeNode root = this.whereTree.getRoot();
            if (root != null) {
                FeatureNode expr = this.processWhereTreeNode(root);
                this.replaceWhereClause(expr);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FeatureNode processWhereTreeNode(IBIWhereTreeNode node) throws BIResourceException {
        String method = "processWhereTreeNode(IBIWhereTreeNode)";
        try {
            if (node instanceof IBIWhereTreeUnaryNode) {
                return this.processWhereTreeUnaryNode((IBIWhereTreeUnaryNode)node);
            }
            if (node instanceof IBIWhereTreeBinaryNode) {
                return this.processWhereTreeBinaryNode((IBIWhereTreeBinaryNode)node);
            }
            if (node instanceof IBIWhereTreeColumnValueNode) {
                return this.processWhereTreeColumnValueNode((IBIWhereTreeColumnValueNode)node);
            }
            if (node instanceof IBIWhereTreeColumnJoinNode) {
                return this.processWhereTreeColumnJoinNode((IBIWhereTreeColumnJoinNode)node);
            }
            if (node instanceof IBIWhereTreeColumnSubQueryNode) {
                return this.processWhereTreeColumnSubQueryNode((IBIWhereTreeColumnSubQueryNode)node);
            }
            BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
            loggingLoc.throwing("processWhereTreeNode(IBIWhereTreeNode)", (Throwable)rex);
            throw rex;
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            throw throwable;
        }
    }

    private FeatureNode processWhereTreeUnaryNode(IBIWhereTreeUnaryNode node) throws BIResourceException {
        String method = "processWhereTreeUnaryNode(IBIWhereTreeUnaryNode)";
        try {
            FeatureNode logical;
            if (!(node instanceof IBIWhereTreeNotNode)) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
                loggingLoc.throwing("processWhereTreeUnaryNode(IBIWhereTreeUnaryNode)", (Throwable)rex);
                throw rex;
            }
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<FeatureNode> args = new ArrayList<FeatureNode>();
            pars.add(IBISQLParserConstants.LHS);
            args.add(this.processWhereTreeNode(node.getChild()));
            if (!(node instanceof IBIWhereTreeNotNode)) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
                loggingLoc.throwing("processWhereTreeUnaryNode(IBIWhereTreeUnaryNode)", (Throwable)rex);
                throw rex;
            }
            Operation _loper = this.createOperation(IBISQLKeyword.NOT, pars);
            FeatureNode featureNode = logical = this.createFeatureNode(_loper, args);
            Object var9_10 = null;
            return featureNode;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            throw throwable;
        }
    }

    private FeatureNode processWhereTreeBinaryNode(IBIWhereTreeBinaryNode node) throws BIResourceException {
        String method = "processWhereTreeBinaryNode(IBIWhereTreeBinaryNode)";
        try {
            FeatureNode logical;
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<FeatureNode> args = new ArrayList<FeatureNode>();
            pars.add(IBISQLParserConstants.LHS);
            pars.add(IBISQLParserConstants.RHS);
            Operation _loper = null;
            if (node instanceof IBIWhereTreeAndNode) {
                _loper = this.createOperation(IBISQLKeyword.AND, pars);
            } else if (node instanceof IBIWhereTreeOrNode) {
                _loper = this.createOperation(IBISQLKeyword.OR, pars);
            } else {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
                loggingLoc.throwing("processWhereTreeBinaryNode(IBIWhereTreeBinaryNode)", (Throwable)rex);
                throw rex;
            }
            args.add(this.processWhereTreeNode(node.getLeft()));
            args.add(this.processWhereTreeNode(node.getRight()));
            FeatureNode featureNode = logical = this.createFeatureNode(_loper, args);
            Object var9_9 = null;
            return featureNode;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            throw throwable;
        }
    }

    private FeatureNode processWhereTreeColumnValueNode(IBIWhereTreeColumnValueNode node) throws BIResourceException {
        String method = "processWhereTreeColumnValueNode(IBIWhereTreeColumnValueNode)";
        try {
            FeatureNode comparison;
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<Object> args = new ArrayList<Object>();
            Object _lhs = null;
            ExpressionNode _ref = this.createColumnReference(node.getTableRef(), node.getColumn());
            pars.clear();
            pars.add(node.getTableRef() != null ? IBISQLParserConstants.REFERENCE : IBISQLParserConstants.COLUMN);
            int i = 0;
            while (i < node.getValue().length) {
                pars.add(IBISQLParserConstants.CONSTANT);
                ++i;
            }
            Operation _coper = this.createOperation(node.getOper().getKeyword(), pars);
            args.clear();
            args.add(_ref);
            int i2 = 0;
            while (i2 < node.getValue().length) {
                args.add(this.createConstantNode(node.getValue()[i2]));
                ++i2;
            }
            FeatureNode featureNode = comparison = this.createFeatureNode(_coper, args);
            Object var13_12 = null;
            return featureNode;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            throw throwable;
        }
    }

    private FeatureNode processWhereTreeColumnJoinNode(IBIWhereTreeColumnJoinNode node) throws BIResourceException {
        String method = "processWhereTreeColumnJoinNode(IBIWhereTreeColumnJoinNode)";
        try {
            FeatureNode comparison;
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<ExpressionNode> args = new ArrayList<ExpressionNode>();
            Object _lhs = null;
            ExpressionNode _ref = this.createColumnReference(node.getTableRef(), node.getColumn());
            ExpressionNode _ref2 = this.createColumnReference(node.getOtherTableRef(), node.getOtherColumn());
            pars.clear();
            pars.add(node.getTableRef() != null ? IBISQLParserConstants.REFERENCE : IBISQLParserConstants.COLUMN);
            pars.add(node.getOtherTableRef() != null ? IBISQLParserConstants.REFERENCE : IBISQLParserConstants.COLUMN);
            Operation _coper = this.createOperation(node.getOper().getKeyword(), pars);
            args.clear();
            args.add(_ref);
            args.add(_ref2);
            FeatureNode featureNode = comparison = this.createFeatureNode(_coper, args);
            Object var12_11 = null;
            return featureNode;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            throw throwable;
        }
    }

    private FeatureNode processWhereTreeColumnSubQueryNode(IBIWhereTreeColumnSubQueryNode node) throws BIResourceException {
        String method = "processWhereTreeColumnSubQueryNode(IBIWhereTreeColumnSubQueryNode)";
        try {
            FeatureNode comparison;
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<Object> args = new ArrayList<Object>();
            Object _lhs = null;
            ExpressionNode _ref = this.createColumnReference(node.getTableRef(), node.getColumn());
            pars.clear();
            pars.add(node.getTableRef() != null ? IBISQLParserConstants.REFERENCE : IBISQLParserConstants.COLUMN);
            pars.add(IBISQLParserConstants.SUBSELECT);
            Operation _coper = this.createOperation(node.getOper().getKeyword(), pars);
            args.clear();
            args.add(_ref);
            args.add(node.getSubSelect().getExpression());
            FeatureNode featureNode = comparison = this.createFeatureNode(_coper, args);
            Object var11_10 = null;
            return featureNode;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            throw throwable;
        }
    }

    private void processWhereExpressionLogOper(IBISQLLogicalOperator oper) throws BIResourceException {
        String method = "processWhereExpressionLogOper(IBISQLLogicalOperator)";
        try {
            if (oper == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1019");
                loggingLoc.throwing("processWhereExpressionLogOper(IBISQLLogicalOperator)", (Throwable)rex);
                throw rex;
            }
            ArrayList<BISQLParserConstants> pars = new ArrayList<BISQLParserConstants>();
            ArrayList<FeatureNode> args = new ArrayList<FeatureNode>();
            FeatureNode lhs = null;
            FeatureNode rhs = null;
            pars.clear();
            args.clear();
            if (oper.isBinary()) {
                this.assertWhereStackTop(class$org$omg$cwm$foundation$expressions$FeatureNode == null ? (class$org$omg$cwm$foundation$expressions$FeatureNode = BICommandProcessor.class$("org.omg.cwm.foundation.expressions.FeatureNode")) : class$org$omg$cwm$foundation$expressions$FeatureNode);
                rhs = (FeatureNode)this.whereStack.pop();
                pars.add(IBISQLParserConstants.RHS);
                args.add(rhs);
            }
            this.assertWhereStackTop(class$org$omg$cwm$foundation$expressions$FeatureNode == null ? (class$org$omg$cwm$foundation$expressions$FeatureNode = BICommandProcessor.class$("org.omg.cwm.foundation.expressions.FeatureNode")) : class$org$omg$cwm$foundation$expressions$FeatureNode);
            lhs = (FeatureNode)this.whereStack.pop();
            pars.add(IBISQLParserConstants.LHS);
            args.add(lhs);
            Operation _loper = this.createOperation(oper.getKeyword(), pars);
            FeatureNode logical = this.createFeatureNode(_loper, args);
            this.whereStack.push(logical);
            this.replaceWhereClause(logical);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            throw throwable;
        }
    }

    private void replaceWhereClause(FeatureNode whereNode) throws BIResourceException {
        String method = "replaceWhereClause(FeatureNode)";
        try {
            if (!(this.query.getExpression() instanceof FeatureNode)) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1014");
                loggingLoc.throwing("replaceWhereClause(FeatureNode)", (Throwable)rex);
                throw rex;
            }
            Iterator clauses = ((FeatureNode)this.query.getExpression()).getArgument().iterator();
            int index = 0;
            int where = -1;
            int from = -1;
            while (clauses.hasNext()) {
                FeatureNode clause = (FeatureNode)clauses.next();
                if (clause.getFeature() != null && IBISQLKeyword.WHERE.equals(clause.getFeature().getName())) {
                    where = index;
                }
                if (clause.getFeature() != null && IBISQLKeyword.FROM.equals(clause.getFeature().getName())) {
                    from = index;
                }
                ++index;
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(IBISQLParserConstants.LOGEXPR);
            Operation woper = this.createOperation(IBISQLKeyword.WHERE, params);
            ArrayList<FeatureNode> args = new ArrayList<FeatureNode>();
            args.add(whereNode);
            FeatureNode whereClause = this.createFeatureNode(woper, args);
            if (where >= 0) {
                ((FeatureNode)this.query.getExpression()).getArgument().set(where, whereClause);
            } else if (from >= 0) {
                this.addArgument((FeatureNode)this.query.getExpression(), from + 1, whereClause, IBISQLKeyword.WHERE.toString());
            } else {
                params.clear();
                params.add(IBISQLKeyword.WHERE.toString());
                args.clear();
                args.add(whereClause);
                this.addArgument((FeatureNode)this.query.getExpression(), args, params);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            throw throwable;
        }
    }

    private void retrieveTableAliases() throws BIResourceException {
        String method = "retrieveTableAliases()";
        try {
            FeatureNode from = this.findClause(IBISQLKeyword.FROM);
            Iterator args = from.getArgument().iterator();
            while (args.hasNext()) {
                FeatureNode arg = (FeatureNode)args.next();
                if (!IBISQLKeyword.AS.equals(arg.getFeature().getName())) continue;
                String refName = (String)arg.getArgument().get(0);
                ModelElement refObject = (ModelElement)arg.getArgument().get(1);
                this.objectReference.put(refName, refObject);
                int ref = this.generatedTableReference(refName);
                if (ref <= 0) continue;
                long l = this.referenceCounter = this.referenceCounter < (long)ref ? (long)ref : this.referenceCounter;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            throw throwable;
        }
    }

    private void setup() throws BIResourceException {
        String method = "setup()";
        try {
            this.bP = (BehavioralPackage)this.query.getRefPackage().refPackage("org.omg.cwm.objectmodel.Behavioral");
            this.cP = (CorePackage)this.query.getRefPackage().refPackage("org.omg.cwm.objectmodel.Core");
            this.eP = (ExpressionsPackage)this.query.getRefPackage().refPackage("org.omg.cwm.foundation.Expressions");
            this.rP = (RelationalPackage)this.query.getRefPackage().refPackage("org.omg.cwm.resource.Relational");
            this.stack.empty();
            if (this.query == null || this.query.getExpression() == null) {
                this.setupEmptyQuery();
            } else {
                this.setupExistingQuery();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    private void setupEmptyClause(IBISQLKeyword clauseName) throws BIResourceException {
        String method = "setupEmptyClause(IBISQLKeyword)";
        try {
            Operation oper = this.createOperation(clauseName, Collections.EMPTY_LIST);
            FeatureNode clause = this.createFeatureNode(oper, Collections.EMPTY_LIST);
            ArrayList<IBISQLKeyword> pars = new ArrayList<IBISQLKeyword>();
            ArrayList<FeatureNode> args = new ArrayList<FeatureNode>();
            args.add(clause);
            pars.add(clauseName);
            if (!(this.query.getExpression() instanceof FeatureNode)) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.rel.query_1014");
                loggingLoc.throwing("setupEmptyClause(IBISQLKeyword)", (Throwable)rex);
                throw rex;
            }
            this.addArgument((FeatureNode)this.query.getExpression(), args, pars);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            throw throwable;
        }
    }

    private void setupEmptyQuery() throws BIResourceException {
        String method = "setupEmptyQuery()";
        try {
            Operation selop = this.createOperation(IBISQLKeyword.SELECT, Collections.EMPTY_LIST);
            FeatureNode select = this.createFeatureNode(selop, Collections.EMPTY_LIST);
            Operation frop = this.createOperation(IBISQLKeyword.FROM, Collections.EMPTY_LIST);
            FeatureNode from = this.createFeatureNode(frop, Collections.EMPTY_LIST);
            ArrayList<BISQLKeyword> pars = new ArrayList<BISQLKeyword>();
            pars.add(IBISQLKeyword.SELECT);
            pars.add(IBISQLKeyword.FROM);
            Operation rop = this.createOperation(IBISQLKeyword._ROOT, pars);
            ArrayList<FeatureNode> args = new ArrayList<FeatureNode>();
            args.add(select);
            args.add(from);
            FeatureNode root = this.createFeatureNode(rop, args);
            this.query.setExpression(root);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            throw throwable;
        }
    }

    private void setupExistingQuery() throws BIResourceException {
        String method = "setupExistingQuery()";
        try {
            this.assertQueryExpression();
            this.retrieveTableAliases();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WhereComparisonJoin
    extends WhereComparison {
        private String tableReferenceRight = null;
        private Column columnRight = null;

        private WhereComparisonJoin() {
        }

        public WhereComparisonJoin(String tableReferenceLeft, Column columnLeft, IBISQLComparisonOperator oper, String tableReferenceRight, Column columnRight) {
            super(tableReferenceLeft, columnLeft, oper);
            this.tableReferenceRight = tableReferenceRight;
            this.columnRight = columnRight;
        }

        public String getRightTableReference() {
            return this.tableReferenceRight;
        }

        public Column getRightColumn() {
            return this.columnRight;
        }

        public String getLeftTableReference() {
            return super.getTableReference();
        }

        public Column getLeftColumn() {
            return super.getColumn();
        }
    }

    private class WhereComparisonSubSelect
    extends WhereComparison {
        private IBIQuery query = null;

        private WhereComparisonSubSelect() {
        }

        public WhereComparisonSubSelect(String tableReference, Column column, IBISQLComparisonOperator oper, IBIQuery query) {
            super(tableReference, column, oper);
            this.query = query;
        }

        public IBIQuery getQuery() {
            return this.query;
        }
    }

    private class WhereComparisonValue
    extends WhereComparison {
        private Object[] value = null;

        private WhereComparisonValue() {
        }

        public WhereComparisonValue(String tableReference, Column column, IBISQLComparisonOperator oper, Object[] value) {
            super(tableReference, column, oper);
            if (value != null && this.quoteValues(column)) {
                this.value = new Object[value.length];
                int i = 0;
                while (i < this.value.length) {
                    this.value[i] = value[i] != null ? value[i].toString() : null;
                    ++i;
                }
            } else {
                this.value = value;
            }
        }

        public Object[] getValue() {
            return this.value;
        }
    }

    private class WhereComparison
    extends StackItem {
        private String tableReference = null;
        private Column column = null;
        private IBISQLComparisonOperator oper = null;

        private WhereComparison() {
        }

        public WhereComparison(String tableReference, Column column, IBISQLComparisonOperator oper) {
            this.tableReference = tableReference;
            this.column = column;
            this.oper = oper;
        }

        public String getTableReference() {
            return this.tableReference;
        }

        public Column getColumn() {
            return this.column;
        }

        public IBISQLComparisonOperator getOper() {
            return this.oper;
        }

        protected boolean quoteValues(Column column) {
            if (column != null && column.getType() != null) {
                int sqlType = ((SqlsimpleType)column.getType()).getTypeNumber();
                switch (sqlType) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return false;
                    }
                }
                return true;
            }
            return true;
        }
    }

    private class AddTable
    extends StackItem
    implements IBIQueryExpressionTableRef {
        private Table table = null;
        private String tableReference = null;

        private AddTable() {
        }

        private AddTable(Table table, String tableReference) {
            this.table = table;
            this.tableReference = tableReference;
        }

        public Table getTable() {
            return this.table;
        }

        public String getTableRef() {
            return this.tableReference;
        }
    }

    private class AddOrderBy
    extends StackItem
    implements IBIQueryExpressionOrderByRef {
        private Column column = null;
        private String tableReference = null;
        private boolean ascending = true;

        private AddOrderBy() {
        }

        private AddOrderBy(Column column, String tableReference, boolean ascending) {
            this.column = column;
            this.tableReference = tableReference;
            this.ascending = ascending;
        }

        private AddOrderBy(Column column, String tableReference) {
            this.column = column;
            this.tableReference = tableReference;
            this.ascending = true;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public Column getColumn() {
            return this.column;
        }

        public String getTableRef() {
            return this.tableReference;
        }
    }

    private class AddGroupBy
    extends StackItem
    implements IBIQueryExpressionGroupByRef {
        private Column column = null;
        private String tableReference = null;

        private AddGroupBy() {
        }

        private AddGroupBy(Column column, String tableReference) {
            this.column = column;
            this.tableReference = tableReference;
        }

        public Column getColumn() {
            return this.column;
        }

        public String getTableRef() {
            return this.tableReference;
        }
    }

    private class AddRowCount
    extends AddColumn
    implements IBIQueryExpressionSelectColumnRef {
        private AddRowCount() {
        }

        private AddRowCount(String tableReference, String columnReference) {
            super(tableReference, null, IBISQLAggregateFunction.COUNT, columnReference);
        }
    }

    private class AddColumn
    extends StackItem
    implements IBIQueryExpressionSelectColumnRef {
        private String tableReference = null;
        private Column column = null;
        private IBISQLAggregateFunction aggregateFunction = null;
        private String columnReference = null;

        private AddColumn() {
        }

        private AddColumn(String tableReference, Column column, IBISQLAggregateFunction aggregateFunction, String columnReference) {
            this.tableReference = tableReference;
            this.column = column;
            this.aggregateFunction = aggregateFunction;
            this.columnReference = columnReference;
        }

        public IBISQLAggregateFunction getAggr() {
            return this.aggregateFunction;
        }

        public Column getColumn() {
            return this.column;
        }

        public String getColumnRef() {
            return this.columnReference;
        }

        public String getTableRef() {
            return this.tableReference;
        }
    }

    private class StackItem {
        protected StackItem() {
        }
    }

    private static class WhereType {
        private final String type;
        public static final WhereType UNKNOWN = new WhereType("unknown");
        public static final WhereType SELOPT = new WhereType("SELECT-OPTIONS");
        public static final WhereType WHERE = new WhereType("WHERE condition");

        private WhereType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

