/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl.persistence;

import com.sap.ip.bi.sdk.dac.connector.IBIConnection;
import com.sap.ip.bi.sdk.dac.connector.IBIOlapObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.olap.BITreeOperator;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.CubeDimensionAssociation;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.Hierarchy;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.analysis.olap.LevelBasedHierarchy;
import org.omg.cwm.analysis.olap.Schema;
import org.omg.cwm.objectmodel.core.Attribute;
import org.omg.cwm.objectmodel.core.ModelElement;

public final class BIMetadata {
    private static final String makeId(String prefix, String[] names) {
        StringBuffer name = new StringBuffer(prefix);
        int i = 0;
        while (i < names.length) {
            name.append(':');
            if (names[i].indexOf(58) >= 0) {
                StringBuffer part = new StringBuffer(names[i]);
                int j = 0;
                while (j < part.length()) {
                    if (part.charAt(j) == ':' || part.charAt(j) == '\\') {
                        part.insert(j, "\\");
                        ++j;
                    }
                    ++j;
                }
                name.append(part.toString());
            } else {
                name.append(names[i]);
            }
            ++i;
        }
        return name.toString();
    }

    private static final String[] extractNames(String id, int expectedParts) {
        String[] names = null;
        if (id.indexOf(92) >= 0) {
            ArrayList<String> temp = new ArrayList<String>();
            int lowerLimit = 0;
            StringBuffer part = new StringBuffer(id);
            int j = 0;
            while (j < part.length()) {
                if (part.charAt(j) == '\\') {
                    part.deleteCharAt(j);
                } else if (part.charAt(j) == ':') {
                    temp.add(part.substring(lowerLimit, j));
                    lowerLimit = j + 1;
                } else if (j == part.length() - 1) {
                    temp.add(part.substring(lowerLimit, j + 1));
                }
                ++j;
            }
            names = temp.size() == expectedParts ? temp.toArray(new String[0]) : new String[]{};
        } else {
            StringTokenizer tok = new StringTokenizer(id, ":");
            if (tok.countTokens() != expectedParts) {
                names = new String[]{};
            } else {
                names = new String[expectedParts];
                int i = 0;
                while (tok.hasMoreTokens()) {
                    names[i] = tok.nextToken();
                    ++i;
                }
            }
        }
        return names;
    }

    public static final ModelElement decodeId(String id, IBIConnection connection) {
        Schema modelElement = null;
        String prefix = null;
        Object lengths = null;
        if (id.length() <= 3) {
            throw new RuntimeException();
        }
        prefix = id.substring(0, 3);
        if (prefix.equals(Type.SCHEMA)) {
            modelElement = BIMetadata.getSchema(id, connection);
        } else if (prefix.equals(Type.CUBE)) {
            modelElement = BIMetadata.getCube(id, connection);
        } else if (prefix.equals(Type.DIMENSION)) {
            modelElement = BIMetadata.getDimension(id, connection);
        } else if (prefix.equals(Type.HIERARCHY)) {
            modelElement = BIMetadata.getHierarchy(id, connection);
        } else if (prefix.equals(Type.LEVEL)) {
            modelElement = BIMetadata.getLevel(id, connection);
        } else if (prefix.equals(Type.MEMBER)) {
            modelElement = BIMetadata.getMember(id, connection);
        } else if (prefix.equals(Type.ATTRIBUTE)) {
            modelElement = BIMetadata.getAttribute(id, connection);
        }
        return modelElement;
    }

    public static final String getSchemaId(Schema schema) {
        String id = BIMetadata.makeId(Type.SCHEMA.toString(), new String[]{schema.getName()});
        return id;
    }

    public static final Schema getSchema(String id, IBIConnection connection) {
        Schema schema = null;
        try {
            IBIOlapObjectFinder finder = connection.getOlap().getObjectFinder();
            String[] names = BIMetadata.extractNames(id, 2);
            schema = finder.findSchemaFirst(names[1]);
        }
        catch (BIResourceException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return schema;
    }

    public static final String getCubeId(Cube cube) {
        String id = BIMetadata.makeId(Type.CUBE.toString(), new String[]{cube.getSchema().getName(), cube.getName()});
        return id;
    }

    public static final Cube getCube(String id, IBIConnection connection) {
        Cube cube = null;
        try {
            IBIOlapObjectFinder finder = connection.getOlap().getObjectFinder();
            String[] names = BIMetadata.extractNames(id, 3);
            cube = finder.findCubeFirst(names[1], names[2]);
        }
        catch (BIResourceException e) {
            e.printStackTrace();
        }
        return cube;
    }

    public static final String getDimensionId(Dimension dimension) {
        Cube cube = ((CubeDimensionAssociation)dimension.getCubeDimensionAssociation().iterator().next()).getCube();
        String id = BIMetadata.makeId(Type.DIMENSION.toString(), new String[]{dimension.getSchema().getName(), cube.getName(), dimension.getName()});
        return id;
    }

    public static final Dimension getDimension(String id, IBIConnection connection) {
        Dimension dimension = null;
        try {
            IBIOlapObjectFinder finder = connection.getOlap().getObjectFinder();
            String[] names = BIMetadata.extractNames(id, 4);
            dimension = finder.findDimensionFirst(names[1], names[2], names[3]);
        }
        catch (BIResourceException e) {
            e.printStackTrace();
        }
        return dimension;
    }

    public static final String getHierarchyId(Hierarchy hierarchy) {
        Cube cube = ((CubeDimensionAssociation)hierarchy.getDimension().getCubeDimensionAssociation().iterator().next()).getCube();
        String id = BIMetadata.makeId(Type.HIERARCHY.toString(), new String[]{cube.getSchema().getName(), cube.getName(), hierarchy.getDimension().getName(), hierarchy.getName()});
        return id;
    }

    public static final Hierarchy getHierarchy(String id, IBIConnection connection) {
        LevelBasedHierarchy hierarchy = null;
        try {
            IBIOlapObjectFinder finder = connection.getOlap().getObjectFinder();
            String[] names = BIMetadata.extractNames(id, 5);
            hierarchy = finder.findHierarchyFirst(names[1], names[2], names[3], names[4]);
        }
        catch (BIResourceException e) {
            e.printStackTrace();
        }
        return hierarchy;
    }

    public static final String getLevelId(Level level) {
        Cube cube = ((CubeDimensionAssociation)level.getDimension().getCubeDimensionAssociation().iterator().next()).getCube();
        String id = BIMetadata.makeId(Type.LEVEL.toString(), new String[]{cube.getSchema().getName(), cube.getName(), level.getDimension().getName(), level.getName()});
        return id;
    }

    public static final Level getLevel(String id, IBIConnection connection) {
        Level level = null;
        try {
            IBIOlapObjectFinder finder = connection.getOlap().getObjectFinder();
            String[] names = BIMetadata.extractNames(id, 5);
            level = finder.findLevelFirst(names[1], names[2], names[3], null, names[4]);
        }
        catch (BIResourceException e) {
            e.printStackTrace();
        }
        return level;
    }

    public static final String getMemberId(IBIMember member) {
        Cube cube = ((CubeDimensionAssociation)member.getDimension().getCubeDimensionAssociation().iterator().next()).getCube();
        String id = BIMetadata.makeId(Type.MEMBER.toString(), new String[]{cube.getSchema().getName(), cube.getName(), member.getDimension().getName(), member.getName()});
        return id;
    }

    public static final IBIMember getMember(String id, IBIConnection connection) {
        IBIMember member = null;
        try {
            IBIOlapObjectFinder finder = connection.getOlap().getObjectFinder();
            String[] names = BIMetadata.extractNames(id, 5);
            member = finder.findMemberFirst(names[1], names[2], names[3], null, null, names[4], BITreeOperator.SELF);
        }
        catch (BIResourceException e) {
            e.printStackTrace();
        }
        return member;
    }

    public static final String getAttributeId(Dimension dimension, Attribute attribute) {
        Cube cube = ((CubeDimensionAssociation)dimension.getCubeDimensionAssociation().iterator().next()).getCube();
        String id = BIMetadata.makeId(Type.ATTRIBUTE.toString(), new String[]{dimension.getSchema().getName(), cube.getName(), dimension.getName(), attribute.getName()});
        return id;
    }

    public static final Attribute getAttribute(String id, IBIConnection connection) {
        Attribute attribute = null;
        try {
            IBIOlapObjectFinder finder = connection.getOlap().getObjectFinder();
            String[] names = BIMetadata.extractNames(id, 5);
            Dimension dimension = finder.findDimensionFirst(names[1], names[2], names[3]);
            Iterator i = dimension.getFeature().iterator();
            while (i.hasNext()) {
                Attribute loopAttribute = (Attribute)i.next();
                if (!loopAttribute.getName().equals(names[4])) continue;
                attribute = loopAttribute;
                break;
            }
            attribute.getName();
        }
        catch (BIResourceException e) {
            e.printStackTrace();
        }
        return attribute;
    }

    public static final class Type {
        private final String type;
        public static final Type SCHEMA = new Type("SCH");
        public static final Type CUBE = new Type("CUB");
        public static final Type DIMENSION = new Type("DIM");
        public static final Type HIERARCHY = new Type("HIE");
        public static final Type LEVEL = new Type("LEV");
        public static final Type MEMBER = new Type("MEM");
        public static final Type ATTRIBUTE = new Type("ATT");

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

