/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util;

import com.sap.ip.bi.sdk.dac.olap.query.impl.factory.BIQueryFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BIName;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BIParserInfo;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BITaggedValues;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIOlapQueryRuntimeException;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.Hierarchy;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.objectmodel.core.Attribute;
import org.omg.cwm.objectmodel.core.CorePackage;
import org.omg.cwm.objectmodel.core.ModelElement;

public class BIUniqueName {
    private static final String[] mandatoryProperties = new String[]{"MEMBER_UNIQUE_NAME", "MEMBER_NAME", "MEMBER_CAPTION", "CATALOG_NAME", "SCHEMA_NAME", "CUBE_NAME", "DIMENSION_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "LEVEL_UNIQUE_NAME", "LEVEL_NUMBER", "MEMBER_TYPE", "MEMBER_GUID", "MEMBER_ORDINAL", "CHILDREN_CARDINALITY", "PARENT_LEVEL", "PARENT_UNIQUE_NAME", "PARENT_COUNT", "DESCRIPTION"};

    private BIUniqueName() {
    }

    public static String getUniqueName(Cube cube, BIParserInfo info) throws BIOlapQueryException {
        return BIName.getName(cube, info);
    }

    public static String getUniqueName(Dimension dimension, BIParserInfo info) throws BIOlapQueryException {
        return BIUniqueName.getUniqueNameInternal((ModelElement)dimension, info);
    }

    public static String getUniqueName(Hierarchy hierarchy, BIParserInfo info) throws BIOlapQueryException {
        return BIUniqueName.getUniqueNameInternal((ModelElement)hierarchy, info);
    }

    public static String getUniqueName(Level level, BIParserInfo info) throws BIOlapQueryException {
        return BIUniqueName.getUniqueNameInternal((ModelElement)level, info);
    }

    public static String getUniqueName(IBIMember member, BIParserInfo info) throws BIOlapQueryException {
        return BIUniqueName.getUniqueNameInternal((ModelElement)member, info);
    }

    public static String getUniqueName(Attribute attribute, BIParserInfo info) throws BIOlapQueryException {
        return BIUniqueName.getUniqueNameInternal((ModelElement)attribute, info);
    }

    private static String getUniqueNameInternal(ModelElement olapMetadataObject, BIParserInfo info) {
        CorePackage corePackage = ((BIQueryFactory)info.olap.getQueryFactory()).getCorePackage();
        String key = null;
        if (olapMetadataObject instanceof Dimension) {
            key = "DIMENSION_UNIQUE_NAME";
        } else if (olapMetadataObject instanceof Hierarchy) {
            key = "HIERARCHY_UNIQUE_NAME";
        } else if (olapMetadataObject instanceof Level) {
            key = "LEVEL_UNIQUE_NAME";
        } else if (olapMetadataObject instanceof IBIMember) {
            key = "MEMBER_UNIQUE_NAME";
        } else {
            if (olapMetadataObject instanceof Attribute) {
                Attribute attribute = (Attribute)olapMetadataObject;
                int i = 0;
                while (i < mandatoryProperties.length) {
                    if (attribute.getName().equals(mandatoryProperties[i])) {
                        return attribute.getName();
                    }
                    ++i;
                }
                String prefix = null;
                try {
                    prefix = BITaggedValues.getTaggedValue(olapMetadataObject, "LEVEL_UNIQUE_NAME", info);
                }
                catch (BIOlapQueryException e) {
                    prefix = null;
                }
                if (prefix == null || prefix.equals("")) {
                    try {
                        prefix = BITaggedValues.getTaggedValue(olapMetadataObject, "DIMENSION_UNIQUE_NAME", info);
                    }
                    catch (BIOlapQueryException e) {
                        throw new BIOlapQueryRuntimeException(info.locale, (Throwable)e);
                    }
                }
                String suffix = null;
                suffix = ((Attribute)olapMetadataObject).getName();
                if (suffix == null) {
                    try {
                        suffix = BITaggedValues.getTaggedValue(olapMetadataObject, "PROPERTY_NAME", info);
                    }
                    catch (BIOlapQueryException e) {
                        throw new BIOlapQueryRuntimeException(info.locale, (Throwable)e);
                    }
                }
                if (!suffix.startsWith("[") || !suffix.endsWith("]")) {
                    suffix = "[" + suffix + "]";
                }
                return prefix + "." + suffix;
            }
            throw new BIOlapQueryRuntimeException(info.locale, "sdk.dac.olap.query_1009", new Object[]{olapMetadataObject.toString()});
        }
        try {
            return BITaggedValues.getTaggedValue(olapMetadataObject, key, info);
        }
        catch (BIOlapQueryException e) {
            throw new BIOlapQueryRuntimeException(info.locale, "sdk.dac.olap.query_1010", new Object[]{"UNIQUE NAME", olapMetadataObject.toString()});
        }
    }
}

