/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub;

import com.sap.ip.bi.sdk.dac.olap.mdx.model.BIMdxModelUtilities;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxAxisSpecification;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxCellProps;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxCubeSpecification;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxFormulaSpecification;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxSelectStatement;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxSlicerSpecification;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.util.BIParserInfo;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIAxis;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIAxisDimension;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBICalculatedMember;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.impl.BIOlapQueryExceptionAssure;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BITrace;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BIQueryParser {
    private static final Category category = BILoggingSetup.QUERY.getCategory();
    private static final Location location = Location.getLocation((Class)(class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$BIQueryParser == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$BIQueryParser = BIQueryParser.class$("com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.BIQueryParser")) : class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$BIQueryParser));
    private static final BITrace trace = new BITrace(location);
    private static final BIOlapQueryExceptionAssure assure = new BIOlapQueryExceptionAssure(class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$BIQueryParser == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$BIQueryParser = BIQueryParser.class$("com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.BIQueryParser")) : class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$BIQueryParser, BILoggingSetup.QUERY.getCategory());
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$impl$mdx$sub$BIQueryParser;

    protected BIQueryParser() {
    }

    public IBIMdxSelectStatement parse(BIParserInfo info) throws BIOlapQueryException {
        IBIMdxSelectStatement iBIMdxSelectStatement;
        String method = "parse(BIParserInfo)";
        trace.enter("parse(BIParserInfo)", new Object[]{info});
        try {
            assure.notNull("parse(BIParserInfo)", info.locale, (Object)info);
            info.selectStatement = info.mdxFactory.createSelectStatement();
            info.selectStatement.setCellProps(this.createCellProps(info));
            info.selectStatement.setCubeSpecification(this.createCubeSpecification(info));
            info.selectStatement.setFormulaSpecification(this.createFormulaSpecification(info));
            info.selectStatement.setAxisSpecification(this.createAxisSpecification(info));
            info.selectStatement.setSlicerSpecification(this.createSlicerSpecification(info));
            iBIMdxSelectStatement = info.selectStatement;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMdxSelectStatement;
    }

    protected IBIMdxCubeSpecification createCubeSpecification(BIParserInfo info) throws BIOlapQueryException {
        IBIMdxCubeSpecification iBIMdxCubeSpecification;
        String method = "createCubeSpecification(BIParserInfo)";
        trace.enter("createCubeSpecification(BIParserInfo)", new Object[]{info});
        try {
            assure.notNull("createCubeSpecification(BIParserInfo)", info.locale, (Object)info);
            iBIMdxCubeSpecification = info.parserFactory.getMetadataParser().parse(info.query.getCube(), info);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMdxCubeSpecification;
    }

    protected IBIMdxCellProps createCellProps(BIParserInfo info) throws BIOlapQueryException {
        IBIMdxCellProps iBIMdxCellProps;
        String method = "createCellProps(BIParserInfo)";
        trace.enter("createCellProps(BIParserInfo)", new Object[]{info});
        try {
            assure.notNull("createCellProps(BIParserInfo)", info.locale, (Object)info);
            iBIMdxCellProps = BIMdxModelUtilities.createCellProps(true, true, true, true, info.mdxFactory, info.locale);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMdxCellProps;
    }

    protected List createAxisSpecification(BIParserInfo info) throws BIOlapQueryException {
        ArrayList<IBIMdxAxisSpecification> arrayList;
        String method = "createAxisSpecification(BIParserInfo)";
        trace.enter("createAxisSpecification(BIParserInfo)", new Object[]{info});
        try {
            assure.notNull("createAxisSpecification(BIParserInfo)", info.locale, (Object)info);
            ArrayList<IBIMdxAxisSpecification> axisSpecifications = new ArrayList<IBIMdxAxisSpecification>();
            int axisIndex = 0;
            Iterator iterator = info.query.getAxis().iterator();
            while (iterator.hasNext()) {
                IBIAxis axis;
                info.context.currentAxis = axis = (IBIAxis)iterator.next();
                IBIMdxAxisSpecification axisSpecification = info.parserFactory.getAxisParser().parse(axis, axisIndex, info);
                if (axisSpecification != null) {
                    axisSpecifications.add(axisSpecification);
                }
                ++axisIndex;
            }
            arrayList = axisSpecifications;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return arrayList;
    }

    protected IBIMdxSlicerSpecification createSlicerSpecification(BIParserInfo info) throws BIOlapQueryException {
        IBIMdxSlicerSpecification iBIMdxSlicerSpecification;
        String method = "createSlicerSpecification(BIParserInfo)";
        trace.enter("createSlicerSpecification(BIParserInfo)", new Object[]{info});
        try {
            assure.notNull("createSlicerSpecification(BIParserInfo)", info.locale, (Object)info);
            info.context.currentAxis = info.query.getSlicer();
            iBIMdxSlicerSpecification = info.parserFactory.getSlicerParser().parse(info.query.getSlicer(), info);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMdxSlicerSpecification;
    }

    protected IBIMdxFormulaSpecification createFormulaSpecification(BIParserInfo info) throws BIOlapQueryException {
        IBIMdxFormulaSpecification iBIMdxFormulaSpecification;
        String method = "createFormulaSpecification(BIParserInfo)";
        trace.enter("createFormulaSpecification(BIParserInfo)", new Object[]{info});
        try {
            assure.notNull("createFormulaSpecification(BIParserInfo)", info.locale, (Object)info);
            Iterator i = info.query.getAxis().iterator();
            while (i.hasNext()) {
                IBIAxis axis;
                info.context.currentAxis = axis = (IBIAxis)i.next();
                Iterator j = axis.getAxisDimension().iterator();
                while (j.hasNext()) {
                    IBIAxisDimension axisDimension;
                    info.context.currentAxisDimension = axisDimension = (IBIAxisDimension)j.next();
                    Iterator k = axisDimension.getCalculatedMember().iterator();
                    while (k.hasNext()) {
                        IBICalculatedMember calculatedMember = (IBICalculatedMember)k.next();
                        info.parserFactory.getMemberParser().parseCalculatedMember(calculatedMember, info);
                    }
                }
            }
            iBIMdxFormulaSpecification = info.selectStatement.getFormulaSpecification();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMdxFormulaSpecification;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

