/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl.factory;

import com.sap.ip.bi.sdk.dac.olap.query.main.IBIIdentifiable;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public final class BIIdLabelGenerator {
    private static final Map numberRanges = new HashMap();
    private static final DecimalFormat decimalFormat = new DecimalFormat("000000");

    private BIIdLabelGenerator() {
    }

    private static final String getNumberAsString(Class clazz) {
        long index = 0L;
        DecimalFormat decimalFormat = BIIdLabelGenerator.decimalFormat;
        synchronized (decimalFormat) {
            if (!numberRanges.containsKey(clazz)) {
                numberRanges.put(clazz, new NumberRange());
            }
            index = ((NumberRange)numberRanges.get(clazz)).getNext();
        }
        return BIIdLabelGenerator.decimalFormat.format(index);
    }

    public static final void setIdLabel(IBIIdentifiable identifiable) {
        String fullyQualifiedName = identifiable.getClass().getName();
        String packageName = identifiable.getClass().getPackage().getName();
        String onlyClassName = fullyQualifiedName.substring(packageName.length() + 1);
        identifiable.setId(onlyClassName + "_" + BIIdLabelGenerator.getNumberAsString(identifiable.getClass()));
        identifiable.setLabel(onlyClassName);
        identifiable.setDescription("");
    }

    private static final class NumberRange {
        private long index = 0L;

        private NumberRange() {
        }

        public long getNext() {
            return ++this.index;
        }
    }
}

