/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.query.impl;

import com.sap.ip.bi.sdk.dac.olap.query.IBICommandProcessor;
import com.sap.ip.bi.sdk.dac.olap.query.IBIQueryFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.BICommandInfo;
import com.sap.ip.bi.sdk.dac.olap.query.impl.BICommandUtils;
import com.sap.ip.bi.sdk.dac.olap.query.impl.QueryExecuterImpl;
import com.sap.ip.bi.sdk.dac.olap.query.impl.factory.BIQueryFactory;
import com.sap.ip.bi.sdk.dac.olap.query.input.IBIInputReference;
import com.sap.ip.bi.sdk.dac.olap.query.input.IBILiteralReference;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIAxis;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIAxisDimension;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIMemberSet;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIQuery;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBISetExpression;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBITupleSet;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBICalculatedMember;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBICompositeMemberSetExpression;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIConditionBasedFilter;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIDimensionMembers;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBILevelMembers;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIMemberDrill;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIMemberList;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIMemberSetExpression;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBIRankingFilter;
import com.sap.ip.bi.sdk.dac.olap.query.msx.IBISort;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBITuple;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBITupleDrill;
import com.sap.ip.bi.sdk.dac.olap.query.tsx.IBITupleSetExpression;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIDrillDirectionType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIDrillDirectionTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIJoinType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIJoinTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIRankType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIRankTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIRelationalOperatorType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIRelationalOperatorTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISapRangeSignType;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISapRangeSignTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISapVariableSelectionTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISortDirectionType;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapHierarchyValue;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapHierarchyVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapMemberValueRange;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapMemberVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapNumericValueRange;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapNumericVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariable;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapVariableValue;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIOlapQueryRuntimeException;
import com.sap.ip.bi.sdk.exception.impl.BIOlapQueryExceptionAssure;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BIAssure;
import com.sap.ip.bi.sdk.util.impl.BITrace;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.resource.ResourceException;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.Hierarchy;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.objectmodel.core.Attribute;
import org.omg.cwm.objectmodel.instance.Instance;
import org.omg.cwm.objectmodel.instance.Object;
import org.omg.cwm.objectmodel.instance.Slot;

public final class BICommandProcessor
implements IBICommandProcessor {
    private static final Category category = BILoggingSetup.QUERY.getCategory();
    private static final Location location = Location.getLocation((Class)(class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandProcessor == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandProcessor = BICommandProcessor.class$("com.sap.ip.bi.sdk.dac.olap.query.impl.BICommandProcessor")) : class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandProcessor));
    private static final BITrace trace = new BITrace(location);
    private static final BIOlapQueryExceptionAssure assure = new BIOlapQueryExceptionAssure(class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandProcessor == null ? (class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandProcessor = BICommandProcessor.class$("com.sap.ip.bi.sdk.dac.olap.query.impl.BICommandProcessor")) : class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandProcessor, BILoggingSetup.QUERY.getCategory());
    private static final QueryExecuterImpl queryExecuterImpl = new QueryExecuterImpl();
    private final BICommandInfo info;
    private final Locale locale;
    private List sapVariables = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$olap$query$impl$BICommandProcessor;

    BICommandProcessor(IBIQuery query, IBIQueryFactory queryFactory) throws BIOlapQueryException {
        String method = "BICommandProcessor(IBIQuery, IBIQueryFactory)";
        trace.enter("BICommandProcessor(IBIQuery, IBIQueryFactory)", new java.lang.Object[]{query, queryFactory});
        try {
            assure.notNull("BICommandProcessor(IBIQuery, IBIQueryFactory)", Locale.getDefault(), (java.lang.Object)query, (java.lang.Object)queryFactory);
            this.info = new BICommandInfo();
            this.info.query = query;
            try {
                this.info.locale = queryExecuterImpl.getInternalMemory(query).getOlapQueryResultProcessor().getConnectionInfo().getLocale();
                this.info.user = queryExecuterImpl.getInternalMemory(query).getOlapQueryResultProcessor().getConnectionInfo().getUser();
            }
            catch (ResourceException e) {
                throw new BIOlapQueryRuntimeException(Locale.getDefault(), (Throwable)e);
            }
            this.locale = this.info.locale;
            this.info.queryFactory = queryFactory;
            this.info.queryPackages = ((BIQueryFactory)queryFactory).getQueryPackages();
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized IBIDimensionMembers addDimensionMembers(Dimension dimension) throws BIOlapQueryException {
        IBIDimensionMembers iBIDimensionMembers;
        String method = "addDimensionMembers(Dimension)";
        trace.enter("addDimensionMembers(Dimension)", new java.lang.Object[]{dimension});
        try {
            assure.notNull("addDimensionMembers(Dimension)", this.locale, (java.lang.Object)dimension);
            IBIDimensionMembers dimensionMembers = this.info.queryFactory.getMemberSetFactory().createDimensionMembers(dimension, (IBIJoinType)IBIJoinTypeEnum.APPEND);
            List steps = BICommandUtils.getAxisDimension((Dimension)dimension, (boolean)true, (BICommandInfo)this.info).axisDimension.getMemberSet().getMemberSetExpression();
            BICommandUtils.addNoneSortStep((IBISetExpression)dimensionMembers, steps, this.info);
            iBIDimensionMembers = dimensionMembers;
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIDimensionMembers;
    }

    public synchronized IBILevelMembers addLevelMembers(Level level) throws BIOlapQueryException {
        IBILevelMembers iBILevelMembers;
        String method = "addLevelMembers(Level)";
        trace.enter("addLevelMembers(Level)", new java.lang.Object[]{level});
        try {
            assure.notNull("addLevelMembers(Level)", this.locale, (java.lang.Object)level);
            IBILevelMembers levelMembers = this.info.queryFactory.getMemberSetFactory().createLevelMembers(level, (IBIJoinType)IBIJoinTypeEnum.APPEND);
            List steps = BICommandUtils.getAxisDimension((Dimension)level.getDimension(), (boolean)true, (BICommandInfo)this.info).axisDimension.getMemberSet().getMemberSetExpression();
            BICommandUtils.addNoneSortStep((IBISetExpression)levelMembers, steps, this.info);
            iBILevelMembers = levelMembers;
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBILevelMembers;
    }

    public synchronized void addMember(IBIMember member) throws BIOlapQueryException {
        String method = "addMember(IBIMember)";
        trace.enter("addMember(IBIMember)", new java.lang.Object[]{member});
        try {
            assure.notNull("addMember(IBIMember)", this.locale, (java.lang.Object)member);
            IBIMemberList memberList = null;
            List steps = BICommandUtils.getAxisDimension((Dimension)member.getDimension(), (boolean)true, (BICommandInfo)this.info).axisDimension.getMemberSet().getMemberSetExpression();
            IBISetExpression setExpression = BICommandUtils.getLastNoneSortStep(steps, this.info);
            if (setExpression != null && setExpression instanceof IBIMemberList) {
                memberList = (IBIMemberList)setExpression;
                memberList.getMember().add(member);
            } else {
                ArrayList<IBIMember> members = new ArrayList<IBIMember>();
                members.add(member);
                memberList = this.info.queryFactory.getMemberSetFactory().createMemberList(members, (IBIJoinType)IBIJoinTypeEnum.APPEND);
                BICommandUtils.addNoneSortStep((IBISetExpression)memberList, steps, this.info);
            }
            java.lang.Object var8_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized IBICalculatedMember addCalculatedMember(Dimension dimension, IBIInputReference formula, int solveOrder) throws BIOlapQueryException {
        IBICalculatedMember iBICalculatedMember;
        String method = "addCalculatedMember(Dimension, IBIInputReference, int)";
        trace.enter("addCalculatedMember(Dimension, IBIInputReference, int)", new java.lang.Object[]{dimension, formula, new Integer(solveOrder)});
        try {
            assure.notNull("addCalculatedMember(Dimension, IBIInputReference, int)", this.locale, (java.lang.Object)dimension, (java.lang.Object)formula, (java.lang.Object)BIAssure.IGNORE);
            IBICalculatedMember calculatedMember = this.info.queryFactory.getMemberFactory().createCalculatedMember(dimension, formula, solveOrder);
            this.addMember((IBIMember)calculatedMember);
            this.getAxisDimension(dimension).getCalculatedMember().add(calculatedMember);
            iBICalculatedMember = calculatedMember;
            java.lang.Object var8_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBICalculatedMember;
    }

    public synchronized void addMemberList(IBIMemberList memberList) throws BIOlapQueryException {
        String method = "addMemberList(IBIMemberList)";
        trace.enter("addMemberList(IBIMemberList)", new java.lang.Object[]{memberList});
        try {
            assure.notNull("addMemberList(IBIMemberList)", this.locale, (java.lang.Object)memberList);
            if (memberList.getMember().size() > 0) {
                IBIMember member = (IBIMember)memberList.getMember().get(0);
                List steps = BICommandUtils.getAxisDimension((Dimension)member.getDimension(), (boolean)true, (BICommandInfo)this.info).axisDimension.getMemberSet().getMemberSetExpression();
                BICommandUtils.addNoneSortStep((IBISetExpression)memberList, steps, this.info);
            }
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void clearMemberSet(Dimension dimension) throws BIOlapQueryException {
        String method = "clearMemberSet(Dimension)";
        trace.enter("clearMemberSet(Dimension)", new java.lang.Object[]{dimension});
        try {
            assure.notNull("clearMemberSet(Dimension)", this.locale, (java.lang.Object)dimension);
            BICommandUtils.getAxisDimension((Dimension)dimension, (boolean)true, (BICommandInfo)this.info).axisDimension.getMemberSet().getMemberSetExpression().clear();
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized IBIRankingFilter createBottomCountFilter(Dimension dimension, int bottomValue, IBIMember measure) throws BIOlapQueryException {
        IBIRankingFilter iBIRankingFilter;
        String method = "createBottomCountFilter(Dimension, int, IBIMember)";
        trace.enter("createBottomCountFilter(Dimension, int, IBIMember)", new java.lang.Object[]{dimension, new Integer(bottomValue), measure});
        try {
            assure.notNull("createBottomCountFilter(Dimension, int, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            IBILiteralReference value = this.info.queryFactory.getInputFactory().createLiteralReference(new Integer(bottomValue));
            iBIRankingFilter = BICommandUtils.createRankingFilter(dimension, value, measure, (IBIRankType)IBIRankTypeEnum.BOTTOMCOUNT, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var8_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIRankingFilter;
    }

    public synchronized IBIRankingFilter createBottomPercentFilter(Dimension dimension, double bottomPercentage, IBIMember measure) throws BIOlapQueryException {
        IBIRankingFilter iBIRankingFilter;
        String method = "createBottomPercentFilter(Dimension, double, IBIMember)";
        trace.enter("createBottomPercentFilter(Dimension, double, IBIMember)", new java.lang.Object[]{dimension, new Double(bottomPercentage), measure});
        try {
            assure.notNull("createBottomPercentFilter(Dimension, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            IBILiteralReference value = this.info.queryFactory.getInputFactory().createLiteralReference(new Double(bottomPercentage));
            iBIRankingFilter = BICommandUtils.createRankingFilter(dimension, value, measure, (IBIRankType)IBIRankTypeEnum.BOTTOMPERCENT, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var9_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var9_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIRankingFilter;
    }

    public synchronized IBIRankingFilter createBottomSumFilter(Dimension dimension, double threshold, IBIMember measure) throws BIOlapQueryException {
        IBIRankingFilter iBIRankingFilter;
        String method = "createBottomSumFilter(Dimension, double, IBIMember)";
        trace.enter("createBottomSumFilter(Dimension, double, IBIMember)", new java.lang.Object[]{dimension, new Double(threshold), measure});
        try {
            assure.notNull("createBottomSumFilter(Dimension, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            IBILiteralReference value = this.info.queryFactory.getInputFactory().createLiteralReference(new Double(threshold));
            iBIRankingFilter = BICommandUtils.createRankingFilter(dimension, value, measure, (IBIRankType)IBIRankTypeEnum.BOTTOMSUM, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var9_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var9_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIRankingFilter;
    }

    public synchronized IBIConditionBasedFilter createSearchFilterEqual(Dimension dimension, double searchValue, IBIMember measure) throws BIOlapQueryException {
        IBIConditionBasedFilter iBIConditionBasedFilter;
        String method = "createSearchFilterEqual(Dimension, double, IBIMember)";
        trace.enter("createSearchFilterEqual(Dimension, double, IBIMember)", new java.lang.Object[]{dimension, new Double(searchValue), measure});
        try {
            assure.notNull("createSearchFilterEqual(Dimension, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            iBIConditionBasedFilter = BICommandUtils.createConditionBasedFilter(dimension, searchValue, 0.0, measure, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.EQUAL, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var8_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIConditionBasedFilter;
    }

    public synchronized IBIConditionBasedFilter createSearchFilterGreaterThan(Dimension dimension, double lowerLimit, IBIMember measure) throws BIOlapQueryException {
        IBIConditionBasedFilter iBIConditionBasedFilter;
        String method = "createSearchFilterGreaterThan(Dimension, double, IBIMember)";
        trace.enter("createSearchFilterGreaterThan(Dimension, double, IBIMember)", new java.lang.Object[]{dimension, new Double(lowerLimit), measure});
        try {
            assure.notNull("createSearchFilterGreaterThan(Dimension, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            iBIConditionBasedFilter = BICommandUtils.createConditionBasedFilter(dimension, lowerLimit, 0.0, measure, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.GREATERTHAN, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var8_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIConditionBasedFilter;
    }

    public synchronized IBIConditionBasedFilter createSearchFilterGreaterThanEqual(Dimension dimension, double lowerLimit, IBIMember measure) throws BIOlapQueryException {
        IBIConditionBasedFilter iBIConditionBasedFilter;
        String method = "createSearchFilterGreaterThanEqual(Dimension, double, IBIMember)";
        trace.enter("createSearchFilterGreaterThanEqual(Dimension, double, IBIMember)", new java.lang.Object[]{dimension, new Double(lowerLimit), measure});
        try {
            assure.notNull("createSearchFilterGreaterThanEqual(Dimension, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            iBIConditionBasedFilter = BICommandUtils.createConditionBasedFilter(dimension, lowerLimit, 0.0, measure, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.GREATERTHANEQUAL, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var8_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIConditionBasedFilter;
    }

    public synchronized IBIConditionBasedFilter createSearchFilterLessThan(Dimension dimension, double upperLimit, IBIMember measure) throws BIOlapQueryException {
        IBIConditionBasedFilter iBIConditionBasedFilter;
        String method = "createSearchFilterLessThan(Dimension, double, IBIMember)";
        trace.enter("createSearchFilterLessThan(Dimension, double, IBIMember)", new java.lang.Object[]{dimension, new Double(upperLimit), measure});
        try {
            assure.notNull("createSearchFilterLessThan(Dimension, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            iBIConditionBasedFilter = BICommandUtils.createConditionBasedFilter(dimension, upperLimit, 0.0, measure, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.LESSTHAN, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var8_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIConditionBasedFilter;
    }

    public synchronized IBIConditionBasedFilter createSearchFilterLessThanEqual(Dimension dimension, double upperLimit, IBIMember measure) throws BIOlapQueryException {
        IBIConditionBasedFilter iBIConditionBasedFilter;
        String method = "createSearchFilterLessThanEqual(Dimension, double, IBIMember)";
        trace.enter("createSearchFilterLessThanEqual(Dimension, double, IBIMember)", new java.lang.Object[]{dimension, new Double(upperLimit), measure});
        try {
            assure.notNull("createSearchFilterLessThanEqual(Dimension, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            iBIConditionBasedFilter = BICommandUtils.createConditionBasedFilter(dimension, upperLimit, 0.0, measure, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.LESSTHANEQUAL, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var8_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIConditionBasedFilter;
    }

    public synchronized IBIConditionBasedFilter createSearchFilterNotEqual(Dimension dimension, double searchValue, IBIMember measure) throws BIOlapQueryException {
        IBIConditionBasedFilter iBIConditionBasedFilter;
        String method = "createSearchFilterNotEqual(Dimension, double, IBIMember)";
        trace.enter("createSearchFilterNotEqual(Dimension, double, IBIMember)", new java.lang.Object[]{dimension, new Double(searchValue), measure});
        try {
            assure.notNull("createSearchFilterNotEqual(Dimension, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            iBIConditionBasedFilter = BICommandUtils.createConditionBasedFilter(dimension, searchValue, 0.0, measure, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.NOTEQUAL, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var8_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIConditionBasedFilter;
    }

    public synchronized IBIConditionBasedFilter createSearchFilterBetween(Dimension dimension, double lowerLimit, double upperLimit, IBIMember measure) throws BIOlapQueryException {
        IBIConditionBasedFilter iBIConditionBasedFilter;
        String method = "createSearchFilterBetween(Dimension, double, double, IBIMember)";
        trace.enter("createSearchFilterBetween(Dimension, double, double, IBIMember)", new java.lang.Object[]{dimension, new Double(lowerLimit), new Double(upperLimit), measure});
        try {
            assure.notNull("createSearchFilterBetween(Dimension, double, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            iBIConditionBasedFilter = BICommandUtils.createConditionBasedFilter(dimension, lowerLimit, upperLimit, measure, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.BETWEEN, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var10_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var10_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIConditionBasedFilter;
    }

    public synchronized IBIRankingFilter createTopCountFilter(Dimension dimension, int topValue, IBIMember measure) throws BIOlapQueryException {
        IBIRankingFilter iBIRankingFilter;
        String method = "createTopCountFilter(Dimension, int, IBIMember)";
        trace.enter("createTopCountFilter(Dimension, int, IBIMember)", new java.lang.Object[]{dimension, new Integer(topValue), measure});
        try {
            assure.notNull("createTopCountFilter(Dimension, int, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            IBILiteralReference value = this.info.queryFactory.getInputFactory().createLiteralReference(new Integer(topValue));
            iBIRankingFilter = BICommandUtils.createRankingFilter(dimension, value, measure, (IBIRankType)IBIRankTypeEnum.TOPCOUNT, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var8_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIRankingFilter;
    }

    public synchronized IBIRankingFilter createTopPercentFilter(Dimension dimension, double topPercentage, IBIMember measure) throws BIOlapQueryException {
        IBIRankingFilter iBIRankingFilter;
        String method = "createTopPercentFilter(Dimension, double, IBIMember)";
        trace.enter("createTopPercentFilter(Dimension, double, IBIMember)", new java.lang.Object[]{dimension, new Double(topPercentage), measure});
        try {
            assure.notNull("createTopPercentFilter(Dimension, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            IBILiteralReference value = this.info.queryFactory.getInputFactory().createLiteralReference(new Double(topPercentage));
            iBIRankingFilter = BICommandUtils.createRankingFilter(dimension, value, measure, (IBIRankType)IBIRankTypeEnum.TOPPERCENT, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var9_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var9_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIRankingFilter;
    }

    public synchronized IBIRankingFilter createTopSumFilter(Dimension dimension, double threshold, IBIMember measure) throws BIOlapQueryException {
        IBIRankingFilter iBIRankingFilter;
        String method = "createTopSumFilter(Dimension, double, IBIMember)";
        trace.enter("createTopSumFilter(Dimension, double, IBIMember)", new java.lang.Object[]{dimension, new Double(threshold), measure});
        try {
            assure.notNull("createTopSumFilter(Dimension, double, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            IBILiteralReference value = this.info.queryFactory.getInputFactory().createLiteralReference(new Double(threshold));
            iBIRankingFilter = BICommandUtils.createRankingFilter(dimension, value, measure, (IBIRankType)IBIRankTypeEnum.TOPSUM, (IBIJoinType)IBIJoinTypeEnum.INITIAL, this.info);
            java.lang.Object var9_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var9_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIRankingFilter;
    }

    public synchronized void deselectAttribute(Dimension dimension, Attribute attribute) throws BIOlapQueryException {
        String method = "deselectAttribute(Dimension, Attribute)";
        trace.enter("deselectAttribute(Dimension, Attribute)", new java.lang.Object[]{dimension, attribute});
        try {
            assure.notNull("deselectAttribute(Dimension, Attribute)", this.locale, (java.lang.Object)dimension, (java.lang.Object)attribute);
            Collection attributes = BICommandUtils.getAxisDimension((Dimension)dimension, (boolean)true, (BICommandInfo)this.info).axisDimension.getSelectedAttribute();
            if (attributes.contains(attribute)) {
                attributes.remove(attribute);
            }
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized IBIMemberDrill drillDownMember(IBIMember member) throws BIOlapQueryException {
        IBIMemberDrill iBIMemberDrill;
        String method = "drillDownMember(IBIMember)";
        trace.enter("drillDownMember(IBIMember)", new java.lang.Object[]{member});
        try {
            assure.notNull("drillDownMember(IBIMember)", this.locale, (java.lang.Object)member);
            IBIAxisDimension axisDimension = BICommandUtils.getAxisDimension((Dimension)member.getDimension(), (boolean)true, (BICommandInfo)this.info).axisDimension;
            IBIMemberDrill memberDrill = this.info.queryFactory.getMemberSetFactory().createMemberDrill(member, (IBIDrillDirectionType)IBIDrillDirectionTypeEnum.DOWN, false);
            BICommandUtils.addNoneSortStep((IBISetExpression)memberDrill, axisDimension.getMemberSet().getMemberSetExpression(), this.info);
            iBIMemberDrill = memberDrill;
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMemberDrill;
    }

    public synchronized IBIMemberDrill drillUpMember(IBIMember member) throws BIOlapQueryException {
        IBIMemberDrill iBIMemberDrill;
        String method = "drillUpMember(IBIMember)";
        trace.enter("drillUpMember(IBIMember)", new java.lang.Object[]{member});
        try {
            assure.notNull("drillUpMember(IBIMember)", this.locale, (java.lang.Object)member);
            IBIAxisDimension axisDimension = BICommandUtils.getAxisDimension((Dimension)member.getDimension(), (boolean)true, (BICommandInfo)this.info).axisDimension;
            IBIMemberDrill memberDrill = this.info.queryFactory.getMemberSetFactory().createMemberDrill(member, (IBIDrillDirectionType)IBIDrillDirectionTypeEnum.UP, false);
            BICommandUtils.addNoneSortStep((IBISetExpression)memberDrill, axisDimension.getMemberSet().getMemberSetExpression(), this.info);
            iBIMemberDrill = memberDrill;
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMemberDrill;
    }

    public synchronized List getMemberSetExpression(Dimension dimension) throws BIOlapQueryException {
        List list;
        String method = "getMemberSetExpression(Dimension)";
        trace.enter("getMemberSetExpression(Dimension)", new java.lang.Object[]{dimension});
        try {
            assure.notNull("getMemberSetExpression(Dimension)", this.locale, (java.lang.Object)dimension);
            BICommandUtils.AxisDimensionInfo axisDimensionInfo = BICommandUtils.getAxisDimension(dimension, true, this.info);
            IBIAxisDimension axisDimension = axisDimensionInfo.axisDimension;
            list = axisDimension.getMemberSet().getMemberSetExpression();
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return list;
    }

    public List getTupleSetExpression(int axisIndex) throws BIOlapQueryException {
        List list;
        String method = "getTupleSetExpression(int)";
        trace.enter("getTupleSetExpression(int)", new java.lang.Object[]{new Integer(axisIndex)});
        try {
            assure.notNull("getTupleSetExpression(int)", this.locale, (java.lang.Object)BIAssure.IGNORE);
            List axes = this.info.query.getAxis();
            IBIAxis axis = null;
            if (axisIndex == -1) {
                axis = this.info.query.getSlicer();
            } else if (axisIndex < axes.size()) {
                axis = (IBIAxis)axes.get(axisIndex);
            } else {
                throw new BIOlapQueryRuntimeException(this.info.locale, "sdk.dac.olap.query_2004", new java.lang.Object[]{new Integer(axisIndex), this.info.query.getLabel()});
            }
            list = axis.getTupleSet().getTupleSetExpression();
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return list;
    }

    public synchronized IBICompositeMemberSetExpression moveMemberSetExpressionsToComposite(Dimension dimension, IBIJoinType joinType, boolean addCompositeToMemberSet) throws BIOlapQueryException {
        IBICompositeMemberSetExpression iBICompositeMemberSetExpression;
        String method = "moveMemberSetExpressionsToComposite(Dimension, boolean)";
        trace.enter("moveMemberSetExpressionsToComposite(Dimension, boolean)", new java.lang.Object[]{dimension, new Boolean(addCompositeToMemberSet)});
        try {
            assure.notNull("moveMemberSetExpressionsToComposite(Dimension, boolean)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE);
            IBICompositeMemberSetExpression compositeMemberSetExpression = this.info.queryFactory.getMemberSetFactory().createCompositeMemberSetExpression(joinType);
            BICommandUtils.AxisDimensionInfo axisDimensionInfo = BICommandUtils.getAxisDimension(dimension, true, this.info);
            IBIAxisDimension axisDimension = axisDimensionInfo.axisDimension;
            List memberSetExpressions = axisDimension.getMemberSet().getMemberSetExpression();
            compositeMemberSetExpression.getMemberSetExpression().addAll(memberSetExpressions);
            memberSetExpressions.clear();
            if (addCompositeToMemberSet) {
                axisDimension.getMemberSet().getMemberSetExpression().add(compositeMemberSetExpression);
            }
            iBICompositeMemberSetExpression = compositeMemberSetExpression;
            java.lang.Object var11_10 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var11_11 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBICompositeMemberSetExpression;
    }

    public synchronized IBISort getSortOrder(Dimension dimension) throws BIOlapQueryException {
        IBISort iBISort;
        String method = "getSortOrder(Dimension)";
        trace.enter("getSortOrder(Dimension)", new java.lang.Object[]{dimension});
        try {
            assure.notNull("getSortOrder(Dimension)", this.locale, (java.lang.Object)dimension);
            iBISort = BICommandUtils.getSort(dimension, this.info);
            java.lang.Object var5_4 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var5_5 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBISort;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean isSuppressingEmptyColumns() {
        boolean bl;
        block4: {
            boolean bl2;
            block3: {
                String method = "isSuppressingEmptyColumns()";
                trace.enter("isSuppressingEmptyColumns()");
                try {
                    if (this.info.query.getAxis().size() >= 1) {
                        IBIAxis axis = (IBIAxis)this.info.query.getAxis().get(0);
                        bl2 = axis.isSupressingEmptyTuples();
                        java.lang.Object var5_5 = null;
                        break block3;
                    }
                    bl = false;
                    break block4;
                }
                catch (Throwable throwable) {
                    java.lang.Object var5_7 = null;
                    trace.exit();
                    throw throwable;
                }
            }
            trace.exit();
            return bl2;
        }
        java.lang.Object var5_6 = null;
        trace.exit();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean isSuppressingEmptyRows() {
        boolean bl;
        block4: {
            boolean bl2;
            block3: {
                String method = "isSuppressingEmptyRows()";
                trace.enter("isSuppressingEmptyRows()");
                try {
                    if (this.info.query.getAxis().size() >= 2) {
                        IBIAxis axis = (IBIAxis)this.info.query.getAxis().get(1);
                        bl2 = axis.isSupressingEmptyTuples();
                        java.lang.Object var5_5 = null;
                        break block3;
                    }
                    bl = false;
                    break block4;
                }
                catch (Throwable throwable) {
                    java.lang.Object var5_7 = null;
                    trace.exit();
                    throw throwable;
                }
            }
            trace.exit();
            return bl2;
        }
        java.lang.Object var5_6 = null;
        trace.exit();
        return bl;
    }

    public synchronized void moveDimension(Dimension dimension, int axisIndex, int positionIndex) throws BIOlapQueryException {
        String method = "moveDimension(Dimension, int, int)";
        trace.enter("moveDimension(Dimension, int, int)", new java.lang.Object[]{dimension, new Integer(axisIndex), new Integer(positionIndex)});
        try {
            assure.notNull("moveDimension(Dimension, int, int)", this.locale, (java.lang.Object)dimension, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)BIAssure.IGNORE);
            BICommandUtils.moveDimension(dimension, axisIndex, positionIndex, this.info);
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void moveDimensionToColumns(Dimension dimension) throws BIOlapQueryException {
        String method = "moveDimensionToColumns(Dimension)";
        trace.enter("moveDimensionToColumns(Dimension)", new java.lang.Object[]{dimension});
        try {
            assure.notNull("moveDimensionToColumns(Dimension)", this.locale, (java.lang.Object)dimension);
            BICommandUtils.moveDimension(dimension, 0, -1, this.info);
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void moveDimensionToRows(Dimension dimension) throws BIOlapQueryException {
        String method = "moveDimensionToRows(Dimension)";
        trace.enter("moveDimensionToRows(Dimension)", new java.lang.Object[]{dimension});
        try {
            assure.notNull("moveDimensionToRows(Dimension)", this.locale, (java.lang.Object)dimension);
            BICommandUtils.moveDimension(dimension, 1, -1, this.info);
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void moveDimensionToSlicer(Dimension dimension) throws BIOlapQueryException {
        String method = "moveDimensionToSlicer(Dimension)";
        trace.enter("moveDimensionToSlicer(Dimension)", new java.lang.Object[]{dimension});
        try {
            assure.notNull("moveDimensionToSlicer(Dimension)", this.locale, (java.lang.Object)dimension);
            BICommandUtils.moveDimension(dimension, -1, -1, this.info);
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void removeSetExpression(IBISetExpression setExpression) throws BIOlapQueryException {
        String method = "removeSetExpression(IBISetExpression)";
        trace.enter("removeSetExpression(IBISetExpression)", new java.lang.Object[]{setExpression});
        try {
            IBITupleSet tupleSet;
            assure.notNull("removeSetExpression(IBISetExpression)", this.locale, (java.lang.Object)setExpression);
            if (setExpression instanceof IBIMemberSetExpression) {
                IBIMemberSet memberSet = ((IBIMemberSetExpression)setExpression).getMemberSet();
                if (memberSet != null) {
                    memberSet.getMemberSetExpression().remove(setExpression);
                }
            } else if (setExpression instanceof IBITupleSetExpression && (tupleSet = ((IBITupleSetExpression)setExpression).getTupleSet()) != null) {
                tupleSet.getTupleSetExpression().remove(setExpression);
            }
            java.lang.Object var5_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var5_6 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void revealEmptyColumns() {
        String method = "revealEmptyColumns()";
        trace.enter("revealEmptyColumns()");
        try {
            if (this.info.query.getAxis().size() >= 1) {
                IBIAxis axis = (IBIAxis)this.info.query.getAxis().get(0);
                axis.setSupressingEmptyTuples(false);
            }
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void revealEmptyRows() {
        String method = "revealEmptyRows()";
        trace.enter("revealEmptyRows()");
        try {
            if (this.info.query.getAxis().size() >= 2) {
                IBIAxis axis = (IBIAxis)this.info.query.getAxis().get(1);
                axis.setSupressingEmptyTuples(false);
            }
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void selectAttribute(Dimension dimension, Attribute attribute) throws BIOlapQueryException {
        String method = "selectAttribute(Dimension, Attribute)";
        trace.enter("selectAttribute(Dimension, Attribute)", new java.lang.Object[]{dimension, attribute});
        try {
            assure.notNull("selectAttribute(Dimension, Attribute)", this.locale, (java.lang.Object)dimension, (java.lang.Object)attribute);
            Collection attributes = BICommandUtils.getAxisDimension((Dimension)dimension, (boolean)true, (BICommandInfo)this.info).axisDimension.getSelectedAttribute();
            if (!attributes.contains(attribute)) {
                attributes.add(attribute);
            }
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void setInitialState() {
        String method = "setInitialState()";
        trace.enter("setInitialState()");
        try {
            BICommandUtils.setInitialState(this.info);
            java.lang.Object var3_2 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var3_3 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized IBISort setOrderByAttribute(Dimension dimension, IBISortDirectionType sortDirection, boolean breakingHierarchy, Attribute attribute) throws BIOlapQueryException {
        IBISort iBISort;
        String method = "setOrderByAttribute(Dimension, IBISortDirectionType, boolean, Attribute)";
        trace.enter("setOrderByAttribute(Dimension, IBISortDirectionType, boolean, Attribute)", new java.lang.Object[]{dimension, sortDirection, new Boolean(breakingHierarchy), attribute});
        try {
            assure.notNull("setOrderByAttribute(Dimension, IBISortDirectionType, boolean, Attribute)", this.locale, (java.lang.Object)dimension, (java.lang.Object)sortDirection, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)attribute);
            iBISort = BICommandUtils.setSortStep(dimension, sortDirection, breakingHierarchy, null, attribute, this.info);
            java.lang.Object var8_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBISort;
    }

    public synchronized IBISort setOrderByMeasureValue(Dimension dimension, IBISortDirectionType sortDirection, boolean breakingHierarchy, IBIMember measure) throws BIOlapQueryException {
        IBISort iBISort;
        String method = "setOrderByMeasureValue(Dimension, IBISortDirectionType, boolean, IBIMember)";
        trace.enter("setOrderByMeasureValue(Dimension, IBISortDirectionType, boolean, IBIMember)", new java.lang.Object[]{dimension, sortDirection, new Boolean(breakingHierarchy), measure});
        try {
            assure.notNull("setOrderByMeasureValue(Dimension, IBISortDirectionType, boolean, IBIMember)", this.locale, (java.lang.Object)dimension, (java.lang.Object)sortDirection, (java.lang.Object)BIAssure.IGNORE, (java.lang.Object)measure);
            iBISort = BICommandUtils.setSortStep(dimension, sortDirection, breakingHierarchy, measure, null, this.info);
            java.lang.Object var8_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBISort;
    }

    public synchronized void suppressEmptyColumns() {
        String method = "suppressEmptyColumns()";
        trace.enter("suppressEmptyColumns()");
        try {
            if (this.info.query.getAxis().size() >= 1) {
                IBIAxis axis = (IBIAxis)this.info.query.getAxis().get(0);
                axis.setSupressingEmptyTuples(true);
            }
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void suppressEmptyRows() {
        String method = "suppressEmptyRows()";
        trace.enter("suppressEmptyRows()");
        try {
            if (this.info.query.getAxis().size() >= 2) {
                IBIAxis axis = (IBIAxis)this.info.query.getAxis().get(1);
                axis.setSupressingEmptyTuples(true);
            }
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void swapAxes() {
        String method = "swapAxes()";
        trace.enter("swapAxes()");
        try {
            if (this.info.query.getAxis().size() >= 2) {
                java.lang.Object rowsAxis = this.info.query.getAxis().get(1);
                this.info.query.getAxis().remove(1);
                this.info.query.getAxis().add(0, rowsAxis);
            }
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized IBIMemberDrill zoomInMember(IBIMember member) throws BIOlapQueryException {
        IBIMemberDrill iBIMemberDrill;
        String method = "zoomInMember(IBIMember)";
        trace.enter("zoomInMember(IBIMember)", new java.lang.Object[]{member});
        try {
            assure.notNull("zoomInMember(IBIMember)", this.locale, (java.lang.Object)member);
            IBIAxisDimension axisDimension = BICommandUtils.getAxisDimension((Dimension)member.getDimension(), (boolean)true, (BICommandInfo)this.info).axisDimension;
            IBIMemberDrill memberDrill = this.info.queryFactory.getMemberSetFactory().createMemberDrill(member, (IBIDrillDirectionType)IBIDrillDirectionTypeEnum.DOWN, true);
            BICommandUtils.addNoneSortStep((IBISetExpression)memberDrill, axisDimension.getMemberSet().getMemberSetExpression(), this.info);
            iBIMemberDrill = memberDrill;
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMemberDrill;
    }

    public synchronized IBIMemberDrill zoomOutMember(IBIMember member) throws BIOlapQueryException {
        IBIMemberDrill iBIMemberDrill;
        String method = "zoomOutMember(IBIMember)";
        trace.enter("zoomOutMember(IBIMember)", new java.lang.Object[]{member});
        try {
            assure.notNull("zoomOutMember(IBIMember)", this.locale, (java.lang.Object)member);
            IBIAxisDimension axisDimension = BICommandUtils.getAxisDimension((Dimension)member.getDimension(), (boolean)true, (BICommandInfo)this.info).axisDimension;
            IBIMemberDrill memberDrill = this.info.queryFactory.getMemberSetFactory().createMemberDrill(member, (IBIDrillDirectionType)IBIDrillDirectionTypeEnum.UP, true);
            BICommandUtils.addNoneSortStep((IBISetExpression)memberDrill, axisDimension.getMemberSet().getMemberSetExpression(), this.info);
            iBIMemberDrill = memberDrill;
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIMemberDrill;
    }

    public synchronized IBISetExpression getSetExpressionById(String id) throws BIOlapQueryException {
        IBISetExpression iBISetExpression;
        String method = "getSetExpressionById(String)";
        trace.enter("getSetExpressionById(String)", new java.lang.Object[]{id});
        try {
            assure.notNull("getSetExpressionById(String)", this.locale, (java.lang.Object)id);
            iBISetExpression = BICommandUtils.getSetExpressionById(id, this.info);
            java.lang.Object var5_4 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var5_5 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBISetExpression;
    }

    public synchronized IBIAxisDimension getAxisDimension(Dimension dimension) throws BIOlapQueryException {
        IBIAxisDimension iBIAxisDimension;
        String method = "getAxisDimension(Dimension)";
        trace.enter("getAxisDimension(Dimension)", new java.lang.Object[]{dimension});
        try {
            assure.notNull("getAxisDimension(Dimension)", this.locale, (java.lang.Object)dimension);
            iBIAxisDimension = BICommandUtils.getAxisDimension((Dimension)dimension, (boolean)true, (BICommandInfo)this.info).axisDimension;
            java.lang.Object var5_4 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var5_5 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIAxisDimension;
    }

    public synchronized IBIQueryFactory getQueryFactory() {
        IBIQueryFactory iBIQueryFactory;
        String method = "getQueryFactory()";
        trace.enter("getQueryFactory()");
        try {
            iBIQueryFactory = this.info.queryFactory;
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBIQueryFactory;
    }

    public synchronized IBITupleDrill drillDownTuple(IBITuple tuple, IBIMember member) throws BIOlapQueryException {
        IBITupleDrill iBITupleDrill;
        String method = "drillDownTuple(IBITuple, IBIMember)";
        trace.enter("drillDownTuple(IBITuple, IBIMember)", new java.lang.Object[]{tuple, member});
        try {
            assure.notNull("drillDownTuple(IBITuple, IBIMember)", this.locale, (java.lang.Object)tuple, (java.lang.Object)member);
            IBIAxis axis = BICommandUtils.getAxis(tuple, true, this.info);
            IBITupleDrill tupleDrill = this.info.queryFactory.getTupleSetFactory().createTupleDrill(tuple, member, (IBIDrillDirectionType)IBIDrillDirectionTypeEnum.DOWN, false);
            axis.getTupleSet().getTupleSetExpression().add(tupleDrill);
            iBITupleDrill = tupleDrill;
            java.lang.Object var8_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBITupleDrill;
    }

    public synchronized IBITupleDrill drillUpTuple(IBITuple tuple, IBIMember member) throws BIOlapQueryException {
        IBITupleDrill iBITupleDrill;
        String method = "drillUpTuple(IBITuple, IBIMember)";
        trace.enter("drillUpTuple(IBITuple, IBIMember)", new java.lang.Object[]{tuple, member});
        try {
            assure.notNull("drillUpTuple(IBITuple, IBIMember)", this.locale, (java.lang.Object)tuple, (java.lang.Object)member);
            IBIAxis axis = BICommandUtils.getAxis(tuple, true, this.info);
            IBITupleDrill tupleDrill = this.info.queryFactory.getTupleSetFactory().createTupleDrill(tuple, member, (IBIDrillDirectionType)IBIDrillDirectionTypeEnum.UP, false);
            axis.getTupleSet().getTupleSetExpression().add(tupleDrill);
            iBITupleDrill = tupleDrill;
            java.lang.Object var8_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBITupleDrill;
    }

    public synchronized IBITupleDrill zoomInTuple(IBITuple tuple, IBIMember member) throws BIOlapQueryException {
        IBITupleDrill iBITupleDrill;
        String method = "zoomInTuple(IBITuple, IBIMember)";
        trace.enter("zoomInTuple(IBITuple, IBIMember)", new java.lang.Object[]{tuple, member});
        try {
            assure.notNull("zoomInTuple(IBITuple, IBIMember)", this.locale, (java.lang.Object)tuple, (java.lang.Object)member);
            IBIAxis axis = BICommandUtils.getAxis(tuple, true, this.info);
            IBITupleDrill tupleDrill = this.info.queryFactory.getTupleSetFactory().createTupleDrill(tuple, member, (IBIDrillDirectionType)IBIDrillDirectionTypeEnum.DOWN, true);
            axis.getTupleSet().getTupleSetExpression().add(tupleDrill);
            iBITupleDrill = tupleDrill;
            java.lang.Object var8_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBITupleDrill;
    }

    public synchronized IBITupleDrill zoomOutTuple(IBITuple tuple, IBIMember member) throws BIOlapQueryException {
        IBITupleDrill iBITupleDrill;
        String method = "zoomOutTuple(IBITuple, IBIMember)";
        trace.enter("zoomOutTuple(IBITuple, IBIMember)", new java.lang.Object[]{tuple, member});
        try {
            assure.notNull("zoomOutTuple(IBITuple, IBIMember)", this.locale, (java.lang.Object)tuple, (java.lang.Object)member);
            IBIAxis axis = BICommandUtils.getAxis(tuple, true, this.info);
            IBITupleDrill tupleDrill = this.info.queryFactory.getTupleSetFactory().createTupleDrill(tuple, member, (IBIDrillDirectionType)IBIDrillDirectionTypeEnum.UP, true);
            axis.getTupleSet().getTupleSetExpression().add(tupleDrill);
            iBITupleDrill = tupleDrill;
            java.lang.Object var8_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_8 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return iBITupleDrill;
    }

    public synchronized void addSapVariableValue(IBISapMemberVariable variable, IBISapRangeSignType sign, IBIRelationalOperatorType option, IBIMember low, IBIMember high) throws BIOlapQueryException {
        String method = "addSapVariableValue(IBISapMemberVariable, IBISapRangeSignType, IBIRelationalOperatorType, IBIMember, IBIMember)";
        trace.enter("addSapVariableValue(IBISapMemberVariable, IBISapRangeSignType, IBIRelationalOperatorType, IBIMember, IBIMember)", new java.lang.Object[]{variable, sign, option, low, high});
        try {
            if (option == IBIRelationalOperatorTypeEnum.BETWEEN) {
                assure.notNull("addSapVariableValue(IBISapMemberVariable, IBISapRangeSignType, IBIRelationalOperatorType, IBIMember, IBIMember)", this.locale, (java.lang.Object)variable, (java.lang.Object)sign, (java.lang.Object)option, (java.lang.Object)low, (java.lang.Object)high);
            } else {
                assure.notNull("addSapVariableValue(IBISapMemberVariable, IBISapRangeSignType, IBIRelationalOperatorType, IBIMember, IBIMember)", this.locale, (java.lang.Object)variable, (java.lang.Object)sign, (java.lang.Object)option, (java.lang.Object)low, (java.lang.Object)BIAssure.IGNORE);
            }
            if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.SINGLEVALUE) {
                this.setSapVariableValue(variable, low);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.INTERVAL) {
                this.setSapVariableValue(variable, low, high);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.COMPLEX) {
                Instance instance = BICommandUtils.getVariableValue((IBISapVariable)variable, this.info);
                IBISapMemberValueRange valueRange = this.info.queryFactory.getVarFactory().createSapMemberValue(sign, option, low);
                if (option == IBIRelationalOperatorTypeEnum.BETWEEN) {
                    valueRange.setHigh(high);
                }
                BICommandUtils.createAndAddSlot((IBISapVariable)variable, (IBISapVariableValue)valueRange, (Object)instance, this.info);
            }
            java.lang.Object var10_9 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var10_10 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void addSapVariableValue(IBISapNumericVariable variable, IBISapRangeSignType sign, IBIRelationalOperatorType option, java.lang.Object low, java.lang.Object high) throws BIOlapQueryException {
        String method = "addSapVariableValue(IBISapNumericVariable, IBISapRangeSignType, IBIRelationalOperatorType, Object, Object)";
        trace.enter("addSapVariableValue(IBISapNumericVariable, IBISapRangeSignType, IBIRelationalOperatorType, Object, Object)", new java.lang.Object[]{variable, sign, option, low, high});
        try {
            if (option == IBIRelationalOperatorTypeEnum.BETWEEN) {
                assure.notNull("addSapVariableValue(IBISapNumericVariable, IBISapRangeSignType, IBIRelationalOperatorType, Object, Object)", this.locale, (java.lang.Object)variable, (java.lang.Object)sign, (java.lang.Object)option, low, high);
            } else {
                assure.notNull("addSapVariableValue(IBISapNumericVariable, IBISapRangeSignType, IBIRelationalOperatorType, Object, Object)", this.locale, (java.lang.Object)variable, (java.lang.Object)sign, (java.lang.Object)option, low, (java.lang.Object)BIAssure.IGNORE);
            }
            if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.SINGLEVALUE) {
                this.setSapVariableValue(variable, low);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.INTERVAL) {
                this.setSapVariableValue(variable, low, high);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.COMPLEX) {
                Instance instance = BICommandUtils.getVariableValue((IBISapVariable)variable, this.info);
                IBISapNumericValueRange valueRange = this.info.queryFactory.getVarFactory().createSapNumericValue(sign, option, this.info.queryPackages.queryMemberPackage.getIBIAnyDataValue().createIBIAnyDataValue("", null, low));
                if (high != null) {
                    valueRange.setHigh(this.info.queryPackages.queryMemberPackage.getIBIAnyDataValue().createIBIAnyDataValue("", null, high));
                }
                BICommandUtils.createAndAddSlot((IBISapVariable)variable, (IBISapVariableValue)valueRange, (Object)instance, this.info);
            }
            java.lang.Object var10_9 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var10_10 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void clearSapVariableValue(IBISapVariable variable) throws BIOlapQueryException {
        String method = "clearSapVariableValue(IBISapVariable)";
        trace.enter("clearSapVariableValue(IBISapVariable)", new java.lang.Object[]{variable});
        try {
            assure.notNull("clearSapVariableValue(IBISapVariable)", this.locale, (java.lang.Object)variable);
            if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.COMPLEX) {
                ((Object)BICommandUtils.getVariableValue(variable, this.info)).getSlot().clear();
            } else {
                BICommandUtils.getSlotForVariable(variable, this.info).setValue(null);
            }
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized List getSapVariables() {
        List list;
        String method = "getSapVariables()";
        trace.enter("getSapVariables()");
        try {
            if (this.sapVariables == null) {
                if (this.info.query.getSapVariable().size() == 0) {
                    this.sapVariables = Collections.EMPTY_LIST;
                } else {
                    this.sapVariables = new ArrayList();
                    Iterator i = this.info.query.getSapVariable().iterator();
                    while (i.hasNext()) {
                        Slot slot = (Slot)i.next();
                        this.sapVariables.add(slot.getFeature());
                    }
                    this.sapVariables = Collections.unmodifiableList(this.sapVariables);
                }
            }
            list = this.sapVariables;
            java.lang.Object var5_4 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var5_5 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
        return list;
    }

    public synchronized void setSapVariableValue(IBISapHierarchyVariable variable, Hierarchy hierarchy) throws BIOlapQueryException {
        String method = "setSapVariableValue(IBISapHierarchyVariable, Hierarchy)";
        trace.enter("setSapVariableValue(IBISapHierarchyVariable, Hierarchy)", new java.lang.Object[]{variable, hierarchy});
        try {
            assure.notNull("setSapVariableValue(IBISapHierarchyVariable, Hierarchy)", this.locale, (java.lang.Object)variable, (java.lang.Object)hierarchy);
            IBISapHierarchyValue value = (IBISapHierarchyValue)BICommandUtils.getVariableValue((IBISapVariable)variable, this.info);
            value.setName(hierarchy.getName());
            value.setHierarchy(hierarchy);
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void setSapVariableValue(IBISapMemberVariable variable, IBIMember low, IBIMember high) throws BIOlapQueryException {
        String method = "setSapVariableValue(IBISapMemberVariable, IBIMember, IBIMember)";
        trace.enter("setSapVariableValue(IBISapMemberVariable, IBIMember, IBIMember)", new java.lang.Object[]{variable, low, high});
        try {
            assure.notNull("setSapVariableValue(IBISapMemberVariable, IBIMember, IBIMember)", this.locale, (java.lang.Object)variable, (java.lang.Object)low, (java.lang.Object)high);
            if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.SINGLEVALUE) {
                this.setSapVariableValue(variable, low);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.INTERVAL) {
                IBISapMemberValueRange value = (IBISapMemberValueRange)BICommandUtils.getVariableValue((IBISapVariable)variable, this.info);
                value.setSign((IBISapRangeSignType)IBISapRangeSignTypeEnum.INCLUDING);
                value.setOption((IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.BETWEEN);
                value.setLow(low);
                value.setHigh(high);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.COMPLEX) {
                this.clearSapVariableValue((IBISapVariable)variable);
                this.addSapVariableValue(variable, (IBISapRangeSignType)IBISapRangeSignTypeEnum.INCLUDING, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.BETWEEN, low, high);
            }
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void setSapVariableValue(IBISapMemberVariable variable, IBIMember member) throws BIOlapQueryException {
        String method = "setSapVariableValue(IBISapMemberVariable, IBIMember)";
        trace.enter("setSapVariableValue(IBISapMemberVariable, IBIMember)", new java.lang.Object[]{variable, member});
        try {
            assure.notNull("setSapVariableValue(IBISapMemberVariable, IBIMember)", this.locale, (java.lang.Object)variable, (java.lang.Object)member);
            if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.SINGLEVALUE) {
                IBISapMemberValueRange value = (IBISapMemberValueRange)BICommandUtils.getVariableValue((IBISapVariable)variable, this.info);
                value.setSign((IBISapRangeSignType)IBISapRangeSignTypeEnum.INCLUDING);
                value.setOption((IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.EQUAL);
                value.setLow(member);
                value.setHigh(null);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.INTERVAL) {
                this.setSapVariableValue(variable, member, member);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.COMPLEX) {
                this.clearSapVariableValue((IBISapVariable)variable);
                this.addSapVariableValue(variable, (IBISapRangeSignType)IBISapRangeSignTypeEnum.INCLUDING, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.EQUAL, member, null);
            }
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void setSapVariableValue(IBISapNumericVariable variable, java.lang.Object low, java.lang.Object high) throws BIOlapQueryException {
        String method = "setSapVariableValue(IBISapNumericVariable, Object, Object)";
        trace.enter("setSapVariableValue(IBISapNumericVariable, Object, Object)", new java.lang.Object[]{variable, low, high});
        try {
            assure.notNull("setSapVariableValue(IBISapNumericVariable, Object, Object)", this.locale, (java.lang.Object)variable, low, high);
            if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.SINGLEVALUE) {
                this.setSapVariableValue(variable, low);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.INTERVAL) {
                IBISapNumericValueRange value = (IBISapNumericValueRange)BICommandUtils.getVariableValue((IBISapVariable)variable, this.info);
                value.setSign((IBISapRangeSignType)IBISapRangeSignTypeEnum.INCLUDING);
                value.setOption((IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.BETWEEN);
                if (value.getLow() == null) {
                    value.setLow(this.info.queryPackages.queryMemberPackage.getIBIAnyDataValue().createIBIAnyDataValue("", null, low));
                } else {
                    value.getLow().setValue(low);
                }
                if (value.getHigh() == null) {
                    value.setHigh(this.info.queryPackages.queryMemberPackage.getIBIAnyDataValue().createIBIAnyDataValue("", null, high));
                } else {
                    value.getHigh().setValue(high);
                }
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.COMPLEX) {
                this.clearSapVariableValue((IBISapVariable)variable);
                this.addSapVariableValue(variable, (IBISapRangeSignType)IBISapRangeSignTypeEnum.INCLUDING, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.BETWEEN, low, high);
            }
            java.lang.Object var7_6 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var7_7 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    public synchronized void setSapVariableValue(IBISapNumericVariable variable, java.lang.Object value) throws BIOlapQueryException {
        String method = "setSapVariableValue(IBISapNumericVariable, Object)";
        trace.enter("setSapVariableValue(IBISapNumericVariable, Object)", new java.lang.Object[]{variable, value});
        try {
            assure.notNull("setSapVariableValue(IBISapNumericVariable, Object)", this.locale, (java.lang.Object)variable, value);
            if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.SINGLEVALUE) {
                IBISapNumericValueRange valueRange = (IBISapNumericValueRange)BICommandUtils.getVariableValue((IBISapVariable)variable, this.info);
                valueRange.setSign((IBISapRangeSignType)IBISapRangeSignTypeEnum.INCLUDING);
                valueRange.setOption((IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.EQUAL);
                if (valueRange.getLow() == null) {
                    valueRange.setLow(this.info.queryPackages.queryMemberPackage.getIBIAnyDataValue().createIBIAnyDataValue("", null, value));
                } else {
                    valueRange.getLow().setValue(value);
                }
                valueRange.setHigh(null);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.INTERVAL) {
                this.setSapVariableValue(variable, value, value);
            } else if (variable.getSelectionType() == IBISapVariableSelectionTypeEnum.COMPLEX) {
                this.clearSapVariableValue((IBISapVariable)variable);
                this.addSapVariableValue(variable, (IBISapRangeSignType)IBISapRangeSignTypeEnum.INCLUDING, (IBIRelationalOperatorType)IBIRelationalOperatorTypeEnum.EQUAL, value, null);
            }
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            trace.exit();
            throw throwable;
        }
        trace.exit();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

