/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.olap.mdx.model;

import com.sap.ip.bi.sdk.dac.olap.mdx.model.BIMdxObjectsFactory;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.def.IBIMdxFactor;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.def.IBIMdxNumericValueExpression;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.def.IBIMdxValueExpressionPrimaryByVx;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxAxisName;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxCellProps;
import com.sap.ip.bi.sdk.dac.olap.mdx.model.stat.IBIMdxMandatoryCellProperty;
import com.sap.ip.bi.sdk.exception.BIOlapQueryRuntimeException;
import java.util.ArrayList;
import java.util.Locale;

public final class BIMdxModelUtilities {
    private BIMdxModelUtilities() {
    }

    public static IBIMdxAxisName getAxisName(int axisIndex, BIMdxObjectsFactory mdxFactory) {
        return mdxFactory.createAxisName(false, false, false, false, false, mdxFactory.createFactor(axisIndex < 0, mdxFactory.createExactNumericLiteral(String.valueOf(Math.abs(axisIndex)))));
    }

    public static IBIMdxCellProps createCellProps(boolean cell, boolean cellOrdinal, boolean value, boolean formattedValue, BIMdxObjectsFactory mdxFactory, Locale locale) {
        if (!(cellOrdinal || value || formattedValue)) {
            throw new BIOlapQueryRuntimeException(locale, "sdk.dac.olap.query_1011");
        }
        ArrayList<IBIMdxMandatoryCellProperty> cellProperties = new ArrayList<IBIMdxMandatoryCellProperty>();
        if (cellOrdinal) {
            cellProperties.add(mdxFactory.createMandatoryCellProperty(cellOrdinal, false, false));
        }
        if (value) {
            cellProperties.add(mdxFactory.createMandatoryCellProperty(false, value, false));
        }
        if (formattedValue) {
            cellProperties.add(mdxFactory.createMandatoryCellProperty(false, false, formattedValue));
        }
        return mdxFactory.createCellProps(cell, cellProperties);
    }

    public static IBIMdxFactor createFactorFromInt(int factor, BIMdxObjectsFactory mdxFactory) {
        return mdxFactory.createFactor(factor < 0, mdxFactory.createExactNumericLiteral(String.valueOf(factor)));
    }

    public static IBIMdxFactor createFactorFromNumericValueExpression(boolean minus, IBIMdxNumericValueExpression mdxNumericValueExpression, BIMdxObjectsFactory mdxFactory) {
        IBIMdxValueExpressionPrimaryByVx mdxValueExpressionPrimaryByVx = mdxFactory.createValueExpressionPrimaryByVx(mdxNumericValueExpression);
        IBIMdxFactor mdxFactor = mdxFactory.createFactor(minus, mdxValueExpressionPrimaryByVx);
        return mdxFactor;
    }
}

