/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.contextcopy.ui;

import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.controllereditor.context.ContextLabelProvider;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class UsedControllersContextLabelProvider
extends LabelProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Map mLabelProvidersForUsedController = new HashMap();
    private Controller mController;

    public UsedControllersContextLabelProvider(Controller controller) {
        this.mController = controller;
        this.createProvider(controller);
        ControllerUsage[] usages = this.mController.getOutgoingControllerUsages();
        int i = 0;
        while (i < usages.length) {
            Controller usedController = usages[i].getUsedController();
            if (usedController != null) {
                this.createProvider(usedController);
            }
            ++i;
        }
    }

    public void dispose() {
        Iterator iter = this.mLabelProvidersForUsedController.values().iterator();
        while (iter.hasNext()) {
            IBaseLabelProvider prov = (IBaseLabelProvider)iter.next();
            prov.dispose();
        }
        this.mLabelProvidersForUsedController.clear();
    }

    public String getText(Object element) {
        if (element instanceof ContextElement) {
            ContextElement contextElement = (ContextElement)element;
            ILabelProvider prov = this.findLabelProvider(contextElement);
            if (prov != null) {
                return prov.getText((Object)contextElement);
            }
        } else if (element instanceof Controller) {
            Controller controller = (Controller)element;
            return controller.getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof ContextElement) {
            ILabelProvider prov = this.findLabelProvider((ContextElement)element);
            if (prov != null) {
                return prov.getImage(element);
            }
        } else if (element instanceof Controller) {
            ControllerTypeEnum type = ((Controller)element).getType();
            if (ControllerTypeEnum.COMPONENT == type) {
                return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPONENT_CONTROLLER);
            }
            if (ControllerTypeEnum.COMPONENT_INTERFACE == type) {
                return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPONENT_INTERFACE_CONTROLLER);
            }
            if (ControllerTypeEnum.COMPONENT_CONFIGURATION == type) {
                return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPONENT_CONFIGURATION_CONTROLLER);
            }
            if (ControllerTypeEnum.INTERFACE_VIEW == type) {
                return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_INTERFACE_VIEW_CONTROLLER);
            }
            if (ControllerTypeEnum.CUSTOM == type) {
                return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_CUSTOM_CONTROLLER);
            }
            if (ControllerTypeEnum.VIEW == type) {
                return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_VIEW);
            }
        }
        return super.getImage(element);
    }

    private void createProvider(Controller controller) {
        ContextLabelProvider labelProv = new ContextLabelProvider(controller.getOutgoingControllerUsages(), false, false, false);
        this.mLabelProvidersForUsedController.put(controller, labelProv);
    }

    private ILabelProvider findLabelProvider(ContextElement element) {
        Iterator iter = this.mLabelProvidersForUsedController.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Controller controller = (Controller)entry.getKey();
            if (!element.getMDO().equals(controller)) continue;
            return (ILabelProvider)entry.getValue();
        }
        return null;
    }
}

