/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.contextcopy.ui;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class UsedControllersContextContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Map mContentProvidersForUsedController = new HashMap();
    private Controller mController;
    private ControllerUsage[] mUsages;
    private boolean mIncludeUsingController;

    public UsedControllersContextContentProvider(boolean includeUsingController) {
        this(includeUsingController, null);
    }

    public UsedControllersContextContentProvider(boolean includeUsingController, ControllerUsage[] usages) {
        this.mIncludeUsingController = includeUsingController;
        this.mUsages = usages;
    }

    public Object[] getChildren(Object parentElement) {
        ITreeContentProvider prov;
        if (parentElement instanceof Controller) {
            Controller controller = (Controller)parentElement;
            return new Object[]{controller.getContext()};
        }
        if (parentElement instanceof ContextElement && (prov = this.findContentProvider((ContextElement)parentElement)) != null) {
            return prov.getChildren(parentElement);
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof ContextElement) {
            ContextElement contextElement = (ContextElement)element;
            DevelopmentObject parent = contextElement.getParent();
            if (parent.isMDO()) {
                return parent;
            }
            ITreeContentProvider prov = this.findContentProvider(contextElement);
            if (prov != null) {
                return prov.getParent(element);
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ContextElement) {
            ITreeContentProvider prov = this.findContentProvider((ContextElement)element);
            if (prov != null) {
                return prov.hasChildren(element);
            }
        } else {
            if (element instanceof Controller) {
                return true;
            }
            if (element instanceof ControllerRoot) {
                return true;
            }
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Controller> elements = new ArrayList<Controller>();
        if (inputElement instanceof ControllerRoot) {
            ControllerRoot root = (ControllerRoot)inputElement;
            ControllerUsage[] usages = this.getControllerUsages(this.mController);
            int i = 0;
            while (i < usages.length) {
                Controller usedController = usages[i].getUsedController();
                if (usedController != null) {
                    elements.add(usedController);
                }
                ++i;
            }
            if (this.mIncludeUsingController) {
                elements.add(this.mController);
            }
        }
        return elements.toArray();
    }

    public void dispose() {
        Iterator iter = this.mContentProvidersForUsedController.values().iterator();
        while (iter.hasNext()) {
            IContentProvider prov = (IContentProvider)iter.next();
            prov.dispose();
        }
        this.mContentProvidersForUsedController.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ControllerRoot) {
            this.mController = ((ControllerRoot)newInput).getRoot();
            this.mContentProvidersForUsedController.clear();
            if (this.mIncludeUsingController) {
                this.createProvider(this.mController);
            }
            ControllerUsage[] usages = this.getControllerUsages(this.mController);
            int i = 0;
            while (i < usages.length) {
                Controller usedController = usages[i].getUsedController();
                if (usedController != null) {
                    this.createProvider(usedController);
                }
                ++i;
            }
        }
    }

    private void createProvider(Controller controller) {
        ContextContentProvider.ContextRoot root = new ContextContentProvider.ContextRoot((ContextElement)controller.getContext());
        this.mContentProvidersForUsedController.put(root, new ContextContentProvider(root));
    }

    private ITreeContentProvider findContentProvider(ContextElement element) {
        Iterator iter = this.mContentProvidersForUsedController.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ContextContentProvider.ContextRoot root = (ContextContentProvider.ContextRoot)entry.getKey();
            if (!root.getRoot().equals(this.getContext(element))) continue;
            return (ITreeContentProvider)entry.getValue();
        }
        return null;
    }

    private ContextValueNode getContext(ContextElement element) {
        return ((Controller)element.getMDO()).getContext();
    }

    private ControllerUsage[] getControllerUsages(Controller controller) {
        return this.mUsages != null ? this.mUsages : this.mController.getOutgoingControllerUsages();
    }

    public static class ControllerRoot {
        private Controller mRoot;

        public ControllerRoot(Controller root) {
            this.mRoot = root;
        }

        public Controller getRoot() {
            return this.mRoot;
        }
    }
}

