/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.contextcopy.ui;

import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.tools.core.template.service.GenerationPositionEnum;
import com.sap.ide.webdynpro.controllereditor.wizards.method.CreateMethodWizardDialog;
import com.sap.ide.webdynpro.template.contextcopy.ContextCopyData;
import com.sap.ide.webdynpro.template.contextcopy.ui.AbstractContextCopyWizardPage;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PageGenerationDetails
extends AbstractContextCopyWizardPage {
    static final String PAGE_NAME = (class$com$sap$ide$webdynpro$template$contextcopy$ui$PageGenerationDetails == null ? (class$com$sap$ide$webdynpro$template$contextcopy$ui$PageGenerationDetails = PageGenerationDetails.class$("com.sap.ide.webdynpro.template.contextcopy.ui.PageGenerationDetails")) : class$com$sap$ide$webdynpro$template$contextcopy$ui$PageGenerationDetails).getName();
    private ContextCopyData mData;
    private List mButtonGroup;
    private Button mNewButton;
    private Combo mMethodCombo;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$template$contextcopy$ui$PageGenerationDetails;

    public PageGenerationDetails(ContextCopyData data) {
        super(PAGE_NAME);
        this.mData = data;
        this.setTitle(AbstractContextCopyWizardPage.mTextPool.getText(21));
        this.setDescription(AbstractContextCopyWizardPage.mTextPool.getText(31));
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        IGridLayoutPane glp = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        glp.setVerticalMargin(15);
        glp.setSpacing(10, 0);
        IGridLayoutData gd = glp.createGridLayoutData(1, 4, 3, 1);
        glp.addPlaceholder(gd);
        gd = glp.createGridLayoutData(1, 2, false, false);
        glp.addTextLabel(AbstractContextCopyWizardPage.mTextPool.getText(1), gd);
        gd = glp.createGridLayoutData(4, 4, true, false);
        String[] methodItems = this.getMethodItems();
        this.mMethodCombo = glp.addComboBox(methodItems, "", true, gd);
        this.mMethodCombo.addSelectionListener((SelectionListener)new MethodListener());
        gd = glp.createGridLayoutData(1, 2, false, false);
        this.mNewButton = glp.addPushButton(AbstractContextCopyWizardPage.mTextPool.getText(0, gd));
        this.mNewButton.addSelectionListener((SelectionListener)new NewMethodListener(this.mMethodCombo));
        gd = glp.createGridLayoutData(1, 4, 3, 1);
        glp.addPlaceholder(gd);
        String[] buttons = new String[]{AbstractContextCopyWizardPage.mTextPool.getText(3), AbstractContextCopyWizardPage.mTextPool.getText(4)};
        gd = glp.createGridLayoutData(4, 4, true, false, 2, 1);
        Button[] buttonGroup = glp.addVerticalRadioButtonGroup(AbstractContextCopyWizardPage.mTextPool.getText(2), buttons, this.getIndex(), gd);
        buttonGroup[0].getParent().setLayout((Layout)new GridLayout());
        int i = 0;
        while (i < buttonGroup.length) {
            GridData data = new GridData();
            data.horizontalIndent = 5;
            buttonGroup[i].setLayoutData((Object)data);
            ++i;
        }
        this.mButtonGroup = Arrays.asList(buttonGroup);
        int i2 = 0;
        while (i2 < buttonGroup.length) {
            buttonGroup[i2].addSelectionListener((SelectionListener)new PositionListener());
            ++i2;
        }
        this.setControl((Control)root);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.mMethodCombo.getItemCount() == 0) {
                this.mNewButton.setFocus();
            } else {
                this.mMethodCombo.setFocus();
            }
        }
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.mData.getMethodName() != null && this.mData.getPosition() != null;
    }

    private String[] getMethodItems() {
        Controller viewController = this.mData.getTargetController();
        Method[] methods = viewController.getMethods();
        EventHandler[] eventHandlers = viewController.getEventHandlers();
        Object[] items = new String[methods.length + eventHandlers.length + 2];
        items[0] = "wdDoInit";
        items[1] = "wdDoExit";
        int i = 0;
        while (i < methods.length) {
            items[i + 2] = methods[i].getName();
            ++i;
        }
        int i2 = 0;
        while (i2 < eventHandlers.length) {
            items[i2 + methods.length + 2] = eventHandlers[i2].getName();
            ++i2;
        }
        Arrays.sort(items);
        return items;
    }

    private int getIndex() {
        GenerationPositionEnum generationPositionEnum = this.mData.getPosition();
        if (generationPositionEnum == GenerationPositionEnum.BEFORE) {
            return 0;
        }
        if (generationPositionEnum == GenerationPositionEnum.AFTER) {
            return 1;
        }
        return -1;
    }

    private GenerationPositionEnum getPosition(int index) {
        if (index == 0) {
            return GenerationPositionEnum.BEFORE;
        }
        if (index == 1) {
            return GenerationPositionEnum.AFTER;
        }
        return this.mData.getPosition();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class PositionListener
    extends AbstractContextCopyWizardPage.ContextCopyWizardPageSelectionListener {
        private PositionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            int index = PageGenerationDetails.this.mButtonGroup.indexOf(source);
            PageGenerationDetails.this.mData.setPosition(PageGenerationDetails.this.getPosition(index));
            super.widgetSelected(e);
        }
    }

    private final class MethodListener
    extends AbstractContextCopyWizardPage.ContextCopyWizardPageSelectionListener {
        private MethodListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Combo combo = (Combo)e.getSource();
            String methodName = combo.getText();
            PageGenerationDetails.this.mData.setMethodName(methodName);
            super.widgetSelected(e);
        }
    }

    private final class NewMethodListener
    extends AbstractContextCopyWizardPage.ContextCopyWizardPageSelectionListener {
        private final Combo mCombo;

        NewMethodListener(Combo combo) {
            this.mCombo = combo;
        }

        public void widgetSelected(SelectionEvent e) {
            Procedure proc;
            CreateMethodWizardDialog dialog = new CreateMethodWizardDialog(PageGenerationDetails.this.mData.getTargetController());
            if (dialog.open() == 0 && (proc = dialog.getNewProcedure()) != null) {
                String name = proc.getName();
                this.mCombo.add(name);
                this.mCombo.setText(name);
                PageGenerationDetails.this.mData.setMethodName(name);
            }
            super.widgetSelected(e);
        }
    }
}

