/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.contextcopy.ui;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.TreeMappingValidator;
import com.sap.ide.tools.core.treemappingcomponent.listener.DragDropListener;
import com.sap.ide.tools.core.treemappingcomponent.listener.TreeMappingListener;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.template.contextcopy.ContextCopyData;
import com.sap.ide.webdynpro.template.contextcopy.ContextCopyLink;
import com.sap.ide.webdynpro.template.contextcopy.TextPool;
import com.sap.ide.webdynpro.template.contextcopy.ui.AbstractContextCopyWizardPage;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;

public final class CopyListenerAndValidator
implements TreeMappingListener,
TreeMappingValidator,
DragDropListener {
    private final TextPool mTextPool = TextPool.getInstance();
    private ContextCopyData mData;
    private WizardPage mPage;

    CopyListenerAndValidator(ContextCopyData data, WizardPage page) {
        this.mData = data;
        this.mPage = page;
    }

    public boolean allowMapping(Object source, Object target, int direction) {
        String errorMessage = null;
        String warningMessage = null;
        ContextElement targetElement = (ContextElement)target;
        ContextElement sourceElement = (ContextElement)source;
        if (target instanceof AbstractContextNode) {
            errorMessage = AbstractContextCopyWizardPage.mTextPool.getText(50);
        } else if (target instanceof ContextAttribute && source instanceof AbstractContextNode) {
            errorMessage = AbstractContextCopyWizardPage.mTextPool.getText(51);
        } else if (sourceElement.equals(targetElement)) {
            errorMessage = AbstractContextCopyWizardPage.mTextPool.getText(53);
        } else if (this.linkExists(this.mData.getContextCopyLinks(), (ContextAttribute)sourceElement)) {
            errorMessage = AbstractContextCopyWizardPage.mTextPool.getText(52);
        } else {
            warningMessage = this.areTypesCompatible((ContextAttribute)targetElement, (ContextAttribute)sourceElement);
        }
        this.mPage.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.mPage.setMessage(warningMessage, 2);
        }
        return errorMessage == null;
    }

    public boolean allowDelete(MappingObject mappingObject) {
        return true;
    }

    public boolean allowModify(Object oldSource, Object oldTarget, Object newSource, Object newTarget) {
        return false;
    }

    public void mappingCreated(MappingObject mappingObject) {
        Object source = mappingObject.getSourceNode().getData();
        Object target = mappingObject.getTargetNode().getData();
        if (source instanceof ContextAttribute && target instanceof ContextAttribute) {
            ContextAttribute sourceAtt = (ContextAttribute)source;
            ContextAttribute targetAtt = (ContextAttribute)target;
            this.mData.addContextCopyLink(sourceAtt, targetAtt);
        }
        this.mPage.setPageComplete(this.mPage.isPageComplete());
    }

    public void mappingDeleted(MappingObject mappingObject) {
        Object target = mappingObject.getTargetNode().getData();
        Object source = mappingObject.getTargetNode().getData();
        this.mData.removeContextCopyLink((ContextElement)source, (ContextElement)target);
        this.mPage.getWizard().getContainer().updateButtons();
    }

    public void mappingModified(MappingObject oldMappingObject, MappingObject newMappingObject) {
    }

    public void dragFinished(Object object, int direction) {
        this.mPage.setErrorMessage(null);
        this.mPage.setMessage(null);
    }

    public void dragStart(Object object, int direction) {
    }

    public void dragOver(Object object, int mDirection) {
    }

    private String areTypesCompatible(ContextAttribute sourceAtt, ContextAttribute targetAtt) {
        Object message = null;
        DevelopmentObject sourceType = CheckLayerHelper.getType((ContextAttribute)sourceAtt);
        DevelopmentObject targetType = CheckLayerHelper.getType((ContextAttribute)targetAtt);
        message = CheckLayerHelper.isValidType((DevelopmentObject)targetType, (DevelopmentObject)sourceType);
        if (message != null) {
            message = this.mData.isTypedAccessRequired(targetAtt.getNode()) ? (this.mData.isStringType(targetAtt) ? null : this.mTextPool.getText(54)) : this.mTextPool.getText(55);
            String sourceJavaType = this.mData.extractJavaClassName(sourceType);
            String targetJavaType = this.mData.extractJavaClassName(targetType);
            if (sourceJavaType != null && targetJavaType != null) {
                Class sourceClass = this.mData.getTypeClass(sourceJavaType);
                Class targetClass = this.mData.getTypeClass(targetJavaType);
                if (sourceClass != null && targetClass != null) {
                    if (targetClass.isAssignableFrom(sourceClass)) {
                        message = null;
                    }
                } else if (sourceJavaType.equals(targetJavaType)) {
                    message = null;
                }
            }
        }
        return message;
    }

    private boolean linkExists(List links, ContextAttribute targetAttribute) {
        Iterator iter = links.iterator();
        while (iter.hasNext()) {
            ContextCopyLink link = (ContextCopyLink)iter.next();
            if (link.getTargetElement().equals(targetAttribute)) {
                return true;
            }
            if (!this.linkExists(link.getChildLinks(), targetAttribute)) continue;
            return true;
        }
        return false;
    }
}

