/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.contextcopy.generation;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.tools.core.patternfwk.ISourcePatternResult;
import com.sap.ide.tools.core.template.service.GenerationPositionEnum;
import com.sap.ide.tools.core.template.service.IGenerationFacade;
import com.sap.ide.tools.core.template.service.ITemplateData;
import com.sap.ide.tools.core.template.service.ITemplateGeneration;
import com.sap.ide.webdynpro.template.contextcopy.ContextCopyData;
import com.sap.ide.webdynpro.template.contextcopy.ContextCopyLink;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextCopyGeneration
implements ITemplateGeneration,
ISourcePatternResult {
    private static final MainDevelopmentObject[] EMPTY_MDO_ARRAY = new MainDevelopmentObject[0];
    private static final String LINE_SEP = System.getProperty("line.separator", "\n");
    private static final String TAB = "\t";
    private static final String SPACE = " ";
    private static final String QUOT = "\"";
    private static final String COLON = ",";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String DOT = ".";
    private static final String SEMICOLON = ";";
    private static final String PARENTHESES_OPENED = "(";
    private static final String PARENTHESES_CLOSED = ")";
    private static final String PARENTHESES_BOTH = "()";
    private static final String CURLY_BRACKET_OPENED = "{";
    private static final String CURLY_BRACKET_CLOSED = "}";
    private static final String NOT_EQUAL_NULL = " != null";
    private static final String AND_LOGICAL = " && ";
    private static final String IF = "if ";
    private static final String ASSIGNMENT_OP = " = ";
    private static final String NEW = "new";
    private static final String STRING_CLASS = "String";
    private static final String STRING_VALUEOF = "String.valueOf";
    private static final String TO_STRING = "toString";
    private static final String PACKAGE_PROGMODEL_API = "com.sap.tc.webdynpro.progmodel.api";
    private static final String INTF_PREFIX = "I";
    private static final String WDCONTEXT = "wdContext";
    private static final String WDTHIS = "wdThis";
    private static final String WD_GET = "wdGet";
    private static final String CONTROLLER_SUFFIX = "Controller";
    private static final String WD_GET_CONTEXT = "wdGetContext";
    private static final String CURRENT = "current";
    private static final String ELEMENT = "Element";
    private static final String IPRIVATE = "IPrivate";
    private static final String INODEELEMENT = "IWDNodeElement";
    private static final String INODEELEMENT_QUALIFIED = "com.sap.tc.webdynpro.progmodel.api.IWDNodeElement";
    private static final String ATTRIBUTE_VALUE = "AttributeValue";
    private static final String GET_ATTRIBUTE_VALUE = "getAttributeValue";
    private static final String SET_ATTRIBUTE_VALUE = "setAttributeValue";
    private ContextCopyData mData;
    private Map mNodeVariablesForNode = new HashMap();
    private Set mNeededImports = new HashSet();

    public ContextCopyGeneration() {
    }

    public ContextCopyGeneration(ContextCopyData data) {
        this.mData = data;
    }

    public void generateMetaDataObjects(ITemplateData templateData, DevelopmentObject containingObject) {
    }

    public void generateCoding(IGenerationFacade facade) {
        this.mData = (ContextCopyData)facade.getTemplateData();
        String code = this.generateCopyCode();
        if (code != null) {
            Controller controller = this.mData.getTargetController();
            String methodName = this.mData.getMethodName();
            GenerationPositionEnum position = this.mData.getPosition();
            if ("wdDoInit".equals(methodName)) {
                if (position == GenerationPositionEnum.BEFORE) {
                    facade.insert((DevelopmentObject)controller, GenerationPositionEnum.INITBEFORE, code);
                } else {
                    facade.insert((DevelopmentObject)controller, GenerationPositionEnum.INITAFTER, code);
                }
            } else if ("wdDoExit".equals(methodName)) {
                if (position == GenerationPositionEnum.BEFORE) {
                    facade.insert((DevelopmentObject)controller, GenerationPositionEnum.EXITBEFORE, code);
                } else {
                    facade.insert((DevelopmentObject)controller, GenerationPositionEnum.EXITAFTER, code);
                }
            } else {
                Method proc = controller.getMethod(methodName);
                if (proc == null) {
                    proc = controller.getEventHandler(methodName);
                }
                if (proc != null) {
                    facade.insert((DevelopmentObject)proc, position, code);
                }
            }
        }
    }

    public void finish(ITemplateData templateData) {
    }

    public boolean check(ITemplateData templateData, DevelopmentObject object) {
        return (object instanceof Controller || object instanceof View) && templateData.isValid();
    }

    public MainDevelopmentObject[] getAffectedMDOs(ITemplateData templateData, DevelopmentObject object) {
        return new MainDevelopmentObject[]{object.getMDO()};
    }

    public MainDevelopmentObject[] getCreatedMDOs(ITemplateData templateData, DevelopmentObject object) {
        return EMPTY_MDO_ARRAY;
    }

    public MainDevelopmentObject[] getDeletedMDOs(ITemplateData templateData, DevelopmentObject object) {
        return EMPTY_MDO_ARRAY;
    }

    public String getCoding() {
        return this.generateCopyCode();
    }

    public void setCoding(String coding) {
    }

    public void addImport(String className) {
    }

    public void removeImport(String className) {
    }

    public String[] getImports() {
        return this.mNeededImports.toArray(new String[this.mNeededImports.size()]);
    }

    private String generateCopyCode() {
        List copyLinks = this.mData.getContextCopyLinks();
        StringBuffer buf = new StringBuffer();
        this.mNodeVariablesForNode.clear();
        this.mNeededImports.clear();
        Iterator iter = copyLinks.iterator();
        while (iter.hasNext()) {
            String checkExpr;
            ContextCopyLink nodeLink = (ContextCopyLink)iter.next();
            if (!nodeLink.hasChildLinks()) continue;
            ContextElement sourceElement = nodeLink.getSourceElement();
            ContextElement targetElement = nodeLink.getTargetElement();
            if (!(sourceElement instanceof ContextNode)) continue;
            ContextNode sourceNode = (ContextNode)sourceElement;
            ContextNode targetNode = (ContextNode)targetElement;
            Controller sourceController = (Controller)sourceNode.getMDO();
            Controller targetController = (Controller)targetNode.getMDO();
            String sourcePrivateController = this.privateController(sourceNode.getMDO().getName());
            String targetPrivateController = this.privateController(targetNode.getMDO().getName());
            String sourceNodeName = sourceNode.getName();
            String targetNodeName = targetNode.getName();
            boolean isSourceTypedAccessRequired = this.mData.isTypedAccessRequired(sourceNode);
            boolean isTargetTypedAccessRequired = this.mData.isTypedAccessRequired(targetNode);
            String sourceNodeVariable = this.getUniqueNameForNodeVariable(sourceNode, this.mNodeVariablesForNode);
            if (!this.mNodeVariablesForNode.containsKey(sourceNode)) {
                this.mNodeVariablesForNode.put(sourceNode, sourceNodeVariable);
                buf.append(this.indentAbsolute());
                if (isSourceTypedAccessRequired) {
                    buf.append(sourcePrivateController + DOT);
                    buf.append(this.intfElement(sourceNodeName) + SPACE);
                    this.mNeededImports.add(this.qualifiedPrivateController(sourceController));
                } else {
                    buf.append("IWDNodeElement ");
                    this.mNeededImports.add(INODEELEMENT_QUALIFIED);
                }
                String currentSourceNodeElement = null;
                currentSourceNodeElement = sourceController.equals(targetController) ? "wdContext." + this.currentElement(sourceNodeName) : this.usedContextAccessor(sourceController.getName()) + DOT + this.currentElement(sourceNodeName);
                buf.append(this.assignment(sourceNodeVariable, currentSourceNodeElement));
                buf.append(LINE_SEP);
            }
            String targetNodeVariable = this.getUniqueNameForNodeVariable(targetNode, this.mNodeVariablesForNode);
            if (!targetNode.equals(sourceNode)) {
                if (!this.mNodeVariablesForNode.containsKey(targetNode)) {
                    this.mNodeVariablesForNode.put(targetNode, targetNodeVariable);
                    buf.append(this.indentAbsolute());
                    if (isTargetTypedAccessRequired) {
                        buf.append(targetPrivateController + DOT);
                        buf.append(this.intfElement(targetNodeName) + SPACE);
                        this.mNeededImports.add(this.qualifiedPrivateController(targetController));
                    } else {
                        buf.append("IWDNodeElement ");
                        this.mNeededImports.add(INODEELEMENT_QUALIFIED);
                    }
                    String currentTargetNodeElement = "wdContext." + this.currentElement(targetNodeName);
                    buf.append(this.assignment(targetNodeVariable, currentTargetNodeElement));
                    buf.append(LINE_SEP);
                }
                checkExpr = this.logicalAndExpression(this.notEqualNullExpression(sourceNodeVariable, true), this.notEqualNullExpression(targetNodeVariable, true));
            } else {
                checkExpr = this.notEqualNullExpression(sourceNodeVariable, false);
            }
            buf.append(this.indentAbsolute() + this.ifStatementHeader(checkExpr));
            buf.append(LINE_SEP);
            List childLinks = nodeLink.getChildLinks();
            Iterator childIter = childLinks.iterator();
            while (childIter.hasNext()) {
                ContextCopyLink link = (ContextCopyLink)childIter.next();
                ContextAttribute sourceAtt = (ContextAttribute)link.getSourceElement();
                ContextAttribute targetAtt = (ContextAttribute)link.getTargetElement();
                String sourceGetter = this.sourceGetter(sourceAtt, sourceNodeVariable, targetAtt, isSourceTypedAccessRequired, isTargetTypedAccessRequired);
                String targetSetter = this.targetSetter(targetAtt, targetNodeVariable, sourceGetter, isSourceTypedAccessRequired, isTargetTypedAccessRequired);
                buf.append(this.indentAbsolute() + TAB + targetSetter);
                buf.append(SEMICOLON + LINE_SEP);
            }
            if (iter.hasNext()) {
                buf.append(this.indentAbsolute() + CURLY_BRACKET_CLOSED + LINE_SEP + LINE_SEP);
                continue;
            }
            buf.append(this.indentAbsolute() + CURLY_BRACKET_CLOSED);
        }
        return buf.toString();
    }

    private String sourceGetter(ContextAttribute sourceAtt, String sourceNodeVariable, ContextAttribute targetAtt, boolean isSourceTypedAccessRequired, boolean isTargetTypedAccessRequired) {
        String sourceGetter = null;
        if (isSourceTypedAccessRequired) {
            sourceGetter = this.methodInvocation(sourceNodeVariable, this.getter(sourceAtt.getName()));
            if (isTargetTypedAccessRequired) {
                if (this.mData.isStringType(targetAtt)) {
                    String primitiveName = this.mData.getJavaPrimitiveClassName(sourceAtt);
                    if (primitiveName != null) {
                        sourceGetter = this.valueOf(sourceGetter);
                    } else if (!this.mData.isStringType(sourceAtt)) {
                        sourceGetter = this.toString(sourceGetter);
                    }
                }
            } else {
                String primitiveName = this.mData.getJavaPrimitiveClassName(sourceAtt);
                if (primitiveName != null) {
                    sourceGetter = this.constructor(primitiveName, sourceGetter);
                }
            }
        } else {
            String attributeValue = this.getAttributeValue(sourceAtt.getName());
            sourceGetter = this.methodInvocation(sourceNodeVariable, attributeValue);
        }
        return sourceGetter;
    }

    private String targetSetter(ContextAttribute targetAtt, String targetNodeVariable, String sourceGetter, boolean isSourceTypedAccessRequired, boolean isTargetTypedAccessRequired) {
        String targetSetter = null;
        targetSetter = isTargetTypedAccessRequired && isSourceTypedAccessRequired ? this.methodInvocation(targetNodeVariable, this.setter(targetAtt.getName(), sourceGetter)) : this.methodInvocation(targetNodeVariable, this.setAttributeValue(targetAtt.getName(), sourceGetter));
        return targetSetter;
    }

    private String getUniqueNameForNodeVariable(ContextNode node, Map variablesForNode) {
        String elementName = this.element(node.getName());
        StringBuffer name = new StringBuffer(elementName);
        int counter = 0;
        while (this.variableConflicts(variablesForNode, node, name.toString())) {
            name = new StringBuffer(elementName);
            name.append("_");
            name.append(++counter);
        }
        return name.toString();
    }

    private boolean variableConflicts(Map variablesForNode, ContextNode node, String variable) {
        return variablesForNode.containsValue(variable) && !variablesForNode.containsKey(node);
    }

    private String indentAbsolute() {
        return this.mData.isSourcePatternMode() ? "" : TAB;
    }

    private String getter(String name) {
        StringBuffer buf = new StringBuffer(GET);
        buf.append(this.firstUpper(name));
        buf.append(PARENTHESES_BOTH);
        return buf.toString();
    }

    private String setter(String name, String args) {
        StringBuffer buf = new StringBuffer(SET);
        buf.append(this.firstUpper(name));
        buf.append(PARENTHESES_OPENED);
        buf.append(args);
        buf.append(PARENTHESES_CLOSED);
        return buf.toString();
    }

    private void element(String name, StringBuffer buf) {
        buf.append(this.firstUpper(name));
        buf.append(ELEMENT);
    }

    private String element(String name) {
        StringBuffer buf = new StringBuffer(this.firstLower(name));
        buf.append(ELEMENT);
        return buf.toString();
    }

    private String currentElement(String name) {
        StringBuffer buf = new StringBuffer(CURRENT);
        this.element(name, buf);
        buf.append(PARENTHESES_BOTH);
        return buf.toString();
    }

    private String intfElement(String name) {
        StringBuffer buf = new StringBuffer(INTF_PREFIX);
        this.element(name, buf);
        return buf.toString();
    }

    private String privateController(String controllerName) {
        StringBuffer buf = new StringBuffer(IPRIVATE);
        buf.append(controllerName);
        return buf.toString();
    }

    private String getAttributeValue(String attributeName) {
        StringBuffer buf = new StringBuffer("getAttributeValue(\"");
        buf.append(attributeName);
        buf.append("\")");
        return buf.toString();
    }

    private String setAttributeValue(String attributeName, String value) {
        StringBuffer buf = new StringBuffer("setAttributeValue(\"");
        buf.append(attributeName);
        buf.append("\", ");
        buf.append(value);
        buf.append(PARENTHESES_CLOSED);
        return buf.toString();
    }

    private String usedContextAccessor(String controllerName) {
        StringBuffer buf = new StringBuffer("wdThis.wdGet");
        buf.append(this.firstUpper(controllerName));
        buf.append(CONTROLLER_SUFFIX);
        buf.append("().");
        buf.append("wdGetContext()");
        return buf.toString();
    }

    private String qualifiedPrivateController(Controller controller) {
        StringBuffer buf = new StringBuffer(controller.getPackage());
        buf.append(".wdp");
        buf.append(".IPrivate");
        buf.append(this.firstUpper(controller.getName()));
        return buf.toString();
    }

    private String valueOf(String primitiveArgument) {
        StringBuffer buf = new StringBuffer("String.valueOf(");
        buf.append(primitiveArgument);
        buf.append(PARENTHESES_CLOSED);
        return buf.toString();
    }

    private String toString(String objectName) {
        return this.methodInvocation(objectName, TO_STRING) + PARENTHESES_BOTH;
    }

    private String notEqualNullExpression(String operand, boolean encloseInBrackets) {
        StringBuffer buf = new StringBuffer();
        if (encloseInBrackets) {
            buf.append(PARENTHESES_OPENED);
        }
        buf.append(operand);
        buf.append(NOT_EQUAL_NULL);
        if (encloseInBrackets) {
            buf.append(PARENTHESES_CLOSED);
        }
        return buf.toString();
    }

    private String logicalAndExpression(String boolExpr1, String boolExpr2) {
        StringBuffer buf = new StringBuffer(boolExpr1);
        buf.append(AND_LOGICAL);
        buf.append(boolExpr2);
        return buf.toString();
    }

    private String ifStatementHeader(String boolExpr) {
        StringBuffer buf = new StringBuffer("if (");
        buf.append(boolExpr);
        buf.append(") {");
        return buf.toString();
    }

    private String assignment(String variable, String expression) {
        StringBuffer buf = new StringBuffer(variable);
        buf.append(ASSIGNMENT_OP);
        buf.append(expression);
        buf.append(SEMICOLON);
        return buf.toString();
    }

    private String methodInvocation(String objectName, String method) {
        StringBuffer buf = new StringBuffer(objectName);
        buf.append(DOT);
        buf.append(method);
        return buf.toString();
    }

    private String constructor(String className, String args) {
        StringBuffer buf = new StringBuffer("new ");
        buf.append(className);
        buf.append(PARENTHESES_OPENED);
        buf.append(args);
        buf.append(PARENTHESES_CLOSED);
        return buf.toString();
    }

    private String firstUpper(String name) {
        char[] chars = name.trim().toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private String firstLower(String name) {
        char[] chars = name.trim().toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

