/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.contextcopy;

import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContextCopyLink {
    private ContextElement mSourceElement;
    private ContextElement mTargetElement;
    private List mChildLinks = new ArrayList();
    private Map mChildLinkByTarget = new HashMap();

    ContextCopyLink(ContextElement sourceElement, ContextElement targetElement) {
        this.mSourceElement = sourceElement;
        this.mTargetElement = targetElement;
    }

    public ContextElement getSourceElement() {
        return this.mSourceElement;
    }

    public ContextElement getTargetElement() {
        return this.mTargetElement;
    }

    public ContextCopyLink addChildLink(ContextElement sourceElement, ContextElement targetElement) {
        if (sourceElement == null || targetElement == null) {
            throw new IllegalArgumentException("Source and target must not be null");
        }
        if (!this.mChildLinkByTarget.containsKey(targetElement)) {
            ContextCopyLink link = new ContextCopyLink(sourceElement, targetElement);
            this.mChildLinks.add(link);
            this.mChildLinkByTarget.put(targetElement, link);
            return link;
        }
        return (ContextCopyLink)this.mChildLinkByTarget.get(targetElement);
    }

    public void removeChildLink(ContextElement targetElement) {
        if (targetElement == null) {
            throw new IllegalArgumentException("Link to remove must not be null");
        }
        ContextCopyLink link = (ContextCopyLink)this.mChildLinkByTarget.get(targetElement);
        if (link != null) {
            this.removeInternal(link);
        }
    }

    private void removeInternal(ContextCopyLink link) {
        ContextElement targetElement = link.getTargetElement();
        this.mChildLinks.remove(link);
        this.mChildLinkByTarget.remove(targetElement);
    }

    public List getChildLinks() {
        return this.mChildLinks;
    }

    public ContextCopyLink getChildLink(ContextElement targetElement) {
        return (ContextCopyLink)this.mChildLinkByTarget.get(targetElement);
    }

    public void clearChildLinks() {
        this.mChildLinks.clear();
        this.mChildLinkByTarget.clear();
    }

    public boolean hasChildLink(ContextElement targetElement) {
        return this.mChildLinkByTarget.containsKey(targetElement);
    }

    public boolean hasChildLinks() {
        return !this.mChildLinks.isEmpty();
    }

    public boolean equals(Object o) {
        ContextCopyLink link;
        if (o == this) {
            return true;
        }
        return o instanceof ContextCopyLink && this.mSourceElement.equals((link = (ContextCopyLink)o).getSourceElement()) && this.mTargetElement.equals(link.getTargetElement());
    }

    public int hashCode() {
        int h = 17;
        h = 37 * h + this.mSourceElement.hashCode();
        h = 37 * h + this.mTargetElement.hashCode();
        return h;
    }

    public String toString() {
        return this.mSourceElement.getName() + " -> " + this.mTargetElement.getName();
    }
}

