/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.contextcopy;

import com.sap.ide.metamodel.dictionary.datatype.DtHint;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import com.sap.ide.tools.core.patternfwk.ISourcePatternData;
import com.sap.ide.tools.core.template.service.GenerationPositionEnum;
import com.sap.ide.tools.core.template.service.data.TemplateDataBase;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.template.contextcopy.ContextCopyLink;
import com.sap.ide.webdynpro.template.contextcopy.ContextCopyPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ContextCopyData
extends TemplateDataBase
implements ISourcePatternData {
    public static final String METHOD_NAME_WDDOINIT = "wdDoInit";
    public static final String METHOD_NAME_WDDOEXIT = "wdDoExit";
    private static final String DDIC_STRING = "string";
    private static final String JAVA_STRING = "String";
    private static final String JAVA_STRING_PACKAGE = "java.lang";
    private static final String JAVA_STRING_QUALIFIED = "java.lang.String";
    private static final Map JAVA_PRIMITIVE_CLASSES = ContextCopyData.initPrimitiveClasses();
    private static final Map JAVA_PRIMITIVE_CLASS_NAMES = ContextCopyData.initPrimitiveObjectNames();
    private List mLinks = new ArrayList();
    private Controller mController;
    private String mMethodName;
    private GenerationPositionEnum mPosition = GenerationPositionEnum.BEFORE;
    private boolean mSourcePatternMode = false;

    private static Map initPrimitiveClasses() {
        HashMap<String, Class<Comparable<Boolean>>> classes = new HashMap<String, Class<Comparable<Boolean>>>();
        classes.put("boolean", Boolean.TYPE);
        classes.put("byte", Byte.TYPE);
        classes.put("char", Character.TYPE);
        classes.put("short", Short.TYPE);
        classes.put("int", Integer.TYPE);
        classes.put("long", Long.TYPE);
        classes.put("float", Float.TYPE);
        classes.put("double", Double.TYPE);
        return classes;
    }

    private static Map initPrimitiveObjectNames() {
        HashMap<String, String> objectNames = new HashMap<String, String>();
        objectNames.put("boolean", "Boolean");
        objectNames.put("byte", "Byte");
        objectNames.put("char", "Character");
        objectNames.put("short", "Short");
        objectNames.put("int", "Integer");
        objectNames.put("long", "Long");
        objectNames.put("float", "Float");
        objectNames.put("double", "Double");
        return objectNames;
    }

    public boolean isValid() {
        return this.mName != null && this.mMethodName != null && this.mPosition != null && this.hasContextCopyLinks();
    }

    public DevelopmentObject getContainingObject() {
        return this.mController;
    }

    public void setContainingObject(DevelopmentObject object) {
        if (object instanceof Controller) {
            this.mController = (Controller)object;
        } else if (object instanceof View) {
            this.mController = ((View)object).getViewController();
        }
    }

    public Class getJavaPrimitiveClass(String javaType) {
        return (Class)JAVA_PRIMITIVE_CLASSES.get(javaType);
    }

    public String getJavaPrimitiveClassName(ContextAttribute attribute) {
        DevelopmentObject type = CheckLayerHelper.getType((ContextAttribute)attribute);
        String typeName = this.extractJavaClassName(type);
        return typeName != null ? (String)JAVA_PRIMITIVE_CLASS_NAMES.get(typeName) : null;
    }

    public boolean isStringType(ContextAttribute attribute) {
        DevelopmentObject type = CheckLayerHelper.getType((ContextAttribute)attribute);
        return this.isStringType(type);
    }

    private boolean isStringType(DevelopmentObject type) {
        JavaNativeType nativeType;
        String javaPackage;
        DtSimpleType simpleType;
        String builtinType;
        return type instanceof DtSimpleType ? (builtinType = (simpleType = (DtSimpleType)type).getBuiltInType()) != null && DDIC_STRING.equals(builtinType) : type instanceof JavaNativeType && ((javaPackage = (nativeType = (JavaNativeType)type).getJavaPackage()) != null ? JAVA_STRING_PACKAGE.equals(javaPackage) && JAVA_STRING.equals(nativeType.getName()) : JAVA_STRING_QUALIFIED.equals(nativeType.getName()));
    }

    public List getContextCopyLinks() {
        return this.mLinks;
    }

    public boolean hasContextCopyLinks() {
        return !this.mLinks.isEmpty();
    }

    public Controller getTargetController() {
        return this.mController;
    }

    public void setTargetController(Controller controller) {
        this.mController = controller;
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public GenerationPositionEnum getPosition() {
        return this.mPosition;
    }

    public void setMethodName(String methodName) {
        this.mMethodName = methodName;
    }

    public void setPosition(GenerationPositionEnum position) {
        this.mPosition = position;
    }

    public boolean isSourcePatternMode() {
        return this.mSourcePatternMode;
    }

    public void setSourcePatternMode() {
        this.mSourcePatternMode = true;
    }

    public ContextCopyLink addContextCopyLink(ContextAttribute sourceAttribute, ContextAttribute targetAttribute) {
        ContextCopyLink link;
        if (sourceAttribute == null || targetAttribute == null) {
            throw new IllegalArgumentException("Source and target must not be null");
        }
        ContextNode sourceNode = sourceAttribute.getNode();
        ContextNode targetNode = targetAttribute.getNode();
        Iterator iter = this.mLinks.iterator();
        while (iter.hasNext()) {
            link = (ContextCopyLink)iter.next();
            if (!link.getSourceElement().equals(sourceNode) || !link.getTargetElement().equals(targetNode)) continue;
            List childLinks = link.getChildLinks();
            if (!link.hasChildLink((ContextElement)targetAttribute)) {
                return link.addChildLink((ContextElement)sourceAttribute, (ContextElement)targetAttribute);
            }
            return link.getChildLink((ContextElement)targetAttribute);
        }
        link = new ContextCopyLink((ContextElement)sourceNode, (ContextElement)targetNode);
        ContextCopyLink childLink = link.addChildLink((ContextElement)sourceAttribute, (ContextElement)targetAttribute);
        this.mLinks.add(link);
        return childLink;
    }

    public void removeContextCopyLink(ContextElement sourceElement, ContextElement targetElement) {
        if (targetElement == null) {
            throw new IllegalArgumentException("Link to remove must not be null");
        }
        ContextCopyLink linkToRemove = null;
        Iterator iter = this.mLinks.iterator();
        while (iter.hasNext()) {
            ContextCopyLink link = (ContextCopyLink)iter.next();
            if (sourceElement instanceof ContextNode && targetElement instanceof ContextNode) {
                if (!link.getSourceElement().equals(sourceElement) || !link.getTargetElement().equals(targetElement)) continue;
                linkToRemove = link;
                break;
            }
            if (!link.hasChildLink(targetElement)) continue;
            link.removeChildLink(targetElement);
            if (link.hasChildLinks()) break;
            linkToRemove = link;
            break;
        }
        if (linkToRemove != null) {
            this.removeInternal(linkToRemove);
        }
    }

    public Class getTypeClass(String javaType) {
        ClassLoader pluginClassLoader = ContextCopyPlugin.getDefault().getDescriptor().getPluginClassLoader();
        try {
            return pluginClassLoader.loadClass(javaType);
        }
        catch (ClassNotFoundException e) {
            return this.getJavaPrimitiveClass(javaType);
        }
    }

    public boolean isTypedAccessRequired(ContextNode node) {
        if (node.getTypedAccessRequired()) {
            return true;
        }
        if (node.getParent().isMDO()) {
            return true;
        }
        return this.hasCalculatedAttributes(node);
    }

    public String extractJavaClassName(DevelopmentObject type) {
        if (type instanceof DtSimpleType) {
            try {
                DtSimpleType simpleType = (DtSimpleType)type;
                String builtinTypeName = simpleType.getBuiltInType();
                DtSimpleType builtinType = simpleType.getDictionary().getSimpleType("com.sap.dictionary", builtinTypeName);
                if (builtinType != null) {
                    DtHint[] hints = builtinType.getHints();
                    int i = 0;
                    while (i < hints.length) {
                        if ("java".equalsIgnoreCase(hints[i].getSoftwareLanguage())) {
                            return hints[i].getLanguageDataType();
                        }
                        ++i;
                    }
                }
            }
            catch (LoadException e) {
                ContextCopyPlugin.internalError(((Object)((Object)this)).getClass(), "extractJavaClassName(DevelopmentObject)", e.getMessage(), e, true);
            }
        } else if (type instanceof JavaNativeType) {
            JavaNativeType nativeType = (JavaNativeType)type;
            String javaPackage = nativeType.getJavaPackage();
            if (javaPackage != null) {
                return javaPackage + "." + nativeType.getName();
            }
            return nativeType.getName();
        }
        return null;
    }

    private boolean hasCalculatedAttributes(ContextNode node) {
        int i = 0;
        while (i < node.getAttributeCount()) {
            if (this.isCalculatedAttribute(node.getAttribute(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isCalculatedAttribute(ContextAttribute attr) {
        return attr instanceof ContextValueAttribute && !CheckLayerHelper.hasValidMapping((ContextElement)attr, (ControllerUsage[])((Controller)attr.getMDO()).getOutgoingControllerUsages()) && ((ContextValueAttribute)attr).hasCalculatedAttributeProvider();
    }

    private void removeInternal(ContextCopyLink link) {
        ContextElement targetElement = link.getTargetElement();
        this.mLinks.remove(link);
    }
}

