/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.descriptor;

import com.sapportals.portal.prt.deployment.descriptor.Descriptor;
import com.sapportals.portal.prt.deployment.descriptor.IProperty;
import com.sapportals.portal.prt.deployment.descriptor.IPropertyList;
import com.sapportals.portal.prt.deployment.descriptor.Property;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyList
implements IPropertyList {
    Descriptor mm_descriptor;
    NodeList mm_nodeList;
    HashMap mm_properties;

    public PropertyList(Descriptor descriptor, NodeList nodeList) {
        this.mm_descriptor = descriptor;
        this.mm_nodeList = nodeList;
        this.mm_properties = null;
    }

    private void load() {
        int len = 0;
        if (this.mm_nodeList != null) {
            len = this.mm_nodeList.getLength();
        }
        HashMap<String, Property> properties = new HashMap<String, Property>(len);
        int i = 0;
        while (i < len) {
            Element element = (Element)this.mm_nodeList.item(i);
            String propertyName = element.getAttribute("name");
            if (propertyName != null) {
                Property property = new Property(this.mm_descriptor, element);
                properties.put(propertyName, property);
            }
            ++i;
        }
        this.mm_properties = properties;
    }

    public int getLength() {
        if (this.mm_nodeList != null) {
            return this.mm_nodeList.getLength();
        }
        return 0;
    }

    public IProperty item(int pos) {
        if (this.mm_nodeList != null) {
            try {
                Element element = (Element)this.mm_nodeList.item(pos);
                return new Property(this.mm_descriptor, element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public IProperty getProperty(String name) {
        PropertyList propertyList = this;
        synchronized (propertyList) {
            if (this.mm_properties == null) {
                this.load();
            }
        }
        return (IProperty)this.mm_properties.get(name);
    }
}

