/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.descriptor;

import com.sapportals.portal.prt.deployment.descriptor.Descriptor;
import com.sapportals.portal.prt.deployment.descriptor.FilteredNodeList;
import com.sapportals.portal.prt.deployment.descriptor.IProperty;
import com.sapportals.portal.prt.deployment.descriptor.IPropertyList;
import com.sapportals.portal.prt.deployment.descriptor.PropertyList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class Property
implements IProperty {
    Descriptor mm_descriptor;
    Element mm_element;
    PropertyList mm_attributeList = null;

    public Property(Descriptor descriptor, Element element) {
        this.mm_descriptor = descriptor;
        this.mm_element = element;
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getValue() {
        return this.getAttribute("value");
    }

    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    public IProperty getProperty(String name) {
        if (this.mm_element != null) {
            return this.getProperties().getProperty(name);
        }
        return null;
    }

    public IPropertyList getProperties() {
        if (this.mm_attributeList == null && this.mm_element != null) {
            FilteredNodeList list = new FilteredNodeList(this.mm_element.getChildNodes(), "property");
            this.mm_attributeList = new PropertyList(this.mm_descriptor, list);
        }
        return this.mm_attributeList;
    }

    protected String getAttribute(String attrName) {
        Attr attr;
        if (this.mm_element != null && (attr = this.mm_element.getAttributeNode(attrName)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    protected void setAttribute(String attrName, String attrValue) {
        if (this.mm_element != null) {
            if (attrValue == null) {
                this.mm_element.removeAttribute(attrName);
            } else {
                Attr attr = this.mm_element.getAttributeNode(attrName);
                if (attr != null) {
                    attr.setNodeValue(attrValue);
                } else {
                    this.mm_element.setAttribute(attrName, attrValue);
                }
            }
        }
    }
}

