/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.descriptor;

import com.sapportals.portal.prt.deployment.DeploymentException;
import com.sapportals.portal.prt.deployment.descriptor.Descriptor;
import com.sapportals.portal.prt.deployment.descriptor.HybridApplication;
import com.sapportals.portal.prt.deployment.descriptor.IApplication;
import com.sapportals.portal.prt.deployment.descriptor.IDescriptor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HybridDescriptor
implements IDescriptor {
    IDescriptor mm_originalDescriptor;
    IDescriptor mm_customDescriptor;

    public HybridDescriptor(IDescriptor originalDescriptor, IDescriptor customDescriptor) {
        this.mm_originalDescriptor = originalDescriptor;
        this.mm_customDescriptor = customDescriptor;
    }

    public Document load(File file) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public Document load(InputStream is) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void saveAs(OutputStream os) {
        this.mm_customDescriptor.saveAs(os);
    }

    public IApplication getApplication() {
        return new HybridApplication(this);
    }

    public int getOriginalFormat() {
        return this.mm_originalDescriptor.getOriginalFormat();
    }

    public Set getDeclaredResourceBundles() {
        return this.mm_originalDescriptor.getDeclaredResourceBundles();
    }

    protected IDescriptor getOriginalDescriptor() {
        return this.mm_originalDescriptor;
    }

    protected IDescriptor getCustomDescriptor() {
        return this.mm_customDescriptor;
    }

    protected void createService(String name) {
        Document document = ((Descriptor)this.mm_customDescriptor).getDocument();
        Element applicationElement = document.getDocumentElement();
        NodeList nodeList = applicationElement.getElementsByTagName("services");
        Element servicesNode = (Element)nodeList.item(0);
        if (servicesNode == null) {
            throw new UnsupportedOperationException("The initial XML DOM is not consistent");
        }
        Element serviceNode = document.createElement("service");
        serviceNode.setAttribute("name", name);
        servicesNode.appendChild(serviceNode);
        Element serviceConfig = document.createElement("service-config");
        serviceNode.appendChild(serviceConfig);
        Element serviceProfile = document.createElement("service-profile");
        serviceNode.appendChild(serviceProfile);
        ((Descriptor)this.mm_customDescriptor).refresh();
    }

    protected void createComponent(String name) {
        Document document = ((Descriptor)this.mm_customDescriptor).getDocument();
        Element applicationElement = document.getDocumentElement();
        NodeList nodeList = applicationElement.getElementsByTagName("components");
        Element componentsNode = (Element)nodeList.item(0);
        if (componentsNode == null) {
            throw new UnsupportedOperationException("The initial XML DOM is not consistent");
        }
        Element componentNode = document.createElement("component");
        componentNode.setAttribute("name", name);
        componentsNode.appendChild(componentNode);
        Element componentConfig = document.createElement("component-config");
        componentNode.appendChild(componentConfig);
        Element componentProfile = document.createElement("component-profile");
        componentNode.appendChild(componentProfile);
        ((Descriptor)this.mm_customDescriptor).refresh();
    }
}

