/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.descriptor;

import com.sapportals.portal.prt.deployment.descriptor.HybridComponent;
import com.sapportals.portal.prt.deployment.descriptor.HybridComponentList;
import com.sapportals.portal.prt.deployment.descriptor.HybridConfiguration;
import com.sapportals.portal.prt.deployment.descriptor.HybridDescriptor;
import com.sapportals.portal.prt.deployment.descriptor.HybridService;
import com.sapportals.portal.prt.deployment.descriptor.HybridServiceList;
import com.sapportals.portal.prt.deployment.descriptor.IApplication;
import com.sapportals.portal.prt.deployment.descriptor.IComponent;
import com.sapportals.portal.prt.deployment.descriptor.IComponentList;
import com.sapportals.portal.prt.deployment.descriptor.IConfiguration;
import com.sapportals.portal.prt.deployment.descriptor.IEntryList;
import com.sapportals.portal.prt.deployment.descriptor.IService;
import com.sapportals.portal.prt.deployment.descriptor.IServiceList;

public class HybridApplication
implements IApplication {
    HybridDescriptor mm_hybridDescriptor;

    protected HybridApplication(HybridDescriptor hybridDescriptor) {
        this.mm_hybridDescriptor = hybridDescriptor;
    }

    public String getName() {
        return this.mm_hybridDescriptor.getOriginalDescriptor().getApplication().getName();
    }

    public String getAlias() {
        return this.mm_hybridDescriptor.getOriginalDescriptor().getApplication().getAlias();
    }

    public IEntryList getEntries() {
        return this.mm_hybridDescriptor.getOriginalDescriptor().getApplication().getEntries();
    }

    public IConfiguration getConfiguration() {
        IConfiguration originalConfiguration = this.mm_hybridDescriptor.getOriginalDescriptor().getApplication().getConfiguration();
        IConfiguration customConfiguration = this.mm_hybridDescriptor.getCustomDescriptor().getApplication().getConfiguration();
        return new HybridConfiguration(originalConfiguration, customConfiguration);
    }

    public IComponentList getComponents() {
        IComponentList originalComponentList = this.mm_hybridDescriptor.getOriginalDescriptor().getApplication().getComponents();
        return new HybridComponentList(this, originalComponentList);
    }

    public IServiceList getServices() {
        IServiceList originalServiceList = this.mm_hybridDescriptor.getOriginalDescriptor().getApplication().getServices();
        return new HybridServiceList(this, originalServiceList);
    }

    public IComponent getComponent(String name) {
        IComponent originalComponent = this.mm_hybridDescriptor.getOriginalDescriptor().getApplication().getComponent(name);
        if (originalComponent != null) {
            IApplication application = this.mm_hybridDescriptor.getCustomDescriptor().getApplication();
            IComponent customComponent = application.getComponent(name);
            if (customComponent == null) {
                this.mm_hybridDescriptor.createComponent(name);
                customComponent = application.getComponent(name);
                if (customComponent == null) {
                    throw new UnsupportedOperationException();
                }
            }
            return new HybridComponent(originalComponent, customComponent);
        }
        return null;
    }

    public IService getService(String name) {
        IService originalService = this.mm_hybridDescriptor.getOriginalDescriptor().getApplication().getService(name);
        if (originalService != null) {
            IApplication application = this.mm_hybridDescriptor.getCustomDescriptor().getApplication();
            IService customService = application.getService(name);
            if (customService == null) {
                this.mm_hybridDescriptor.createService(name);
                customService = application.getService(name);
                if (customService == null) {
                    throw new UnsupportedOperationException();
                }
            }
            return new HybridService(originalService, customService);
        }
        return null;
    }

    public HybridDescriptor getHybridDescriptor() {
        return this.mm_hybridDescriptor;
    }
}

