/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.descriptor;

import com.sapportals.portal.prt.deployment.descriptor.Descriptor;
import com.sapportals.portal.prt.deployment.descriptor.IComponent;
import com.sapportals.portal.prt.deployment.descriptor.IComponentList;
import com.sapportals.portal.prt.deployment.descriptor.IDescriptor;
import com.sapportals.portal.prt.deployment.descriptor.IService;
import com.sapportals.portal.prt.deployment.descriptor.IServiceList;
import com.sapportals.portal.prt.deployment.ep50.ProfileEP50;
import com.sapportals.portal.prt.deployment.ep50.ServiceConfigEP50;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DescriptorBuilder
extends Descriptor {
    Element mm_applicationConfigNode = null;
    Element mm_componentsNode = null;
    Element mm_servicesNode = null;

    public DescriptorBuilder(String applicationName) {
        super(applicationName);
        this.buildSkeletonStructureEP50();
    }

    public DescriptorBuilder(String applicationName, IDescriptor originalDescriptor) {
        super(applicationName);
        this.buildSkeletonStructure(originalDescriptor);
    }

    public Document load(InputStream is) {
        throw new UnsupportedOperationException("[DescriptorBuilder.load] Operation not supported in that context");
    }

    public void addEP50Component(String subName, InputStream is) {
        ProfileEP50 profile = new ProfileEP50(is);
        Document document = this.getDocument();
        Element componentNode = document.createElement("component");
        componentNode.setAttribute("name", subName);
        Element configNode = document.createElement("component-config");
        Element profileNode = document.createElement("component-profile");
        componentNode.appendChild(configNode);
        componentNode.appendChild(profileNode);
        profile.toEP60Config(document, configNode);
        profile.toEP60Profile(document, profileNode);
        Element propertyNode = document.createElement("property");
        propertyNode.setAttribute("name", "SecurityZone");
        propertyNode.setAttribute("value", "com.sap.portal.ep50/ep50_safety");
        configNode.appendChild(propertyNode);
        this.mm_componentsNode.appendChild(componentNode);
        this.setOriginalFormat(1);
        if (subName.equals("default")) {
            profile.toEP60ApplicationConfig(document, this.mm_applicationConfigNode);
        }
    }

    public void addEP50Service(InputStream is) {
        ServiceConfigEP50 serviceConfig = new ServiceConfigEP50(is);
        Document document = this.getDocument();
        Element serviceNode = document.createElement("service");
        Element configNode = document.createElement("service-config");
        serviceNode.appendChild(configNode);
        this.setOriginalFormat(2);
        serviceConfig.toEP60(document, configNode, this.mm_applicationConfigNode);
        this.mm_servicesNode.appendChild(serviceNode);
    }

    public DescriptorBuilder setEP50DefaultServiceProperties() {
        this.setOriginalFormat(2);
        return this;
    }

    private void buildSkeletonStructureEP50() {
        Document document;
        Object db = null;
        try {
            DocumentBuilderFactory docBuilderFactory = Descriptor.getDocumentBuilderFactory();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            document = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return;
        }
        Element rootElement = document.createElement("application");
        document.appendChild(rootElement);
        this.mm_applicationConfigNode = document.createElement("application-config");
        Element propertyNode = document.createElement("property");
        propertyNode.setAttribute("name", "ClassLoadingPolicy");
        propertyNode.setAttribute("value", "5.0");
        this.mm_applicationConfigNode.appendChild(propertyNode);
        propertyNode = document.createElement("property");
        propertyNode.setAttribute("name", "DeploymentPolicy");
        propertyNode.setAttribute("value", "5.0");
        this.mm_applicationConfigNode.appendChild(propertyNode);
        propertyNode = document.createElement("property");
        propertyNode.setAttribute("name", "AuthenticationPolicy");
        propertyNode.setAttribute("value", "5.0");
        this.mm_applicationConfigNode.appendChild(propertyNode);
        this.mm_componentsNode = document.createElement("components");
        this.mm_servicesNode = document.createElement("services");
        rootElement.appendChild(this.mm_applicationConfigNode);
        rootElement.appendChild(this.mm_componentsNode);
        rootElement.appendChild(this.mm_servicesNode);
        this.setDocument(document);
    }

    public void saveAs(OutputStream os) {
        this.saveAs(os, "ISO-8859-1");
    }

    private void buildSkeletonStructure(IDescriptor originalDescriptor) {
        Document document;
        Object db = null;
        try {
            DocumentBuilderFactory docBuilderFactory = Descriptor.getDocumentBuilderFactory();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            document = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return;
        }
        Element rootElement = document.createElement("application");
        document.appendChild(rootElement);
        this.mm_applicationConfigNode = document.createElement("application-config");
        this.mm_componentsNode = document.createElement("components");
        this.mm_servicesNode = document.createElement("services");
        rootElement.appendChild(this.mm_applicationConfigNode);
        rootElement.appendChild(this.mm_componentsNode);
        rootElement.appendChild(this.mm_servicesNode);
        IComponentList componentList = originalDescriptor.getApplication().getComponents();
        int i = 0;
        while (i < componentList.getLength()) {
            IComponent component = componentList.item(i);
            Element componentNode = document.createElement("component");
            componentNode.setAttribute("name", component.getName());
            this.mm_componentsNode.appendChild(componentNode);
            Element componentConfig = document.createElement("component-config");
            componentNode.appendChild(componentConfig);
            Element componentProfile = document.createElement("component-profile");
            componentNode.appendChild(componentProfile);
            ++i;
        }
        IServiceList serviceList = originalDescriptor.getApplication().getServices();
        int i2 = 0;
        while (i2 < serviceList.getLength()) {
            IService service = serviceList.item(i2);
            Element serviceNode = document.createElement("service");
            serviceNode.setAttribute("name", service.getName());
            this.mm_servicesNode.appendChild(serviceNode);
            Element serviceConfig = document.createElement("service-config");
            serviceNode.appendChild(serviceConfig);
            Element serviceProfile = document.createElement("service-profile");
            serviceNode.appendChild(serviceProfile);
            ++i2;
        }
        this.setDocument(document);
    }
}

