/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.descriptor;

import com.sapportals.portal.prt.deployment.descriptor.Descriptor;
import com.sapportals.portal.prt.deployment.descriptor.FilteredNodeList;
import com.sapportals.portal.prt.deployment.descriptor.IConfiguration;
import com.sapportals.portal.prt.deployment.descriptor.IProperty;
import com.sapportals.portal.prt.deployment.descriptor.IPropertyList;
import com.sapportals.portal.prt.deployment.descriptor.PropertyList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Configuration
implements IConfiguration {
    Descriptor mm_descriptor;
    Element mm_element;
    PropertyList mm_propertyList = null;

    public Configuration(Descriptor descriptor, Element element) {
        this.mm_descriptor = descriptor;
        this.mm_element = element;
    }

    public IProperty getProperty(String propertyName) {
        if (this.mm_element != null) {
            return this.getProperties().getProperty(propertyName);
        }
        return null;
    }

    public String getPropertyValue(String propertyName) {
        IProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public IPropertyList getProperties() {
        Document document;
        if (this.mm_propertyList == null && this.mm_element != null && (document = this.mm_descriptor.getDocument()) != null) {
            Document document2 = document;
            synchronized (document2) {
                FilteredNodeList list = new FilteredNodeList(this.mm_element.getChildNodes(), "property");
                this.mm_propertyList = new PropertyList(this.mm_descriptor, list);
            }
        }
        return this.mm_propertyList;
    }

    protected void removeProperty(String propertyName) {
        NodeList nodeList = this.mm_element.getChildNodes();
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeName;
                Node node = nodeList.item(i);
                if (node != null && node.getNodeType() == 1 && "property".equalsIgnoreCase(nodeName = node.getNodeName())) {
                    String name = null;
                    Attr nodeAtt = ((Element)node).getAttributeNode("name");
                    name = nodeAtt.getNodeValue();
                    if (propertyName != null && propertyName.equals(name)) {
                        this.mm_element.removeChild(node);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    protected void addProperty(String propertyName, String propertyValue) {
        Document document = this.mm_descriptor.getDocument();
        Element propertyNode = document.createElement("property");
        propertyNode.setAttribute("name", propertyName);
        if (propertyValue != null) {
            propertyNode.setAttribute("value", propertyValue);
        }
        this.mm_element.appendChild(propertyNode);
        if ("CodeLink".equals(propertyName)) {
            Element subPropertyNode = document.createElement("property");
            subPropertyNode.setAttribute("name", "inheritance");
            subPropertyNode.setAttribute("value", "final");
            propertyNode.appendChild(subPropertyNode);
        }
    }

    public void setPropertyValue(String propertyName, String propertyValue) {
        Document document = this.mm_descriptor.getDocument();
        if (document != null) {
            Document document2 = document;
            synchronized (document2) {
                this.mm_propertyList = null;
                IProperty property = this.getProperty(propertyName);
                if (property != null) {
                    if (propertyValue == null) {
                        this.removeProperty(propertyName);
                        this.mm_propertyList = null;
                    } else {
                        property.setValue(propertyValue);
                    }
                } else if (propertyValue != null) {
                    this.addProperty(propertyName, propertyValue);
                    this.mm_propertyList = null;
                }
            }
        }
    }
}

