/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment;

import com.sapportals.portal.prt.deployment.ArchiveExtractorEP50;
import com.sapportals.portal.prt.deployment.DeploymentPolicy;
import com.sapportals.portal.prt.deployment.descriptor.IDescriptor;
import java.io.File;
import java.util.Hashtable;

public class ZARExtractor
extends ArchiveExtractorEP50 {
    private static final Hashtable mm_mapping = new Hashtable();

    public ZARExtractor(File sourceFile, File publicPath, File privatePath, IDescriptor descriptor, DeploymentPolicy policy) {
        super(sourceFile, publicPath, privatePath, descriptor, policy);
    }

    protected String getTargetName(String fileName, boolean isPrivate) {
        if (!isPrivate) {
            return fileName;
        }
        if (fileName.equals("config/service.xml")) {
            return null;
        }
        int pos = fileName.indexOf("/");
        if (pos > 0) {
            String realFolder;
            String folder = fileName.substring(0, pos).toLowerCase();
            String rightPart = fileName.substring(pos + 1).toLowerCase();
            int pos2 = rightPart.indexOf("/");
            if (pos2 > 0) {
                String folder2 = rightPart.substring(0, pos2).toLowerCase();
                String realFolder2 = (String)mm_mapping.get(folder + "/" + folder2);
                if (realFolder2 != null) {
                    return realFolder2 + rightPart.substring(pos2);
                }
            }
            if ((realFolder = (String)mm_mapping.get(folder)) != null) {
                return realFolder + fileName.substring(pos);
            }
        }
        return fileName;
    }

    static {
        mm_mapping.put("lib/private", "private/lib");
        mm_mapping.put("classes/private", "private/classes");
    }
}

