/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment;

import com.sapportals.portal.prt.deployment.DeploymentException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class ArchiveIterator {
    public static final boolean STOP_PROCESS = true;
    public static final boolean CONTINUE_PROCESS = false;
    public static final String META_INF_FOLDER = "META-INF";
    public static final int META_INF_FOLDER_LENGTH = "META-INF".length();
    public static final String PORTAL_INF_FOLDER = "PORTAL-INF";
    public static final int PORTAL_INF_FOLDER_LENGTH = "PORTAL-INF".length();
    public static final String REVISION_EXTENSION = ".revision";
    public static final String DESCRIPTOR_FILE_NAME = "portalapp.xml";
    public static final String PRESERVED_CONFIG_PATHS = "PreservedConfigPaths";
    public static final String PUBLIC_SCOPE = "public";
    public static final int PUBLIC_LENGTH = "public".length();
    public static final String PRIVATE_SCOPE = "private";
    public static final int PRIVATE_LENGTH = "private".length();
    public static final int BUFFER_SIZE = 16384;
    public static final String SLASH = "/";

    public void iterate(File source) throws IOException, DeploymentException {
        ZipFile zip = new ZipFile(source);
        try {
            Enumeration<? extends ZipEntry> enumeration = zip.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry ze = enumeration.nextElement();
                if (!this.handleEntry(zip, ze)) continue;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            zip.close();
            throw throwable;
        }
        zip.close();
    }

    protected abstract boolean handleEntry(ZipFile var1, ZipEntry var2) throws IOException, DeploymentException;
}

