/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment;

import com.sapportals.portal.prt.deployment.ArchiveIterator;
import com.sapportals.portal.prt.deployment.DeploymentException;
import com.sapportals.portal.prt.deployment.DeploymentPolicy;
import com.sapportals.portal.prt.deployment.descriptor.Descriptor;
import com.sapportals.portal.prt.deployment.descriptor.DescriptorBuilder;
import com.sapportals.portal.prt.deployment.descriptor.IApplication;
import com.sapportals.portal.prt.deployment.descriptor.IConfiguration;
import com.sapportals.portal.prt.deployment.descriptor.IDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArchiveIntrospector
extends ArchiveIterator {
    String mm_applicationName;
    File mm_sourceFile = null;
    private IDescriptor mm_deploymentDescriptor = null;
    private DeploymentPolicy mm_deploymentPolicy = null;

    public ArchiveIntrospector(File file) {
        this.mm_applicationName = "unknown";
        this.mm_sourceFile = file;
    }

    public ArchiveIntrospector(String appName, File file) {
        this.mm_applicationName = appName;
        this.mm_sourceFile = file;
    }

    public DeploymentPolicy getDeploymentPolicy() throws IOException, DeploymentException {
        IConfiguration configuration;
        IApplication application;
        IDescriptor descriptor = this.getDeploymentDescriptor();
        if (descriptor != null && (application = descriptor.getApplication()) != null && (configuration = application.getConfiguration()) != null) {
            String preservedConfigPaths = configuration.getPropertyValue("PreservedConfigPaths");
            String deploymentPolicy = configuration.getPropertyValue("DeploymentPolicy");
            return new DeploymentPolicy(preservedConfigPaths, deploymentPolicy);
        }
        return this.mm_deploymentPolicy;
    }

    public IDescriptor getDeploymentDescriptor() throws IOException, DeploymentException {
        if (this.mm_deploymentDescriptor == null) {
            String descriptorName = "PORTAL-INF/portalapp.xml";
            ZipFile zip = new ZipFile(this.mm_sourceFile);
            try {
                ZipEntry entry = zip.getEntry(descriptorName);
                if (entry != null) {
                    InputStream is = zip.getInputStream(entry);
                    this.mm_deploymentDescriptor = new Descriptor(this.mm_applicationName);
                    this.mm_deploymentDescriptor.load(is);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                zip.close();
                throw throwable;
            }
            zip.close();
            if (this.mm_deploymentDescriptor == null) {
                this.iterate(this.mm_sourceFile);
                if (this.mm_deploymentDescriptor == null) {
                    this.mm_deploymentDescriptor = new DescriptorBuilder(this.mm_applicationName).setEP50DefaultServiceProperties();
                }
            }
        }
        return this.mm_deploymentDescriptor;
    }

    protected boolean handleEntry(ZipFile zip, ZipEntry ze) throws IOException, DeploymentException {
        boolean stop = false;
        String entryName = ze.getName();
        if (entryName.startsWith("private")) {
            entryName = entryName.substring("private".length() + 1);
        }
        if (entryName.startsWith("profiles") && entryName.endsWith(".properties")) {
            if (this.mm_deploymentDescriptor == null) {
                this.mm_deploymentDescriptor = new DescriptorBuilder(this.mm_applicationName);
            }
            DescriptorBuilder db = (DescriptorBuilder)this.mm_deploymentDescriptor;
            String componentName = entryName.substring(entryName.lastIndexOf("/") + 1, entryName.lastIndexOf(".properties"));
            db.addEP50Component(componentName, zip.getInputStream(ze));
        } else if (entryName.equals("config/service.xml")) {
            if (this.mm_deploymentDescriptor == null) {
                this.mm_deploymentDescriptor = new DescriptorBuilder(this.mm_applicationName);
            }
            DescriptorBuilder db = (DescriptorBuilder)this.mm_deploymentDescriptor;
            db.addEP50Service(zip.getInputStream(ze));
        }
        return false;
    }
}

